/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.layout;

import com.mathworks.ide.layout.DragTracker;
import com.mathworks.ide.layout.LayoutArea;
import com.mathworks.ide.layout.LayoutLooper;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.mwt.MWScrollPanel;
import com.mathworks.services.ObjectRegistry;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

class CornerDrag
implements DragTracker {
    private static final int MIN_WIDTH = 72;
    private static final int MIN_HEIGHT = 24;
    private LayoutArea fLayout;
    private Component fTarget;
    private Object fHandle;
    private Object fAdapter;
    private Rectangle fAperture;
    private Point fOffsetPt;
    private Point fCurrentPt;

    CornerDrag(LayoutArea layoutArea, Component component) {
        this.fLayout = layoutArea;
        this.fTarget = component;
        this.init();
    }

    CornerDrag(LayoutArea layoutArea, Object object, Object object2) {
        this.fLayout = layoutArea;
        this.fHandle = object;
        this.fAdapter = object2;
        this.init();
    }

    private void init() {
        this.fOffsetPt = ((Component)((Object)this.fLayout)).getLocation();
        Container container = ((Component)((Object)this.fLayout)).getParent();
        while (container != null) {
            if (container instanceof MWScrollPanel) {
                this.fAperture = ((MWScrollPanel)container).getAperture();
                return;
            }
            container = container.getParent();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.fLayout.selectAll(false);
        this.fLayout.drawNow();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Graphics graphics = this.getXORGraphics();
        this.drawMarquee(graphics);
        this.fCurrentPt = this.pinPoint(mouseEvent.getPoint());
        this.drawMarquee(graphics);
        graphics.dispose();
        graphics = null;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Graphics graphics = this.getXORGraphics();
        this.drawMarquee(graphics);
        graphics.dispose();
        graphics = null;
        this.fCurrentPt = this.pinPoint(mouseEvent.getPoint());
        if (this.fTarget != null) {
            this.fTarget.setSize(this.fCurrentPt.x, this.fCurrentPt.y);
            return;
        }
        if (this.fHandle != null) {
            LayoutLooper.resizeFigure(this.fHandle, this.fCurrentPt, new ResizeObserver(this.fAdapter));
        }
    }

    private Point pinPoint(Point point) {
        if (this.fAperture != null) {
            if (point.x < this.fAperture.x) {
                point.x = this.fAperture.x;
            } else if (point.x > this.fAperture.x + this.fAperture.width) {
                point.x = this.fAperture.x + this.fAperture.width;
            }
            if (point.y < this.fAperture.y) {
                point.y = this.fAperture.y;
            } else if (point.y > this.fAperture.y + this.fAperture.height) {
                point.y = this.fAperture.y + this.fAperture.height;
            }
        }
        if (point.x < 72) {
            point.x = 72;
        }
        if (point.y < 24) {
            point.y = 24;
        }
        return point;
    }

    private void drawMarquee(Graphics graphics) {
        if (this.fCurrentPt != null) {
            graphics.drawRect(this.fOffsetPt.x, this.fOffsetPt.y, this.fCurrentPt.x - 1, this.fCurrentPt.y - 1);
        }
    }

    private Graphics getXORGraphics() {
        Graphics graphics = ((Component)((Object)this.fLayout)).getParent().getGraphics();
        graphics.setColor(((Component)((Object)this.fLayout)).getBackground());
        graphics.setXORMode(Color.gray);
        return graphics;
    }

    private static class ResizeObserver
    implements CompletionObserver {
        private Object fAdapter;

        ResizeObserver(Object object) {
            this.fAdapter = object;
        }

        public void completed(int n, Object object) {
            if (LayoutLooper.checkStatus(n) == 0) {
                Object[] objectArray = new Object[]{this.fAdapter};
                ObjectRegistry.getLayoutRegistry().change(objectArray);
            }
        }
    }
}

