/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.layout;

import com.mathworks.ide.layout.DragTracker;
import com.mathworks.ide.layout.LOControlWrapper;
import com.mathworks.ide.layout.LayoutArea;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;

class ConnectDrag
implements DragTracker {
    private LayoutArea fOwner;
    private LOControlWrapper fSource;
    private LOControlWrapper fTarget;
    private Point fStartPt;
    private Point fLastPt;

    ConnectDrag(LayoutArea layoutArea, LOControlWrapper lOControlWrapper) {
        this.fOwner = layoutArea;
        this.fSource = lOControlWrapper;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.fStartPt = mouseEvent.getPoint();
        ((Component)((Object)this.fOwner)).setCursor(Cursor.getPredefinedCursor(12));
        this.fOwner.selectAll(false);
        this.fSource.setSelected(true);
        this.fOwner.drawNow();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Graphics graphics = this.getGraphics();
        this.eraseLastLine(graphics);
        LOControlWrapper lOControlWrapper = this.fOwner.findBeanAtPoint(mouseEvent.getPoint());
        if (lOControlWrapper != this.fTarget) {
            boolean bl = false;
            if (this.fTarget != null) {
                this.fTarget.setSelected(false);
                bl = true;
            }
            if (lOControlWrapper != null && lOControlWrapper != this.fSource) {
                this.fTarget = lOControlWrapper;
                lOControlWrapper.setSelected(true);
                bl = true;
            } else {
                this.fTarget = null;
            }
            if (bl) {
                this.fOwner.drawNow();
            }
        }
        this.drawNextLine(graphics, mouseEvent.getPoint());
        this.fOwner.getHRuler().doMouseTrackMouseMoved(mouseEvent.getPoint());
        this.fOwner.getVRuler().doMouseTrackMouseMoved(mouseEvent.getPoint());
        graphics.dispose();
        graphics = null;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Graphics graphics = this.getGraphics();
        this.eraseLastLine(graphics);
        graphics.dispose();
        graphics = null;
        LOControlWrapper lOControlWrapper = this.fOwner.findBeanAtPoint(mouseEvent.getPoint());
        if (lOControlWrapper != null && lOControlWrapper != this.fSource) {
            lOControlWrapper.setSelected(true);
            this.fOwner.markWrapper(this.fSource, 0);
            this.fOwner.markWrapper(lOControlWrapper, 1);
            this.fOwner.doCommand(1003);
        }
        this.fOwner.updateSelection();
    }

    private void eraseLastLine(Graphics graphics) {
        if (this.fLastPt != null) {
            graphics.drawLine(this.fStartPt.x, this.fStartPt.y, this.fLastPt.x, this.fLastPt.y);
            this.fLastPt = null;
        }
    }

    private void drawNextLine(Graphics graphics, Point point) {
        graphics.drawLine(this.fStartPt.x, this.fStartPt.y, point.x, point.y);
        this.fLastPt = point;
    }

    private Graphics getGraphics() {
        Graphics graphics = ((Component)((Object)this.fOwner)).getGraphics();
        graphics.setXORMode(((Component)((Object)this.fOwner)).getBackground());
        graphics.setColor(Color.black);
        return graphics;
    }
}

