/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.inspector;

import com.mathworks.beans.editors.CallbackEditor;
import com.mathworks.beans.editors.EditorManager;
import com.mathworks.ide.filtermgr.PropertyFilter;
import com.mathworks.ide.inspector.NamedEditor;
import com.mathworks.ide.inspector.PropertyCell;
import com.mathworks.ide.inspector.PropertyCellBoolean;
import com.mathworks.ide.inspector.PropertyCellCustom;
import com.mathworks.ide.inspector.PropertyCellEditField;
import com.mathworks.ide.inspector.PropertyTarget;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.bean.UDDObject;
import com.mathworks.mwt.MWTList;
import com.mathworks.mwt.MWTListEvent;
import com.mathworks.mwt.MWTListListener;
import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.services.ObjectRegistry;
import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Vector;

class PropertyViewList
extends MWTList
implements Runnable,
MWTListListener,
ItemListener,
ActionListener {
    private static final int NAME_COLUMN = 0;
    private static final int VALUE_COLUMN = 1;
    private static final int DEFAULT_COLUMN_WIDTH = 170;
    private static final int DEFAULT_CELL_HEIGHT = 19;
    private static final int DEFAULT_ROWS_VISIBLE = 15;
    private static final int SCROLL_PADDING = 30;
    protected static Font sInspectorFont = new Font("SansSerif", 0, 12);
    private PropertyTarget fTarget;
    private Thread fUpdater;
    private Object[] fPendingObjects;
    private PropertyFilter fFilter;
    private boolean fUpdatePending;
    private boolean fValueRefreshPending;
    private boolean fUpdating;
    private String fPropertyToSelect;
    private boolean fShowReadOnly;
    private boolean fCallbacksOnly;
    private int fTrackingItem;
    private int fInCellItem;
    private Dimension fCachedSize;
    private Vector fTopLevelCells;
    private Hashtable fCellsHash;
    private Vector fExpandedProps;
    private ObjectRegistry fRegistry;
    private boolean fUseMatlabThread;
    private boolean fWaitForMatlab;

    PropertyViewList(ObjectRegistry objectRegistry) {
        super(false, true, 2);
        this.fRegistry = objectRegistry;
        EditorManager.init();
        this.setDrawSelection(false);
        this.setWholeItemSelect(true);
        this.setDrawColumnLines(false);
        this.setDrawRowLines(true);
        Color color = Decorations.getColor((int)2);
        if (PlatformInfo.getAppearance() != 0) {
            this.setListColor(this.makeShade(color, 1, 16));
            this.setHGridColor(color);
            this.setSortColumnColor(this.makeShade(color, 1, 8));
        } else {
            this.setSortColumnColor(this.makeShade(color, 1, 16));
        }
        this.setFont(sInspectorFont);
        this.setCellHeight(19);
        this.fTopLevelCells = new Vector();
        this.fCellsHash = new Hashtable();
        this.fExpandedProps = new Vector();
        this.fTrackingItem = -1;
        this.fInCellItem = -1;
        this.fShowReadOnly = false;
        this.fCallbacksOnly = false;
        this.fFilter = null;
        this.fUpdatePending = false;
        this.fValueRefreshPending = false;
        this.fUpdating = true;
        this.fPropertyToSelect = null;
        this.fPendingObjects = null;
        this.fUpdater = new Thread(this);
        this.fUpdater.setName("PropertyView Updater");
        this.fUpdater.setPriority(1);
        this.fCachedSize = null;
        this.addActionListener(this);
        this.addMWTListListener(this);
        this.addItemListener(this);
        this.fUpdater.start();
        this.setObject(null);
    }

    protected void dumpProperties(PrintStream printStream) {
        Object[] objectArray = this.getTarget().getObjects();
        printStream.println("=================================================");
        printStream.println("Properties for:");
        int n = 0;
        while (n < objectArray.length) {
            printStream.println(objectArray[n].getClass().getName());
            ++n;
        }
        printStream.println("-------------------------------------------------");
        this.expandAll();
        int n2 = this.getFirstItem();
        while (n2 != -1) {
            String string = "";
            int n3 = this.getParentId(n2);
            while (n3 != -1) {
                string = String.valueOf(string) + "    ";
                n3 = this.getParentId(n3);
            }
            string = String.valueOf(string) + this.getCell(n2).getName();
            printStream.println(string);
            n2 = this.getNextItem(n2);
        }
        printStream.println("=================================================");
    }

    private void expandAll() {
        int n = this.getFirstItem();
        boolean bl = ((Component)((Object)this)).isVisible();
        this.setVisible(false);
        while (n != -1) {
            if (this.isItemKiddable(n) && !this.isItemTwisted(n)) {
                this.expand(this.getCell(n));
                this.setItemTwisted(n, true);
                this.setColumnWidths();
            }
            n = this.getNextItem(n);
        }
        this.setVisible(bl);
    }

    private Color makeShade(Color color, int n, int n2) {
        int n3 = color.getRed();
        int n4 = color.getGreen();
        int n5 = color.getBlue();
        n3 -= n3 * n / n2;
        n4 -= n4 * n / n2;
        n5 -= n5 * n / n2;
        return new Color(n3, n4, n5);
    }

    public boolean getCallbacksOnly() {
        return this.fCallbacksOnly;
    }

    public synchronized void setCallbacksOnly(boolean bl) {
        if (bl != this.fCallbacksOnly) {
            this.fCallbacksOnly = bl;
            if (this.fTarget != null) {
                this.fPendingObjects = this.fTarget.getObjects();
                this.fUpdatePending = true;
                this.notifyAll();
            }
        }
    }

    public boolean getShowReadOnly() {
        return this.fShowReadOnly;
    }

    public synchronized void setShowReadOnly(boolean bl) {
        if (bl != this.fShowReadOnly) {
            this.fShowReadOnly = bl;
            if (this.fTarget != null) {
                this.fPendingObjects = this.fTarget.getObjects();
                this.fUpdatePending = true;
                this.notifyAll();
            }
        }
    }

    synchronized void setObject(Object object) {
        Object[] objectArray = new Object[]{object};
        this.setObject(objectArray);
    }

    synchronized void setObject(Object[] objectArray) {
        this.setObject(objectArray, null);
    }

    synchronized void setObject(Object[] objectArray, PropertyFilter propertyFilter) {
        this.fFilter = propertyFilter;
        this.fPendingObjects = objectArray;
        this.fUpdatePending = true;
        this.notifyAll();
    }

    synchronized void updateValues() {
        this.fValueRefreshPending = true;
        this.notifyAll();
    }

    synchronized void setFilter(PropertyFilter propertyFilter) {
        if (this.fTarget != null) {
            this.fFilter = propertyFilter;
            this.fPendingObjects = this.fTarget.getObjects();
            this.fUpdatePending = true;
            this.notifyAll();
        }
    }

    PropertyTarget getTarget() {
        return this.fTarget;
    }

    void setRegistry(ObjectRegistry objectRegistry) {
        this.fRegistry = objectRegistry;
    }

    ObjectRegistry getRegistry() {
        return this.fRegistry;
    }

    private PropertyCell getCell(int n) {
        PropertyCell propertyCell = null;
        propertyCell = (PropertyCell)this.fCellsHash.get(new Integer(n));
        return propertyCell;
    }

    private void refreshValues() {
        this.fTarget.refreshValues();
        int n = 0;
        while (n < this.fTopLevelCells.size()) {
            ((PropertyCell)this.fTopLevelCells.elementAt(n)).refreshChildren();
            ++n;
        }
    }

    private void populate(Object[] objectArray) {
        int n = 0;
        PropertyCell propertyCell = this.getCell(this.fInCellItem);
        if (propertyCell != null) {
            propertyCell.finishEdit();
            this.fInCellItem = -1;
        }
        this.removeAll();
        this.fCellsHash.clear();
        this.fTopLevelCells.removeAllElements();
        this.fTarget = new PropertyTarget(objectArray, this);
        if (this.fFilter != null) {
            this.fTarget.setFilter(this.fFilter);
        }
        while (this.fTarget.hasMoreProperties()) {
            NamedEditor namedEditor = this.fTarget.nextProperty();
            if (namedEditor == null || namedEditor.getEditor() == null || !namedEditor.isEditable() && !this.fShowReadOnly || this.fCallbacksOnly && !(namedEditor.getEditor() instanceof CallbackEditor)) continue;
            PropertyCell propertyCell2 = PropertyCell.makePropertyCell(this, this.fTarget, -1, n, namedEditor);
            this.fTopLevelCells.addElement(propertyCell2);
            this.fCellsHash.put(new Integer(n), propertyCell2);
            if (this.fExpandedProps.contains(propertyCell2.getName())) {
                this.setItemTwisted(n, true);
                this.expand(propertyCell2);
            }
            ++n;
        }
        this.setColumnWidths();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension();
        int[] nArray = this.calcColumnWidths();
        dimension.height = 285;
        dimension.width = nArray[0] + nArray[1] + 30;
        return dimension;
    }

    void setColumnWidths() {
        PropertyCell propertyCell;
        int[] nArray = this.calcColumnWidths();
        this.setColumnWidths(nArray);
        if (this.fInCellItem != -1 && (propertyCell = (PropertyCell)this.fCellsHash.get(new Integer(this.fInCellItem))) != null) {
            propertyCell.updateBounds();
        }
        if (((Component)((Object)this)).isShowing()) {
            ((Component)((Object)this)).repaint(5L);
        }
    }

    private int[] calcColumnWidths() {
        int[] nArray = new int[2];
        Font font = this.getFont();
        FontMetrics fontMetrics = ((Component)((Object)this)).getFontMetrics(font);
        int n = fontMetrics.charWidth('3') * 3;
        nArray[0] = 170;
        int n2 = this.getFirstItem();
        while (n2 != -1) {
            String string = this.getCell(n2).getName();
            int n3 = fontMetrics.stringWidth(string) + fontMetrics.charWidth('3') + 10 + n;
            int n4 = this.getParentId(n2);
            while (n4 != -1) {
                n3 += n;
                n4 = this.getParentId(n4);
            }
            if (n3 > nArray[0]) {
                nArray[0] = n3;
            }
            n2 = this.getNextItem();
        }
        nArray[1] = ((Component)((Object)this)).getSize().width - nArray[0] - 30;
        if (nArray[1] < 170) {
            nArray[1] = 170;
        }
        return nArray;
    }

    public void paint(Graphics graphics) {
        if (this.fCachedSize == null || !this.fCachedSize.equals(((Component)((Object)this)).getSize())) {
            this.fCachedSize = ((Component)((Object)this)).getSize();
            this.setColumnWidths();
        }
        super.paint(graphics);
    }

    public void selectProperty(String string) {
        if (!this.fUpdating) {
            this.selectPropertyImpl(string);
            return;
        }
        this.fPropertyToSelect = string;
    }

    private void selectPropertyImpl(String string) {
        int n = -1;
        int n2 = 0;
        PropertyCell propertyCell = null;
        while (n2 < this.fTopLevelCells.size() && n == -1) {
            propertyCell = (PropertyCell)this.fTopLevelCells.elementAt(n2);
            if (propertyCell.getName().equalsIgnoreCase(string)) {
                n = propertyCell.getItemId();
            }
            ++n2;
        }
        if (n != -1) {
            this.selectItem(n);
            this.showFirstSelectedItem();
            if (propertyCell instanceof PropertyCellEditField) {
                ((PropertyCellEditField)propertyCell).startEdit();
            }
        }
    }

    public void drawItem(Graphics graphics, int n, int n2, Rectangle rectangle, boolean bl) {
        PropertyCell propertyCell = this.getCell(n);
        if (propertyCell != null) {
            graphics.setFont(this.getFont());
            switch (n2) {
                case 0: {
                    propertyCell.drawName(graphics, rectangle, bl);
                    return;
                }
                case 1: {
                    propertyCell.drawValue(graphics, rectangle);
                    return;
                }
            }
        }
    }

    public boolean clickItem(MouseEvent mouseEvent, int n, int n2, Rectangle rectangle) {
        boolean bl = false;
        PropertyCell propertyCell = this.getCell(n);
        if (this.fInCellItem != -1 && this.fInCellItem != n) {
            PropertyCell propertyCell2 = this.getCell(this.fInCellItem);
            propertyCell2.finishEdit();
            this.fInCellItem = -1;
        }
        if (propertyCell != null && propertyCell.isEditable()) {
            switch (n2) {
                case 0: {
                    bl = propertyCell.clickName(mouseEvent.getPoint(), rectangle);
                    break;
                }
                case 1: {
                    bl = propertyCell.clickValue(mouseEvent.getPoint(), rectangle);
                    break;
                }
            }
            this.fTrackingItem = propertyCell.isTracking() ? n : -1;
            this.fInCellItem = propertyCell.isEditInProgress() ? n : -1;
        }
        return bl;
    }

    private void expand(PropertyCell propertyCell) {
        if (propertyCell != null) {
            Vector vector;
            if (this.fTopLevelCells.contains(propertyCell) && !this.fExpandedProps.contains(propertyCell.getName())) {
                this.fExpandedProps.addElement(propertyCell.getName());
            }
            if ((vector = propertyCell.expand()).size() > 0) {
                int n = 0;
                while (n < vector.size()) {
                    PropertyCell propertyCell2 = (PropertyCell)vector.elementAt(n);
                    if (propertyCell2 != null) {
                        this.fCellsHash.put(new Integer(propertyCell2.getItemId()), propertyCell2);
                    }
                    ++n;
                }
            }
        }
    }

    private void collapse(PropertyCell propertyCell) {
        if (propertyCell != null) {
            if (this.fTopLevelCells.contains(propertyCell) && this.fExpandedProps.contains(propertyCell.getName())) {
                this.fExpandedProps.removeElement(propertyCell.getName());
            }
            propertyCell.collapse();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        PropertyCell propertyCell = this.getCell(this.fTrackingItem);
        if (propertyCell == null || !propertyCell.mouseReleased(mouseEvent.getPoint())) {
            super.mouseReleased(mouseEvent);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        PropertyCell propertyCell = this.getCell(this.fTrackingItem);
        if (propertyCell == null || !propertyCell.mouseDragged(mouseEvent.getPoint())) {
            super.mouseDragged(mouseEvent);
        }
    }

    public void expandItem(MWTListEvent mWTListEvent) {
        this.expand(this.getCell(mWTListEvent.getItemId()));
        this.setColumnWidths();
    }

    public void collapseItem(MWTListEvent mWTListEvent) {
        int[] nArray = this.getDescendants(mWTListEvent.getItemId());
        if (nArray != null && nArray.length > 0) {
            int n = 0;
            while (n < nArray.length) {
                PropertyCell propertyCell = this.getCell(nArray[n]);
                propertyCell.finishEdit();
                if (nArray[n] == this.fInCellItem) {
                    this.fInCellItem = -1;
                }
                this.fCellsHash.remove(new Integer(nArray[n]));
                ++n;
            }
        }
        this.collapse(this.getCell(mWTListEvent.getItemId()));
        this.setColumnWidths();
    }

    public void scrollList(MWTListEvent mWTListEvent) {
        PropertyCell propertyCell = this.getCell(this.fInCellItem);
        if (propertyCell != null) {
            propertyCell.updateBounds();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n = this.getFirstSelectedItem();
        PropertyCell propertyCell = this.getCell(n);
        if (propertyCell instanceof PropertyCellEditField) {
            PropertyCellEditField propertyCellEditField = (PropertyCellEditField)propertyCell;
            Rectangle rectangle = this.getItemRect(n, 1);
            Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y + 1, rectangle.height - 1, rectangle.height - 1);
            Rectangle rectangle3 = new Rectangle(rectangle2.x + rectangle2.width, rectangle2.y, rectangle.width - rectangle2.width, rectangle2.height);
            propertyCellEditField.startEdit(rectangle3);
            return;
        }
        if (propertyCell instanceof PropertyCellCustom) {
            ((PropertyCellCustom)propertyCell).invokeContentEditor();
            return;
        }
        if (propertyCell instanceof PropertyCellBoolean) {
            ((PropertyCellBoolean)propertyCell).toggleBooleanValue();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getItemSelectable() == this) {
            PropertyCell propertyCell = this.getCell(this.fInCellItem);
            if (itemEvent.getStateChange() == 2 && propertyCell != null) {
                propertyCell.finishEdit();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        while (true) {
            PropertyViewList propertyViewList;
            block23: {
                Object[] objectArray;
                propertyViewList = this;
                synchronized (propertyViewList) {
                    while (true) {
                        if (((Component)((Object)this)).isShowing() && (this.fUpdatePending || this.fValueRefreshPending)) {
                            this.fUpdating = true;
                            objectArray = this.fUpdatePending ? this.fPendingObjects : null;
                        }
                        try {
                            this.wait();
                        }
                        catch (Exception exception) {}
                    }
                    this.fUpdatePending = false;
                    this.fValueRefreshPending = false;
                }
                if (objectArray != null) {
                    this.fUseMatlabThread = false;
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        if (objectArray[n2] != null && objectArray[n2] instanceof UDDObject) {
                            this.fUseMatlabThread = true;
                            break;
                        }
                        ++n2;
                    }
                }
                if (this.fUseMatlabThread) {
                    this.fWaitForMatlab = true;
                    Matlab.whenMatlabReady((Runnable)new UpdateObjectsFromMatlab(objectArray));
                    PropertyViewList propertyViewList2 = this;
                    synchronized (propertyViewList2) {
                        while (true) {
                            if (!this.fWaitForMatlab) {
                                break block23;
                            }
                            try {
                                this.wait();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                this.updateObjects(objectArray);
            }
            propertyViewList = this;
            synchronized (propertyViewList) {
                this.fUpdating = false;
                if (this.fPropertyToSelect != null) {
                    this.selectPropertyImpl(this.fPropertyToSelect);
                    this.fPropertyToSelect = null;
                }
            }
        }
    }

    private void updateObjects(Object[] objectArray) {
        block7: {
            boolean bl = ((Component)((Object)this)).getParent().isVisible();
            if (bl) {
                this.setVisible(false);
            }
            try {
                try {
                    if (objectArray != null) {
                        this.populate(objectArray);
                    } else {
                        this.refreshValues();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                Object var4_4 = null;
                if (!bl) break block7;
            }
            catch (Throwable throwable) {
                block8: {
                    Object var4_5 = null;
                    if (!bl) break block8;
                    this.setVisible(true);
                }
                throw throwable;
            }
            this.setVisible(true);
        }
    }

    private void updateObjectsFromMatlab(Object[] objectArray) {
        this.updateObjects(objectArray);
        PropertyViewList propertyViewList = this;
        synchronized (propertyViewList) {
            this.fWaitForMatlab = false;
            this.notifyAll();
            return;
        }
    }

    private class UpdateObjectsFromMatlab
    implements Runnable {
        private Object[] fObjects;

        UpdateObjectsFromMatlab(Object[] objectArray) {
            PropertyViewList.this = PropertyViewList.this;
            this.fObjects = objectArray;
        }

        public void run() {
            PropertyViewList.this.updateObjectsFromMatlab(this.fObjects);
            this.fObjects = null;
        }
    }
}

