/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.inspector;

import com.mathworks.ide.filtermgr.PropertyFilter;
import com.mathworks.ide.inspector.PropertyViewList;
import com.mathworks.mwt.MWPanel;
import com.mathworks.services.ObjectRegistry;
import com.mathworks.services.ObjectRegistryEvent;
import com.mathworks.services.ObjectRegistryListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.PrintStream;

public class PropertyView
extends MWPanel {
    private Object[] fObjects;
    private ObjectRegistry fRegistry;
    private RegistryHandler fRegistryHandler = new RegistryHandler();
    private PropertyViewList fList;

    public PropertyView() {
        this(ObjectRegistry.getRegistry());
    }

    public PropertyView(ObjectRegistry objectRegistry) {
        this.setOpaque(false);
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.fList = new PropertyViewList(objectRegistry);
        ((Container)((Object)this)).add((Component)((Object)this.fList), "Center");
        this.setCallbacksOnly(false);
        this.setRegistry(objectRegistry);
    }

    public ObjectRegistry getRegistry() {
        return this.fRegistry;
    }

    public void setRegistry(ObjectRegistry objectRegistry) {
        if (this.fRegistry != null) {
            this.fRegistry.removeItemListener((ItemListener)this.fRegistryHandler);
            this.fRegistry.removeObjectRegistryListener((ObjectRegistryListener)this.fRegistryHandler);
        }
        this.fRegistry = objectRegistry;
        this.fList.setRegistry(objectRegistry);
        if (this.fRegistry != null) {
            this.fRegistry.addItemListener((ItemListener)this.fRegistryHandler);
            this.fRegistry.addObjectRegistryListener((ObjectRegistryListener)this.fRegistryHandler);
            this.setObject(this.fRegistry.getSelectedObjects());
        }
    }

    public void requestFocus() {
        ((Component)((Object)this.fList)).requestFocus();
    }

    public boolean getCallbacksOnly() {
        return this.fList.getCallbacksOnly();
    }

    public void setCallbacksOnly(boolean bl) {
        this.fList.setCallbacksOnly(bl);
    }

    public boolean getShowReadOnly() {
        return this.fList.getShowReadOnly();
    }

    public void setShowReadOnly(boolean bl) {
        this.fList.setShowReadOnly(bl);
    }

    public Font getFont() {
        return this.fList.getFont();
    }

    public void setFont(Font font) {
        this.fList.setFont(font);
    }

    public void selectProperty(String string) {
        this.fList.selectProperty(string);
    }

    public Object[] getObjects() {
        return this.fObjects;
    }

    public void setObject(Object object) {
        Object[] objectArray = new Object[]{object};
        this.setObject(objectArray);
    }

    public void setObject(Object[] objectArray) {
        this.setObject(objectArray, null);
    }

    public void setObject(Object[] objectArray, PropertyFilter propertyFilter) {
        this.fObjects = objectArray;
        this.fList.setObject(objectArray, propertyFilter);
    }

    public void setFilter(PropertyFilter propertyFilter) {
        this.fList.setFilter(propertyFilter);
    }

    public void dumpProperties(PrintStream printStream) {
        this.fList.dumpProperties(printStream);
    }

    public void triggerRefresh() {
        PropertyViewList propertyViewList = this.fList;
        synchronized (propertyViewList) {
            this.fList.notifyAll();
            return;
        }
    }

    public void updateValues() {
        this.fList.updateValues();
    }

    private class RegistryHandler
    implements ItemListener,
    ObjectRegistryListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            if (PropertyView.this.fRegistry != null) {
                Object[] objectArray = PropertyView.this.fRegistry.getSelectedObjects();
                if (itemEvent.getStateChange() == 1 || objectArray.length == 0) {
                    PropertyView.this.setObject(objectArray);
                }
            }
        }

        public void objectChanged(ObjectRegistryEvent objectRegistryEvent) {
            PropertyView.this.fList.updateValues();
        }

        public void objectRegistered(ObjectRegistryEvent objectRegistryEvent) {
        }

        public void objectUnregistered(ObjectRegistryEvent objectRegistryEvent) {
        }

        public void objectMoved(ObjectRegistryEvent objectRegistryEvent) {
        }

        public void transactionStarted(ObjectRegistryEvent objectRegistryEvent) {
        }

        public void transactionEnded(ObjectRegistryEvent objectRegistryEvent) {
        }

        RegistryHandler() {
            PropertyView.this = PropertyView.this;
        }
    }
}

