/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.inspector;

import com.mathworks.beans.editors.DynamicBeanInfo;
import com.mathworks.beans.editors.MWPropertyEditorUtils;
import com.mathworks.ide.filtermgr.PropertyFilter;
import com.mathworks.ide.inspector.MultiValue;
import com.mathworks.ide.inspector.NamedEditor;
import com.mathworks.ide.inspector.PropertyViewList;
import java.awt.Component;
import java.awt.Frame;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class PropertyTarget
implements PropertyChangeListener {
    private Object[] fObjects;
    private PropertyTarget fParent;
    private String fPropertyName;
    private PropertyViewList fView;
    private PropertyFilter fFilter;
    private Hashtable fProperties;
    private PropertyDescriptor[] fMergedProperties;
    private NamedEditor[] fEditors;
    private int fEnumCounter;
    static /* synthetic */ Class class$com$mathworks$beans$editors$DynamicBeanInfo;

    PropertyTarget(Object[] objectArray, PropertyViewList propertyViewList, PropertyTarget propertyTarget, String string) {
        this.fObjects = objectArray;
        this.fView = propertyViewList;
        this.fEnumCounter = 0;
        this.fParent = propertyTarget;
        this.fPropertyName = string;
        this.fFilter = null;
        this.buildPropertyList();
    }

    PropertyTarget(Object[] objectArray, PropertyTarget propertyTarget, String string) {
        this(objectArray, null, propertyTarget, string);
    }

    PropertyTarget(Object[] objectArray, PropertyViewList propertyViewList) {
        this(objectArray, propertyViewList, null, null);
    }

    PropertyTarget(Object[] objectArray) {
        this(objectArray, null, null, null);
    }

    private void buildPropertyList() {
        if (this.fObjects != null) {
            this.fProperties = new Hashtable();
            int n = 0;
            while (n < this.fObjects.length) {
                Class<?> clazz;
                if (this.fObjects[n] != null && !this.fProperties.containsKey((clazz = this.fObjects[n].getClass()).getName())) {
                    this.fProperties.put(clazz.getName(), this.getProperties(this.fObjects[n]));
                }
                ++n;
            }
            if (this.fProperties.size() > 0) {
                Enumeration enumeration = this.fProperties.elements();
                this.fMergedProperties = (PropertyDescriptor[])enumeration.nextElement();
                while (enumeration.hasMoreElements()) {
                    PropertyDescriptor[] propertyDescriptorArray = (PropertyDescriptor[])enumeration.nextElement();
                    this.fMergedProperties = this.mergeProperties(this.fMergedProperties, propertyDescriptorArray);
                }
                if (this.fObjects.length > 1) {
                    this.fMergedProperties = this.removeDynamicProperties(this.fMergedProperties);
                }
                this.fMergedProperties = this.filterProperties(this.fMergedProperties);
                this.fMergedProperties = this.removeNoInspectProperties(this.fMergedProperties);
                this.fEditors = new NamedEditor[this.fMergedProperties.length];
                int n2 = 0;
                while (n2 < this.fMergedProperties.length) {
                    Method method = this.fMergedProperties[n2].getReadMethod();
                    Method method2 = this.fMergedProperties[n2].getWriteMethod();
                    if (method != null) {
                        PropertyEditor propertyEditor = this.getEditor(this.fMergedProperties[n2]);
                        this.fEditors[n2] = new NamedEditor(this.fMergedProperties[n2].getDisplayName(), propertyEditor, method2 != null);
                    } else {
                        this.fEditors[n2] = null;
                    }
                    ++n2;
                }
            }
            this.refreshValues();
        }
    }

    void refreshValues() {
        Object[] objectArray;
        if (this.fParent != null && this.fPropertyName != null && (objectArray = this.fParent.getValuesAsArray(this.fPropertyName)).length == this.fObjects.length) {
            this.fObjects = objectArray;
        }
        if (this.fMergedProperties != null) {
            int n = 0;
            while (n < this.fMergedProperties.length) {
                PropertyEditor propertyEditor;
                if (this.fEditors != null && this.fEditors[n] != null && (propertyEditor = this.fEditors[n].getEditor()) != null) {
                    propertyEditor.removePropertyChangeListener(this);
                    try {
                        MultiValue multiValue = this.getMultiValue(this.fMergedProperties[n].getDisplayName());
                        propertyEditor.setValue(multiValue.getValue());
                        this.fEditors[n].setMixed(multiValue.isMixed());
                    }
                    catch (Exception exception) {}
                    propertyEditor.addPropertyChangeListener(this);
                }
                ++n;
            }
        }
    }

    private PropertyDescriptor[] getProperties(Object object) {
        Class<?> clazz = null;
        BeanInfo beanInfo = null;
        PropertyDescriptor[] propertyDescriptorArray = new PropertyDescriptor[]{};
        try {
            if (object instanceof DynamicBeanInfo) {
                DynamicBeanInfo dynamicBeanInfo = (DynamicBeanInfo)object;
                propertyDescriptorArray = dynamicBeanInfo.getDynamicPropertyDescriptors();
            } else {
                if (object != null) {
                    clazz = object.getClass();
                }
                if (clazz != null) {
                    beanInfo = Introspector.getBeanInfo(clazz);
                }
                if (beanInfo != null) {
                    propertyDescriptorArray = beanInfo.getPropertyDescriptors();
                }
            }
            if (propertyDescriptorArray != null) {
                this.sortProperties(propertyDescriptorArray);
            }
        }
        catch (Exception exception) {}
        return propertyDescriptorArray;
    }

    private PropertyDescriptor[] getClassProperties(Class clazz) {
        BeanInfo beanInfo = null;
        PropertyDescriptor[] propertyDescriptorArray = new PropertyDescriptor[]{};
        try {
            if (clazz != null) {
                beanInfo = Introspector.getBeanInfo(clazz);
            }
            if (beanInfo != null) {
                propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            }
            if (propertyDescriptorArray != null) {
                this.sortProperties(propertyDescriptorArray);
            }
        }
        catch (Exception exception) {}
        return propertyDescriptorArray;
    }

    private String sortKey(PropertyDescriptor propertyDescriptor) {
        String string = (String)propertyDescriptor.getValue("BeanUtils.SortKey");
        if (string == null) {
            string = propertyDescriptor.getDisplayName().toLowerCase();
        }
        return string;
    }

    private int compare(PropertyDescriptor propertyDescriptor, PropertyDescriptor propertyDescriptor2) {
        return this.sortKey(propertyDescriptor).compareTo(this.sortKey(propertyDescriptor2));
    }

    private void sortProperties(PropertyDescriptor[] propertyDescriptorArray) {
        int n = 0;
        while (n < propertyDescriptorArray.length) {
            int n2 = n;
            int n3 = n + 1;
            while (n3 < propertyDescriptorArray.length) {
                if (this.compare(propertyDescriptorArray[n3], propertyDescriptorArray[n2]) < 0) {
                    n2 = n3;
                }
                ++n3;
            }
            PropertyDescriptor propertyDescriptor = propertyDescriptorArray[n2];
            propertyDescriptorArray[n2] = propertyDescriptorArray[n];
            propertyDescriptorArray[n] = propertyDescriptor;
            ++n;
        }
    }

    private boolean propertiesMatch(PropertyDescriptor propertyDescriptor, PropertyDescriptor propertyDescriptor2) {
        String string = propertyDescriptor.getDisplayName().toLowerCase();
        String string2 = propertyDescriptor2.getDisplayName().toLowerCase();
        String string3 = "unknown";
        String string4 = "unknown";
        PropertyEditor propertyEditor = this.getEditor(propertyDescriptor);
        PropertyEditor propertyEditor2 = this.getEditor(propertyDescriptor2);
        String string5 = "null";
        String string6 = "null";
        String[] stringArray = null;
        String[] stringArray2 = null;
        if (propertyDescriptor.getPropertyType() != null) {
            string3 = propertyDescriptor.getPropertyType().getName();
        }
        if (propertyDescriptor2.getPropertyType() != null) {
            string4 = propertyDescriptor2.getPropertyType().getName();
        }
        if (propertyEditor != null) {
            string5 = propertyEditor.getClass().getName();
            stringArray = propertyEditor.getTags();
        }
        if (propertyEditor2 != null) {
            string6 = propertyEditor2.getClass().getName();
            stringArray2 = propertyEditor2.getTags();
        }
        boolean bl = true;
        if (propertyEditor == null || propertyEditor2 == null) {
            bl = false;
        } else if (!string5.equals(string6)) {
            bl = false;
        } else if (stringArray == null ^ stringArray2 == null) {
            bl = false;
        } else if (stringArray != null && stringArray2 != null) {
            if (stringArray.length != stringArray2.length) {
                bl = false;
            } else {
                int n = 0;
                while (n < stringArray.length) {
                    if (!stringArray[n].equals(stringArray2[n])) {
                        bl = false;
                        break;
                    }
                    ++n;
                }
            }
        }
        return string.equals(string2) && string3.equals(string3) && bl;
    }

    PropertyDescriptor[] removeDynamicProperties(PropertyDescriptor[] propertyDescriptorArray) {
        if (propertyDescriptorArray != null) {
            Vector<PropertyDescriptor> vector = new Vector<PropertyDescriptor>(propertyDescriptorArray.length);
            int n = 0;
            while (n < propertyDescriptorArray.length) {
                Class<?> clazz = propertyDescriptorArray[n].getPropertyType();
                if (clazz != null && !(class$com$mathworks$beans$editors$DynamicBeanInfo != null ? class$com$mathworks$beans$editors$DynamicBeanInfo : PropertyTarget.class$("com.mathworks.beans.editors.DynamicBeanInfo")).isAssignableFrom(clazz)) {
                    vector.addElement(propertyDescriptorArray[n]);
                }
                ++n;
            }
            Object[] objectArray = new PropertyDescriptor[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return propertyDescriptorArray;
    }

    PropertyDescriptor[] filterProperties(PropertyDescriptor[] propertyDescriptorArray) {
        if (this.fFilter != null && propertyDescriptorArray != null) {
            Vector<PropertyDescriptor> vector = new Vector<PropertyDescriptor>(propertyDescriptorArray.length);
            int n = 0;
            while (n < propertyDescriptorArray.length) {
                if (this.fFilter.contains(propertyDescriptorArray[n].getDisplayName())) {
                    vector.addElement(propertyDescriptorArray[n]);
                }
                ++n;
            }
            Object[] objectArray = new PropertyDescriptor[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return propertyDescriptorArray;
    }

    PropertyDescriptor[] removeNoInspectProperties(PropertyDescriptor[] propertyDescriptorArray) {
        int n = 0;
        boolean bl = false;
        while (!bl && n < propertyDescriptorArray.length) {
            boolean bl2 = bl = propertyDescriptorArray[n++].getValue("BeanUtils.NoInspectKey") != null;
        }
        if (bl) {
            Vector<PropertyDescriptor> vector = new Vector<PropertyDescriptor>(propertyDescriptorArray.length);
            n = 0;
            while (n < propertyDescriptorArray.length) {
                if (propertyDescriptorArray[n].getValue("BeanUtils.NoInspectKey") == null) {
                    vector.addElement(propertyDescriptorArray[n]);
                }
                ++n;
            }
            Object[] objectArray = new PropertyDescriptor[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return propertyDescriptorArray;
    }

    private PropertyDescriptor[] mergeProperties(PropertyDescriptor[] propertyDescriptorArray, PropertyDescriptor[] propertyDescriptorArray2) {
        PropertyDescriptor[] propertyDescriptorArray3 = new PropertyDescriptor[Math.min(propertyDescriptorArray.length, propertyDescriptorArray2.length)];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n < propertyDescriptorArray.length && n2 < propertyDescriptorArray2.length) {
            String string = propertyDescriptorArray[n].getDisplayName().toLowerCase();
            String string2 = propertyDescriptorArray[n].getDisplayName().toLowerCase();
            if (this.propertiesMatch(propertyDescriptorArray[n], propertyDescriptorArray2[n2])) {
                propertyDescriptorArray3[n3++] = propertyDescriptorArray[n];
                ++n;
                ++n2;
                continue;
            }
            if (string.compareTo(string2) < 0) {
                ++n;
                continue;
            }
            if (n >= propertyDescriptorArray.length || ++n2 < propertyDescriptorArray2.length) continue;
            ++n;
            n2 = 0;
        }
        PropertyDescriptor[] propertyDescriptorArray4 = new PropertyDescriptor[n3];
        if (n3 > 0) {
            System.arraycopy(propertyDescriptorArray3, 0, propertyDescriptorArray4, 0, n3);
        }
        return propertyDescriptorArray4;
    }

    private PropertyEditor getEditor(PropertyDescriptor propertyDescriptor) {
        Class<?> clazz = propertyDescriptor.getPropertyType();
        Class<?> clazz2 = propertyDescriptor.getPropertyEditorClass();
        PropertyEditor propertyEditor = null;
        if (clazz2 != null) {
            try {
                propertyEditor = (PropertyEditor)clazz2.newInstance();
            }
            catch (Exception exception) {}
        }
        if (propertyEditor == null && clazz != null) {
            propertyEditor = PropertyEditorManager.findEditor(clazz);
        }
        if (propertyEditor != null) {
            if (this.fObjects != null && this.fObjects.length > 0) {
                MWPropertyEditorUtils.setEditObject((PropertyEditor)propertyEditor, (Object)this.fObjects[0]);
            }
            MWPropertyEditorUtils.setFrame((PropertyEditor)propertyEditor, (Frame)this.getParentFrame((Component)((Object)this.fView)));
            if (MWPropertyEditorUtils.hasAttachedData((PropertyEditor)propertyEditor)) {
                String string = MWPropertyEditorUtils.getDataKey((PropertyEditor)propertyEditor);
                MWPropertyEditorUtils.setData((PropertyEditor)propertyEditor, (Object)propertyDescriptor.getValue(string));
            }
            propertyEditor.addPropertyChangeListener(this);
        }
        return propertyEditor;
    }

    private Frame getParentFrame(Component component) {
        Component component2 = component;
        while (component2 != null && !(component2 instanceof Frame)) {
            component2 = component2.getParent();
        }
        if (component2 instanceof Frame) {
            return (Frame)component2;
        }
        return null;
    }

    private PropertyDescriptor getDescriptor(Class clazz, String string) {
        String string2 = string.toLowerCase();
        PropertyDescriptor propertyDescriptor = null;
        String string3 = clazz.getName();
        PropertyDescriptor[] propertyDescriptorArray = (PropertyDescriptor[])this.fProperties.get(string3);
        if (propertyDescriptorArray != null) {
            int n = 0;
            while (n < propertyDescriptorArray.length) {
                if (propertyDescriptorArray[n].getDisplayName().toLowerCase().equals(string2)) {
                    propertyDescriptor = propertyDescriptorArray[n];
                    break;
                }
                ++n;
            }
        }
        return propertyDescriptor;
    }

    private Object getPropertyValue(Object object, PropertyDescriptor propertyDescriptor) {
        Object object2;
        block2: {
            object2 = null;
            Method method = propertyDescriptor.getReadMethod();
            Object[] objectArray = new Object[]{};
            if (method == null) break block2;
            try {
                object2 = method.invoke(object, objectArray);
            }
            catch (Exception exception) {}
        }
        return object2;
    }

    MultiValue getMultiValue(String string) {
        Object object = null;
        boolean bl = false;
        if (this.fObjects != null && this.fObjects.length > 0) {
            object = this.getPropertyValue(this.fObjects[0], this.getDescriptor(this.fObjects[0].getClass(), string));
            int n = 1;
            while (n < this.fObjects.length) {
                Object object2 = this.getPropertyValue(this.fObjects[n], this.getDescriptor(this.fObjects[n].getClass(), string));
                if (object == null) {
                    if (object2 != null) {
                        bl = true;
                        break;
                    }
                } else if (object2 == null || !object2.equals(object)) {
                    object = null;
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        return new MultiValue(object, bl);
    }

    String getPropertyName() {
        return this.fPropertyName;
    }

    void updateValues() {
    }

    private Object[] getValuesAsArray(String string) {
        Object[] objectArray = new Object[]{};
        Object[] objectArray2 = new Object[]{};
        if (this.fObjects != null && this.fObjects[0] != null) {
            objectArray = new Object[this.fObjects.length];
            PropertyDescriptor propertyDescriptor = this.getDescriptor(this.fObjects[0].getClass(), string);
            PropertyEditor propertyEditor = this.getEditor(propertyDescriptor);
            propertyEditor.removePropertyChangeListener(this);
            int n = 0;
            while (n < this.fObjects.length) {
                propertyDescriptor = this.getDescriptor(this.fObjects[n].getClass(), string);
                Method method = propertyDescriptor.getReadMethod();
                try {
                    objectArray[n] = method.invoke(this.fObjects[n], objectArray2);
                }
                catch (Exception exception) {
                    objectArray[n] = null;
                }
                if (MWPropertyEditorUtils.canExpand((PropertyEditor)propertyEditor)) {
                    try {
                        propertyEditor.setValue(objectArray[n]);
                    }
                    catch (Exception exception) {}
                    objectArray[n] = MWPropertyEditorUtils.getIntrospectableValue((PropertyEditor)propertyEditor);
                }
                ++n;
            }
        }
        return objectArray;
    }

    PropertyTarget getValues(String string) {
        PropertyTarget propertyTarget = null;
        if (this.fObjects != null && this.fObjects[0] != null) {
            propertyTarget = new PropertyTarget(this.getValuesAsArray(string), this.fView, this, string);
        }
        return propertyTarget;
    }

    Object[] getObjects() {
        return this.fObjects;
    }

    int getPropertyCount() {
        return this.fEditors.length;
    }

    void setFilter(PropertyFilter propertyFilter) {
        this.fFilter = propertyFilter;
        this.buildPropertyList();
    }

    void resetEnumeration() {
        this.fEnumCounter = 0;
    }

    NamedEditor nextProperty() {
        if (this.fEditors != null) {
            return this.fEditors[this.fEnumCounter++];
        }
        return null;
    }

    boolean hasMoreProperties() {
        if (this.fEditors != null) {
            return this.fEnumCounter < this.fEditors.length;
        }
        return false;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object;
        PropertyDescriptor propertyDescriptor;
        int n;
        Object object2 = propertyChangeEvent.getSource();
        Method method = null;
        if (object2 instanceof PropertyEditor) {
            PropertyEditor propertyEditor = (PropertyEditor)object2;
            n = 0;
            while (n < this.fEditors.length) {
                if (this.fEditors[n] != null && propertyEditor == this.fEditors[n].getEditor()) break;
                ++n;
            }
            if (propertyEditor == this.fEditors[n].getEditor()) {
                int n2 = 0;
                while (n2 < this.fObjects.length) {
                    propertyDescriptor = this.getDescriptor(this.fObjects[n2].getClass(), this.fEditors[n].getName());
                    method = propertyDescriptor.getWriteMethod();
                    if (method != null) {
                        Object[] objectArray = new Object[]{propertyEditor.getValue()};
                        try {
                            method.invoke(this.fObjects[n2], objectArray);
                        }
                        catch (Exception exception) {
                            System.out.println("Exception while setting the value");
                        }
                    }
                    ++n2;
                }
            }
        } else if (object2 instanceof PropertyTarget) {
            PropertyTarget propertyTarget = (PropertyTarget)object2;
            String string = propertyTarget.getPropertyName();
            n = 0;
            while (n < this.fEditors.length) {
                if (this.fEditors[n] != null && this.fEditors[n].getName().equals(string)) break;
                ++n;
            }
            if (n < this.fEditors.length) {
                Object[] objectArray = propertyTarget.getObjects();
                if (objectArray.length == this.fObjects.length) {
                    int n3 = 0;
                    while (n3 < objectArray.length) {
                        Object object3;
                        object = this.fEditors[n].getEditor();
                        if (MWPropertyEditorUtils.canExpand((PropertyEditor)object)) {
                            object.removePropertyChangeListener(this);
                            MWPropertyEditorUtils.setIntrospectableValue((PropertyEditor)object, (Object)objectArray[n3]);
                            object3 = object.getValue();
                            object.addPropertyChangeListener(this);
                        } else {
                            object3 = objectArray[n3];
                        }
                        propertyDescriptor = this.getDescriptor(this.fObjects[n3].getClass(), this.fEditors[n].getName());
                        method = propertyDescriptor.getWriteMethod();
                        if (method != null) {
                            Object[] objectArray2 = new Object[]{object3};
                            try {
                                method.invoke(this.fObjects[n3], objectArray2);
                            }
                            catch (Exception exception) {
                                System.out.println("Exception while setting the value");
                            }
                        }
                        ++n3;
                    }
                } else {
                    System.out.println("value & object arrays not of same length");
                }
            }
        }
        if (this.fParent == null) {
            this.fView.getRegistry().change(this.fObjects, (Object)this);
        }
        Vector<Object> vector = new Vector<Object>();
        int n4 = 0;
        while (n4 < this.fObjects.length) {
            object = this.fView.getRegistry().getParent(this.fObjects[n4]);
            if (object instanceof Component && !vector.contains(object)) {
                vector.addElement(object);
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < vector.size()) {
            object = (Component)vector.elementAt(n4);
            ((Component)object).repaint(5L);
            ++n4;
        }
        if (this.fView != null) {
            ((Component)((Object)this.fView)).repaint(5L);
        }
        if (this.fParent != null) {
            this.fParent.propertyChange(new PropertyChangeEvent(this, null, null, null));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

