/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.inspector;

import com.mathworks.beans.editors.MWPropertyEditorUtils;
import com.mathworks.beans.editors.ValueValidityEvent;
import com.mathworks.beans.editors.ValueValidityListener;
import com.mathworks.beans.editors.ValueValiditySource;
import com.mathworks.ide.inspector.PropertyCell;
import com.mathworks.mwt.MWButton;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.command.MWCommandCenter;
import com.mathworks.mwt.command.MWCommandSource;
import com.mathworks.mwt.command.MWCommandTarget;
import com.mathworks.mwt.dialog.MWDialog;
import com.mathworks.mwt.window.MWWindowActivater;
import com.mathworks.mwt.window.MWWindowOwner;
import com.mathworks.util.PlatformInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.WindowListener;
import java.beans.PropertyEditor;

public class PropertyDialog
extends MWPanel
implements MWWindowOwner,
MWCommandTarget,
ValueValidityListener {
    private static final int DONE = 0;
    private static final int OK = 1;
    private static final int CANCEL = 2;
    private static final int NUM_BUTTONS = 3;
    private PropertyCell fOwner;
    private Component fEditorComponent;
    private MWCommandCenter fCommandCenter;
    private Dialog fDialog;

    PropertyDialog(String string, PropertyCell propertyCell) {
        Dimension dimension;
        this.fOwner = propertyCell;
        this.fCommandCenter = new MWCommandCenter((MWCommandTarget)this);
        ((Container)((Object)this)).setLayout(new BorderLayout());
        ((Component)((Object)this)).setFont(new Font("Dialog", 0, 10));
        this.fEditorComponent = propertyCell.getEditor().getCustomEditor();
        ((Container)((Object)this)).add("Center", this.fEditorComponent);
        MWPanel mWPanel = new MWPanel();
        mWPanel.setLayout(new FlowLayout(2));
        PropertyEditor propertyEditor = propertyCell.getEditor();
        if (MWPropertyEditorUtils.canApply((PropertyEditor)propertyEditor)) {
            if (PlatformInfo.getAppearance() == 0) {
                mWPanel.add((Component)this.buildCommandButton("Cancel", 2));
                mWPanel.add((Component)this.buildCommandButton("OK", 1));
            } else {
                mWPanel.add((Component)this.buildCommandButton("OK", 1));
                mWPanel.add((Component)this.buildCommandButton("Cancel", 2));
            }
        } else {
            mWPanel.add((Component)this.buildCommandButton("Done", 0));
        }
        ((Container)((Object)this)).add("South", (Component)mWPanel);
        if (string == null) {
            string = propertyCell.getEditor().getClass().getName();
        }
        Frame frame = this.getViewFrame();
        this.fDialog = new MWDialog(frame, string, true);
        this.fDialog.setResizable(false);
        this.fDialog.addWindowListener((WindowListener)new MWWindowActivater((Component)((Object)this)));
        this.fDialog.add((Component)((Object)this), "Center");
        if (PlatformInfo.getPlatform() == 2) {
            dimension = ((Container)((Object)this)).getPreferredSize();
            Insets insets = frame != null ? frame.getInsets() : new Insets(0, 0, 0, 0);
            dimension.width += insets.left + insets.right;
            dimension.height += insets.top + insets.bottom;
            ((Component)this.fDialog).setSize(dimension);
        } else {
            this.fDialog.pack();
        }
        if (this.fEditorComponent instanceof ValueValiditySource) {
            dimension = (ValueValiditySource)this.fEditorComponent;
            dimension.addValueValidityListener(this);
            this.setValueValid(dimension.isValueValid());
        }
        this.centerDialog();
        ((Component)this.fDialog).setVisible(true);
    }

    private void setValueValid(boolean bl) {
        this.fCommandCenter.setCommandEnabled(1, bl);
    }

    public void valueValidityChanged(ValueValidityEvent valueValidityEvent) {
        if (valueValidityEvent.getSource() == this.fEditorComponent) {
            this.setValueValid(valueValidityEvent.isValueValid());
        }
    }

    private void centerDialog() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.fDialog.getSize();
        int n = (dimension.width - dimension2.width) / 2;
        int n2 = (dimension.height - dimension2.height) / 2;
        ((Component)this.fDialog).setLocation(n, n2);
    }

    private Frame getViewFrame() {
        Container container = ((Component)((Object)this.fOwner.getView())).getParent();
        Frame frame = null;
        while (container != null && !(container instanceof Frame)) {
            container = container.getParent();
        }
        if (container instanceof Frame) {
            frame = (Frame)container;
        }
        return frame;
    }

    private MWButton buildCommandButton(String string, int n) {
        MWButton mWButton = new MWButton(string);
        this.fCommandCenter.addCommandSource((MWCommandSource)mWButton, n);
        return mWButton;
    }

    public void doCommand(int n) {
        PropertyEditor propertyEditor;
        if (n == 1 && MWPropertyEditorUtils.canApply((PropertyEditor)(propertyEditor = this.fOwner.getEditor()))) {
            MWPropertyEditorUtils.apply((PropertyEditor)propertyEditor);
        }
        this.closeWindow();
    }

    public int closeWindow() {
        if (this.fEditorComponent instanceof ValueValiditySource) {
            ((ValueValiditySource)this.fEditorComponent).removeValueValidityListener((ValueValidityListener)this);
        }
        if (this.fOwner != null) {
            this.fOwner.customEditorClosed();
        }
        this.fDialog.dispose();
        return 0;
    }

    public void setActive(boolean bl) {
    }

    public String getShortName() {
        return "";
    }

    public String getLongName() {
        return "";
    }
}

