/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.inspector;

import com.mathworks.beans.editors.MWPropertyEditorUtils;
import com.mathworks.ide.inspector.NamedEditor;
import com.mathworks.ide.inspector.PropertyCell;
import com.mathworks.ide.inspector.PropertyTarget;
import com.mathworks.ide.inspector.PropertyViewList;
import com.mathworks.mwt.MWMenu;
import com.mathworks.mwt.MWMenuComponent;
import com.mathworks.mwt.MWMenuItem;
import com.mathworks.mwt.command.MWCommandTarget;
import com.mathworks.mwt.decorations.Decorations;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyEditor;

class PropertyCellEnum
extends PropertyCell
implements MWCommandTarget {
    private MWMenu fMenu = null;

    PropertyCellEnum(PropertyViewList propertyViewList, PropertyTarget propertyTarget, int n, int n2, NamedEditor namedEditor) {
        super(propertyViewList, propertyTarget, n, n2, namedEditor);
    }

    void setEnumValue(String string) {
        if (!string.equals(this.getEditor().getAsText())) {
            this.getEditor().setAsText(string);
            ((Component)((Object)this.getView())).repaint();
        }
    }

    void dispose() {
        if (this.fMenu != null) {
            this.fMenu.disconnect();
            this.fMenu = null;
        }
    }

    boolean clickValue(Point point, Rectangle rectangle) {
        boolean bl = false;
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y + 1, rectangle.height - 1, rectangle.height - 1);
        new Rectangle(rectangle2.x + rectangle2.width, rectangle2.y, rectangle.width - rectangle2.width, rectangle2.height);
        if (rectangle.contains(point)) {
            Graphics graphics = ((Component)((Object)this.getView())).getGraphics();
            this.drawIconButton(graphics, true, rectangle2);
            graphics.dispose();
            String[] stringArray = this.getEditor().getTags();
            String string = this.getEditor().getAsText();
            if (this.fMenu == null) {
                this.fMenu = new MWMenu("");
                this.fMenu.attachTo((Component)((Object)this.getView()));
            }
            this.fMenu.removeAll();
            int n = 0;
            while (n < stringArray.length) {
                MWMenuItem mWMenuItem = new MWMenuItem(stringArray[n]);
                mWMenuItem.setFont(PropertyViewList.sInspectorFont);
                mWMenuItem.setTarget((MWCommandTarget)this);
                mWMenuItem.setState(stringArray[n].equals(string));
                mWMenuItem.setCommand(n);
                this.fMenu.add((MWMenuComponent)mWMenuItem);
                ++n;
            }
            this.fMenu.show((Component)((Object)this.getView()), rectangle2.x + rectangle2.width, rectangle2.y);
            this.getView().selectItem(this.getItemId());
            bl = true;
        } else {
            bl = super.clickValue(point, rectangle);
        }
        return bl;
    }

    public void doCommand(int n) {
        MWMenuItem mWMenuItem;
        if (n >= 0 && n < this.fMenu.getItemCount() && (mWMenuItem = (MWMenuItem)this.fMenu.getMenuComponent(n)) != null) {
            this.setEnumValue(mWMenuItem.getLabel());
        }
    }

    void drawValue(Graphics graphics, Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y + 1, rectangle.height - 1, rectangle.height - 1);
        Rectangle rectangle3 = new Rectangle(rectangle2.x + rectangle2.width, rectangle2.y, rectangle.width - rectangle2.width, rectangle2.height);
        super.drawValue(graphics, rectangle);
        this.drawIconButton(graphics, false, rectangle2);
    }

    private void drawIconButton(Graphics graphics, boolean bl, Rectangle rectangle) {
        Image image = null;
        if (!this.isEditable()) {
            return;
        }
        image = MWPropertyEditorUtils.getIcon((PropertyEditor)this.getEditor());
        if (image != null) {
            MediaTracker mediaTracker = new MediaTracker((Component)((Object)this.getView()));
            mediaTracker.addImage(image, 1);
            try {
                mediaTracker.waitForID(1);
            }
            catch (Exception exception) {}
        }
        Decorations.drawButtonBevel((Graphics)graphics, (Rectangle)rectangle, (boolean)bl, (boolean)false, (boolean)true);
        if (image != null) {
            Decorations.drawButtonImage((Graphics)graphics, (Image)image, (int)(rectangle.x + 1), (int)(rectangle.y + 1), (boolean)bl, (boolean)true);
        }
    }
}

