/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.inspector;

import com.mathworks.beans.editors.MWPropertyEditorUtils;
import com.mathworks.beans.editors.ModelessPropertyEditor;
import com.mathworks.ide.inspector.NamedEditor;
import com.mathworks.ide.inspector.PropertyCellEditField;
import com.mathworks.ide.inspector.PropertyDialog;
import com.mathworks.ide.inspector.PropertyTarget;
import com.mathworks.ide.inspector.PropertyViewList;
import com.mathworks.mwt.decorations.Decorations;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyEditor;

class PropertyCellCustomEdit
extends PropertyCellEditField {
    private Rectangle fTrackRect = null;
    private boolean fTracking = false;
    private boolean fMouseIn = false;
    private PropertyDialog fEditorDialog = null;

    PropertyCellCustomEdit(PropertyViewList propertyViewList, PropertyTarget propertyTarget, int n, int n2, NamedEditor namedEditor) {
        super(propertyViewList, propertyTarget, n, n2, namedEditor);
    }

    boolean isTracking() {
        return this.fTracking;
    }

    void finishEdit() {
        super.finishEdit();
        if (this.fEditorDialog != null) {
            this.fEditorDialog.closeWindow();
            this.fEditorDialog = null;
        }
    }

    boolean clickValue(Point point, Rectangle rectangle) {
        boolean bl = false;
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y + 1, rectangle.height - 1, rectangle.height - 1);
        Rectangle rectangle3 = new Rectangle(rectangle2.x + rectangle2.width, rectangle2.y, rectangle.width - rectangle2.width, rectangle2.height);
        if (rectangle2.contains(point)) {
            this.fTrackRect = rectangle2;
            this.fTracking = true;
            this.fMouseIn = true;
            this.drawIconButton(((Component)((Object)this.getView())).getGraphics(), this.fMouseIn, this.fTrackRect);
            bl = true;
        } else {
            bl = super.clickValue(point, rectangle);
        }
        return bl;
    }

    boolean mouseReleased(Point point) {
        boolean bl = false;
        if (this.fTracking) {
            if (this.fTrackRect.contains(point)) {
                ((Component)((Object)this.getView())).repaint(5L);
                this.invokeContentEditor();
            }
            this.fTracking = false;
            this.fTrackRect = null;
            this.fMouseIn = false;
            bl = true;
        } else {
            bl = super.mouseReleased(point);
        }
        return bl;
    }

    boolean mouseDragged(Point point) {
        boolean bl = false;
        if (this.fTracking) {
            boolean bl2 = this.fTrackRect.contains(point);
            if (bl2 != this.fMouseIn) {
                this.fMouseIn = bl2;
                this.drawIconButton(((Component)((Object)this.getView())).getGraphics(), this.fMouseIn, this.fTrackRect);
            }
        } else {
            bl = super.mouseDragged(point);
        }
        return bl;
    }

    void drawValue(Graphics graphics, Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y + 1, rectangle.height - 1, rectangle.height - 1);
        Rectangle rectangle3 = new Rectangle(rectangle2.x + rectangle2.width, rectangle2.y, rectangle.width - rectangle2.width, rectangle2.height);
        super.drawValue(graphics, rectangle);
        this.drawIconButton(graphics, false, rectangle2);
    }

    void customEditorClosed() {
        this.fEditorDialog = null;
    }

    protected void drawIconButton(Graphics graphics, boolean bl, Rectangle rectangle) {
        Image image = null;
        if (!this.isEditable()) {
            return;
        }
        image = MWPropertyEditorUtils.getIcon((PropertyEditor)this.getEditor());
        if (image != null) {
            MediaTracker mediaTracker = new MediaTracker((Component)((Object)this.getView()));
            mediaTracker.addImage(image, 1);
            try {
                mediaTracker.waitForID(1);
            }
            catch (Exception exception) {}
        }
        Decorations.drawButtonBevel((Graphics)graphics, (Rectangle)rectangle, (boolean)bl, (boolean)false, (boolean)true);
        if (image != null) {
            Decorations.drawButtonImage((Graphics)graphics, (Image)image, (int)(rectangle.x + 1), (int)(rectangle.y + 1), (boolean)bl, (boolean)true);
        }
    }

    void invokeContentEditor() {
        if (this.getEditor() instanceof ModelessPropertyEditor) {
            ModelessPropertyEditor modelessPropertyEditor = (ModelessPropertyEditor)this.getEditor();
            modelessPropertyEditor.invokeModelessEdit();
            return;
        }
        this.fEditorDialog = new PropertyDialog(this.getName(), this);
    }
}

