/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.inspector;

import com.mathworks.beans.editors.BooleanEditor;
import com.mathworks.beans.editors.CallbackEditor;
import com.mathworks.beans.editors.MWPropertyEditorUtils;
import com.mathworks.ide.inspector.NamedEditor;
import com.mathworks.ide.inspector.PropertyCellBoolean;
import com.mathworks.ide.inspector.PropertyCellCallback;
import com.mathworks.ide.inspector.PropertyCellCustom;
import com.mathworks.ide.inspector.PropertyCellCustomEdit;
import com.mathworks.ide.inspector.PropertyCellCustomEnum;
import com.mathworks.ide.inspector.PropertyCellEditField;
import com.mathworks.ide.inspector.PropertyCellEnum;
import com.mathworks.ide.inspector.PropertyTarget;
import com.mathworks.ide.inspector.PropertyViewList;
import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.util.ResLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import java.beans.PropertyEditor;
import java.util.Vector;

class PropertyCell {
    private static final int NAME_COLUMN = 0;
    private static final int VALUE_COLUMN = 1;
    private static Image sReadOnlyIcon = null;
    private PropertyViewList fView;
    private PropertyTarget fTarget;
    private PropertyTarget fChildTarget;
    private int fItemId;
    private NamedEditor fEditor;
    private Vector fCells;

    PropertyCell(PropertyViewList propertyViewList, PropertyTarget propertyTarget, int n, int n2, NamedEditor namedEditor) {
        String[] stringArray = new String[]{"", ""};
        this.fView = propertyViewList;
        this.fItemId = n2;
        this.fEditor = namedEditor;
        this.fTarget = propertyTarget;
        this.fChildTarget = null;
        this.fCells = new Vector();
        boolean bl = MWPropertyEditorUtils.canExpand((PropertyEditor)this.fEditor.getEditor());
        this.fView.add(n, n2, stringArray, null, bl);
    }

    Vector expand() {
        Vector<PropertyCell> vector = new Vector<PropertyCell>();
        PropertyTarget propertyTarget = null;
        int n = 1000 * (this.fItemId + 1);
        boolean bl = ((Component)((Object)this.fView)).isVisible();
        if (bl) {
            this.fView.setVisible(false);
        }
        this.fChildTarget = propertyTarget = this.fTarget.getValues(this.fEditor.getName());
        if (propertyTarget != null) {
            while (propertyTarget.hasMoreProperties()) {
                NamedEditor namedEditor = propertyTarget.nextProperty();
                if (namedEditor == null || namedEditor.getEditor() == null || !namedEditor.isEditable() && !this.fView.getShowReadOnly()) continue;
                PropertyCell propertyCell = PropertyCell.makePropertyCell(this.fView, propertyTarget, this.fItemId, n++, namedEditor);
                vector.addElement(propertyCell);
            }
        }
        if (bl) {
            this.fView.setVisible(true);
        }
        this.fCells = vector;
        return vector;
    }

    void collapse() {
        this.fChildTarget = null;
        this.fCells.removeAllElements();
        this.fView.removeDescendants(this.fItemId);
    }

    void refreshChildren() {
        if (this.fChildTarget != null) {
            this.fChildTarget.refreshValues();
        }
        int n = 0;
        while (n < this.fCells.size()) {
            ((PropertyCell)this.fCells.elementAt(n)).refreshChildren();
            ++n;
        }
    }

    void dispose() {
    }

    void customEditorClosed() {
    }

    PropertyEditor getEditor() {
        return this.fEditor.getEditor();
    }

    String getName() {
        return this.fEditor.getName();
    }

    PropertyViewList getView() {
        return this.fView;
    }

    int getItemId() {
        return this.fItemId;
    }

    boolean isTracking() {
        return false;
    }

    boolean isEditable() {
        return this.fEditor.isEditable();
    }

    boolean isEditInProgress() {
        return false;
    }

    void updateBounds() {
    }

    void finishEdit() {
    }

    private Color textColor(int n, boolean bl) {
        Color color = n == 1 && !this.isEditable() ? Decorations.getColor((int)9) : (n == 0 && this.fView.isSelected(this.fItemId) ? Decorations.getColor((int)5, (boolean)bl) : Color.black);
        return color;
    }

    void drawName(Graphics graphics, Rectangle rectangle, boolean bl) {
        Point point = this.textPos(graphics, rectangle);
        Decorations.getColor((int)2);
        if (this.fView.isSelected(this.fItemId)) {
            graphics.setColor(Decorations.getColor((int)4, (boolean)bl));
            graphics.fillRect(rectangle.x, rectangle.y + 1, rectangle.width, rectangle.height - 1);
        }
        graphics.setColor(this.textColor(0, bl));
        graphics.drawString(this.fEditor.getName(), point.x, point.y);
    }

    void drawValue(Graphics graphics, Rectangle rectangle) {
        Decorations.getColor((int)2);
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y + 1, rectangle.height - 1, rectangle.height - 1);
        Rectangle rectangle3 = new Rectangle(rectangle2.x + rectangle2.width, rectangle2.y, rectangle.width - rectangle2.width, rectangle2.height);
        graphics.setColor(this.textColor(1, true));
        if (!this.fEditor.isMixed()) {
            if (this.fEditor.getEditor().isPaintable()) {
                this.fEditor.getEditor().paintValue(graphics, rectangle3);
            } else if (this.fEditor.getEditor().getAsText() != null) {
                Point point = this.textPos(graphics, rectangle3);
                graphics.drawString(this.fEditor.getEditor().getAsText(), point.x, point.y);
            }
        } else {
            graphics.setFont(new Font("SansSerif", 2, 9));
            Point point = this.textPos(graphics, rectangle3);
            graphics.drawString("Mixed", point.x, point.y);
        }
        if (!this.isEditable()) {
            this.initIcons();
            if (sReadOnlyIcon != null) {
                graphics.drawImage(sReadOnlyIcon, rectangle2.x + 1, rectangle2.y + 1, (ImageObserver)((Object)this.fView));
            }
        }
    }

    boolean clickName(Point point, Rectangle rectangle) {
        return false;
    }

    boolean clickValue(Point point, Rectangle rectangle) {
        return false;
    }

    boolean mouseReleased(Point point) {
        return false;
    }

    boolean mouseDragged(Point point) {
        return false;
    }

    Point textPos(Graphics graphics, Rectangle rectangle) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Point point = new Point();
        int n = fontMetrics.getMaxAscent();
        int n2 = n + fontMetrics.getMaxDescent();
        point.x = rectangle.x + 3;
        point.y = rectangle.y + n + (rectangle.height - n2) / 2;
        return point;
    }

    private void initIcons() {
        if (sReadOnlyIcon == null) {
            ResLoader resLoader = new ResLoader((Component)((Object)this.fView));
            sReadOnlyIcon = resLoader.loadImage("resources/readonlyicon.gif");
            resLoader.waitForPendingImages();
        }
    }

    static PropertyCell makePropertyCell(PropertyViewList propertyViewList, PropertyTarget propertyTarget, int n, int n2, NamedEditor namedEditor) {
        PropertyCell propertyCell = null;
        PropertyEditor propertyEditor = namedEditor.getEditor();
        propertyCell = propertyEditor.supportsCustomEditor() && propertyEditor.getTags() != null ? new PropertyCellCustomEnum(propertyViewList, propertyTarget, n, n2, namedEditor) : (propertyEditor.supportsCustomEditor() ? (MWPropertyEditorUtils.supportsInPlaceEditing((PropertyEditor)propertyEditor) ? new PropertyCellCustomEdit(propertyViewList, propertyTarget, n, n2, namedEditor) : new PropertyCellCustom(propertyViewList, propertyTarget, n, n2, namedEditor)) : (propertyEditor instanceof CallbackEditor ? new PropertyCellCallback(propertyViewList, propertyTarget, n, n2, namedEditor) : (propertyEditor instanceof BooleanEditor ? new PropertyCellBoolean(propertyViewList, propertyTarget, n, n2, namedEditor) : (propertyEditor.getTags() != null ? new PropertyCellEnum(propertyViewList, propertyTarget, n, n2, namedEditor) : new PropertyCellEditField(propertyViewList, propertyTarget, n, n2, namedEditor)))));
        return propertyCell;
    }
}

