/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.inspector;

import com.mathworks.ide.filtermgr.FilterManager;
import com.mathworks.ide.filtermgr.FilterManagerEvent;
import com.mathworks.ide.filtermgr.FilterManagerListener;
import com.mathworks.ide.filtermgr.PropertyFilter;
import com.mathworks.ide.inspector.PropertyView;
import com.mathworks.ide.inspector.PropertyViewUtils;
import com.mathworks.ide.inspector.SelectedBeanDisplay;
import com.mathworks.mwt.MWButton;
import com.mathworks.mwt.MWCheckbox;
import com.mathworks.mwt.MWChoice;
import com.mathworks.mwt.MWFrame;
import com.mathworks.mwt.MWLabel;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.MWToolbar;
import com.mathworks.mwt.command.MWCommandCenter;
import com.mathworks.mwt.command.MWCommandSource;
import com.mathworks.mwt.command.MWCommandTarget;
import com.mathworks.mwt.dialog.MWFileDialog;
import com.mathworks.mwt.dialog.MWFileFilter;
import com.mathworks.mwt.window.MWWindowActivater;
import com.mathworks.mwt.window.MWWindowOwner;
import com.mathworks.mwt.window.WindowRegistry;
import com.mathworks.services.ObjectRegistry;
import com.mathworks.services.Prefs;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.ResLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class Inspector
extends MWPanel
implements ItemListener,
MWWindowOwner,
MWCommandTarget,
FilterManagerListener {
    private static final String BOUNDS_PREF = "InspectorWindowBounds";
    private static final String NO_CLASS = "!_NO_CLASS_!";
    private static final String PREFS_KEY = "Inspector";
    private static final String MWT_RES = "/com/mathworks/mwt/resources/";
    private static final int INSPECTOR = 0;
    private static final int NUM_ICONS = 1;
    private static final int DUMP_PROPERTIES = 101;
    private static final boolean SHOW_CHECKBOXES = false;
    private static Image[] sIcons = null;
    private static MWFrame sInspectorWin = null;
    private static Inspector sInspector = null;
    private MWCheckbox fReadOnlyCheckbox;
    private MWCheckbox fToolbarCheckbox;
    private SelectedBeanDisplay fSelBeanDisplay;
    private PropertyView fPropView;
    private MWFrame fFrame;
    private MWToolbar fToolbar;
    private MWChoice fFilterPopup;
    private MWPanel fMainPanel;
    private boolean fToolbarVisible;
    private FilterManager fFilterManager;
    private MWCommandCenter fCommandCenter;

    public Inspector(MWFrame mWFrame) {
        this(mWFrame, ObjectRegistry.getRegistry());
    }

    public Inspector(MWFrame mWFrame, ObjectRegistry objectRegistry) {
        Object var3_3 = null;
        this.fFrame = mWFrame;
        this.fCommandCenter = new MWCommandCenter((MWCommandTarget)this);
        this.fFilterManager = new FilterManager(PREFS_KEY);
        this.fFilterManager.addFilterManagerListener(this);
        this.fToolbarVisible = false;
        this.setOpaque(false);
        ((Component)((Object)this)).setFont(new Font("SansSerif", 0, 10));
        this.fToolbar = new MWToolbar();
        this.fToolbar.addImageButton("/com/mathworks/mwt/resources/new.gif", -101, this.fCommandCenter);
        this.fToolbar.addImageButton("/com/mathworks/mwt/resources/open.gif", -102, this.fCommandCenter);
        this.fToolbar.addSpacer();
        MWPanel mWPanel = new MWPanel((LayoutManager)new FlowLayout(0));
        mWPanel.add((Component)new MWLabel("Filter:"));
        this.fFilterPopup = new MWChoice();
        this.fFilterPopup.addItemListener((ItemListener)this);
        mWPanel.add((Component)this.fFilterPopup);
        this.fToolbar.addComponent((Component)mWPanel);
        this.fPropView = new PropertyView(objectRegistry);
        ((Component)((Object)this.fPropView)).setName("Properties Panel");
        this.fSelBeanDisplay = new SelectedBeanDisplay(objectRegistry);
        this.fMainPanel = new MWPanel((LayoutManager)new BorderLayout());
        this.fMainPanel.setOpaque(false);
        this.fMainPanel.add((Component)((Object)this.fPropView), "Center");
        this.fMainPanel.add((Component)((Object)this.fSelBeanDisplay), "North");
        ((Container)((Object)this)).setLayout(new BorderLayout());
        if (this.fToolbarVisible) {
            ((Container)((Object)this)).add((Component)this.fToolbar, "North");
        }
        ((Container)((Object)this)).add((Component)this.fMainPanel, "Center");
        if (this.fFrame != null) {
            this.fFrame.addWindowListener(new 1());
            this.fFrame.addComponentListener(new 2());
        }
        this.updateControls();
    }

    private void registerWindow() {
        WindowRegistry.getRegistry().register((MWWindowOwner)this);
    }

    private void unregisterWindow() {
        WindowRegistry.getRegistry().unregister((MWWindowOwner)this);
    }

    public Inspector() {
        this(null);
    }

    public ObjectRegistry getRegistry() {
        return this.fPropView.getRegistry();
    }

    public void setRegistry(ObjectRegistry objectRegistry) {
        this.fPropView.setRegistry(objectRegistry);
        this.fSelBeanDisplay.setRegistry(objectRegistry);
    }

    public void selectProperty(String string) {
        this.fPropView.selectProperty(string);
    }

    private void doNew() {
        this.fFilterManager.editFilter(this.getClassName(), null);
    }

    private void doEditFilter() {
        int n = this.fFilterPopup.getSelectedIndex() - 1;
        if (n > -1) {
            this.fFilterManager.editFilter(this.getClassName(), this.fFilterPopup.getSelectedItem());
        }
    }

    private void doClose() {
        this.closeWindow();
    }

    private void doDumpProperties() {
        PrintStream printStream = System.out;
        File file = null;
        FileOutputStream fileOutputStream = null;
        if (this.fFrame != null) {
            MWFileDialog mWFileDialog = new MWFileDialog((Frame)this.fFrame, "Save Property List:", 1, new MWFileFilter());
            mWFileDialog.setFile("PropertyDump.txt");
            mWFileDialog.show();
            if (mWFileDialog.getFile() != null) {
                try {
                    file = new File(mWFileDialog.getDirectory(), mWFileDialog.getFile());
                    fileOutputStream = new FileOutputStream(file);
                    printStream = new PrintStream(fileOutputStream);
                }
                catch (Exception exception) {
                    System.out.println("error opening file");
                }
            }
        }
        this.fPropView.dumpProperties(printStream);
        if (fileOutputStream != null) {
            try {
                fileOutputStream.close();
                return;
            }
            catch (IOException iOException) {
                System.out.println("error closing file");
                return;
            }
        }
    }

    public void doCommand(int n) {
        switch (n) {
            case -101: {
                this.doNew();
                return;
            }
            case -102: {
                this.doEditFilter();
                return;
            }
            case -103: {
                this.doClose();
                return;
            }
            case 101: {
                this.doDumpProperties();
                return;
            }
        }
    }

    private void showDumpButton() {
        MWButton mWButton = new MWButton("Dump Properties...");
        MWPanel mWPanel = new MWPanel();
        this.fCommandCenter.addCommandSource((MWCommandSource)mWButton, 101);
        mWPanel.add((Component)mWButton);
        ((Container)((Object)this)).add((Component)mWPanel, "South");
        ((Container)((Object)this)).validate();
        ((Component)((Object)this)).repaint();
    }

    private void growPopup() {
        Container container = this.fFilterPopup.getParent();
        this.fFilterPopup.invalidate();
        container.setSize(((Component)container).getPreferredSize());
        this.fToolbar.validate();
        container.repaint(5L);
    }

    private void updateControls() {
        PropertyFilter[] propertyFilterArray;
        boolean bl;
        int n = this.fFilterPopup.getSelectedIndex();
        String string = this.getClassName();
        boolean bl2 = bl = !string.equals(NO_CLASS);
        if (bl) {
            propertyFilterArray = this.fFilterManager.getFilters(string);
            n = this.fFilterManager.getActiveFilterIndex(string) + 1;
        } else {
            propertyFilterArray = new PropertyFilter[]{};
            n = 0;
        }
        this.fFilterPopup.removeAll();
        this.fFilterPopup.add("Show All");
        int n2 = 0;
        while (n2 < propertyFilterArray.length) {
            this.fFilterPopup.add(propertyFilterArray[n2].getName());
            ++n2;
        }
        this.fFilterPopup.select(n);
        this.fFilterPopup.setEnabled(bl);
        this.fCommandCenter.setCommandEnabled(-101, bl);
        this.fCommandCenter.setCommandEnabled(-102, bl && this.fFilterPopup.getSelectedIndex() != 0);
        this.growPopup();
    }

    private String getClassName() {
        Object[] objectArray = this.fPropView.getObjects();
        String string = NO_CLASS;
        if (objectArray != null && objectArray.length > 0) {
            string = objectArray[0].getClass().getName();
            int n = 1;
            while (n < objectArray.length && string.equals(objectArray[n].getClass().getName())) {
                ++n;
            }
            if (n < objectArray.length) {
                string = NO_CLASS;
            }
        }
        return string;
    }

    public String getWindowTitle() {
        return PropertyViewUtils.getResource("frame.title");
    }

    public void setShowReadOnly(boolean bl) {
        this.fPropView.setShowReadOnly(bl);
    }

    public void filterAdded(FilterManagerEvent filterManagerEvent) {
        this.updateControls();
    }

    public void filterRemoved(FilterManagerEvent filterManagerEvent) {
        String string = this.getClassName();
        this.updateControls();
        if (!string.equals(NO_CLASS)) {
            this.fPropView.setFilter(this.fFilterManager.getActiveFilter(string));
        }
    }

    public void filterSelected(FilterManagerEvent filterManagerEvent) {
        this.fPropView.setFilter(filterManagerEvent.getFilter());
    }

    public void filterChanged(FilterManagerEvent filterManagerEvent) {
        String string = this.getClassName();
        this.updateControls();
        if (!string.equals(NO_CLASS)) {
            this.fPropView.setFilter(this.fFilterManager.getActiveFilter(string));
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (itemSelectable == this.fFilterPopup) {
            String string = this.getClassName();
            if (!string.equals(NO_CLASS)) {
                int n = this.fFilterPopup.getSelectedIndex() - 1;
                this.fFilterManager.setActiveFilter(string, n);
            }
            this.updateControls();
            return;
        }
        if (itemSelectable == this.fReadOnlyCheckbox) {
            this.setShowReadOnly(this.fReadOnlyCheckbox.getState());
            return;
        }
        if (itemSelectable == this.fToolbarCheckbox) {
            this.fToolbarVisible = this.fToolbarCheckbox.getState();
            if (this.fToolbarVisible) {
                ((Container)((Object)this)).add((Component)this.fToolbar, "North");
            } else {
                ((Container)((Object)this)).remove((Component)this.fToolbar);
            }
            ((Container)((Object)this)).validate();
            ((Component)((Object)this)).repaint(5L);
        }
    }

    public int closeWindow() {
        if (this.fFrame != null) {
            this.fFilterManager.removeFilterManagerListener(this);
            if (this.fFrame == sInspectorWin) {
                Dimension dimension = sInspectorWin.getRestoredSize();
                Point point = sInspectorWin.getRestoredLocation();
                Rectangle rectangle = new Rectangle(point.x, point.y, dimension.width, dimension.height);
                Prefs.setRectanglePref((String)BOUNDS_PREF, (Rectangle)rectangle);
                sInspectorWin = null;
            }
            if (this == sInspector) {
                sInspector = null;
            }
            this.fFrame.dispose();
        }
        this.setRegistry(null);
        return 0;
    }

    public void setActive(boolean bl) {
        if (bl && PlatformInfo.getPlatform() == 1) {
            this.fPropView.requestFocus();
        }
        this.notifyPanels();
    }

    public String getShortName() {
        return this.getWindowTitle();
    }

    public String getLongName() {
        return this.getWindowTitle();
    }

    void notifyPanels() {
        this.fPropView.triggerRefresh();
    }

    private void initIcons() {
        if (sIcons == null) {
            ResLoader resLoader = new ResLoader((Component)((Object)this));
            sIcons = new Image[1];
            Inspector.sIcons[0] = resLoader.loadImage("resources/inspectoricon.gif");
            resLoader.waitForPendingImages();
        }
    }

    private static void createInspector() {
        if (sInspector == null || sInspectorWin == null) {
            sInspectorWin = new MWFrame();
            sInspector = new Inspector(sInspectorWin, ObjectRegistry.getLayoutRegistry());
            sInspectorWin.setTitle(sInspector.getWindowTitle());
            sInspector.initIcons();
            sInspectorWin.setIconImage(sIcons[0]);
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dimension2 = ((Container)((Object)sInspector)).getPreferredSize();
            sInspectorWin.addWindowListener((WindowListener)new MWWindowActivater((Component)((Object)sInspector)));
            sInspectorWin.add("Center", (Component)((Object)sInspector));
            if (Prefs.exists((String)BOUNDS_PREF)) {
                Rectangle rectangle = Prefs.getRectanglePref((String)BOUNDS_PREF);
                sInspectorWin.setBounds(rectangle);
                return;
            }
            sInspectorWin.setLocation(dimension.width - dimension2.width - 10, 10);
            sInspectorWin.setContentSize(new Dimension(dimension2.width, dimension2.height));
        }
    }

    public static Inspector getInspector() {
        Inspector.createInspector();
        return sInspector;
    }

    public static void activateInspector() {
        if (sInspectorWin == null || sInspector == null) {
            Inspector.createInspector();
        }
        if (!sInspectorWin.isVisible()) {
            sInspectorWin.setVisible(true);
            return;
        }
        sInspectorWin.toFront();
    }

    public static void inspectIfOpen(Object object) {
        ObjectRegistry objectRegistry = sInspector != null ? sInspector.getRegistry() : ObjectRegistry.getLayoutRegistry();
        Object[] objectArray = object instanceof Object[] ? (Object[])object : new Object[]{object};
        objectRegistry.setSelected(objectArray, true);
    }

    public static void refreshIfOpen() {
        if (sInspector != null) {
            ObjectRegistry objectRegistry = sInspector.getRegistry();
            objectRegistry.setSelected(objectRegistry.getSelectedObjects(), true);
        }
    }

    public static void inspectObject(Object object) {
        Object[] objectArray = new Object[]{object};
        Inspector.inspectObjectArray(objectArray);
    }

    public static void inspectObjectArray(Object[] objectArray) {
        if (sInspectorWin == null || !sInspectorWin.isVisible()) {
            Inspector.activateInspector();
        }
        sInspector.getRegistry().setSelected(objectArray, true);
    }

    public static void main(String[] stringArray) {
        try {
            Inspector.activateInspector();
            Inspector.getInspector().showDumpButton();
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosed(WindowEvent windowEvent) {
            Inspector.this.unregisterWindow();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends ComponentAdapter {
        public void componentHidden(ComponentEvent componentEvent) {
            Inspector.this.unregisterWindow();
        }

        public void componentShown(ComponentEvent componentEvent) {
            Inspector.this.registerWindow();
        }

        /* synthetic */ 2() {
        }
    }
}

