/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.help;

import java.io.DataInput;
import java.io.IOException;

public class SearchWord {
    String word;
    int[] counts;
    int countsLength;

    public int getCount(int n) {
        if (n < this.countsLength) {
            return this.counts[n];
        }
        return 0;
    }

    public int getNumberCounts() {
        return this.countsLength;
    }

    public int totalNonZero() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.countsLength) {
            if (this.counts[n2] > 0) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public SearchWord() {
        this.word = "";
        this.countsLength = 1;
        this.counts = new int[this.countsLength];
    }

    public SearchWord(String string) {
        this();
        this.word = string;
    }

    private final void resize(int n) {
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n && n2 < this.countsLength) {
            nArray[n2] = this.counts[n2];
            ++n2;
        }
        this.counts = nArray;
        this.countsLength = n;
    }

    private final void ensure(int n) {
        if (n < this.countsLength) {
            return;
        }
        int n2 = this.countsLength;
        while (n >= n2) {
            n2 *= 2;
        }
        this.resize(n2);
    }

    public SearchWord(String string, DataInput dataInput) {
        this.word = string;
        this.countsLength = 16;
        this.counts = new int[this.countsLength];
        short s = 0;
        int n = 0;
        short s2 = 0;
        while (true) {
            try {
                s = dataInput.readShort();
                n = 1;
            }
            catch (IOException iOException) {
                break;
            }
            this.ensure(s + 1);
            this.counts[s] = n;
            if (s <= s2) continue;
            s2 = s;
        }
        this.resize(s2 + 1);
    }

    public SearchWord and(SearchWord searchWord) {
        if (searchWord.countsLength > this.countsLength) {
            this.ensure(searchWord.countsLength);
        }
        int n = 0;
        while (n < this.countsLength && n < searchWord.countsLength) {
            if (searchWord.getCount(n) < this.counts[n]) {
                this.counts[n] = searchWord.getCount(n);
            }
            ++n;
        }
        while (n < this.countsLength) {
            this.counts[n] = 0;
            ++n;
        }
        return this;
    }

    public SearchWord or(SearchWord searchWord) {
        if (searchWord.countsLength > this.countsLength) {
            this.ensure(searchWord.countsLength);
        }
        int n = 0;
        while (n < this.countsLength && n < searchWord.countsLength) {
            if (searchWord.getCount(n) > this.counts[n]) {
                this.counts[n] = searchWord.getCount(n);
            }
            ++n;
        }
        return this;
    }

    public SearchWord andNot(SearchWord searchWord) {
        if (searchWord.countsLength > this.countsLength) {
            this.ensure(searchWord.countsLength);
        }
        int n = 0;
        while (n < this.countsLength && n < searchWord.countsLength) {
            if (this.counts[n] > 0 && searchWord.getCount(n) > 0) {
                this.counts[n] = 0;
            }
            ++n;
        }
        return this;
    }

    public int[] getFileIds() {
        int[] nArray = new int[this.totalNonZero()];
        int n = 0;
        int n2 = 0;
        while (n < this.getNumberCounts()) {
            if (this.counts[n] > 0) {
                nArray[n2++] = n;
            }
            ++n;
        }
        return nArray;
    }
}

