/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.help;

import com.mathworks.ide.help.HelpBrowser;
import com.mathworks.ide.help.HelpPrefs;
import com.mathworks.ide.help.HelpProductList;
import com.mathworks.ide.help.ProductNameObject;
import com.mathworks.ide.help.SearchDatabase;
import com.mathworks.ide.help.SearchFileList;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwt.MWButton;
import com.mathworks.mwt.MWChoice;
import com.mathworks.mwt.MWCombobox;
import com.mathworks.mwt.MWLabel;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.MWTextField;
import com.mathworks.mwt.dialog.MWDialog;
import com.mathworks.mwt.message.MWLooper;
import com.mathworks.mwt.window.MWWindowActivater;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.Vector;

public class SearchTab
extends MWPanel {
    private static final String FULL_TEXT_STRING = HelpBrowser.sRes.getString("search.full_text_search");
    private static final String GOTO_FUNCTION_STRING = HelpBrowser.sRes.getString("search.goto_function");
    private static final String DOCUMENT_TITLES_STRING = HelpBrowser.sRes.getString("search.page_titles");
    private static final String TECH_SUPPORT_DATABASE_STRING = HelpBrowser.sRes.getString("search.tech_support");
    private HelpBrowser fParent;
    private SearchFileList fSearchFileList;
    private MWCombobox fSearchTextField;
    private SearchFileList fGotoFileList;
    private Vector fSearchDatabases = new Vector();
    private String fDocRoot;
    private String fDocRootForBrowser;
    private MWPanel fSearchForPanel;
    private MWButton fSearchButton;
    private Matlab fMatlab = new Matlab(new MWLooper("Help Browser: Goto Function"));
    private boolean fShowingWordPanel = false;
    private boolean fShowingSearchFileList = true;
    private boolean fDatabasesOpen = false;
    private OpenDatabaseThread fOpenDatabaseThread;
    private SearchThread fSearchThread;
    private MWChoice fSearchTypeChoice;
    private boolean fSearchAllProducts;
    private boolean fStopRequested = false;

    public SearchTab(HelpBrowser helpBrowser) {
        this.fParent = helpBrowser;
        Font font = new Font("SanSerif", 0, 11);
        MWLabel mWLabel = new MWLabel(HelpBrowser.sRes.getString("search.search_type"));
        mWLabel.setFont(font);
        this.fSearchTypeChoice = new MWChoice();
        this.fSearchTypeChoice.addItem(FULL_TEXT_STRING);
        this.fSearchTypeChoice.addItem(DOCUMENT_TITLES_STRING);
        this.fSearchTypeChoice.addItem(GOTO_FUNCTION_STRING);
        this.fSearchTypeChoice.addItem(TECH_SUPPORT_DATABASE_STRING);
        this.fSearchTypeChoice.setFont(font);
        this.fSearchTypeChoice.setName("Search Type");
        MyButton myButton = new MyButton();
        myButton.setLabel(HelpBrowser.sRes.getString("icecontainer.tips"));
        myButton.setFont(font);
        myButton.addActionListener(new TipsButtonActionListener());
        MWPanel mWPanel = new MWPanel((LayoutManager)new BorderLayout(5, 5));
        mWPanel.add((Component)mWLabel, "West");
        mWPanel.add((Component)this.fSearchTypeChoice, "Center");
        mWPanel.add((Component)((Object)myButton), "East");
        MWLabel mWLabel2 = new MWLabel(HelpBrowser.sRes.getString("search.search_for"));
        mWLabel2.setFont(font);
        SearchButtonActionListener searchButtonActionListener = new SearchButtonActionListener();
        String[] stringArray = new String[]{null};
        this.fSearchTextField = new MWCombobox(null, stringArray);
        this.fSearchTextField.requestFocus();
        this.fSearchTextField.setFont(font);
        this.fSearchTextField.setName("Search Field");
        this.fSearchTextField.addActionListener((ActionListener)searchButtonActionListener);
        this.fSearchButton = new MyButton();
        this.fSearchButton.setLabel(String.valueOf(HelpBrowser.sRes.getString("search.go")) + " ");
        this.fSearchButton.setFont(font);
        this.fSearchButton.addActionListener((ActionListener)searchButtonActionListener);
        this.fSearchForPanel = new MWPanel((LayoutManager)new BorderLayout(5, 5));
        this.fSearchForPanel.add((Component)mWLabel2, "West");
        this.fSearchForPanel.add((Component)this.fSearchTextField, "Center");
        this.fSearchForPanel.add((Component)this.fSearchButton, "East");
        MWPanel mWPanel2 = new MWPanel();
        mWPanel2.setLayout(new BorderLayout(5, 5));
        mWPanel2.add((Component)this.fSearchForPanel, "Center");
        mWPanel2.add((Component)mWPanel, "North");
        this.fSearchFileList = new SearchFileList(this.fParent, "Search");
        this.fGotoFileList = new SearchFileList(this.fParent, "Goto");
        ((Container)((Object)this)).setLayout(new BorderLayout(5, 5));
        ((Container)((Object)this)).add((Component)mWPanel2, "North");
        ((Container)((Object)this)).add((Component)((Object)this.fSearchFileList), "Center");
        this.fShowingSearchFileList = true;
        this.fShowingWordPanel = false;
    }

    public void loadData(boolean bl) {
        this.fSearchAllProducts = bl;
        this.setDocRoot();
        this.openDatabases();
    }

    public void resetDocRoot(String string) {
        this.closeDatabases();
        this.setDocRoot();
        this.openDatabases();
    }

    public void filterChanged(boolean bl) {
        if (!this.fDatabasesOpen) {
            this.loadData(bl);
        } else {
            this.fParent.loadingDataFinished();
        }
        this.fSearchAllProducts = bl;
        if (this.fSearchTypeChoice.getSelectedItem() != TECH_SUPPORT_DATABASE_STRING) {
            this.doSearch();
        }
    }

    public void openDatabases() {
        if (!this.fDatabasesOpen) {
            if (this.fOpenDatabaseThread != null) {
                try {
                    this.fOpenDatabaseThread.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.enableInputFields(false);
            String string = HelpBrowser.sRes.getString("search.opening_db");
            if (this.fShowingSearchFileList) {
                this.fSearchFileList.clear();
                this.fSearchFileList.addItem(string, "", "", null);
            } else {
                this.fGotoFileList.clear();
                this.fGotoFileList.addItem(string, "", "", null);
            }
            this.fOpenDatabaseThread = new OpenDatabaseThread();
            this.fOpenDatabaseThread.start();
        }
    }

    private void enableInputFields(boolean bl) {
        this.fSearchTextField.setEnabled(bl);
        this.fSearchButton.setEnabled(bl);
    }

    public void closeDatabases() {
        if (this.fDatabasesOpen) {
            int n = 0;
            while (n < this.fSearchDatabases.size()) {
                SearchDatabase searchDatabase = (SearchDatabase)((Object)this.fSearchDatabases.elementAt(n));
                if (searchDatabase != null) {
                    searchDatabase.close();
                }
                ++n;
            }
            this.fSearchDatabases.removeAllElements();
            this.fDatabasesOpen = false;
        }
    }

    private void setDocRoot() {
        this.fDocRoot = HelpPrefs.getDocRoot();
        if (this.fDocRoot != null && !this.fDocRoot.equals("")) {
            this.fDocRootForBrowser = this.fDocRoot.replace('\\', '/');
        }
        this.fSearchFileList.setDocRoot(this.fDocRootForBrowser);
        this.fGotoFileList.setDocRoot(this.fDocRootForBrowser);
        ((Container)((Object)this)).invalidate();
        ((Container)((Object)this)).validate();
    }

    private void showError(String string) {
        if (this.fSearchFileList != null && this.fShowingSearchFileList) {
            ((Container)((Object)this)).remove((Component)((Object)this.fSearchFileList));
        } else if (this.fGotoFileList != null && !this.fShowingSearchFileList) {
            ((Container)((Object)this)).remove((Component)((Object)this.fGotoFileList));
        }
        MWLabel mWLabel = new MWLabel(string, 1);
        mWLabel.setFont(new Font("Dialog", 1, 10));
        ((Container)((Object)this)).add((Component)mWLabel, "Center");
        ((Container)((Object)this)).invalidate();
        ((Container)((Object)this)).validate();
    }

    public void showSearchFileList(boolean bl) {
        if (!bl && this.fShowingWordPanel) {
            this.fShowingWordPanel = false;
            ((Container)((Object)this)).invalidate();
            ((Container)((Object)this)).validate();
            return;
        }
        if (bl && !this.fShowingWordPanel) {
            this.fShowingWordPanel = true;
            ((Container)((Object)this)).invalidate();
            ((Container)((Object)this)).validate();
        }
    }

    public boolean isShowingSearchFileList() {
        return this.fShowingWordPanel;
    }

    private void enableButtons(boolean bl) {
        this.fSearchButton.setEnabled(bl);
        this.fSearchTextField.setEnabled(bl);
    }

    private void doGotoFunction() {
        String string = this.fSearchTextField.getText();
        if (!string.equals("")) {
            Object[] objectArray = new Object[]{string};
            this.enableButtons(false);
            this.fParent.enableProductFilter(false);
            if (Matlab.isMatlabAvailable()) {
                this.fMatlab.feval("doc", objectArray, 1, (CompletionObserver)new GotoFunctionCallback(string));
            }
            this.fGotoFileList.clear();
            this.showSearchFileList(false);
            this.showFileList("Goto");
        }
    }

    private void doSearch() {
        if (this.fSearchTypeChoice.getSelectedItem().equals(FULL_TEXT_STRING)) {
            this.doTextSearch(false);
            return;
        }
        if (this.fSearchTypeChoice.getSelectedItem().equals(GOTO_FUNCTION_STRING)) {
            this.doGotoFunction();
            return;
        }
        if (this.fSearchTypeChoice.getSelectedItem().equals(DOCUMENT_TITLES_STRING)) {
            this.doTextSearch(true);
            return;
        }
        if (this.fSearchTypeChoice.getSelectedItem().equals(TECH_SUPPORT_DATABASE_STRING)) {
            String string = this.fSearchTextField.getText().replace(' ', '+');
            Object[] objectArray = new Object[]{string};
            String string2 = HelpBrowser.getMessage(objectArray, HelpBrowser.sRes.getString("search.tech_support_title"));
            this.fParent.setCurrentLocation(string2, "http://www.mathworks.com/search/ice.cgi?query=" + string);
        }
    }

    private void doTextSearch(boolean bl) {
        if (this.fSearchTextField.getText().equals("")) {
            return;
        }
        this.showFileList("Search");
        if (this.fOpenDatabaseThread != null) {
            try {
                this.fOpenDatabaseThread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.fSearchDatabases.size() == 0) {
            this.fSearchFileList.clear();
            this.fSearchFileList.addItem(HelpBrowser.sRes.getString("search.no_db_found"), "", "", null);
            return;
        }
        if (this.fSearchThread != null && this.fSearchThread.isAlive()) {
            this.fStopRequested = true;
            try {
                this.fSearchThread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.fSearchThread = new SearchThread(bl);
        this.fSearchThread.start();
    }

    public void showFileList(String string) {
        if (string.equals("Search") && !this.fShowingSearchFileList) {
            ((Container)((Object)this)).remove((Component)((Object)this.fGotoFileList));
            ((Container)((Object)this)).add((Component)((Object)this.fSearchFileList), "Center");
            this.fShowingSearchFileList = true;
        } else if (string.equals("Goto") && this.fShowingSearchFileList) {
            ((Container)((Object)this)).remove((Component)((Object)this.fSearchFileList));
            ((Container)((Object)this)).add((Component)((Object)this.fGotoFileList), "Center");
            this.fShowingSearchFileList = false;
        }
        ((Container)((Object)this)).invalidate();
        ((Container)((Object)this)).validate();
    }

    static /* synthetic */ boolean access$13(SearchTab searchTab) {
        return searchTab.fDatabasesOpen;
    }

    private class OpenDatabaseThread
    extends Thread {
        OpenDatabaseThread() {
            SearchTab.this = SearchTab.this;
            SearchTab.this.fSearchDatabases.removeAllElements();
        }

        private void openDatabase(String string, String string2) {
            String string3 = String.valueOf(SearchTab.this.fDocRoot) + HelpBrowser.fSeparator + string;
            String string4 = StringUtils.fromJavaPath((String)(String.valueOf(string3) + "/" + "index.db"));
            File file = new File(string4);
            if (file.exists()) {
                SearchDatabase searchDatabase = new SearchDatabase(string4, string, string2);
                if (searchDatabase != null) {
                    searchDatabase.open();
                }
                if (searchDatabase == null || searchDatabase.getFile() == null) {
                    Object[] objectArray = new Object[]{string4};
                    String string5 = HelpBrowser.getMessage(objectArray, HelpBrowser.sRes.getString("search.cound_not_open_db"));
                    System.out.println(string5);
                    return;
                }
                SearchTab.this.fSearchDatabases.addElement(searchDatabase);
            }
        }

        public void run() {
            Vector vector = HelpProductList.getProductList();
            int n = 0;
            while (n < vector.size()) {
                ProductNameObject productNameObject = (ProductNameObject)vector.elementAt(n);
                String string = productNameObject.getDirectory();
                String string2 = productNameObject.getName();
                this.openDatabase(string, string2);
                ++n;
            }
            if (SearchTab.this.fSearchDatabases.size() == 0) {
                SearchTab.this.fSearchFileList.clear();
                SearchTab.this.fSearchFileList.addItem(HelpBrowser.sRes.getString("search.no_db_found"), "", "", null);
                return;
            }
            if (SearchTab.this.fShowingSearchFileList) {
                SearchTab.this.fSearchFileList.clear();
            } else {
                SearchTab.this.fGotoFileList.clear();
            }
            SearchTab.this.enableInputFields(true);
            SearchTab.this.fDatabasesOpen = true;
            SearchTab.this.fParent.loadingDataFinished();
        }
    }

    private class MyButton
    extends MWButton {
        public Dimension getPreferredSize() {
            Dimension dimension = this.getMinimumSize();
            dimension.height = ((SearchTab)SearchTab.this).fSearchTextField.getPreferredSize().height;
            dimension.width = 30;
            return dimension;
        }

        MyButton() {
            SearchTab.this = SearchTab.this;
        }
    }

    private class TipsButtonActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SearchTab.this.fParent.displayTopic(null, "matlab_env", "matlabenvironment_searchtips", SearchTab.this.fParent.getFrame());
        }

        TipsButtonActionListener() {
            SearchTab.this = SearchTab.this;
        }
    }

    private class AddToDBListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MWDialog mWDialog = new MWDialog(SearchTab.this.getFrame(), "Database Properties - New Product", true);
            MWPanel mWPanel = new MWPanel((LayoutManager)new BorderLayout(5, 0));
            mWPanel.add((Component)new MWLabel("Name of product:"), "West");
            mWPanel.add((Component)new MWTextField(), "Center");
            MWPanel mWPanel2 = new MWPanel((LayoutManager)new BorderLayout(5, 0));
            mWPanel2.add((Component)new MWLabel("Documentation folder:"), "West");
            mWPanel2.add((Component)new MWTextField(), "Center");
            GridLayout gridLayout = new GridLayout(2, 1);
            gridLayout.setVgap(8);
            MWPanel mWPanel3 = new MWPanel((LayoutManager)gridLayout);
            mWPanel3.setInsets(new Insets(8, 5, 8, 5));
            mWPanel3.add((Component)mWPanel);
            mWPanel3.add((Component)mWPanel2);
            MWButton mWButton = new MWButton("Generate database file");
            MWPanel mWPanel4 = new MWPanel((LayoutManager)new BorderLayout(5, 5));
            mWPanel4.add((Component)mWPanel3, "North");
            mWPanel4.add((Component)mWButton, "South");
            mWDialog.add((Component)mWPanel4);
            mWDialog.setSize(400, 120);
            mWDialog.setVisible(true);
            mWDialog.addWindowListener((WindowListener)new MWWindowActivater((Component)mWDialog));
        }

        AddToDBListener() {
            SearchTab.this = SearchTab.this;
        }
    }

    private class SearchThread
    extends Thread {
        private boolean fTitlesOnly;

        SearchThread(boolean bl) {
            SearchTab.this = SearchTab.this;
            this.fTitlesOnly = bl;
            SearchTab.this.fStopRequested = false;
        }

        public void run() {
            String[] stringArray;
            Object object;
            SearchTab.this.fSearchFileList.clear();
            int n = 0;
            String string = SearchTab.this.fSearchTextField.getText();
            Vector<String> vector = new Vector<String>();
            String string2 = string.trim();
            int n2 = string2.indexOf(32);
            while (n2 != -1) {
                vector.addElement(string2.substring(0, n2));
                string2 = string2.substring(n2 + 1).trim();
                n2 = string2.indexOf(32);
            }
            vector.addElement(string2.trim());
            int n3 = vector.size();
            String[] stringArray2 = new String[n3];
            int n4 = 0;
            while (n4 < n3) {
                stringArray2[n4] = ((String)vector.elementAt(n4)).toLowerCase();
                ++n4;
            }
            int n5 = 0;
            while (n5 < SearchTab.this.fSearchDatabases.size()) {
                if (SearchTab.this.fStopRequested) break;
                object = (SearchDatabase)((Object)SearchTab.this.fSearchDatabases.elementAt(n5));
                String string3 = HelpProductList.getProductName(((SearchDatabase)((Object)object)).getProductDirectory());
                if (SearchTab.this.fSearchAllProducts || HelpPrefs.isProductSelected(string3)) {
                    SearchTab.this.showSearchFileList(!string.equals(""));
                    stringArray = ((SearchDatabase)((Object)object)).updateWordList(string);
                    if (stringArray.length > 0) {
                        int n6 = SearchTab.this.fSearchFileList.updateFileList(string3, stringArray, stringArray2, this.fTitlesOnly);
                        n += n6;
                    }
                }
                ++n5;
            }
            if (n == 0) {
                SearchTab.this.fSearchFileList.addItem(HelpBrowser.sRes.getString("search.no_matches_found"), "", "", null);
            } else {
                SearchTab.this.fSearchFileList.removeLastBlankLine();
            }
            object = "";
            int n7 = 0;
            while (n7 < stringArray2.length) {
                if (n7 > 0) {
                    object = String.valueOf(object) + ", ";
                }
                object = String.valueOf(object) + stringArray2[n7];
                ++n7;
            }
            stringArray = "word";
            if (stringArray2.length > 1) {
                stringArray = "words";
            }
            String string4 = String.valueOf(n);
            Object[] objectArray = new Object[]{string4, stringArray, object};
            String string5 = HelpBrowser.getMessage(objectArray, HelpBrowser.sRes.getString("search.hit_message"));
            SearchTab.this.fParent.setStatusText(string5);
        }
    }

    private class SearchButtonActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = SearchTab.this.fSearchTextField.getText();
            if (!SearchTab.this.fSearchTextField.contains(string)) {
                SearchTab.this.fSearchTextField.addItem(string);
            }
            if (SearchTab.this.fSearchTextField.contains(string, true)) {
                SearchTab.this.fSearchTextField.removeItem(string, true);
            }
            String[] stringArray = SearchTab.this.fSearchTextField.getItems();
            String[] stringArray2 = new String[stringArray.length + 1];
            stringArray2[0] = string;
            int n = 0;
            while (n < stringArray.length) {
                stringArray2[n + 1] = stringArray[n];
                ++n;
            }
            SearchTab.this.fSearchTextField.setItems(stringArray2);
            SearchTab.this.doSearch();
        }

        SearchButtonActionListener() {
            SearchTab.this = SearchTab.this;
        }
    }

    private class GotoFunctionCallback
    implements CompletionObserver {
        private String fFuncName;

        public GotoFunctionCallback(String string) {
            SearchTab.this = SearchTab.this;
            this.fFuncName = string;
        }

        public void completed(int n, Object object) {
            String string = (String)object;
            if (string != null) {
                int n2;
                String string2;
                String string3 = string.trim();
                String string4 = "";
                String string5 = string3;
                int n3 = 0;
                int n4 = 0;
                while (n4 < string3.length()) {
                    if (string3.charAt(n4) == ';') {
                        string2 = string3.substring(n3, n4);
                        string2 = string2.replace('\\', '/');
                        String string6 = string2.substring(SearchTab.this.fDocRoot.length() + 1);
                        string5 = String.valueOf(string6) + ".html";
                        n2 = string6.lastIndexOf(47);
                        if ((string6 = string6.substring(0, n2)).endsWith("/ref")) {
                            string6 = string6.substring(0, string6.length() - 4);
                        }
                        string4 = HelpProductList.getProductName(string6);
                        if (SearchTab.this.fSearchAllProducts || HelpPrefs.isProductSelected(string4)) {
                            SearchTab.this.fGotoFileList.addItem(this.fFuncName, string4, string5, SearchTab.this.fGotoFileList.getDefaultIcon());
                        }
                        n3 = n4 + 1;
                    }
                    ++n4;
                }
                if (string4.equals("")) {
                    string2 = Matlab.matlabRoot();
                    if (PlatformInfo.isWindows()) {
                        string2 = string2.toLowerCase();
                        string5 = string5.toLowerCase();
                    }
                    int n5 = string2.length();
                    if (string5.length() > n5 && string5.substring(0, n5).equals(string2)) {
                        string5 = string3.replace('\\', '/');
                        string5 = string5.substring(n5 + 1);
                        n2 = string5.indexOf(47) + 1;
                        string4 = string5.substring(0, string5.indexOf(47, n2));
                    }
                    string4 = string4.endsWith("matlab") ? "MATLAB" : HelpProductList.getProductName(string4);
                    if (SearchTab.this.fSearchAllProducts || HelpPrefs.isProductSelected(string4)) {
                        SearchTab.this.fGotoFileList.addItem(this.fFuncName, string4, "helpwin", SearchTab.this.fGotoFileList.getDefaultIcon());
                    }
                }
            }
            if (SearchTab.this.fGotoFileList.getItemCount() == 0) {
                SearchTab.this.fGotoFileList.addItem(this.fFuncName, HelpBrowser.sRes.getString("search.not_found"), "", null);
            } else {
                SearchTab.this.fGotoFileList.selectFirstItem(false);
            }
            SearchTab.this.fGotoFileList.refresh();
            SearchTab.this.enableButtons(true);
            SearchTab.this.fParent.enableProductFilter(true);
        }
    }
}

