/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.help;

import com.mathworks.ide.help.HelpBrowser;
import com.mathworks.ide.help.HelpFontPrefs;
import com.mathworks.ide.help.HelpPrefs;
import com.mathworks.ide.help.SearchFileList;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwt.MWListbox;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.MWUtils;
import com.mathworks.mwt.message.MWLooper;
import com.mathworks.mwt.table.Cell;
import com.mathworks.mwt.table.CellText;
import com.mathworks.mwt.table.Style;
import com.mathworks.mwt.table.Table;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.ResLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class SearchFileList
extends MWPanel {
    private static final Color LT_GRAY = new Color(187, 187, 187);
    private static Style sProductHeaderStyle = new Style();
    private HelpBrowser fHelpBrowser;
    private String fDocRoot;
    private MWListbox fHitList;
    private ResLoader fResources = new ResLoader((Component)((Object)this));
    private Image fIcon;
    private Font fFont;
    private Font fProductHeaderFont;
    private Color fProductHeaderBackground;
    private PopupMenu fHitListPopupMenu;
    private HitListItemListener fHitListItemListener;
    private boolean fIsFullTextList = true;
    private Style fBaseStyle;
    private String fSearchString = "";
    static /* synthetic */ Class class$java$lang$String;

    public SearchFileList(HelpBrowser helpBrowser, String string) {
        this.fHelpBrowser = helpBrowser;
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.fIcon = this.fResources.loadImage("/com/mathworks/mwt/resources/htmlicon.gif");
        this.fHitList = new MWListbox();
        this.fHitList.setColumnCount(3);
        this.fHitList.getColumnOptions().setHeaderVisible(true);
        this.fHitList.getColumnOptions().setResizable(true);
        this.fHitList.setMultiSelection(true);
        this.fHitList.setEditable(false);
        this.fHitList.setResizeZeroWidthColumns(false);
        this.fHitList.addMouseListener(new HitListMouseListener());
        this.fHitListItemListener = new HitListItemListener();
        this.fHitList.addItemListener((ItemListener)this.fHitListItemListener);
        this.fHitList.setName(string);
        this.fHitList.registerCellType(class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = SearchFileList.class$("java.lang.String")), (Cell)new MyCellText((Table)this.fHitList));
        this.fHitList.setContextTriggerAware(true);
        int[] nArray = new int[3];
        nArray[0] = 250;
        nArray[1] = 200;
        int[] nArray2 = nArray;
        String[] stringArray = new String[]{HelpBrowser.sRes.getString("searchfilelist.subsection"), HelpBrowser.sRes.getString("searchfilelist.section"), "Filename"};
        if (string.equals("Goto")) {
            stringArray[0] = "Function";
            stringArray[1] = "Product";
            nArray2[0] = 120;
            nArray2[1] = 120;
            this.fIsFullTextList = false;
        }
        this.fHitList.setHeaders(stringArray);
        this.fHitList.setColumnWidth(0, nArray2[0]);
        this.fHitList.setColumnWidth(1, nArray2[1]);
        this.fHitList.setAutoExpandColumn(1);
        this.fHitList.setColumnWidth(2, nArray2[2]);
        Style style = new Style(384);
        Insets insets = style.getMargins();
        insets.left = 10;
        style.setMargins(insets);
        style.setHAlignment(0);
        this.fHitList.setColumnStyle(1, style);
        this.fHitList.setCellStyle(-1, 1, style);
        this.fHitListPopupMenu = new HitListPopupMenu();
        this.fHitList.add(this.fHitListPopupMenu);
        this.setFont();
        HelpPrefs.addFontListeners(new FontChangeListener());
        this.fBaseStyle = new Style();
        this.fBaseStyle = this.fBaseStyle.getBaseStyle();
        ((Container)((Object)this)).add((Component)this.fHitList, "Center");
    }

    public Image getDefaultIcon() {
        return this.fIcon;
    }

    public void setVisible(boolean bl) {
        if (bl && this.fDocRoot == null) {
            this.fDocRoot = this.fHelpBrowser.getDocRootForBrowser();
        }
    }

    public void setDocRoot(String string) {
        this.fDocRoot = string;
    }

    private void setFont() {
        this.fFont = HelpFontPrefs.getHelpNavigatorFont();
        this.fHitList.setFont(this.fFont);
        sProductHeaderStyle.setFont(new Font(this.fFont.getFamily(), 1, this.fFont.getSize() + 1));
        this.fHitList.repaint();
    }

    public void clear() {
        this.fHitList.removeAllItems();
    }

    public void refresh() {
        this.fResources.waitForPendingImages();
        ((Component)((Object)this)).repaint();
    }

    public int getItemCount() {
        return this.fHitList.getItemCount();
    }

    public void selectFirstItem(boolean bl) {
        if (!bl) {
            this.fHitList.removeItemListener((ItemListener)this.fHitListItemListener);
        }
        this.fHitList.select(0, 0);
        if (!bl) {
            this.fHitList.addItemListener((ItemListener)this.fHitListItemListener);
        }
    }

    private void addProductHeader(String string) {
        this.addItem(string, "", "", null);
        this.fHitList.setRowStyle(this.fHitList.getItemCount() - 1, sProductHeaderStyle);
    }

    public void addItem(String string, String string2, String string3, Image image) {
        this.insertItem(string, string2, string3, image, this.fHitList.getItemCount());
    }

    public void insertItem(String string, String string2, String string3, Image image, int n) {
        Object[] objectArray = new String[]{string, string2, string3};
        this.fHitList.addItem(objectArray, n);
        this.fHitList.setRowStyle(n, this.fBaseStyle);
    }

    public int updateFileList(String string, String[] stringArray, String[] stringArray2, boolean bl) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = n = this.fHitList.getItemCount() + 1;
        this.fSearchString = stringArray2[0];
        while (stringArray != null && n2 < stringArray.length) {
            String string2 = stringArray[n2];
            String string3 = this.getFirstTitleFromEntry(string2);
            String string4 = this.getSecondTitleFromEntry(string2);
            String string5 = this.getThirdTitleFromEntry(string2);
            String string6 = string5.toLowerCase();
            boolean bl2 = true;
            boolean bl3 = false;
            int n5 = 0;
            while (n5 < stringArray2.length) {
                if (string6.indexOf(stringArray2[n5]) == -1) {
                    bl2 = false;
                } else {
                    bl3 = true;
                }
                ++n5;
            }
            if (!bl || bl2) {
                String string7 = "";
                string7 = string5.equals(string4) ? string3 : string4;
                if (!string5.equals("")) {
                    if (n3 == 0) {
                        this.addProductHeader(string);
                    }
                    int n6 = this.fHitList.getItemCount();
                    if (bl2) {
                        n6 = n++;
                        ++n4;
                    } else if (bl3) {
                        n6 = n4++;
                    }
                    this.insertItem(string5, string7, this.getFilenameFromEntry(string2), this.fIcon, n6);
                    ++n3;
                }
            }
            ++n2;
        }
        if (n3 > 0) {
            this.addItem("", "", "", null);
        }
        return n3;
    }

    public void removeLastBlankLine() {
        int n = this.fHitList.getItemCount() - 1;
        if (this.fHitList.getItem(n).equals("")) {
            this.fHitList.removeItem(n);
        }
    }

    private String getFilenameFromEntry(String string) {
        int n = string.indexOf("::");
        if (n > -1) {
            String string2 = string.substring(0, n);
            if (string2.startsWith("./")) {
                return string2.substring(2);
            }
            return string2;
        }
        return "";
    }

    private String getFirstTitleFromEntry(String string) {
        int n = string.indexOf("::");
        int n2 = string.indexOf("::", n + 2);
        if (n > 0 && n2 > n + 2) {
            return string.substring(n + 2, n2).trim();
        }
        return "";
    }

    private String getSecondTitleFromEntry(String string) {
        int n;
        int n2 = string.indexOf("::");
        int n3 = string.indexOf("::", n2 + 2);
        if (n2 > 0 && n3 > n2 + 2 && (n = string.indexOf("::", n3 + 2)) > -1) {
            return string.substring(n3 + 2, n).trim();
        }
        return "";
    }

    private String getThirdTitleFromEntry(String string) {
        int n = string.indexOf("::");
        int n2 = string.indexOf("::", n + 1);
        if (n > 0 && n2 > n + 2) {
            int n3 = string.indexOf("::", n2 + 1);
            if (n2 > -1 && n3 > n2 + 2) {
                return string.substring(n3 + 2).trim();
            }
        }
        return "";
    }

    private void sendSelectedFileToBrowser() {
        int n = this.fHitList.getSelectedIndex();
        String string = this.fHitList.getItem(n, 2);
        if (n != -2 && !string.equals("")) {
            if (!this.fIsFullTextList && string.equals("helpwin")) {
                Matlab matlab = new Matlab(new MWLooper("Help Browser - helpwin"));
                matlab.evalNoOutput("helpwin " + this.fHitList.getItem(n, 0));
                return;
            }
            this.fHelpBrowser.getIceBrowser().setCurrentLocationAndHighlightString(String.valueOf(this.fDocRoot) + "/" + string, this.fSearchString);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ HelpBrowser access$1(SearchFileList searchFileList) {
        return searchFileList.fHelpBrowser;
    }

    static /* synthetic */ String access$2(SearchFileList searchFileList) {
        return searchFileList.fDocRoot;
    }

    static {
        sProductHeaderStyle.setBackground(LT_GRAY);
        sProductHeaderStyle.setVGridVisible(false);
    }

    private class HitListMouseListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            if (PlatformInfo.getPlatform() == 2) {
                this.doStuff(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (PlatformInfo.getPlatform() != 2) {
                this.doStuff(mouseEvent);
            }
        }

        public void doStuff(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                int n = SearchFileList.this.fHitList.getSelectedIndex();
                String string = SearchFileList.this.fHitList.getItem(n, 2);
                if (string == null || string.equals("")) {
                    SearchFileList.this.fHitListPopupMenu.getItem(0).setEnabled(false);
                } else {
                    SearchFileList.this.fHitListPopupMenu.getItem(0).setEnabled(true);
                }
                SearchFileList.this.fHitListPopupMenu.show((Component)SearchFileList.this.fHitList, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        HitListMouseListener() {
            SearchFileList.this = SearchFileList.this;
        }
    }

    public class HitListPopupMenu
    extends PopupMenu {
        public HitListPopupMenu() {
            SearchFileList.this = SearchFileList.this;
            this.add(HelpBrowser.sRes.getString("icecontainer.addtofavorites"));
            this.addActionListener(new 1(this));
        }

        static /* synthetic */ SearchFileList access$0(HitListPopupMenu hitListPopupMenu) {
            return hitListPopupMenu.SearchFileList.this;
        }
    }

    private class HitListItemListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            SendFileToBrowserThread sendFileToBrowserThread = new SendFileToBrowserThread();
            sendFileToBrowserThread.start();
        }

        HitListItemListener() {
            SearchFileList.this = SearchFileList.this;
        }
    }

    private class SendFileToBrowserThread
    extends Thread {
        SendFileToBrowserThread() {
            SearchFileList.this = SearchFileList.this;
        }

        public void run() {
            SearchFileList.this.sendSelectedFileToBrowser();
        }
    }

    private class FontChangeListener
    implements PrefListener {
        public void prefChanged(PrefEvent prefEvent) {
            if (prefEvent.getEventType() == 1) {
                String string = prefEvent.getPrefKey();
                if (string.equals("HelpNavigatorFont") || string.equals("HelpUseDesktopFont")) {
                    SearchFileList.this.setFont();
                    return;
                }
                if (string.equals("GeneralFont") && HelpFontPrefs.getUseDesktopFont()) {
                    SearchFileList.this.setFont();
                }
            }
        }

        FontChangeListener() {
            SearchFileList.this = SearchFileList.this;
        }
    }

    private class MyCellText
    extends CellText {
        public MyCellText(Table table) {
            super(table);
            SearchFileList.this = SearchFileList.this;
        }

        public void render(Graphics graphics, int n, int n2, Rectangle rectangle, Object object, Style style, boolean bl) {
            if (n2 == 0 && object instanceof String && object != null) {
                graphics.setFont(style.getFont());
                object = MWUtils.shortenString((String)((String)object), (FontMetrics)graphics.getFontMetrics(), (int)(rectangle.width - style.getMargins().right));
            }
            super.render(graphics, n, n2, rectangle, object, style, bl);
        }
    }
}

