/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.help;

import com.mathworks.ide.help.DBBTree;
import com.mathworks.ide.help.SearchWord;
import com.mathworks.mwt.MWPanel;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class SearchDatabase
extends MWPanel {
    private String fDbFilename;
    private String fProductDir;
    private String fProductName;
    private DBBTree fDatabase;
    private Hashtable fCurrentWords = new Hashtable();
    private Vector fFileCaptionsList = new Vector(500);
    private Vector fFileNamesList = new Vector(500);

    public SearchDatabase(String string, String string2, String string3) {
        this.fDbFilename = string;
        this.fProductDir = string2;
        this.fProductName = string3;
        this.fDatabase = this.openDatabase(this.fDbFilename);
    }

    public String getFilename() {
        return this.fDbFilename;
    }

    public RandomAccessFile getFile() {
        if (this.fDatabase == null) {
            return null;
        }
        return this.fDatabase.getFile();
    }

    public String getProductDirectory() {
        return this.fProductDir;
    }

    public String getProductName() {
        return this.fProductName;
    }

    public void open() {
        try {
            this.fDatabase.open();
            return;
        }
        catch (Exception exception) {
            System.err.println("**** Couldn't re-open index ****\n");
            return;
        }
    }

    public void close() {
        this.fDatabase.close();
    }

    public byte[] search(byte[] byArray) throws IOException {
        return this.fDatabase.search(byArray);
    }

    public String[] updateWordList(String string) {
        Object object;
        Object object2;
        SearchWord searchWord = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            object2 = this.LookupWord(this.CanonicalWord(stringTokenizer.nextToken()));
            object = String.valueOf(((SearchWord)object2).word) + ": " + ((SearchWord)object2).totalNonZero();
            if (searchWord == null) {
                searchWord = new SearchWord();
                searchWord.or((SearchWord)object2);
                continue;
            }
            searchWord.and((SearchWord)object2);
        }
        if (searchWord != null) {
            object2 = searchWord.getFileIds();
            object = new String[((int[])object2).length];
            int n = 0;
            while (n < ((int[])object2).length) {
                object[n] = this.getFileCaption((int)object2[n]);
                ++n;
            }
            return object;
        }
        return new String[0];
    }

    private DBBTree openDatabase(String string) {
        try {
            DBBTree dBBTree = new DBBTree(new File(string));
            return dBBTree;
        }
        catch (IOException iOException) {
            System.out.println("    Couldn't open " + string);
            System.out.println("    IOException: " + iOException);
            try {
                DBBTree dBBTree = new DBBTree(string);
                return dBBTree;
            }
            catch (IOException iOException2) {
                System.out.println("    Couldn't open " + string);
                System.out.println("    IOException: " + iOException2);
                StringBuffer stringBuffer = new StringBuffer(string);
                try {
                    char c = File.separatorChar;
                    int n = 0;
                    while (n < stringBuffer.length()) {
                        if (stringBuffer.charAt(n) == '/') {
                            stringBuffer.setCharAt(n, c);
                        }
                        ++n;
                    }
                    DBBTree dBBTree = new DBBTree(stringBuffer.toString());
                    return dBBTree;
                }
                catch (IOException iOException3) {
                    System.out.println("    Couldn't open " + stringBuffer);
                    System.out.println("    IOException: " + iOException3);
                    string = string.substring(1);
                    try {
                        DBBTree dBBTree = new DBBTree(string);
                        return dBBTree;
                    }
                    catch (IOException iOException4) {
                        System.out.println("    Couldn't open " + string);
                        System.out.println("    IOException: " + iOException4);
                        return null;
                    }
                }
            }
        }
    }

    private String CanonicalWord(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        return stringBuffer.toString().toLowerCase();
    }

    private SearchWord LookupWord(String string) {
        SearchWord searchWord;
        byte[] byArray;
        if (this.fCurrentWords.containsKey(string)) {
            return (SearchWord)this.fCurrentWords.get(string);
        }
        if (this.fDatabase == null) {
            return new SearchWord(string);
        }
        byte[] byArray2 = new byte[string.length()];
        int n = 0;
        while (n < string.length()) {
            byArray2[n] = (byte)string.charAt(n);
            ++n;
        }
        try {
            byArray = this.fDatabase.search(byArray2);
        }
        catch (IOException iOException) {
            System.err.println("*** Search for " + string + " generated IOException");
            return new SearchWord(string);
        }
        if (byArray == null) {
            searchWord = new SearchWord(string);
        } else {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            searchWord = new SearchWord(string, dataInputStream);
            String string2 = "Word `" + string + "' appears in files ";
            int n2 = 0;
            int n3 = 0;
            while (n3 < searchWord.getNumberCounts()) {
                if (searchWord.getCount(n3) > 0) {
                    if (++n2 < 10) {
                        string2 = String.valueOf(string2) + " " + n3;
                    } else if (n2 < 11) {
                        string2 = String.valueOf(string2) + " ... ";
                    }
                }
                ++n3;
            }
        }
        this.fCurrentWords.put(string, searchWord);
        return searchWord;
    }

    private String getFileCaption(int n) {
        String string;
        int n2;
        String string2 = null;
        try {
            string2 = (String)this.fFileCaptionsList.elementAt(n);
            if (string2 != null) {
                return string2;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        byte[] byArray = new byte[3];
        byArray[1] = (byte)(n / 256);
        byArray[2] = (byte)(n & 0xFF);
        byte[] byArray2 = byArray;
        try {
            byte[] byArray3 = this.fDatabase.search(byArray2);
            if (byArray3 != null) {
                string2 = new String(byArray3, 0);
            }
        }
        catch (IOException iOException) {}
        if (string2 == null) {
            System.err.println("*** Search for file " + n + " failed ***");
            string2 = "<Error: fileId " + n + ">";
        }
        if ((n2 = string2.lastIndexOf(9)) > 0) {
            string = string2.substring(n2 + 1);
            string2 = string2.substring(0, n2);
        } else {
            string = "";
        }
        if (this.fFileCaptionsList.size() < n + 1) {
            this.fFileCaptionsList.setSize(n + 1);
        }
        if (this.fFileNamesList.size() < n + 1) {
            this.fFileNamesList.setSize(n + 1);
        }
        this.fFileCaptionsList.setElementAt(string2, n);
        this.fFileNamesList.setElementAt(string, n);
        return string2;
    }
}

