/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.help;

import com.mathworks.ide.help.HelpBrowser;
import com.mathworks.ide.help.HelpPrefs;
import com.mathworks.ide.help.HelpProductList;
import com.mathworks.ide.help.ProductNameObject;
import com.mathworks.mwt.MWCheckbox;
import com.mathworks.mwt.MWGroupbox;
import com.mathworks.mwt.MWListbox;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.table.Cell;
import com.mathworks.mwt.table.CellMWCheckbox;
import com.mathworks.mwt.table.LabeledImageResource;
import com.mathworks.mwt.table.Table;
import com.mathworks.util.ResLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.Insets;
import java.util.Vector;

public class ProductFilterPanel
extends MWPanel {
    private static String[] sSelectedProducts = HelpPrefs.getSelectedProducts();
    private static Vector sProductList;
    private MWListbox fProductListbox = new MWListbox();
    private MWGroupbox fFilterBox;
    private Image fAlertIcon;
    static /* synthetic */ Class class$java$lang$String;

    public ProductFilterPanel(boolean bl) {
        this.fProductListbox.setPreferredTableSize(2, 1);
        this.fProductListbox.setEditable(true);
        HelpProductList.buildProductList(HelpPrefs.getDocRoot());
        this.fFilterBox = new MWGroupbox(HelpBrowser.sRes.getString("filter.products_to_include"));
        this.fFilterBox.setMargins(new Insets(5, 5, 5, 5));
        this.fFilterBox.setLayout(new BorderLayout(5, 5));
        this.fFilterBox.add((Component)this.fProductListbox, "Center");
        ResLoader resLoader = new ResLoader((Component)((Object)this));
        this.fAlertIcon = resLoader.loadImage("/com/mathworks/mwt/resources/alerticon.gif");
        ((Container)((Object)this)).setLayout(new BorderLayout());
        ((Container)((Object)this)).add((Component)this.fFilterBox, "Center");
    }

    public void seedProductFilterPanel(Vector vector, String string) {
        this.clearProducts();
        this.fProductListbox.registerCellType(class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = ProductFilterPanel.class$("java.lang.String")), (Cell)new CellMWCheckbox((Table)this.fProductListbox));
        if (vector.size() > 1) {
            int n = 0;
            while (n < vector.size()) {
                ProductNameObject productNameObject = (ProductNameObject)vector.elementAt(n);
                this.addProduct(productNameObject.getName());
                ++n;
            }
            this.doneAddingProducts(true);
            return;
        }
        if (vector.size() == 1) {
            ProductNameObject productNameObject = (ProductNameObject)vector.elementAt(0);
            this.addProduct(productNameObject.getName());
            this.doneAddingProducts(true);
            return;
        }
        String string2 = HelpBrowser.sRes.getString("filter.no_products_found");
        this.fProductListbox.addItem(string2);
        this.fProductListbox.setCellData(0, 0, (Object)new LabeledImageResource(this.fAlertIcon, string2));
    }

    public boolean isProductSelected(int n) {
        Object object = this.fProductListbox.getCellData(n, 0);
        MWCheckbox mWCheckbox = null;
        if (object instanceof MWCheckbox) {
            mWCheckbox = (MWCheckbox)object;
            if (mWCheckbox == null) {
                return false;
            }
            return mWCheckbox.getState();
        }
        return false;
    }

    public boolean isProductSelected(String string) {
        int n = 0;
        while (n < this.fProductListbox.getItemCount()) {
            String string2 = this.fProductListbox.getItem(n, 1);
            if (string2 != null && string2.equals(string)) {
                MWCheckbox mWCheckbox = (MWCheckbox)this.fProductListbox.getCellData(n, 0);
                return mWCheckbox.getState();
            }
            ++n;
        }
        return false;
    }

    public void savePrefs() {
        if (sSelectedProducts != null && this.fProductListbox.getItemCount() > 0) {
            Object object = this.fProductListbox.getCellData(0, 0);
            if (!(object instanceof MWCheckbox)) {
                return;
            }
            Vector<String> vector = new Vector<String>();
            int n = 0;
            while (n < this.fProductListbox.getItemCount()) {
                if (this.isProductSelected(n)) {
                    MWCheckbox mWCheckbox = (MWCheckbox)this.fProductListbox.getCellData(n, 0);
                    vector.addElement(mWCheckbox.getLabel());
                }
                ++n;
            }
            sSelectedProducts = new String[vector.size()];
            int n2 = 0;
            while (n2 < vector.size()) {
                ProductFilterPanel.sSelectedProducts[n2] = (String)vector.elementAt(n2);
                ++n2;
            }
            HelpPrefs.saveDirectoryPrefs("HelpSelectedProducts", "", sSelectedProducts, false);
        }
    }

    private void clearProducts() {
        this.fProductListbox.removeAllItems();
    }

    private void addProduct(String string) {
        String[] stringArray = new String[]{"", string};
        boolean bl = false;
        int n = 0;
        while (n < sSelectedProducts.length) {
            if (sSelectedProducts[n].equals(string)) {
                bl = true;
                break;
            }
            ++n;
        }
        this.fProductListbox.addItem((Object)new MWCheckbox(string, bl));
    }

    private void doneAddingProducts(boolean bl) {
        int n = this.fProductListbox.getItemCount();
        if (n > 2) {
            this.fProductListbox.setPreferredTableSize(2, 1);
        } else {
            this.fProductListbox.setPreferredTableSize(n, 1);
        }
        this.fProductListbox.invalidate();
        ((Container)((Object)this)).validate();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

