/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.help;

import com.mathworks.ide.help.HelpBrowser;
import com.mathworks.ide.help.HelpFontPrefs;
import com.mathworks.ide.help.HelpPrefs;
import com.mathworks.ide.help.Index;
import com.mathworks.ide.help.ProductFilterPanel;
import com.mathworks.mwt.MWLabel;
import com.mathworks.mwt.MWListbox;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.MWTextField;
import com.mathworks.mwt.MWUtils;
import com.mathworks.mwt.table.Cell;
import com.mathworks.mwt.table.CellText;
import com.mathworks.mwt.table.Style;
import com.mathworks.mwt.table.Table;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.QueueEvent;
import com.mathworks.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;

public class Index
extends MWPanel {
    private static final int ABORT_PARSING = -2;
    private HelpBrowser fParent;
    private MWPanel fNorthPanel;
    private MWLabel fWaitMsgLabel;
    private IndexListPopupMenu fIndexListPopupMenu;
    private String fDocRoot;
    private IndexTextField fSearchField;
    private String fIndexFile;
    private int fCurrentIndexList = -1;
    private char fCurrentIndexLetter;
    private boolean fIndexListsInitialized = false;
    private ProductFilterPanel fProductFilterPanel;
    private MergeIndexFilesThread fMergeIndexFilesThread;
    private int fCurrentSelectedItem = -2;
    private boolean fEntriesAdded;
    private Vector fIndexFileList = new Vector();
    private boolean fSearchAllProducts = HelpPrefs.areAllProductsSelected();
    private Vector fIndexEntryList = new Vector();
    private MWListbox fIndexListbox;
    private boolean fSendToBrowser = true;
    private int fNextID;
    private boolean fStopRequested = false;
    static /* synthetic */ Class class$java$lang$String;

    public Index(HelpBrowser helpBrowser) {
        this.fParent = helpBrowser;
        if (this.fDocRoot == null) {
            ((Container)((Object)this)).setLayout(new BorderLayout());
            this.fNorthPanel = new MWPanel((LayoutManager)new BorderLayout(5, 5));
            this.fNorthPanel.setInsets(new Insets(5, 0, 5, 0));
            this.fSearchField = new IndexTextField();
            this.fNorthPanel.add((Component)new MWLabel(HelpBrowser.sRes.getString("index.searchfor")), "North");
            this.fNorthPanel.add((Component)((Object)this.fSearchField), "Center");
            ((Container)((Object)this)).add((Component)this.fNorthPanel, "North");
            this.fSearchField.setEnabled(false);
            ((Container)((Object)this)).invalidate();
            ((Container)((Object)this)).validate();
            this.fIndexListbox = new MWListbox();
            this.fIndexListbox.setName("Index");
            this.fIndexListbox.setColumnCount(3);
            this.fIndexListbox.getColumnOptions().setHeaderVisible(true);
            this.fIndexListbox.getColumnOptions().setResizable(true);
            this.fIndexListbox.setResizeZeroWidthColumns(false);
            this.fIndexListbox.setMultiSelection(true);
            this.fIndexListbox.setEditable(false);
            this.fIndexListbox.addMouseListener(new IndexListMouseListener());
            this.fIndexListbox.addItemListener((ItemListener)new IndexListItemListener());
            this.fIndexListbox.registerCellType(class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = Index.class$("java.lang.String")), (Cell)new MyCellText((Table)this.fIndexListbox));
            this.fIndexListbox.setContextTriggerAware(true);
            int[] nArray = new int[3];
            nArray[0] = 150;
            nArray[1] = 200;
            int[] nArray2 = nArray;
            String[] stringArray = new String[]{"A", HelpBrowser.sRes.getString("index.product_header"), "Filename"};
            this.fIndexListbox.setHeaders(stringArray);
            this.fIndexListbox.setColumnWidth(0, nArray2[0]);
            this.fIndexListbox.setColumnWidth(1, nArray2[1]);
            this.fIndexListbox.setAutoExpandColumn(1);
            this.fIndexListbox.setColumnWidth(2, nArray2[2]);
            this.fIndexListPopupMenu = new IndexListPopupMenu();
            this.fIndexListbox.add(this.fIndexListPopupMenu);
            Style style = new Style(384);
            Insets insets = style.getMargins();
            insets.left = 10;
            style.setMargins(insets);
            style.setHAlignment(0);
            this.fIndexListbox.setColumnStyle(1, style);
            this.fIndexListbox.setCellStyle(-1, 1, style);
            HelpPrefs.addFontListeners(new HelpPrefsListener());
        }
    }

    public void loadData(boolean bl) {
        this.fSearchAllProducts = bl;
        if (this.fDocRoot == null) {
            this.mergeIndexFiles(HelpPrefs.getDocRoot(), 'a', true);
        }
    }

    public void resetDocRoot(String string) {
        this.mergeIndexFiles(string, 'a', true);
    }

    private void getIndexFilesFromMasterFile(String string) {
        File file = new File(string);
        if (!file.exists()) {
            System.out.println(String.valueOf(string) + " does not exist.");
            return;
        }
        BufferedReader bufferedReader = null;
        String string2 = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
        }
        catch (FileNotFoundException fileNotFoundException) {}
        if (bufferedReader != null) {
            try {
                while ((string2 = bufferedReader.readLine()) != null) {
                    String string3;
                    String string4;
                    String string5;
                    File file2;
                    if (!(string2 = string2.trim()).startsWith("<subindex target=")) continue;
                    int n = string2.indexOf("=") + 2;
                    int n2 = string2.indexOf("\"", n + 1);
                    if (n2 == -1) {
                        n2 = string2.length();
                    }
                    if (!(file2 = new File(string5 = StringUtils.fromJavaPath((String)(String.valueOf(this.fDocRoot) + "/" + string2.substring(n, n2))))).exists()) continue;
                    int n3 = string2.indexOf("product=", n2 + 1) + 9;
                    int n4 = string2.indexOf("</subindex>", n3 + 1) - 2;
                    if (n4 == -1) {
                        n4 = string2.length();
                    }
                    if ((string4 = (string3 = string2.substring(n3, n4))).startsWith("MATLAB -")) {
                        string4 = "MATLAB";
                    }
                    if (!this.fSearchAllProducts && !HelpPrefs.isProductSelected(string4)) continue;
                    IndexFileObject indexFileObject = new IndexFileObject(file2, string3);
                    this.fIndexFileList.addElement(indexFileObject);
                }
                bufferedReader.close();
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }
    }

    private void showText(String string) {
        if (this.fCurrentIndexList != -1) {
            ((Container)((Object)this)).remove((Component)this.fIndexListbox);
        } else if (this.fWaitMsgLabel != null) {
            ((Container)((Object)this)).remove((Component)this.fWaitMsgLabel);
        }
        this.fCurrentIndexList = -1;
        this.fWaitMsgLabel = new MWLabel(string, 1);
        this.fWaitMsgLabel.setFont(new Font("Dialog", 1, 10));
        ((Container)((Object)this)).add((Component)this.fWaitMsgLabel, "Center");
        ((Container)((Object)this)).invalidate();
        ((Container)((Object)this)).validate();
    }

    private void setWaitCursor(boolean bl) {
        Cursor cursor = bl ? Cursor.getPredefinedCursor(3) : Cursor.getDefaultCursor();
        ((Component)((Object)this)).setCursor(cursor);
        this.fNorthPanel.setCursor(cursor);
        this.fIndexListbox.setCursor(cursor);
        this.fSearchField.setCursor(cursor);
    }

    private void mergeIndexFiles(String string, char c, boolean bl) {
        if (this.fMergeIndexFilesThread != null && this.fMergeIndexFilesThread.isAlive()) {
            this.fStopRequested = true;
            try {
                this.fMergeIndexFilesThread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        boolean bl2 = false;
        if (bl) {
            this.fSearchField.setEnabled(false);
            if (this.fDocRoot == null || !this.fDocRoot.equals(string)) {
                this.fDocRoot = string;
                bl2 = true;
            }
            if (string == null || string.equals("")) {
                this.showText(HelpBrowser.sRes.getString("index.docroot_not_set"));
                return;
            }
            if (!new File(string).isDirectory()) {
                Object[] objectArray = new Object[]{string};
                String string2 = HelpBrowser.getMessage(objectArray, HelpBrowser.sInvalidDocroot);
                this.showText(string2);
                return;
            }
            this.showText(HelpBrowser.sRes.getString("index.merging_progress"));
            this.fSearchField.setText("");
        }
        this.fMergeIndexFilesThread = new MergeIndexFilesThread(c, bl2, bl);
        this.fMergeIndexFilesThread.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int doMergeIndexFiles(char c, boolean bl) {
        Object object;
        this.fIndexListbox.removeAllItems();
        this.fIndexEntryList.removeAllElements();
        this.fCurrentSelectedItem = -2;
        this.setWaitCursor(true);
        Character c2 = new Character(c);
        String string = c2.toString().toUpperCase();
        if (!this.isCharALetter(c)) {
            string = HelpBrowser.sRes.getString("index.symbol_header");
        }
        String[] stringArray = new String[]{string, HelpBrowser.sRes.getString("index.product_header"), "Filename"};
        this.fIndexListbox.setHeaders(stringArray);
        this.fNextID = 0;
        int n = 0;
        while (n < this.fIndexFileList.size()) {
            this.fEntriesAdded = false;
            object = (IndexFileObject)this.fIndexFileList.elementAt(n);
            this.buildIndex(c, ((IndexFileObject)object).getIndexFile(), ((IndexFileObject)object).getProductName(), n == 0);
            if (this.fStopRequested) {
                return -2;
            }
            ++n;
        }
        object = this.fIndexListbox.getData();
        try {
            object.setHeight(this.fNextID);
            object.suspendDataChangedNotification();
            this.fNextID = 0;
            int n2 = 0;
            while (n2 < this.fIndexEntryList.size()) {
                IndexEntryObject indexEntryObject = (IndexEntryObject)this.fIndexEntryList.elementAt(n2);
                this.addEntryObjectToListbox(indexEntryObject, 0);
                if (this.fStopRequested) {
                    int n3 = -2;
                    Object var10_11 = null;
                    object.resumeDataChangedNotification(true);
                    return n3;
                }
                ++n2;
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            object.resumeDataChangedNotification(true);
            throw throwable;
        }
        Object var10_12 = null;
        object.resumeDataChangedNotification(true);
        this.fIndexEntryList.removeAllElements();
        System.gc();
        this.fSearchField.setEnabled(true);
        this.fIndexListsInitialized = true;
        this.setWaitCursor(false);
        return 0;
    }

    private void addEntryObjectToListbox(IndexEntryObject indexEntryObject, int n) {
        String string = "";
        int n2 = 0;
        while (n2 < n) {
            string = String.valueOf(string) + "     ";
            ++n2;
        }
        string = String.valueOf(string) + indexEntryObject.getLeadingSymbol();
        String[] stringArray = new String[3];
        String string2 = indexEntryObject.getEntryName();
        int n3 = indexEntryObject.getDuplicateNumber();
        if (n3 > 0) {
            string2 = String.valueOf(string2) + " [" + String.valueOf(n3) + "]";
        }
        stringArray[0] = String.valueOf(string) + string2;
        stringArray[1] = indexEntryObject.getProductName();
        stringArray[2] = indexEntryObject.getFileName();
        indexEntryObject.setListboxRow(this.fNextID);
        this.fIndexListbox.setCellData(this.fNextID, 0, (Object)stringArray[0]);
        this.fIndexListbox.setCellData(this.fNextID, 1, (Object)stringArray[1]);
        this.fIndexListbox.setCellData(this.fNextID++, 2, (Object)stringArray[2]);
        Vector vector = indexEntryObject.getChildren();
        int n4 = 0;
        while (n4 < vector.size()) {
            IndexEntryObject indexEntryObject2 = (IndexEntryObject)vector.elementAt(n4);
            this.addEntryObjectToListbox(indexEntryObject2, n + 1);
            ++n4;
        }
        vector.removeAllElements();
    }

    public void buildIndex(char c, File file, String string, boolean bl) {
        BufferedReader bufferedReader = null;
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
            bufferedReader = new BufferedReader(fileReader);
        }
        catch (FileNotFoundException fileNotFoundException) {}
        if (bufferedReader != null) {
            try {
                this.buildIndexFromFile(c, bufferedReader, string, file.getParent(), null, bl, false);
                bufferedReader.close();
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int buildIndexFromFile(char c, BufferedReader bufferedReader, String string, String string2, IndexEntryObject indexEntryObject, boolean bl, boolean bl2) {
        String string3 = null;
        try {
            string2 = string2.replace('\\', '/');
            boolean bl3 = false;
            if (!this.isCharALetter(c)) {
                bl3 = true;
            }
            IndexEntryObject indexEntryObject2 = indexEntryObject;
            while ((string3 = bufferedReader.readLine()) != null) {
                int n;
                boolean bl4 = false;
                boolean bl5 = false;
                if (this.fEntriesAdded) {
                    string3 = string3.trim();
                }
                if (string3.startsWith("<indexitem")) {
                    if (indexEntryObject == null) {
                        n = string3.indexOf(62) + 1;
                        int n2 = string3.indexOf("</indexitem");
                        if (n2 == -1) {
                            n2 = string3.length();
                        }
                        if (n > 0) {
                            String string4 = string3.toLowerCase();
                            char c2 = string4.charAt(n);
                            if (!this.isCharALetter(c2)) {
                                while (n < n2 && !this.isCharALetter(c2)) {
                                    c2 = string4.charAt(n++);
                                }
                            }
                            if (bl3) {
                                if (this.isCharALetter(c2)) return -2;
                                bl4 = true;
                            } else if (c2 != c) {
                                if (this.fEntriesAdded) return -2;
                                bl4 = false;
                            } else {
                                bl4 = true;
                            }
                        }
                    } else if (this.fEntriesAdded) {
                        bl4 = true;
                    }
                    if (bl4) {
                        bl5 = true;
                        if (this.fStopRequested) {
                            return -2;
                        }
                        indexEntryObject2 = this.addLineToIndexList(c, string3, indexEntryObject, string2, bl, string, bl3);
                    }
                } else if (this.fEntriesAdded) {
                    bl5 = true;
                }
                if (!bl5) continue;
                if (!string3.endsWith("</indexitem>") && (n = this.buildIndexFromFile(c, bufferedReader, string, string2, indexEntryObject2, bl, bl2)) == -2) {
                    return -2;
                }
                if (!string3.equals("</indexitem>") || indexEntryObject == null) continue;
                indexEntryObject = indexEntryObject.getParentEntryObj();
            }
            return 0;
        }
        catch (IOException iOException) {}
        return 0;
    }

    private IndexEntryObject addLineToIndexList(char c, String string, IndexEntryObject indexEntryObject, String string2, boolean bl, String string3, boolean bl2) {
        Object object;
        String string4;
        String string5 = "";
        int n = string.indexOf(">") + 1;
        int n2 = string.indexOf("</indexitem");
        if (n2 == -1) {
            n2 = string.length();
        }
        if (n2 <= n) {
            return null;
        }
        String string6 = string.substring(n, n2);
        int n3 = string.indexOf("target=");
        if (n3 != -1) {
            int n4 = string.indexOf(">", n3 += 8) - 1;
            string4 = string.substring(n3, n4);
            object = "";
            if (!string4.startsWith("http://")) {
                if (string2.startsWith(this.fDocRoot.replace('\\', '/'))) {
                    string2 = string2.substring(this.fDocRoot.length() + 1);
                }
                object = String.valueOf(string2) + "/";
            }
            string5 = String.valueOf(object) + string4;
        }
        this.fEntriesAdded = true;
        IndexEntryObject indexEntryObject2 = new IndexEntryObject(string6, string3, string5, indexEntryObject, bl2);
        string4 = indexEntryObject2.getEntryName().toLowerCase();
        if (indexEntryObject == null) {
            if (!bl) {
                return this.insertIndexEntryObject(this.fIndexEntryList, indexEntryObject2, string4);
            }
            if (this.fIndexEntryList.size() > 0 && ((IndexEntryObject)(object = (IndexEntryObject)this.fIndexEntryList.lastElement())).getEntryName().toLowerCase().compareTo(string4) == 0) {
                ((IndexEntryObject)object).addChild(indexEntryObject2);
                ++this.fNextID;
                return indexEntryObject2;
            }
            this.fIndexEntryList.addElement(indexEntryObject2);
            ++this.fNextID;
        } else {
            return this.insertIndexEntryObject(indexEntryObject.getChildren(), indexEntryObject2, string4);
        }
        return indexEntryObject2;
    }

    private IndexEntryObject insertIndexEntryObject(Vector vector, IndexEntryObject indexEntryObject, String string) {
        int n = -200;
        int n2 = 0;
        while (n2 < vector.size()) {
            IndexEntryObject indexEntryObject2 = (IndexEntryObject)vector.elementAt(n2);
            String string2 = indexEntryObject2.getEntryName();
            n = string2.toLowerCase().compareTo(string);
            if (n >= 0) {
                if (n == 0) {
                    boolean bl = false;
                    while (!bl && n2 + 1 < vector.size()) {
                        IndexEntryObject indexEntryObject3 = (IndexEntryObject)vector.elementAt(n2 + 1);
                        if (indexEntryObject3.getEntryName().toLowerCase().compareTo(string) == 0) {
                            indexEntryObject2 = indexEntryObject3;
                            ++n2;
                            continue;
                        }
                        bl = true;
                    }
                    if (indexEntryObject.getFileName().equals("")) {
                        return indexEntryObject2;
                    }
                    int n3 = indexEntryObject2.getDuplicateNumber();
                    if (n3 == 0) {
                        indexEntryObject2.setDuplicateNumber(1);
                        n3 = 1;
                    }
                    indexEntryObject.setDuplicateNumber(n3 + 1);
                    ++n2;
                }
                ++this.fNextID;
                vector.insertElementAt(indexEntryObject, n2);
                return indexEntryObject;
            }
            ++n2;
        }
        ++this.fNextID;
        vector.addElement(indexEntryObject);
        return indexEntryObject;
    }

    private boolean isCharALetter(String string, int n) {
        return Character.isLetter(string.toLowerCase().charAt(n));
    }

    private boolean isCharALetter(char c) {
        return Character.isLetter(c);
    }

    private void setIndexFonts() {
        this.fIndexListbox.setFont(HelpFontPrefs.getHelpNavigatorFont());
        ((Container)((Object)this)).validate();
    }

    private void sendSelectedFileToBrowser() {
        int n = this.fIndexListbox.getSelectedIndex();
        if (n != -2) {
            String string = this.fIndexListbox.getItem(n, 2);
            int n2 = 1;
            while (string.equals("") && n + n2 < this.fIndexListbox.getItemCount()) {
                string = this.fIndexListbox.getItem(n + n2++, 2);
            }
            this.fParent.getIceBrowser().setCurrentLocation(String.valueOf(this.fDocRoot) + "/" + string);
        }
    }

    private void searchTree(String string) {
        boolean bl = false;
        int n = -2;
        if (string.length() == 0) {
            n = 0;
            bl = true;
        } else {
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.fIndexListbox.getItemCount()) {
                String string2 = this.fIndexListbox.getItem(n3, 0);
                if (string2 != null && !string2.startsWith("     ") && string2.length() >= string.length()) {
                    int n4 = 0;
                    if (this.isCharALetter(this.fCurrentIndexLetter)) {
                        while (n4 < string2.length() && !this.isCharALetter(string2, n4)) {
                            ++n4;
                        }
                    }
                    if (n4 + string.length() <= string2.length() && string2.substring(n4, string.length() + n4).equalsIgnoreCase(string)) {
                        n = n3;
                        bl = true;
                        break;
                    }
                    if (string2.compareTo(string) > 0) {
                        n = n2;
                        bl = true;
                        break;
                    }
                    n2 = n3;
                }
                ++n3;
            }
        }
        if (bl && n != -2) {
            this.fSendToBrowser = false;
            this.fIndexListbox.select(n, 0);
            this.fSendToBrowser = true;
            this.fIndexListbox.setFirstRow(n);
            this.fCurrentSelectedItem = n;
        }
    }

    public void filterChanged(boolean bl) {
        this.fSearchAllProducts = bl;
        this.mergeIndexFiles(Prefs.getStringPref((String)"HelpDocRoot"), 'a', true);
    }

    private void getItemAndSendToBrowser() {
        int n = this.fIndexListbox.getFirstSelectedRow();
        if (n != -2) {
            int n2 = n;
            if (n > 0) {
                while (this.fIndexListbox.getItem(n2).startsWith("    ")) {
                    --n2;
                }
            }
            this.fSearchField.setText(this.fIndexListbox.getItem(n2));
            this.sendSelectedFileToBrowser();
            this.fCurrentSelectedItem = n2;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ boolean access$15(Index index) {
        return index.fStopRequested;
    }

    private class MergeIndexFilesThread
    extends Thread {
        private boolean fDocRootChanged;
        private char fLetter;
        private boolean fInitialMerge;

        MergeIndexFilesThread(char c, boolean bl, boolean bl2) {
            Index.this = Index.this;
            this.fLetter = c;
            this.fDocRootChanged = bl;
            this.fInitialMerge = bl2;
            Index.this.fStopRequested = false;
        }

        public void run() {
            int n;
            Index.this.fCurrentIndexLetter = this.fLetter;
            if (this.fInitialMerge) {
                Index.this.fIndexFileList.removeAllElements();
                Index.this.getIndexFilesFromMasterFile(String.valueOf(Index.this.fDocRoot) + HelpBrowser.fSeparator + "r12docindex.xml");
                File file = new File(Index.this.fDocRoot);
                String[] stringArray = file.list();
                if (stringArray != null) {
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        String string = stringArray[n2];
                        File file2 = new File(Index.this.fDocRoot, string);
                        if (string.startsWith("r12docindex") && string.endsWith(".xml") && file2.isFile() && !string.equals("r12docindex.xml")) {
                            Index.this.getIndexFilesFromMasterFile(file2.getAbsolutePath());
                        }
                        ++n2;
                    }
                }
                if (Index.this.fIndexFileList.size() == 0) {
                    Index.this.showText(HelpBrowser.sRes.getString("index.no_indexfiles"));
                    return;
                }
            }
            if ((n = Index.this.doMergeIndexFiles(this.fLetter, this.fDocRootChanged)) == 0) {
                QueueEvent.postQueueEvent((QueueEvent)new ContentsQueueEvent());
                Index.this.searchTree(Index.this.fSearchField.getText());
            }
            Index.this.fParent.loadingDataFinished();
        }
    }

    private class ContentsQueueEvent
    extends QueueEvent {
        public void dispatch() {
            if (Index.this.fCurrentIndexList == -1) {
                ((Container)((Object)Index.this)).remove((Component)Index.this.fWaitMsgLabel);
                ((Container)((Object)Index.this)).add((Component)Index.this.fIndexListbox, "Center");
            }
            Index.this.fCurrentIndexList = 0;
            Index.this.fIndexListbox.repaint();
            ((Container)((Object)Index.this)).validate();
        }

        ContentsQueueEvent() {
            Index.this = Index.this;
        }
    }

    private class IndexEntryObject {
        private String fEntryName;
        private String fProductName;
        private String fFileName;
        private int fDuplicateNumber;
        private int fListboxRow = -1;
        private String fLeadingSymbol = "";
        private IndexEntryObject fParentEntryObj;
        private Vector fChildrenList = new Vector();

        public IndexEntryObject(String string, String string2, String string3, IndexEntryObject indexEntryObject, boolean bl) {
            Index.this = Index.this;
            if (!bl && !Index.this.isCharALetter(string, 0)) {
                int n = 1;
                while (n < string.length() && !Index.this.isCharALetter(string, n)) {
                    ++n;
                }
                this.fEntryName = string.substring(n);
                this.fLeadingSymbol = string.substring(0, n);
            } else {
                this.fEntryName = string;
            }
            this.fProductName = string2;
            this.fFileName = string3;
            this.fParentEntryObj = indexEntryObject;
        }

        public void addChild(IndexEntryObject indexEntryObject) {
            this.fChildrenList.addElement(indexEntryObject);
        }

        public String getEntryName() {
            return this.fEntryName;
        }

        public String getLeadingSymbol() {
            return this.fLeadingSymbol;
        }

        public void setEntryName(String string) {
            this.fEntryName = string;
        }

        public int getDuplicateNumber() {
            return this.fDuplicateNumber;
        }

        public void setDuplicateNumber(int n) {
            this.fDuplicateNumber = n;
        }

        public int getListboxRow() {
            return this.fListboxRow;
        }

        public void setListboxRow(int n) {
            this.fListboxRow = n;
        }

        public String getFileName() {
            return this.fFileName;
        }

        public void setFileName(String string) {
            this.fFileName = string;
        }

        public String getProductName() {
            return this.fProductName;
        }

        public Vector getChildren() {
            return this.fChildrenList;
        }

        public IndexEntryObject getParentEntryObj() {
            return this.fParentEntryObj;
        }
    }

    private class HelpPrefsListener
    implements PrefListener {
        public void prefChanged(PrefEvent prefEvent) {
            if (prefEvent.getEventType() == 1) {
                String string = prefEvent.getPrefKey();
                if (string.equals("HelpNavigatorFont") || string.equals("HelpUseDesktopFont")) {
                    Index.this.setIndexFonts();
                    return;
                }
                if (string.equals("GeneralFont") && HelpFontPrefs.getUseDesktopFont()) {
                    Index.this.setIndexFonts();
                }
            }
        }

        HelpPrefsListener() {
            Index.this = Index.this;
        }
    }

    private class IndexListItemListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            if (Index.this.fSendToBrowser) {
                Index.this.getItemAndSendToBrowser();
            }
        }

        IndexListItemListener() {
            Index.this = Index.this;
        }
    }

    private class IndexListMouseListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            if (PlatformInfo.getPlatform() == 2) {
                this.doStuff(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (PlatformInfo.getPlatform() != 2) {
                this.doStuff(mouseEvent);
            }
        }

        public void doStuff(MouseEvent mouseEvent) {
            MWListbox mWListbox = (MWListbox)mouseEvent.getSource();
            if (mouseEvent.isPopupTrigger()) {
                Index.this.fIndexListPopupMenu.show((Component)mWListbox, mouseEvent.getX(), mouseEvent.getY());
                return;
            }
            Index.this.getItemAndSendToBrowser();
        }

        IndexListMouseListener() {
            Index.this = Index.this;
        }
    }

    public class IndexListPopupMenu
    extends PopupMenu {
        public IndexListPopupMenu() {
            Index.this = Index.this;
            this.add(HelpBrowser.sRes.getString("icecontainer.addtofavorites"));
            this.addActionListener(new 1(this));
        }

        static /* synthetic */ Index access$0(IndexListPopupMenu indexListPopupMenu) {
            return indexListPopupMenu.Index.this;
        }
    }

    private class IndexTextField
    extends MWTextField {
        public IndexTextField() {
            Index.this = Index.this;
            this.addKeyListener(new MyKeyListener());
            this.addActionListener(new MyActionListener());
        }

        class MyKeyListener
        extends KeyAdapter {
            public void keyReleased(KeyEvent keyEvent) {
                char c = 'a';
                if (IndexTextField.this.getText().length() > 0) {
                    c = IndexTextField.this.getText().toLowerCase().charAt(0);
                }
                if (c != Index.this.fCurrentIndexLetter) {
                    Index.this.mergeIndexFiles(HelpPrefs.getDocRoot(), c, false);
                    return;
                }
                Index.this.searchTree(IndexTextField.this.getText());
            }

            MyKeyListener() {
                IndexTextField.this = IndexTextField.this;
            }
        }

        class MyActionListener
        implements ActionListener {
            public void actionPerformed(ActionEvent actionEvent) {
                Index.this.sendSelectedFileToBrowser();
            }

            MyActionListener() {
                IndexTextField.this = IndexTextField.this;
            }
        }
    }

    private class MyCellText
    extends CellText {
        public MyCellText(Table table) {
            super(table);
            Index.this = Index.this;
        }

        public void render(Graphics graphics, int n, int n2, Rectangle rectangle, Object object, Style style, boolean bl) {
            if (n2 == 0 && object instanceof String && object != null) {
                graphics.setFont(style.getFont());
                object = MWUtils.shortenString((String)((String)object), (FontMetrics)graphics.getFontMetrics(), (int)(rectangle.width - style.getMargins().right));
            }
            super.render(graphics, n, n2, rectangle, object, style, bl);
        }
    }

    private class IndexFileObject {
        private File fIndexFile;
        private String fProdName;

        public IndexFileObject(File file, String string) {
            Index.this = Index.this;
            this.fIndexFile = file;
            this.fProdName = string;
        }

        public File getIndexFile() {
            return this.fIndexFile;
        }

        public String getProductName() {
            return this.fProdName;
        }
    }
}

