/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.help;

import com.mathworks.ide.browsers.FileView;
import com.mathworks.ide.browsers.HTMLBrowser;
import com.mathworks.ide.browsers.HTMLBrowser50;
import com.mathworks.ide.editor.EditorApplication;
import com.mathworks.ide.help.HelpBrowser;
import com.mathworks.ide.help.HelpPrefs;
import com.mathworks.ide.help.ScaryDialog;
import com.mathworks.ide.prefs.PrefsDialog;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwt.MWButton;
import com.mathworks.mwt.MWCanvas;
import com.mathworks.mwt.MWCombobox;
import com.mathworks.mwt.MWFrame;
import com.mathworks.mwt.MWLabel;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.MWRightJustifiedIcon;
import com.mathworks.mwt.MWSizeComponentToFit;
import com.mathworks.mwt.MWTextField;
import com.mathworks.mwt.MWToolbar;
import com.mathworks.mwt.command.MWCommandCenter;
import com.mathworks.mwt.dialog.MWAlert;
import com.mathworks.mwt.message.MWLooper;
import com.mathworks.mwt.window.MWWindowActivater;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.ResLoader;
import com.mathworks.util.StringUtils;
import ice.htmlbrowser.MouseOverLinkEvent;
import ice.htmlbrowser.MouseOverLinkListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.PrintJob;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.Vector;

public class ICEBrowserContainer
extends MWPanel {
    private static final String sPrefix = "file://localhost";
    private static final int sPrefixLength = "file://localhost".length();
    private MyHTMLBrowser fIceBrowser;
    private HTMLBrowser50 fIceBrowser50;
    private ResLoader resources = new ResLoader((Component)((Object)this));
    private MWCommandCenter fCenter;
    private MyCombobox fDirCombobox;
    private String fCurrentTitle;
    private String fCurrentFilename = "";
    private String fCurrentCanonicalUrl = "";
    private int fPrevSearch = -1;
    private String fPrevSearchString;
    private MWToolbar fToolbar;
    private FindTextField fSearchTextField;
    private MWPanel fFindInPagePanel;
    private HelpBrowser fParent;
    private boolean fSyncContentsTree = true;
    private boolean fUse50 = false;
    private Matlab fMatlab = new Matlab(new MWLooper("ICEBrowserContainer"));
    private MWCanvas fIceCanvas;
    private Vector fFilenameVector = new Vector();
    private Vector fBackForwardVector = new Vector();
    private int fBackForwardPointer = -1;
    private boolean fAddToBackForwardList = true;
    private boolean fIsFontSet = false;
    private SetLocationThread fSetLocationThread;
    private boolean fMatlabProtocolOK = false;
    public static final String sAddToFavorites = HelpBrowser.sRes.getString("icecontainer.addtofavorites");

    public static void main(String[] stringArray) {
        HelpBrowser helpBrowser = new HelpBrowser();
        MWFrame mWFrame = new MWFrame("MATLAB Help");
        mWFrame.add((Component)((Object)helpBrowser), "Center");
        mWFrame.setLocation(20, 40);
        mWFrame.setSize(900, 700);
        mWFrame.setVisible(true);
        mWFrame.addWindowListener((WindowListener)new MWWindowActivater((Component)mWFrame));
    }

    public ICEBrowserContainer() {
        this(null, null);
    }

    public ICEBrowserContainer(MWCommandCenter mWCommandCenter, HelpBrowser helpBrowser) {
        MWPanel mWPanel;
        this.fParent = helpBrowser;
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.fCenter = mWCommandCenter;
        if (Prefs.getIntegerPref((String)"HelpIceBrowserVersion", (int)4) == 5) {
            this.fUse50 = true;
        }
        if (this.fUse50) {
            mWPanel = new MWPanel((LayoutManager)new BorderLayout());
            this.fIceBrowser50 = new HTMLBrowser50(mWPanel, this.fCenter);
            ((Container)((Object)this)).add((Component)mWPanel, "Center");
        } else {
            this.fIceBrowser = new MyHTMLBrowser(this.fCenter);
            this.fIceBrowser.removeMouseOverLinkListener((MouseOverLinkListener)this.fIceBrowser);
            this.fIceBrowser.addMouseOverLinkListener(new MyMouseOverLinkListener());
            ((Component)((Object)this.fIceBrowser)).addMouseListener(new MyMouseListener());
            ((Container)((Object)this)).add((Component)((Object)this.fIceBrowser), "Center");
        }
        this.fIceCanvas = new MWCanvas(0, 0);
        ((Container)((Object)this)).add((Component)this.fIceCanvas, "South");
        mWPanel = new MWPanel((LayoutManager)new GridLayout(2, 1));
        ((Container)((Object)this)).add((Component)mWPanel, "North");
        mWPanel.add((Component)this.createToolbar());
        MWPanel mWPanel2 = new MWPanel();
        mWPanel.add((Component)mWPanel2);
        mWPanel2.setLayout(new BorderLayout(5, 0));
        mWPanel2.setInsets(new Insets(5, 0, 5, 0));
        String[] stringArray = new String[]{};
        this.fDirCombobox = new MyCombobox("", stringArray);
        ((Component)((Object)this.fDirCombobox)).setName("Address");
        this.fDirCombobox.setGutterWidth(5);
        this.fDirCombobox.setTextEditable(true);
        this.fDirCombobox.setRestrictWidth(false);
        this.fDirCombobox.addActionListener(new AddressActionListener());
        mWPanel2.add("Center", (Component)((Object)this.fDirCombobox));
        MyButton myButton = new MyButton(" " + sAddToFavorites + " ");
        myButton.addActionListener(new FavoritesButtonListener());
        ((Component)((Object)myButton)).setName("Add To Favorites");
        mWPanel2.add("East", (Component)((Object)myButton));
        Prefs.addListener((PrefListener)new FontChangeListener(), (String)"HelpHTML_Browser_FixedFont");
        Prefs.addListener((PrefListener)new FontChangeListener(), (String)"HelpHTML_Browser_ProportionalFont");
        Prefs.addListener((PrefListener)new AutosyncChangeListener(), (String)"HelpAutosyncContents");
    }

    private void setIceBrowserFont() {
        if (!this.fUse50) {
            this.fIceBrowser.setProportionalFont(HelpPrefs.getHtmlBrowserProportionalFont());
            this.fIceBrowser.setFixedFont(HelpPrefs.getHtmlBrowserFixedFont());
        }
    }

    public void requestFocus() {
    }

    public HTMLBrowser getHtmlBrowser() {
        return this.fIceBrowser;
    }

    public void doPrint() {
        PrintJob printJob = ((Component)((Object)this)).getToolkit().getPrintJob(this.getFrame(), "MATLAB Help Browser", null);
        this.fIceBrowser.printDoc(printJob, true);
    }

    public void viewSource() {
        String string = this.getFilenameFromURL(this.fCurrentFilename);
        if (this.fMatlab != null) {
            this.fMatlab.evalConsoleOutput("edit '" + StringUtils.quoteSingleQuotes((String)string) + "';");
            return;
        }
        EditorApplication.openDocument(string);
    }

    private String getFilenameFromURL(String string) {
        int n = (string = this.stripOffLocalhost(string)).indexOf("html#");
        if (n != -1) {
            string = string.substring(0, n + 4);
        } else {
            n = string.indexOf("htm#");
            if (n != -1) {
                string = string.substring(0, n + 3);
            }
        }
        return string;
    }

    private String getTitleFromFilename(String string) {
        int n = 0;
        while (n < this.fFilenameVector.size()) {
            FileAndTitleObject fileAndTitleObject = (FileAndTitleObject)this.fFilenameVector.elementAt(n);
            if (fileAndTitleObject.getFilename().equals(string)) {
                return fileAndTitleObject.getDisplayTitle();
            }
            ++n;
        }
        return "";
    }

    private String getFilenameFromTitle(String string) {
        int n = 0;
        while (n < this.fFilenameVector.size()) {
            FileAndTitleObject fileAndTitleObject = (FileAndTitleObject)this.fFilenameVector.elementAt(n);
            if (fileAndTitleObject.getDisplayTitle().equals(string)) {
                return fileAndTitleObject.getFilename();
            }
            ++n;
        }
        return "";
    }

    private String getCanonicalUrl(String string) {
        String string2 = new String(string);
        if (string.startsWith("file:") && string.length() > 5) {
            string = string.substring(5);
        }
        if (!(string.startsWith("http://") || string.startsWith("ftp") || string.startsWith("news") || string.startsWith(sPrefix))) {
            String string3 = "";
            if (!string.startsWith("//") && !string.startsWith("\\\\")) {
                string3 = "//";
            }
            string2 = new String(sPrefix + string3 + string);
        }
        string2 = string2.replace('\\', '/');
        return string2;
    }

    public void setCurrentLocation(String string) {
        this.setCurrentLocation(null, string, true, true, false, null, null, null);
    }

    public void setCurrentLocationAndHighlightString(String string, String string2) {
        this.setCurrentLocation(null, string, true, true, false, string2, null, null);
    }

    public void setCurrentLocation(String string, String string2) {
        this.setCurrentLocation(string, string2, true, true, false, null, null, null);
    }

    public void setCurrentLocation(boolean bl, String string, String string2) {
        this.setCurrentLocation(string, string2, true, true, bl, null, null, null);
    }

    public void setCurrentLocation(String string, boolean bl) {
        this.setCurrentLocation(null, string, bl, true, false, null, null, null);
    }

    public void setCurrentLocation(String string, String string2, boolean bl) {
        this.setCurrentLocation(string, string2, bl, true, false, null, null, null);
    }

    public void setHtmlText(String string, String string2, String string3) {
        this.fIceBrowser.htmlClear();
        this.fIceBrowser.htmlAppend(string2);
        this.fCurrentCanonicalUrl = string3;
        this.fCurrentFilename = string3;
        this.fCurrentTitle = string;
        this.setCombobox(string, string3);
        this.fPrevSearch = -1;
        this.fCenter.setCommandEnabled(2250, false);
        if (!this.fUse50) {
            this.fIceBrowser.enableDisableEvents();
        }
    }

    public void setCurrentLocation(String string, String string2, boolean bl, boolean bl2, boolean bl3, String string3, String string4, String string5) {
        if (string2 == null || string2.equals("")) {
            return;
        }
        String string6 = new String(string2);
        string6 = string6.replace('\\', '/');
        if ((string2 = this.getCanonicalUrl(string2)).equals(this.fCurrentCanonicalUrl)) {
            if (bl) {
                this.syncContentsTree(string6, bl3);
            }
            return;
        }
        if (this.fSetLocationThread != null && this.fSetLocationThread.isAlive()) {
            try {
                this.fSetLocationThread.stop();
                this.fSetLocationThread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.fSetLocationThread = new SetLocationThread(string, string2, string6, bl, bl2, bl3, string3, string4, string5);
        this.fSetLocationThread.start();
    }

    private void showLinkErrPage(String string) {
        BufferedReader bufferedReader = null;
        FileReader fileReader = null;
        String string2 = null;
        String string3 = String.valueOf(HelpBrowser.sRes.getString("icecontainer.link_not_found")) + string;
        try {
            fileReader = new FileReader(StringUtils.fromJavaPath((String)(String.valueOf(Matlab.matlabRoot()) + "/toolbox/local/linkerr.html")));
            bufferedReader = new BufferedReader(fileReader);
        }
        catch (FileNotFoundException fileNotFoundException) {}
        if (bufferedReader != null) {
            try {
                string3 = "";
                while ((string2 = bufferedReader.readLine()) != null) {
                    string3 = String.valueOf(string3) + string2;
                }
                bufferedReader.close();
                String string4 = "==BROKEN_URL===";
                int n = string3.indexOf(string4);
                if (n != -1) {
                    string3 = String.valueOf(string3.substring(0, n)) + string + string3.substring(n + string4.length());
                }
            }
            catch (IOException iOException) {}
        }
        this.setHtmlText(String.valueOf(HelpBrowser.sRes.getString("icecontainer.link_not_found")) + string, string3, "linkerr:" + string);
    }

    private String getCurrentPageTitle(String string) {
        BufferedReader bufferedReader = new BufferedReader(this.fIceBrowser.getHTMLSource());
        if (bufferedReader != null) {
            return this.getPageTitle(bufferedReader, string);
        }
        return string;
    }

    public String getPageTitle(String string) {
        block3: {
            File file = new File(string = this.getFilenameFromURL(string));
            if (!file.exists()) break block3;
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                if (bufferedReader != null) {
                    return this.getPageTitle(bufferedReader, string);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        return string;
    }

    private String getPageTitle(BufferedReader bufferedReader, String string) {
        String string2;
        String string3;
        String string4;
        String string5;
        block10: {
            if (string.startsWith("file:") && string.length() > 5) {
                string = string.substring(5);
            }
            string5 = string;
            string4 = "";
            string3 = "";
            string2 = "";
            if (bufferedReader != null) {
                String string6 = null;
                try {
                    while ((string6 = bufferedReader.readLine()) != null) {
                        int n;
                        if ((string6 = string6.trim()).toLowerCase().startsWith("<title>")) {
                            n = string6.toLowerCase().indexOf("</title>");
                            if (n == -1) break;
                            string5 = string6.substring(7, n);
                            break;
                        }
                        if (string6.startsWith("<!-- DOCNAME:")) {
                            n = string6.indexOf("-->");
                            string4 = string6.substring(13, n).trim();
                            continue;
                        }
                        if (string6.startsWith("<!-- CHUNKNAME:")) {
                            n = string6.indexOf("-->");
                            string2 = string6.substring(15, n).trim();
                            continue;
                        }
                        if (!string6.startsWith("<!-- CHAPNAME:")) continue;
                        n = string6.indexOf("-->");
                        string3 = string6.substring(14, n).trim();
                        break;
                    }
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    if (!(exception instanceof IOException) && !(exception instanceof NullPointerException)) break block10;
                    return string5;
                }
            }
        }
        if (!string4.equals("")) {
            string2 = string2.equals(string3) || string2.equals("") ? "" : ": " + string2;
            string3 = string3.equals(string4) || string3.equals("") ? "" : ": " + string3;
            return String.valueOf(string4) + string3 + string2;
        }
        if (string5.trim().equals("")) {
            string5 = string;
        }
        return string5;
    }

    private void syncContentsTree(String string, boolean bl) {
        if (!this.fSyncContentsTree || string.equals("")) {
            return;
        }
        this.fParent.getContentsTree().syncContentsTree(string, bl);
    }

    public String getCurrentLocation() {
        if (this.fUse50) {
            return this.fIceBrowser50.getCurrentLocation();
        }
        return this.fIceBrowser.getCurrentLocation();
    }

    public String getCurrentFilename() {
        return this.stripOffLocalhost(this.getCurrentLocation());
    }

    private void setCombobox(String string) {
        this.setCombobox(string, string);
    }

    private void setCombobox(String string, String string2) {
        this.fCurrentTitle = string;
        this.fCurrentFilename = string2;
        this.fDirCombobox.setText(string);
        if (this.fDirCombobox.contains(string)) {
            this.fDirCombobox.removeItem(string);
        } else {
            this.fFilenameVector.addElement(new FileAndTitleObject(string, this.stripOffLocalhost(string2)));
        }
        String[] stringArray = this.fDirCombobox.getItems();
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = string;
        int n = 0;
        while (n < stringArray.length) {
            stringArray2[n + 1] = stringArray[n];
            ++n;
        }
        this.fDirCombobox.setItems(stringArray2);
        if (this.fAddToBackForwardList) {
            if (this.fBackForwardPointer < this.fBackForwardVector.size() - 1) {
                int n2 = this.fBackForwardVector.size() - 1;
                while (n2 > this.fBackForwardPointer) {
                    this.fBackForwardVector.removeElementAt(n2);
                    --n2;
                }
            }
            this.fBackForwardVector.addElement(string2);
            this.fBackForwardPointer = this.fBackForwardVector.size() - 1;
        } else {
            this.fAddToBackForwardList = true;
        }
        if (this.fUse50) {
            this.fCenter.setCommandEnabled(1, this.fIceBrowser50.getBackHistory().size() != 0);
            this.fCenter.setCommandEnabled(2, this.fIceBrowser50.getForwardHistory().size() != 0);
            return;
        }
        this.fCenter.setCommandEnabled(1, this.fBackForwardPointer > 0);
        this.fCenter.setCommandEnabled(2, this.fBackForwardPointer < this.fBackForwardVector.size() - 1);
    }

    private MWToolbar createToolbar() {
        if (PlatformInfo.getAppearance() == 1) {
            String string = "_win.gif";
        } else {
            String string = ".gif";
        }
        if (this.fToolbar == null) {
            this.fToolbar = new MWToolbar();
        }
        if (!this.fParent.isNavigatorShowing()) {
            this.fToolbar.addImageButton("/com/mathworks/ide/help/resources/shownav.gif", 2246, HelpBrowser.sRes.getString("icecontainer.shownavigator"), this.fCenter);
            this.fToolbar.addSpacer();
        }
        this.fToolbar.addImageButton("/com/mathworks/ide/help/resources/backarrow.gif", 1, HelpBrowser.sRes.getString("icecontainer.back"), this.fCenter);
        this.fToolbar.addImageButton("/com/mathworks/ide/help/resources/forwardarrow.gif", 2, HelpBrowser.sRes.getString("icecontainer.forward"), this.fCenter);
        this.fToolbar.addImageButton("/com/mathworks/ide/help/resources/reload.gif", 3, HelpBrowser.sRes.getString("icecontainer.reload"), this.fCenter);
        this.fToolbar.addSpacer();
        this.fToolbar.addImageButton("/com/mathworks/mwt/resources/print.gif", 550, HelpBrowser.sRes.getString("icecontainer.printpage"), this.fCenter);
        this.fToolbar.addSpacer();
        MWLabel mWLabel = new MWLabel(String.valueOf(HelpBrowser.sRes.getString("icecontainer.find_in_page")) + " ");
        mWLabel.setFont(new Font("SanSerif", 0, 11));
        this.fToolbar.addComponent((Component)mWLabel);
        if (this.fFindInPagePanel == null) {
            this.fFindInPagePanel = new FindInPagePanel();
        }
        this.fToolbar.addComponent((Component)this.fFindInPagePanel);
        return this.fToolbar;
    }

    public void removeShowNavigatorToolbarIcon() {
        this.fToolbar.removeAll();
        this.createToolbar();
    }

    public void addShowNavigatorToolbarIcon() {
        this.fToolbar.removeAll();
        this.createToolbar();
    }

    public ICEBrowserContainer getIceBrowser() {
        return this;
    }

    public void doCopy() {
        if (this.fUse50) {
            this.fIceBrowser50.doCopy();
            return;
        }
        this.fIceBrowser.doCopy();
    }

    public void doEvalSelection() {
        if (this.fUse50) {
            this.fIceBrowser50.doEvalSelection();
            return;
        }
        this.fIceBrowser.doEvalSelection();
    }

    public void doOpenSelection() {
        this.fIceBrowser.doOpenSelection();
    }

    public void doHelpOnSelection() {
        this.fIceBrowser.doHelpOnSelection();
    }

    public void goBack() {
        String string;
        if (this.fUse50) {
            this.fIceBrowser50.goBack();
            string = this.fIceBrowser50.getCurrentLocation();
        } else if (this.fBackForwardPointer > 0) {
            string = (String)this.fBackForwardVector.elementAt(--this.fBackForwardPointer);
        } else {
            this.fCenter.setCommandEnabled(1, false);
            return;
        }
        this.fAddToBackForwardList = false;
        if (string.startsWith("matlab:")) {
            this.evalCommandInMatlab(string.substring(7));
            return;
        }
        if (string.startsWith("linkerr:")) {
            this.showLinkErrPage(string.substring(8));
            return;
        }
        this.setCurrentLocation(null, this.stripOffLocalhost(string), true, true, false, null, null, null);
    }

    public void goForward() {
        String string;
        if (this.fUse50) {
            this.fIceBrowser50.goForward();
            string = this.fIceBrowser50.getCurrentLocation();
        } else if (this.fBackForwardPointer < this.fBackForwardVector.size()) {
            string = (String)this.fBackForwardVector.elementAt(++this.fBackForwardPointer);
        } else {
            this.fCenter.setCommandEnabled(2, false);
            return;
        }
        this.fAddToBackForwardList = false;
        if (string.startsWith("matlab:")) {
            this.evalCommandInMatlab(string.substring(7));
            return;
        }
        if (string.startsWith("linkerr:")) {
            this.showLinkErrPage(string.substring(8));
            return;
        }
        this.setCurrentLocation(null, this.stripOffLocalhost(string), true, true, false, null, null, null);
    }

    public void reload() {
        if (this.fUse50) {
            this.fIceBrowser50.reload();
            return;
        }
        if (this.fCurrentFilename.startsWith("matlab:")) {
            this.evalCommandInMatlab(this.fCurrentFilename.substring(7));
            return;
        }
        if (this.fCurrentFilename.startsWith("linkerr:")) {
            this.showLinkErrPage(this.fCurrentFilename.substring(8));
            return;
        }
        this.fIceBrowser.reload();
    }

    private String stripOffLocalhost(String string) {
        String string2 = string;
        if (PlatformInfo.isUnix() && string2.startsWith("file://localhost//") && string2.length() > 18) {
            string2 = string2.substring(18);
        }
        if (string2.startsWith("file://localhost////") && string2.length() > 18) {
            string2 = string2.substring(18);
        } else if (string2.startsWith(sPrefix) && string2.length() > 16) {
            string2 = string2.substring(16);
        } else if (string2.startsWith("file:////") && string2.length() > 7) {
            string2 = string2.substring(7);
        } else if (string2.startsWith("file:") && string2.length() > 5) {
            string2 = string2.substring(5);
        }
        if (PlatformInfo.isWindows() && string2.startsWith("//") && string2.length() > 2 && string2.charAt(2) != '/') {
            if (string2.charAt(3) == '/') {
                string2 = String.valueOf(string2.substring(0, 3)) + ":" + string2.substring(3);
            }
            if (string2.charAt(3) == ':') {
                string2 = string2.substring(2);
            }
        }
        return string2;
    }

    public void doFind(String string, boolean bl) {
        if (!string.equals(this.fPrevSearchString)) {
            this.fPrevSearch = -1;
        }
        this.fPrevSearch = this.fUse50 ? this.fIceBrowser50.search(this.fPrevSearch, string, true) : this.fIceBrowser.search(this.fPrevSearch, string, true);
        if (this.fPrevSearch == -1 && bl) {
            Object[] objectArray = new Object[]{string};
            String string2 = HelpBrowser.getMessage(objectArray, HelpBrowser.sRes.getString("alert.searchstring_not_found"));
            new MWAlert(this.getFrame(), HelpBrowser.sHelpBrowserName, string2, 1);
        }
        this.fPrevSearchString = string;
    }

    void evalCommandInMatlab(String string) {
        int n = string.indexOf(63);
        if (n != -1) {
            String string2 = "global QUERY_STRING; QUERY_STRING='";
            string2 = String.valueOf(string2) + string.substring(n + 1) + "'; ";
            string = String.valueOf(string2) + string.substring(0, n) + "; clear QUERY_STRING;";
        }
        string = string.replace('`', '\'');
        this.fMatlab.evalConsoleOutput(string);
    }

    static /* synthetic */ int access$18(ICEBrowserContainer iCEBrowserContainer) {
        return iCEBrowserContainer.fPrevSearch;
    }

    private class MyButton
    extends MWButton {
        public MyButton(String string) {
            super(string);
            ICEBrowserContainer.this = ICEBrowserContainer.this;
        }

        public Dimension getPreferredSize() {
            Dimension dimension = this.getMinimumSize();
            dimension.height = ((ICEBrowserContainer)ICEBrowserContainer.this).fDirCombobox.getPreferredSize().height;
            return dimension;
        }
    }

    private class MyMouseListener
    implements MouseListener {
        public void mousePressed(MouseEvent mouseEvent) {
            ICEBrowserContainer.this.fIceCanvas.processMouseEvent(mouseEvent);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        MyMouseListener() {
            ICEBrowserContainer.this = ICEBrowserContainer.this;
        }
    }

    private class FontChangeListener
    implements PrefListener {
        public void prefChanged(PrefEvent prefEvent) {
            if (prefEvent.getEventType() == 1 && !ICEBrowserContainer.this.fUse50) {
                if (prefEvent.getPrefKey().equals("HelpHTML_Browser_FixedFont")) {
                    ICEBrowserContainer.this.fIceBrowser.setFixedFont(Prefs.getFontPref((String)"HelpHTML_Browser_FixedFont"));
                    return;
                }
                if (prefEvent.getPrefKey().equals("HelpHTML_Browser_ProportionalFont")) {
                    ICEBrowserContainer.this.fIceBrowser.setProportionalFont(Prefs.getFontPref((String)"HelpHTML_Browser_ProportionalFont"));
                }
            }
        }

        FontChangeListener() {
            ICEBrowserContainer.this = ICEBrowserContainer.this;
        }
    }

    private class AutosyncChangeListener
    implements PrefListener {
        public void prefChanged(PrefEvent prefEvent) {
            if (prefEvent.getEventType() == 1 && prefEvent.getPrefKey().equals("HelpAutosyncContents") && Prefs.getBooleanPref((String)"HelpAutosyncContents")) {
                ICEBrowserContainer.this.setCurrentLocation(ICEBrowserContainer.this.stripOffLocalhost(ICEBrowserContainer.this.getCurrentLocation()));
            }
        }

        AutosyncChangeListener() {
            ICEBrowserContainer.this = ICEBrowserContainer.this;
        }
    }

    private class SetLocationThread
    extends Thread {
        private String displayTitle;
        private String url;
        private String origUrl;
        private boolean syncContentsTree;
        private boolean goThere;
        private boolean expandSelectedItem;
        private String findString;
        private String targetFrame;
        private String outputString;

        SetLocationThread(String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3, String string4, String string5, String string6) {
            ICEBrowserContainer.this = ICEBrowserContainer.this;
            this.displayTitle = string;
            this.url = string2;
            this.origUrl = string3;
            this.syncContentsTree = bl;
            this.goThere = bl2;
            this.expandSelectedItem = bl3;
            this.findString = string4;
            this.targetFrame = string5;
            this.outputString = string6;
        }

        public void run() {
            if (this.goThere) {
                boolean bl;
                String string;
                block19: {
                    string = ICEBrowserContainer.this.getFilenameFromURL(this.url);
                    bl = false;
                    try {
                        URL uRL;
                        Object object;
                        if (string.startsWith("news:")) {
                            new MWAlert(ICEBrowserContainer.this.getFrame(), HelpBrowser.sRes.getString("hb.helpbrowser"), HelpBrowser.sRes.getString("alert.news_not_supported"), 1);
                            return;
                        }
                        File file = new File(string);
                        if (!(file.exists() || string.startsWith("http:") || string.startsWith("ftp:") || string.startsWith("file:") || string.startsWith("news:"))) {
                            this.url = "http:" + string;
                        }
                        if ((object = (uRL = new URL(this.url)).openConnection().getContent()) == null) {
                            bl = true;
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        bl = true;
                    }
                    catch (IOException iOException) {
                        if (iOException instanceof UnknownServiceException && (this.url.endsWith(".pl") || this.url.endsWith(".plx"))) break block19;
                        bl = true;
                    }
                }
                if (bl) {
                    ICEBrowserContainer.this.showLinkErrPage(string);
                    return;
                }
                ICEBrowserContainer.this.fCurrentCanonicalUrl = this.url;
                if (ICEBrowserContainer.this.fUse50) {
                    ICEBrowserContainer.this.fIceBrowser50.gotoLocation(this.url);
                } else {
                    if (this.targetFrame == null) {
                        ICEBrowserContainer.this.fIceBrowser.gotoLocation(this.url);
                    } else {
                        ICEBrowserContainer.this.fIceBrowser.gotoLocation(this.url, this.targetFrame, this.outputString);
                    }
                    if (ICEBrowserContainer.this.fCurrentFilename.startsWith("matlab:") || ICEBrowserContainer.this.fCurrentFilename.startsWith("linkerr:")) {
                        ICEBrowserContainer.this.fIceBrowser.reload();
                    }
                }
                if (!ICEBrowserContainer.this.fIsFontSet) {
                    ICEBrowserContainer.this.setIceBrowserFont();
                    ICEBrowserContainer.this.fIsFontSet = true;
                }
            }
            ICEBrowserContainer.this.fCenter.setCommandEnabled(2250, this.url.startsWith(sPrefix));
            this.url = ICEBrowserContainer.this.fUse50 ? ICEBrowserContainer.this.fIceBrowser50.getCurrentLocation() : ICEBrowserContainer.this.fIceBrowser.getCurrentLocation();
            ICEBrowserContainer.this.fCurrentFilename = this.url;
            if (this.displayTitle == null) {
                this.displayTitle = ICEBrowserContainer.this.getCurrentPageTitle(this.origUrl);
            }
            if (this.origUrl.equals(this.displayTitle)) {
                this.displayTitle = ICEBrowserContainer.this.stripOffLocalhost(this.url);
            }
            ICEBrowserContainer.this.setCombobox(this.displayTitle, this.url);
            ICEBrowserContainer.this.fPrevSearch = -1;
            if (this.findString != null && PlatformInfo.isWindows()) {
                ICEBrowserContainer.this.fIceBrowser.htmlWait(true);
                ICEBrowserContainer.this.doFind(this.findString, false);
            }
            if (this.syncContentsTree) {
                ICEBrowserContainer.this.syncContentsTree(this.origUrl, this.expandSelectedItem);
            }
            if (!ICEBrowserContainer.this.fUse50) {
                ICEBrowserContainer.this.fIceBrowser.enableDisableEvents();
            }
        }
    }

    private class MyHTMLBrowser
    extends HTMLBrowser {
        MWCommandCenter fCenter;

        public MyHTMLBrowser(MWCommandCenter mWCommandCenter) {
            super(mWCommandCenter);
            ICEBrowserContainer.this = ICEBrowserContainer.this;
            this.fCenter = mWCommandCenter;
        }

        public void enableDisableEvents() {
            this.fCenter.setCommandEnabled(1, ICEBrowserContainer.this.fBackForwardPointer > 0);
            this.fCenter.setCommandEnabled(2, ICEBrowserContainer.this.fBackForwardPointer < ICEBrowserContainer.this.fBackForwardVector.size() - 1);
            boolean bl = !this.getSelectedText(false).equals("");
            this.fCenter.setCommandEnabled(4, bl && Matlab.isMatlabAvailable());
            this.fCenter.setCommandEnabled(5, bl && Matlab.isMatlabAvailable());
            this.fCenter.setCommandEnabled(6, bl && Matlab.isMatlabAvailable());
            this.fCenter.setCommandEnabled(910, bl);
        }
    }

    private class FindInPagePanel
    extends MWPanel
    implements MWSizeComponentToFit {
        public FindInPagePanel() {
            ICEBrowserContainer.this = ICEBrowserContainer.this;
            ICEBrowserContainer iCEBrowserContainer2 = ICEBrowserContainer.this;
            ((Object)((Object)iCEBrowserContainer2)).getClass();
            ICEBrowserContainer.this.fSearchTextField = iCEBrowserContainer2.new FindTextField(15);
            ((Component)((Object)ICEBrowserContainer.this.fSearchTextField)).setName("Find in Page");
            ICEBrowserContainer iCEBrowserContainer3 = ICEBrowserContainer.this;
            ((Object)((Object)iCEBrowserContainer3)).getClass();
            MyButton myButton = iCEBrowserContainer3.new MyButton(" " + HelpBrowser.sRes.getString("search.go") + " ");
            SearchActionListener searchActionListener = new SearchActionListener();
            ICEBrowserContainer.this.fSearchTextField.addActionListener(searchActionListener);
            myButton.addActionListener(searchActionListener);
            ((Container)((Object)this)).setLayout(new BorderLayout(5, 5));
            ((Container)((Object)this)).add((Component)((Object)ICEBrowserContainer.this.fSearchTextField), "Center");
            ((Container)((Object)this)).add((Component)((Object)myButton), "East");
        }
    }

    private class FindTextField
    extends MWTextField
    implements MWSizeComponentToFit {
        public FindTextField(int n) {
            super(n);
            ICEBrowserContainer.this = ICEBrowserContainer.this;
        }
    }

    private class SearchActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ICEBrowserContainer.this.doFind(ICEBrowserContainer.this.fSearchTextField.getText(), true);
        }

        SearchActionListener() {
            ICEBrowserContainer.this = ICEBrowserContainer.this;
        }
    }

    private class AddressActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MWCombobox mWCombobox = (MWCombobox)actionEvent.getSource();
            String string = mWCombobox.getText();
            if (string.equals("")) {
                mWCombobox.setText(ICEBrowserContainer.this.fCurrentTitle);
                return;
            }
            String string2 = ICEBrowserContainer.this.getFilenameFromTitle(string);
            if (string2.equals("")) {
                string2 = new String(string);
                string = null;
            }
            if (string2.startsWith("matlab:")) {
                ICEBrowserContainer.this.evalCommandInMatlab(string2.substring(7));
                return;
            }
            if (string2.startsWith("linkerr:")) {
                ICEBrowserContainer.this.showLinkErrPage(string2.substring(8));
                return;
            }
            ICEBrowserContainer.this.setCurrentLocation(string, string2);
        }

        AddressActionListener() {
            ICEBrowserContainer.this = ICEBrowserContainer.this;
        }
    }

    private class MyMouseOverLinkListener
    implements MouseOverLinkListener {
        public void mouseOverLinkEntered(MouseOverLinkEvent mouseOverLinkEvent) {
            if (ICEBrowserContainer.this.fParent != null) {
                ICEBrowserContainer.this.fParent.setStatusText(ICEBrowserContainer.this.stripOffLocalhost(mouseOverLinkEvent.getLink()));
            }
        }

        public void mouseOverLinkExited(MouseOverLinkEvent mouseOverLinkEvent) {
            ICEBrowserContainer.this.fParent.setStatusTextToDefault();
        }

        public void mouseOverLinkMoved(MouseOverLinkEvent mouseOverLinkEvent) {
        }

        public void mouseOverLinkClicked(MouseOverLinkEvent mouseOverLinkEvent) {
            String string = mouseOverLinkEvent.getLink();
            if (string.endsWith(".pdf")) {
                if (ICEBrowserContainer.this.fMatlab != null && Matlab.isMatlabAvailable()) {
                    Matlab.whenMatlabReady((Runnable)new OpenPDFFile(string));
                    return;
                }
            } else if (string.startsWith("matlab:") && string.length() > 7) {
                if (ICEBrowserContainer.this.fMatlab != null) {
                    if (!(ICEBrowserContainer.this.fCurrentCanonicalUrl.startsWith("file:") || ICEBrowserContainer.this.fCurrentCanonicalUrl.startsWith("matlab:") || ICEBrowserContainer.this.fCurrentCanonicalUrl.startsWith("linkerr:") || ICEBrowserContainer.this.fMatlabProtocolOK)) {
                        ScaryDialog scaryDialog = new ScaryDialog(ICEBrowserContainer.this.getFrame(), HelpBrowser.sRes.getString("alert.security_warning_title"), HelpBrowser.sRes.getString("alert.security_warning"));
                        int n = scaryDialog.getReply();
                        if (n == 4) {
                            return;
                        }
                        ICEBrowserContainer.this.fMatlabProtocolOK = true;
                    }
                    ICEBrowserContainer.this.evalCommandInMatlab(string.substring(7));
                    return;
                }
            } else {
                if (string.startsWith("http://www.mathworks.com/search97cgi/s97_cgi??")) {
                    int n = string.indexOf(63);
                    if (string.length() > n + 1) {
                        string = String.valueOf(string.substring(0, n)) + string.substring(n + 1);
                    }
                    ICEBrowserContainer.this.setCurrentLocation(string);
                    return;
                }
                string = ICEBrowserContainer.this.stripOffLocalhost(string);
                if (ICEBrowserContainer.this.fCurrentFilename.startsWith("matlab:")) {
                    ICEBrowserContainer.this.setCurrentLocation(string);
                    return;
                }
                ICEBrowserContainer.this.setCurrentLocation(null, string, true, true, false, null, mouseOverLinkEvent.getTargetFrame(), mouseOverLinkEvent.getOutputString());
            }
        }

        MyMouseOverLinkListener() {
            ICEBrowserContainer.this = ICEBrowserContainer.this;
        }
    }

    private class OpenPDFFile
    implements Runnable {
        private String fLocation;

        public OpenPDFFile(String string) {
            ICEBrowserContainer.this = ICEBrowserContainer.this;
            this.fLocation = string;
        }

        private void startPdfReader(String string, String string2, boolean bl) {
            if (bl) {
                String string3 = ICEBrowserContainer.this.stripOffLocalhost(string2);
                File file = new File(string3);
                boolean bl2 = true;
                if (string3.startsWith("http:") && ICEBrowserContainer.this.fMatlab != null) {
                    ICEBrowserContainer.this.fMatlab.feval("tempname", null, (CompletionObserver)new OpenPdfFileFromWebserver(string, string3));
                    return;
                }
                if (!file.exists() && PlatformInfo.isWindows()) {
                    String string4;
                    String string5 = HelpPrefs.getDocRoot();
                    if (!string5.startsWith(string4 = HelpPrefs.getCDRomPath())) {
                        string3 = StringUtils.fromJavaPath((String)(String.valueOf(string4) + string3.substring(string5.length())));
                        file = new File(string3);
                        boolean bl3 = true;
                        while (!file.exists() && bl3) {
                            MWAlert mWAlert;
                            int n;
                            MWFrame mWFrame = (MWFrame)ICEBrowserContainer.this.getFrame();
                            if (mWFrame == null || (n = (mWAlert = new MWAlert((Frame)mWFrame, HelpBrowser.sHelpBrowserName, HelpBrowser.sRes.getString("alert.pdffile_not_found_message"), 2)).getReply()) != 4) continue;
                            bl3 = false;
                            bl2 = false;
                        }
                    } else {
                        bl2 = false;
                    }
                }
                if (bl2) {
                    ((Component)((Object)ICEBrowserContainer.this)).setCursor(Cursor.getPredefinedCursor(3));
                    ICEBrowserContainer.this.fMatlab.evalConsoleOutput("!\"" + string + "\" \"" + string3 + "\" &", (CompletionObserver)new PDFCompletionObserver());
                    return;
                }
            } else {
                Object[] objectArray = new Object[]{string};
                String string6 = HelpBrowser.getMessage(objectArray, HelpBrowser.sRes.getString("alert.pdfreader_not_found"));
                MWAlert mWAlert = new MWAlert(ICEBrowserContainer.this.getFrame(), HelpBrowser.sHelpBrowserName, string6, 9);
                int n = mWAlert.getReply();
                if (n == 3) {
                    PrefsDialog.showPrefsDialog("Help");
                    return;
                }
            }
        }

        public void run() {
            String string = HelpPrefs.getPdfReader();
            boolean bl = true;
            this.fLocation = ICEBrowserContainer.this.stripOffLocalhost(this.fLocation);
            if (PlatformInfo.isWindows()) {
                File file = new File(string);
                bl = file.exists();
                this.startPdfReader(string, this.fLocation, bl);
                return;
            }
            try {
                Object[] objectArray = new Object[]{"which " + string};
                Object[] objectArray2 = (Object[])Matlab.mtFeval((String)"unix", (Object[])objectArray, (int)2);
                String string2 = (String)objectArray2[1];
                if (string2.indexOf("Command not found.") != -1) {
                    bl = false;
                }
                this.startPdfReader(string, this.fLocation, bl);
                return;
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                return;
            }
        }

        private class OpenPdfFileFromWebserver
        implements CompletionObserver {
            private String fFilename;
            private String fPdfReader;

            public OpenPdfFileFromWebserver(String string, String string2) {
                OpenPDFFile.this = OpenPDFFile.this;
                this.fFilename = string2;
                this.fPdfReader = string;
            }

            public void completed(int n, Object object) {
                String string = (String)object;
                if (string != null) {
                    String string2 = string.trim();
                    String string3 = String.valueOf(string2) + ".pdf";
                    File file = new File(string3);
                    URL uRL = null;
                    try {
                        uRL = new URL(this.fFilename);
                    }
                    catch (MalformedURLException malformedURLException) {
                        new MWAlert(ICEBrowserContainer.this.getFrame(), HelpBrowser.sHelpBrowserName, HelpBrowser.sRes.getString("alert.error_with_pdf_file"), 1);
                        return;
                    }
                    try {
                        InputStream inputStream = uRL.openStream();
                        FileOutputStream fileOutputStream = new FileOutputStream(file);
                        FileView.StreamCopier.copy(inputStream, fileOutputStream);
                        inputStream.close();
                        ((OutputStream)fileOutputStream).close();
                        ((Component)((Object)ICEBrowserContainer.this)).setCursor(Cursor.getPredefinedCursor(3));
                        ICEBrowserContainer.this.fMatlab.evalConsoleOutput("!\"" + this.fPdfReader + "\" \"" + string3 + "\" &", (CompletionObserver)new PDFCompletionObserver());
                        return;
                    }
                    catch (IOException iOException) {
                        new MWAlert(ICEBrowserContainer.this.getFrame(), HelpBrowser.sHelpBrowserName, HelpBrowser.sRes.getString("alert.error_with_pdf_file"), 1);
                        return;
                    }
                }
            }
        }
    }

    private class PDFCompletionObserver
    implements CompletionObserver {
        public PDFCompletionObserver() {
            ICEBrowserContainer.this = ICEBrowserContainer.this;
        }

        public void completed(int n, Object object) {
            ((Component)((Object)ICEBrowserContainer.this)).setCursor(Cursor.getDefaultCursor());
        }
    }

    private class FavoritesButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            HelpBrowser.addEntryToFavorites(ICEBrowserContainer.this.fCurrentTitle, ICEBrowserContainer.this.stripOffLocalhost(ICEBrowserContainer.this.fCurrentFilename));
        }

        FavoritesButtonListener() {
            ICEBrowserContainer.this = ICEBrowserContainer.this;
        }
    }

    private class MyCombobox
    extends MWCombobox {
        MyCombobox(String string, String[] stringArray) {
            super(string, stringArray);
            ICEBrowserContainer.this = ICEBrowserContainer.this;
        }

        public void setText(String string) {
            super.setText(string);
            this.getTextField().setSel(0, 0);
        }
    }

    private class FileAndTitleObject {
        private String fDisplayTitle;
        private String fFilename;

        FileAndTitleObject(String string, String string2) {
            ICEBrowserContainer.this = ICEBrowserContainer.this;
            this.fDisplayTitle = string;
            this.fFilename = string2;
        }

        private String getDisplayTitle() {
            return this.fDisplayTitle;
        }

        private String getFilename() {
            return this.fFilename;
        }
    }

    private class TipsButton
    extends MWButton
    implements MWRightJustifiedIcon {
        TipsButton(Image image, String string) {
            super(image, string);
            ICEBrowserContainer.this = ICEBrowserContainer.this;
        }
    }
}

