/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.help;

import com.mathworks.ide.editor.VertFlowLayout;
import com.mathworks.ide.help.HelpBrowser;
import com.mathworks.ide.help.HelpProductList;
import com.mathworks.ide.help.ProductFilterPanel;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwt.MWButton;
import com.mathworks.mwt.MWCheckbox;
import com.mathworks.mwt.MWCombobox;
import com.mathworks.mwt.MWComponent;
import com.mathworks.mwt.MWExclusiveGroup;
import com.mathworks.mwt.MWExclusiveGroupItem;
import com.mathworks.mwt.MWGroupbox;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.MWTextField;
import com.mathworks.mwt.MWToolTip;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import com.mathworks.util.NativeJava;
import com.mathworks.util.PlatformInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Vector;

public class HelpPrefs
extends MWPanel {
    private static HelpPrefs sPrefsPanel = null;
    private MWExclusiveGroup fDocSourceGroup = new MWExclusiveGroup();
    private MWCombobox fLocalCombobox;
    private MWCombobox fCdromCombobox;
    private MWCombobox fWebCombobox;
    private MWCheckbox fLocalCheckbox;
    private MWCheckbox fCdromCheckbox;
    private MWCheckbox fWebCheckbox;
    private MWCheckbox fAutosyncCheckbox;
    private MWTextField fPdfInputField;
    private MyDirBrowseButton fDirBrowseButton;
    private MyDirBrowseButton fCdromBrowseButton;
    private ProductFilterPanel fProductFilterPanel;
    private boolean fResult;
    private String fCurrentLocalDir;
    private String fCurrentCdromDir;
    private String fCurrentWebDir;
    private String fCurrentDocRoot;
    private String fCurrentDocRootInDialog;
    private boolean fCurrentAutosyncPref;
    private static String[] sSelectedProducts = HelpPrefs.getDirectoryPrefs(Prefs.getStringPref((String)"HelpSelectedProducts", (String)"MATLAB"));

    private HelpPrefs() {
        CheckboxItemListener checkboxItemListener = new CheckboxItemListener();
        DirectoryActionListener directoryActionListener = new DirectoryActionListener();
        this.fLocalCheckbox = new MWCheckbox(HelpBrowser.sRes.getString("prefs.docroot1"), true, this.fDocSourceGroup);
        this.fLocalCheckbox.setBehavior(1);
        this.fLocalCheckbox.addItemListener((ItemListener)checkboxItemListener);
        String string = String.valueOf(Matlab.matlabRoot()) + HelpBrowser.fSeparator + "help";
        String[] stringArray = HelpPrefs.getDirectoryPrefs(Prefs.getStringPref((String)"HelpLocalDirectory", (String)string));
        String string2 = stringArray[0];
        this.fLocalCombobox = new MWCombobox(string2, stringArray);
        this.fLocalCombobox.setTextEditable(true);
        this.fLocalCombobox.setRestrictWidth(false);
        this.fLocalCombobox.addActionListener((ActionListener)directoryActionListener);
        MWPanel mWPanel = new MWPanel((LayoutManager)new BorderLayout(5, 5));
        mWPanel.add((Component)this.fLocalCombobox, "Center");
        if (PlatformInfo.getPlatform() != 2) {
            this.fDirBrowseButton = new MyDirBrowseButton("...");
            this.fDirBrowseButton.addActionListener(new DirectoryBrowseButtonListener());
            new MWToolTip((Component)((Object)this.fDirBrowseButton), HelpBrowser.sRes.getString("prefs.pdf_browse_helpdir"));
            mWPanel.add((Component)((Object)this.fDirBrowseButton), "East");
        }
        MWPanel mWPanel2 = new MWPanel((LayoutManager)new BorderLayout());
        if (PlatformInfo.getPlatform() != 2) {
            mWPanel.setInsets(new Insets(5, 17, 5, 5));
            mWPanel2.setInsets(new Insets(7, 0, 0, 0));
            mWPanel2.add((Component)this.fLocalCheckbox, "North");
        }
        mWPanel2.add((Component)mWPanel, "South");
        this.fCdromCheckbox = new MWCheckbox(HelpBrowser.sRes.getString("prefs.docroot2"), false, this.fDocSourceGroup);
        this.fCdromCheckbox.setBehavior(1);
        this.fCdromCheckbox.addItemListener((ItemListener)checkboxItemListener);
        String[] stringArray2 = HelpPrefs.getDirectoryPrefs(Prefs.getStringPref((String)"HelpCDROMDirectory"));
        String string3 = stringArray2[0];
        this.fCdromCombobox = new MWCombobox(string3, stringArray2);
        this.fCdromCombobox.setTextEditable(true);
        this.fCdromCombobox.setRestrictWidth(false);
        this.fCdromCombobox.addActionListener((ActionListener)directoryActionListener);
        MWPanel mWPanel3 = new MWPanel((LayoutManager)new BorderLayout(5, 5));
        mWPanel3.setInsets(new Insets(5, 17, 5, 5));
        mWPanel3.add((Component)this.fCdromCombobox, "Center");
        if (PlatformInfo.getPlatform() != 2) {
            this.fCdromBrowseButton = new MyDirBrowseButton("...");
            this.fCdromBrowseButton.addActionListener(new CdromBrowseButtonListener());
            new MWToolTip((Component)((Object)this.fCdromBrowseButton), HelpBrowser.sRes.getString("prefs.pdf_browse_cdromdir"));
            mWPanel3.add((Component)((Object)this.fCdromBrowseButton), "East");
        }
        MWPanel mWPanel4 = new MWPanel((LayoutManager)new BorderLayout());
        mWPanel4.setInsets(new Insets(7, 0, 0, 0));
        mWPanel4.add((Component)this.fCdromCheckbox, "North");
        mWPanel4.add((Component)mWPanel3, "South");
        this.fWebCheckbox = new MWCheckbox(HelpBrowser.sRes.getString("prefs.docroot3"), false, this.fDocSourceGroup);
        this.fWebCheckbox.setBehavior(1);
        String[] stringArray3 = new String[]{"http://www.mathworks.com/doc"};
        this.fWebCombobox = new MWCombobox("http://www.mathworks.com/doc", stringArray3);
        this.fWebCombobox.setTextEditable(true);
        this.fWebCombobox.addActionListener((ActionListener)directoryActionListener);
        MWPanel mWPanel5 = new MWPanel((LayoutManager)new BorderLayout());
        mWPanel5.setInsets(new Insets(5, 17, 5, 5));
        mWPanel5.add((Component)this.fWebCombobox, "Center");
        MWPanel mWPanel6 = new MWPanel((LayoutManager)new BorderLayout());
        mWPanel6.setInsets(new Insets(7, 0, 0, 0));
        mWPanel6.add((Component)this.fWebCheckbox, "North");
        mWPanel6.add((Component)mWPanel5, "South");
        this.fCurrentDocRootInDialog = this.fCurrentDocRoot = HelpPrefs.getDocRoot();
        int n = Prefs.getIntegerPref((String)"HelpDocSourceType", (int)0);
        if (n == 0) {
            this.fDocSourceGroup.setSelectedItem((MWExclusiveGroupItem)this.fLocalCheckbox);
        } else if (n == 1) {
            this.fDocSourceGroup.setSelectedItem((MWExclusiveGroupItem)this.fCdromCheckbox);
        } else if (n == 2) {
            this.fDocSourceGroup.setSelectedItem((MWExclusiveGroupItem)this.fWebCheckbox);
        }
        MWGroupbox mWGroupbox = new MWGroupbox(HelpBrowser.sRes.getString("prefs.doc_location"), 0);
        mWGroupbox.setMargins(new Insets(5, 5, 5, 5));
        if (PlatformInfo.getPlatform() == 2) {
            mWGroupbox.setLayout(new GridLayout(1, 1));
            mWGroupbox.add((Component)mWPanel2);
        } else {
            mWGroupbox.setLayout(new GridLayout(2, 1));
            mWGroupbox.add((Component)mWPanel2);
            mWGroupbox.add((Component)mWPanel4);
        }
        String string4 = HelpPrefs.getPdfReader();
        this.fPdfInputField = new MWTextField();
        this.fPdfInputField.setText(string4);
        this.fPdfInputField.setSel(0, 0);
        MyButton myButton = new MyButton("...");
        myButton.addActionListener(new PDFBrowseActionListener());
        new MWToolTip((Component)((Object)myButton), HelpBrowser.sRes.getString("prefs.pdf_browse_title"));
        MWGroupbox mWGroupbox2 = new MWGroupbox(HelpBrowser.sRes.getString("prefs.pdf_reader"), 0);
        mWGroupbox2.setLayout(new BorderLayout(5, 5));
        mWGroupbox2.add((Component)this.fPdfInputField, "Center");
        mWGroupbox2.add((Component)((Object)myButton), "East");
        mWGroupbox2.setMargins(new Insets(5, 5, 5, 5));
        this.fProductFilterPanel = new ProductFilterPanel(false);
        this.fProductFilterPanel.seedProductFilterPanel(HelpProductList.getProductList(), HelpPrefs.getDocRoot());
        this.fAutosyncCheckbox = new MWCheckbox(HelpBrowser.sRes.getString("prefs.sync_option"), true);
        this.fCurrentAutosyncPref = Prefs.getBooleanPref((String)"HelpAutosyncContents", (boolean)true);
        this.fAutosyncCheckbox.setState(this.fCurrentAutosyncPref);
        MWGroupbox mWGroupbox3 = new MWGroupbox(HelpBrowser.sRes.getString("prefs.general"), 0);
        mWGroupbox3.setLayout(new BorderLayout(5, 5));
        mWGroupbox3.add((Component)this.fAutosyncCheckbox, "Center");
        mWGroupbox3.setMargins(new Insets(5, 5, 5, 5));
        VertFlowLayout vertFlowLayout = new VertFlowLayout(3, 10, 10);
        vertFlowLayout.setMaximizeHorizontally(true);
        ((Container)((Object)this)).setLayout(vertFlowLayout);
        this.setInsets(new Insets(0, 0, 0, 0));
        ((Container)((Object)this)).add((Component)mWGroupbox);
        ((Container)((Object)this)).add((Component)((Object)this.fProductFilterPanel));
        ((Container)((Object)this)).add((Component)mWGroupbox2);
        ((Container)((Object)this)).add((Component)mWGroupbox3);
    }

    public static MWPanel createPrefsPanel() {
        if (sPrefsPanel != null) {
            sPrefsPanel = null;
        }
        sPrefsPanel = new HelpPrefs();
        return sPrefsPanel;
    }

    public static void commitPrefsChanges() {
        if (sPrefsPanel != null) {
            sPrefsPanel.savePrefs();
        }
    }

    public static void addFontListeners(PrefListener prefListener) {
        Prefs.addListener((PrefListener)prefListener, (String)"GeneralFont");
        Prefs.addListener((PrefListener)prefListener, (String)"HelpNavigatorFont");
        Prefs.addListener((PrefListener)prefListener, (String)"HelpUseDesktopFont");
    }

    public static String getPdfReader() {
        String string = "d:\\Applications\\Acrobat\\AcroRd32.exe";
        if (PlatformInfo.getPlatform() == 2) {
            string = "acroread";
        }
        return Prefs.getStringPref((String)"HelpPDF_Reader", (String)string);
    }

    public static Font getHtmlBrowserFixedFont() {
        return Prefs.getFontPref((String)"HelpHTML_Browser_FixedFont", (Font)new Font("Monospaced", 0, 12));
    }

    public static Font getHtmlBrowserProportionalFont() {
        return Prefs.getFontPref((String)"HelpHTML_Browser_ProportionalFont", (Font)new Font("SansSerif", 0, 12));
    }

    public static String[] getSelectedProducts() {
        return sSelectedProducts;
    }

    public static boolean isProductSelected(String string) {
        int n = 0;
        while (n < sSelectedProducts.length) {
            if (sSelectedProducts[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean areAllProductsSelected() {
        return Prefs.getBooleanPref((String)"HelpSearchShowAllProducts", (!Matlab.isStudentVersion() ? 1 : 0) != 0);
    }

    public static String getDocRoot() {
        String string = "";
        int n = Prefs.getIntegerPref((String)"HelpDocSourceType", (int)0);
        String string2 = String.valueOf(Matlab.matlabRoot()) + HelpBrowser.fSeparator + "help";
        if (n == 0) {
            String[] stringArray = HelpPrefs.getDirectoryPrefs(Prefs.getStringPref((String)"HelpLocalDirectory", (String)string2));
            string = stringArray[0];
        } else if (n == 1) {
            string = HelpPrefs.getCDRomPath();
        } else if (n == 2) {
            string = "";
        }
        return string;
    }

    public static String getCDRomPath() {
        String string = "";
        if (PlatformInfo.getPlatform() == 1) {
            string = "z:\\help";
        }
        String[] stringArray = HelpPrefs.getDirectoryPrefs(Prefs.getStringPref((String)"HelpCDROMDirectory", (String)string));
        return stringArray[0];
    }

    public static String[] getDirectoryPrefs(String string) {
        int n = 0;
        int n2 = 0;
        Vector<String> vector = new Vector<String>();
        while ((n2 = string.indexOf(";", n)) != -1) {
            vector.addElement(string.substring(n, n2));
            n = n2 + 1;
        }
        vector.addElement(string.substring(n, string.length()));
        String[] stringArray = new String[vector.size()];
        int n3 = 0;
        while (n3 < vector.size()) {
            stringArray[n3] = (String)vector.elementAt(n3);
            ++n3;
        }
        return stringArray;
    }

    private void addDirectoryToCombobox(MWCombobox mWCombobox, String string) {
        String[] stringArray = mWCombobox.getItems();
        int n = stringArray.length;
        if (!mWCombobox.contains(string)) {
            ++n;
        }
        String[] stringArray2 = new String[n];
        stringArray2[0] = string;
        int n2 = 1;
        int n3 = 0;
        while (n3 < stringArray.length) {
            if (!stringArray[n3].equals(stringArray2[0]) && !stringArray[n3].equals("")) {
                stringArray2[n2++] = stringArray[n3];
            }
            ++n3;
        }
        mWCombobox.setItems(stringArray2);
        this.resetDocRootForFilter();
    }

    private void resetDocRootForFilter() {
        String string = "";
        int n = -1;
        if (this.fLocalCheckbox.getState()) {
            string = this.fLocalCombobox.getText();
            n = 0;
        } else if (this.fCdromCheckbox.getState()) {
            string = this.fCdromCombobox.getText();
            n = 1;
        } else if (this.fWebCheckbox.getState()) {
            string = this.fWebCombobox.getText();
            n = 2;
        }
        if (PlatformInfo.isWindows()) {
            string = string.replace('/', '\\');
        }
        if (!string.equals(this.fCurrentDocRootInDialog) && this.fProductFilterPanel != null) {
            Vector vector = HelpProductList.buildTempProductList(string);
            this.fProductFilterPanel.seedProductFilterPanel(vector, string);
            this.fCurrentDocRootInDialog = string;
        }
    }

    public boolean getResult() {
        return this.fResult;
    }

    public void setResult(boolean bl) {
        this.fResult = bl;
    }

    private void savePrefs() {
        String string = "";
        int n = -1;
        if (this.fLocalCheckbox.getState()) {
            string = this.fLocalCombobox.getText();
            n = 0;
        } else if (this.fCdromCheckbox.getState()) {
            string = this.fCdromCombobox.getText();
            n = 1;
        } else if (this.fWebCheckbox.getState()) {
            string = this.fWebCombobox.getText();
            n = 2;
        }
        if (PlatformInfo.isWindows()) {
            string = string.replace('/', '\\');
        }
        Prefs.setIntegerPref((String)"HelpDocSourceType", (int)n);
        HelpPrefs.saveDirectoryPrefs("HelpLocalDirectory", this.fLocalCombobox.getText(), this.fLocalCombobox.getItems(), true);
        HelpPrefs.saveDirectoryPrefs("HelpCDROMDirectory", this.fCdromCombobox.getText(), this.fCdromCombobox.getItems(), true);
        if (!string.equals(this.fCurrentDocRoot)) {
            Prefs.setStringPref((String)"HelpDocRoot", (String)string);
            this.fCurrentDocRoot = string;
        }
        String string2 = this.fPdfInputField.getText();
        if (PlatformInfo.isWindows()) {
            string2 = string2.replace('/', '\\');
        }
        Prefs.setStringPref((String)"HelpPDF_Reader", (String)string2);
        boolean bl = this.fAutosyncCheckbox.getState();
        if (!bl == this.fCurrentAutosyncPref) {
            Prefs.setBooleanPref((String)"HelpAutosyncContents", (boolean)bl);
            this.fCurrentAutosyncPref = bl;
        }
        this.fProductFilterPanel.savePrefs();
        sSelectedProducts = HelpPrefs.getDirectoryPrefs(Prefs.getStringPref((String)"HelpSelectedProducts", (String)"MATLAB"));
        this.fResult = true;
    }

    public static void saveDirectoryPrefs(String string, String string2, String[] stringArray, boolean bl) {
        int n = 5;
        if (!bl || stringArray.length < 5) {
            n = stringArray.length;
        }
        String string3 = string2;
        int n2 = 0;
        while (n2 < n) {
            if (!stringArray[n2].equals(string2) && !stringArray[n2].equals("")) {
                string3 = String.valueOf(string3) + ";" + stringArray[n2];
            }
            ++n2;
        }
        if (PlatformInfo.isWindows()) {
            string3 = string3.replace('/', '\\');
        }
        if (!string3.equals(Prefs.getStringPref((String)string))) {
            Prefs.setStringPref((String)string, (String)string3);
        }
    }

    private class DirectoryActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MWCombobox mWCombobox = (MWCombobox)actionEvent.getSource();
            String string = mWCombobox.getText();
            if (string.endsWith("/") || string.endsWith("\\")) {
                string = string.substring(0, string.length() - 1);
                mWCombobox.setText(string);
            }
            HelpPrefs.this.addDirectoryToCombobox(mWCombobox, string);
        }

        DirectoryActionListener() {
            HelpPrefs.this = HelpPrefs.this;
        }
    }

    private class CheckboxItemListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            HelpPrefs.this.resetDocRootForFilter();
        }

        CheckboxItemListener() {
            HelpPrefs.this = HelpPrefs.this;
        }
    }

    private class PDFBrowseActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            FileDialog fileDialog = new FileDialog(HelpPrefs.this.getFrame(), HelpBrowser.sRes.getString("prefs.pdf_browse_title"), 0);
            fileDialog.show();
            String string = fileDialog.getFile();
            if (string != null) {
                File file = new File(fileDialog.getDirectory(), string);
                HelpPrefs.this.fPdfInputField.setText(file.getAbsolutePath());
            }
        }

        PDFBrowseActionListener() {
            HelpPrefs.this = HelpPrefs.this;
        }
    }

    private class DirectoryBrowseButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            if (actionEvent.getSource() == HelpPrefs.this.fDirBrowseButton) {
                NativeJava.browseForFolder((MWComponent)HelpPrefs.this.fLocalCheckbox, (String)HelpBrowser.sRes.getString("prefs.font.select_a_directory"), (ActionListener)this);
                return;
            }
            if (actionEvent.getID() == 1001 && (string = actionEvent.getActionCommand()) != null && string.length() > 1) {
                HelpPrefs.this.fLocalCombobox.setText(string);
                HelpPrefs.this.addDirectoryToCombobox(HelpPrefs.this.fLocalCombobox, string);
            }
        }

        DirectoryBrowseButtonListener() {
            HelpPrefs.this = HelpPrefs.this;
        }
    }

    private class CdromBrowseButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            if (actionEvent.getSource() == HelpPrefs.this.fCdromBrowseButton) {
                NativeJava.browseForFolder((MWComponent)HelpPrefs.this.fLocalCheckbox, (String)HelpBrowser.sRes.getString("prefs.font.select_a_directory"), (ActionListener)this);
                return;
            }
            if (actionEvent.getID() == 1001 && (string = actionEvent.getActionCommand()) != null && string.length() > 1) {
                HelpPrefs.this.fCdromCombobox.setText(string);
                HelpPrefs.this.addDirectoryToCombobox(HelpPrefs.this.fCdromCombobox, string);
            }
        }

        CdromBrowseButtonListener() {
            HelpPrefs.this = HelpPrefs.this;
        }
    }

    private class MyButton
    extends MWButton {
        public MyButton(String string) {
            super(string);
            HelpPrefs.this = HelpPrefs.this;
        }

        public Dimension getPreferredSize() {
            Dimension dimension = this.getMinimumSize();
            return dimension;
        }
    }

    private class MyDirBrowseButton
    extends MWButton {
        public MyDirBrowseButton(String string) {
            super(string);
            HelpPrefs.this = HelpPrefs.this;
        }

        public Dimension getPreferredSize() {
            Dimension dimension = this.getMinimumSize();
            dimension.height = ((HelpPrefs)HelpPrefs.this).fLocalCombobox.getPreferredSize().height;
            return dimension;
        }
    }
}

