/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.help;

import com.mathworks.ide.editor.VertFlowLayout;
import com.mathworks.ide.help.HelpBrowser;
import com.mathworks.ide.prefs.GeneralPrefsColorPanel;
import com.mathworks.mwt.MWCanvas;
import com.mathworks.mwt.MWChoice;
import com.mathworks.mwt.MWFontHandler;
import com.mathworks.mwt.MWGroupbox;
import com.mathworks.mwt.MWLabel;
import com.mathworks.mwt.MWPanel;
import com.mathworks.services.Prefs;
import com.mathworks.widgets.DesktopFontPicker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;

public class HelpFontPrefs
extends MWPanel {
    private static HelpFontPrefs sPrefsPanel = null;
    private static Font sHtmlFixedFont;
    private static Font sHtmlPropFont;
    private static Font sNavigatorFont;
    private static boolean sUseDesktopFont;
    private HtmlFontEditor fFixedFontEditor;
    private HtmlFontEditor fPropFontEditor;
    private DesktopFontPicker fNavigatorFontEditor;

    private HelpFontPrefs() {
        VertFlowLayout vertFlowLayout = new VertFlowLayout(3, 10, 10);
        vertFlowLayout.setMaximizeHorizontally(true);
        this.fNavigatorFontEditor = new DesktopFontPicker(HelpFontPrefs.getUseDesktopFont(), HelpFontPrefs.getNavigatorFont());
        MWGroupbox mWGroupbox = new MWGroupbox(HelpBrowser.sRes.getString("prefs.font.navigator"));
        mWGroupbox.setLayout(new FlowLayout(0, 0, 0));
        mWGroupbox.add((Component)this.fNavigatorFontEditor);
        sHtmlFixedFont = HelpFontPrefs.getHtmlBrowserFixedFont();
        this.fFixedFontEditor = new HtmlFontEditor(sHtmlFixedFont);
        sHtmlPropFont = HelpFontPrefs.getHtmlBrowserProportionalFont();
        this.fPropFontEditor = new HtmlFontEditor(sHtmlPropFont);
        MWPanel mWPanel = new MWPanel((LayoutManager)new GridLayout(2, 1));
        mWPanel.add((Component)new MWLabel(HelpBrowser.sRes.getString("prefs.font.fixed")));
        mWPanel.add((Component)new MWLabel(HelpBrowser.sRes.getString("prefs.font.proportional")));
        MWPanel mWPanel2 = new MWPanel((LayoutManager)new GridLayout(2, 1));
        mWPanel2.add((Component)((Object)this.fFixedFontEditor));
        mWPanel2.add((Component)((Object)this.fPropFontEditor));
        MWGroupbox mWGroupbox2 = new MWGroupbox(HelpBrowser.sRes.getString("prefs.font.browser"), 0);
        mWGroupbox2.setLayout(new BorderLayout());
        mWGroupbox2.setMargins(new Insets(5, 5, 5, 5));
        mWGroupbox2.add((Component)mWPanel, "West");
        mWGroupbox2.add((Component)mWPanel2, "Center");
        ((Container)((Object)this)).setLayout(vertFlowLayout);
        this.setInsets(new Insets(0, 0, 0, 0));
        ((Container)((Object)this)).add((Component)mWGroupbox);
        ((Container)((Object)this)).add((Component)mWGroupbox2);
    }

    public static MWPanel createPrefsPanel() {
        if (sPrefsPanel != null) {
            sPrefsPanel = null;
        }
        sPrefsPanel = new HelpFontPrefs();
        return sPrefsPanel;
    }

    public static void commitPrefsChanges() {
        if (sPrefsPanel != null) {
            sPrefsPanel.savePrefs();
        }
    }

    public static boolean getUseDesktopFont() {
        return sUseDesktopFont;
    }

    public static void setUseDesktopFont(boolean bl) {
        if (sUseDesktopFont != bl) {
            sUseDesktopFont = bl;
            Prefs.setBooleanPref((String)"HelpUseDesktopFont", (boolean)sUseDesktopFont);
        }
    }

    private static Font getNavigatorFont() {
        return sNavigatorFont;
    }

    public static Font getHelpNavigatorFont() {
        if (sUseDesktopFont) {
            return GeneralPrefsColorPanel.getDesktopFont();
        }
        return sNavigatorFont;
    }

    public static void setNavigatorFont(Font font) {
        if (!sNavigatorFont.equals(font)) {
            sNavigatorFont = font;
            Prefs.setFontPref((String)"HelpNavigatorFont", (Font)sNavigatorFont);
        }
    }

    public static Font getHtmlBrowserFixedFont() {
        return sHtmlFixedFont;
    }

    public static Font getHtmlBrowserProportionalFont() {
        return sHtmlPropFont;
    }

    private void savePrefs() {
        HelpFontPrefs.setUseDesktopFont(this.fNavigatorFontEditor.getUseDesktopFont());
        HelpFontPrefs.setNavigatorFont(this.fNavigatorFontEditor.getSelectedFont());
        Font font = this.fFixedFontEditor.getValue();
        if (!font.equals(sHtmlFixedFont)) {
            Prefs.setFontPref((String)"HelpHTML_Browser_FixedFont", (Font)font);
            sHtmlFixedFont = font;
        }
        if (!(font = this.fPropFontEditor.getValue()).equals(sHtmlPropFont)) {
            Prefs.setFontPref((String)"HelpHTML_Browser_ProportionalFont", (Font)font);
            sHtmlPropFont = font;
        }
    }

    static {
        sUseDesktopFont = Prefs.getBooleanPref((String)"HelpUseDesktopFont", (boolean)false);
        sNavigatorFont = Prefs.getFontPref((String)"HelpNavigatorFont", (Font)new Font("SansSerif", 0, 12));
        sHtmlFixedFont = Prefs.getFontPref((String)"HelpHTML_Browser_FixedFont", (Font)new Font("Monospaced", 0, 12));
        sHtmlPropFont = Prefs.getFontPref((String)"HelpHTML_Browser_ProportionalFont", (Font)new Font("SansSerif", 0, 12));
    }

    private class HtmlFontEditor
    extends MWPanel {
        private MWChoice fNameChoice;
        private MWChoice fSizeChoice;

        public HtmlFontEditor(Font font) {
            HelpFontPrefs.this = HelpFontPrefs.this;
            String[] stringArray = new String[]{"9", "10", "12", "14", "18", "24", "36", "48"};
            String[] stringArray2 = MWFontHandler.getFontList();
            ((Container)((Object)this)).setLayout(new BorderLayout());
            if (font == null) {
                font = new Font("Dialog", 0, 10);
            }
            this.fNameChoice = new MWChoice();
            this.fNameChoice.setRestrictWidth(false);
            int n = 0;
            while (n < stringArray2.length) {
                this.fNameChoice.add(stringArray2[n]);
                if (MWFontHandler.getJavaFontName((String)stringArray2[n]).equals(font.getName())) {
                    this.fNameChoice.select(n);
                }
                ++n;
            }
            ((Container)((Object)this)).add((Component)this.fNameChoice, "Center");
            this.fSizeChoice = new MWChoice();
            int n2 = 0;
            while (n2 < stringArray.length) {
                this.fSizeChoice.add(stringArray[n2]);
                if (font.getSize() == Integer.parseInt(stringArray[n2])) {
                    this.fSizeChoice.select(n2);
                }
                ++n2;
            }
            MWPanel mWPanel = new MWPanel((LayoutManager)new FlowLayout(1, 0, 0));
            mWPanel.add((Component)new MWCanvas(4, 4));
            mWPanel.add((Component)this.fSizeChoice);
            ((Container)((Object)this)).add((Component)mWPanel, "East");
        }

        public Font getValue() {
            return new Font(MWFontHandler.getJavaFontName((String)this.fNameChoice.getSelectedItem()), 0, Integer.parseInt(this.fSizeChoice.getSelectedItem()));
        }

        public void addNotify() {
            super.addNotify();
            MWFontHandler.checkFontAvailability((Component)((Object)this));
        }
    }
}

