/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.help;

import com.mathworks.ide.desktop.DTMenu;
import com.mathworks.ide.desktop.DTMenuBar;
import com.mathworks.ide.desktop.MenuUtils;
import com.mathworks.ide.help.HelpBrowser;
import com.mathworks.mwt.MWCheckboxMenuItem;
import com.mathworks.mwt.MWFrameProxy;
import com.mathworks.mwt.MWMenu;
import com.mathworks.mwt.MWMenuBar;
import com.mathworks.mwt.MWMenuComponent;
import com.mathworks.mwt.command.MWCommandCenter;

public class HelpBrowserMenubar {
    private MWMenuBar fMenubar;
    private DTMenu fViewMenu;
    private MWMenu fGoMenu;
    private MWCheckboxMenuItem fShowHelpNavigatorCheckbox;
    private MWCommandCenter fCenter;
    private boolean fShowNavigator;

    HelpBrowserMenubar(MWFrameProxy mWFrameProxy, MWCommandCenter mWCommandCenter, boolean bl) {
        this.fCenter = mWCommandCenter;
        this.fShowNavigator = bl;
        DTMenuBar dTMenuBar = DTMenuBar.createComponentMenubar(mWFrameProxy);
        this.fMenubar = dTMenuBar.getMenubar();
        this.createViewMenu();
        this.createGoMenu();
        this.fMenubar = this.mergeMenus(this.fMenubar);
        dTMenuBar.autoAddSeparators();
    }

    public MWMenuBar getMenubar() {
        return this.fMenubar;
    }

    private void createViewMenu() {
        this.fViewMenu = new DTMenu(HelpBrowser.sRes.getString("menu.view.options"), this.fCenter);
        this.fShowHelpNavigatorCheckbox = MenuUtils.addCheckboxMenuItem(this.fCenter, this.fViewMenu, HelpBrowser.sRes.getString("menu.view.show_navigator"), 2246);
        this.fShowHelpNavigatorCheckbox.setState(this.fShowNavigator);
        MenuUtils.addMenuItem(this.fCenter, this.fViewMenu, "SEPARATOR", -1, -1);
        MenuUtils.addMenuItem(this.fCenter, this.fViewMenu, HelpBrowser.sRes.getString("menu.view.page_source"), 2250, -1);
    }

    private void createGoMenu() {
        this.fGoMenu = new MWMenu(HelpBrowser.sRes.getString("menu.go"));
        MenuUtils.addMenuItem(this.fCenter, this.fGoMenu, HelpBrowser.sRes.getString("menu.go.back"), 1, -1);
        MenuUtils.addMenuItem(this.fCenter, this.fGoMenu, HelpBrowser.sRes.getString("menu.go.forward"), 2, -1);
        MenuUtils.addMenuItem(this.fCenter, this.fGoMenu, HelpBrowser.sRes.getString("menu.go.reload"), 3, -1);
        MenuUtils.addMenuItem(this.fCenter, this.fGoMenu, "SEPARATOR", -1, -1);
        MenuUtils.addMenuItem(this.fCenter, this.fGoMenu, HelpBrowser.sRes.getString("menu.go.eval_sel"), 4, -1);
    }

    public void setShowingHelpNavigator(boolean bl) {
        this.fShowHelpNavigatorCheckbox.setState(bl);
    }

    public MWMenuBar mergeMenus(MWMenuBar mWMenuBar) {
        boolean bl = false;
        int n = 0;
        while (n < mWMenuBar.getMenuCount()) {
            MWMenu mWMenu = mWMenuBar.getMenu(n);
            if (mWMenu instanceof DTMenu) {
                DTMenu dTMenu = (DTMenu)mWMenu;
                if (dTMenu.getLabel().equals(DTMenuBar.sRes.getString("menu.File")) || dTMenu.getLabel().equals(DTMenuBar.sRes.getString("menu.FileNoAmpersand"))) {
                    dTMenu.addMenuItem(this.fCenter, 550);
                } else if (dTMenu.getLabel().equals(DTMenuBar.sRes.getString("menu.Edit")) || dTMenu.getLabel().equals(DTMenuBar.sRes.getString("menu.EditNoAmpersand"))) {
                    dTMenu.addMenuItem(this.fCenter, 910);
                } else if (dTMenu.getLabel().equals(DTMenuBar.sRes.getString("menu.View")) || dTMenu.getLabel().equals(DTMenuBar.sRes.getString("menu.ViewNoAmpersand"))) {
                    int n2 = 0;
                    while (n2 < dTMenu.getItemCount()) {
                        MWMenuComponent mWMenuComponent = dTMenu.getItem(n2);
                        if (mWMenuComponent.getLabel().equals(HelpBrowser.sRes.getString("menu.view.options")) || mWMenuComponent.getLabel().equals(HelpBrowser.sRes.getString("menu.view.options_noampersand"))) {
                            bl = true;
                        }
                        ++n2;
                    }
                    if (!bl) {
                        dTMenu.add((MWMenuComponent)this.fViewMenu);
                        bl = true;
                    }
                } else if ((dTMenu.getLabel().equals(DTMenuBar.sRes.getString("menu.Help")) || dTMenu.getLabel().equals(DTMenuBar.sRes.getString("menu.HelpNoAmpersand"))) && dTMenu.getItemCount() > 0 && dTMenu.getItem(0).getLabel().equals(DTMenuBar.sRes.getString("menuitem.MATLABHelp"))) {
                    dTMenu.remove(0);
                    dTMenu.addMenuItem(DTMenuBar.sRes.getString("menuitem.FullProductFamilyHelp"), 4001);
                }
            }
            ++n;
        }
        if (!bl) {
            this.fViewMenu.setLabel(HelpBrowser.sRes.getString("menu.view"));
            mWMenuBar.insert((MWMenuComponent)this.fViewMenu, 2);
        }
        mWMenuBar.insert((MWMenuComponent)this.fGoMenu, 3);
        return mWMenuBar;
    }
}

