/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.help;

import com.mathworks.ide.desktop.DTApplication;
import com.mathworks.ide.desktop.MLDesktop;
import com.mathworks.ide.help.CSHelpTopicMap;
import com.mathworks.ide.help.ContentsTree;
import com.mathworks.ide.help.Favorites;
import com.mathworks.ide.help.HelpBrowserMenubar;
import com.mathworks.ide.help.HelpPrefs;
import com.mathworks.ide.help.HelpProductList;
import com.mathworks.ide.help.ICEBrowserContainer;
import com.mathworks.ide.help.Index;
import com.mathworks.ide.help.SearchTab;
import com.mathworks.ide.prefs.PrefsDialog;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwt.MWButton;
import com.mathworks.mwt.MWCheckbox;
import com.mathworks.mwt.MWCloseBox;
import com.mathworks.mwt.MWExclusiveGroup;
import com.mathworks.mwt.MWExclusiveGroupItem;
import com.mathworks.mwt.MWFrame;
import com.mathworks.mwt.MWFrameProxy;
import com.mathworks.mwt.MWGroupbox;
import com.mathworks.mwt.MWLabel;
import com.mathworks.mwt.MWMenuBar;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.MWSplitter;
import com.mathworks.mwt.MWStatusBar;
import com.mathworks.mwt.MWTabPanel;
import com.mathworks.mwt.command.MWCommandCenter;
import com.mathworks.mwt.command.MWCommandTarget;
import com.mathworks.mwt.dialog.MWAlert;
import com.mathworks.mwt.message.MWLooper;
import com.mathworks.mwt.window.MWWindowActivater;
import com.mathworks.mwt.window.MWWindowOwner;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.ResLoader;
import com.mathworks.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public class HelpBrowser
extends MWPanel
implements MWCommandTarget,
DTApplication,
MWWindowOwner {
    public static final int HIDE_NAVIGATOR = 2245;
    public static final int SHOW_NAVIGATOR = 2246;
    public static final int VIEW_SOURCE = 2250;
    public static final int PREFS = 44;
    private static HelpBrowser sHelpBrowser;
    public static String fSeparator;
    private static String sMatlabRoot;
    private String fDocRoot;
    private String fDocRootForBrowser;
    private ICEBrowserContainer fIceContainer;
    private MWGroupbox fIceBrowserPanel;
    private MWPanel fNavigatorPanel;
    private ContentsTree fContentsPanel;
    private Index fIndexPanel;
    private SearchTab fSearchPanel;
    private Favorites fFavoritesPanel;
    private MWCommandCenter fCenter;
    private MWSplitter fSplitter;
    private MWTabPanel fTabPanel;
    private HelpBrowserMenubar fMenubar;
    private boolean fNavigatorShowing;
    private Matlab fMatlab = new Matlab(new MWLooper("Help Browser"));
    private MWFrameProxy fFrame;
    private MWStatusBar fStatusBar;
    private MLDesktop fDesktop;
    private boolean fNavigatorInitialized = false;
    private boolean fValidDocroot = false;
    private boolean fFirstTime = true;
    private boolean fInitialized = false;
    private MWCheckbox fAllProductsCheckbox;
    private MWCheckbox fSelectedProductsCheckbox;
    private MyButton fFilterButton;
    private int fNumThreadsRunning;
    static final String RESDIR = "com.mathworks.ide.help.resources.";
    static ResourceBundle sRes;
    private static ResourceBundle sPrefsRes;
    static final String sHelpBrowserName;
    static final String sInvalidDocroot;
    private static final String sContentsTabName;
    private String fCurrentDefaultStatusText = sRes.getString("status.ready");

    public static void main(String[] stringArray) {
        HelpBrowser helpBrowser = new HelpBrowser(true);
        MWFrame mWFrame = new MWFrame("MATLAB Help Browser");
        mWFrame.add((Component)((Object)helpBrowser), "Center");
        mWFrame.setLocation(20, 40);
        mWFrame.setSize(900, 700);
        mWFrame.setVisible(true);
        mWFrame.addWindowListener((WindowListener)new MWWindowActivater((Component)mWFrame));
    }

    public HelpBrowser() {
        this(true);
    }

    public HelpBrowser(boolean bl) {
        sHelpBrowser = this;
        this.fDocRoot = HelpPrefs.getDocRoot();
        this.fCenter = new MWCommandCenter((MWCommandTarget)this);
        this.fNavigatorShowing = true;
        this.setDocRoot();
        this.fDesktop = MLDesktop.getMLDesktop();
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.setInsets(new Insets(5, 5, 0, 0));
        Font font = new Font("Dialog", 0, 11);
        ((Component)((Object)this)).setFont(font);
        this.fIceContainer = new ICEBrowserContainer(this.fCenter, this);
        this.fFavoritesPanel = new Favorites(this);
        this.fContentsPanel = new ContentsTree(this);
        this.fIndexPanel = new Index(this);
        this.fSearchPanel = new SearchTab(this);
        this.fTabPanel = new MWTabPanel(1, 0);
        this.fTabPanel.setFont(font);
        this.fTabPanel.addPanel(sContentsTabName, (Component)((Object)this.fContentsPanel));
        this.fTabPanel.addItemListener((ItemListener)new TabItemListener());
        HelpNavigatorTitleBar helpNavigatorTitleBar = new HelpNavigatorTitleBar(sRes.getString("hb.helpnavigator"), this.fCenter, 2245, false);
        this.fFilterButton = new MyButton(" " + sRes.getString("filter.select_products") + " ");
        this.fFilterButton.setFont(font);
        this.fFilterButton.addActionListener(new FilterButtonActionListener());
        FilterCheckboxItemListener filterCheckboxItemListener = new FilterCheckboxItemListener();
        MWExclusiveGroup mWExclusiveGroup = new MWExclusiveGroup();
        this.fAllProductsCheckbox = new MWCheckbox(sRes.getString("filter.all"), true, mWExclusiveGroup);
        this.fAllProductsCheckbox.setBehavior(1);
        this.fAllProductsCheckbox.setFont(font);
        this.fAllProductsCheckbox.addItemListener((ItemListener)filterCheckboxItemListener);
        this.fSelectedProductsCheckbox = new MWCheckbox(sRes.getString("filter.selected"), false, mWExclusiveGroup);
        this.fSelectedProductsCheckbox.setBehavior(1);
        this.fSelectedProductsCheckbox.setFont(font);
        this.fSelectedProductsCheckbox.addItemListener((ItemListener)filterCheckboxItemListener);
        boolean bl2 = Prefs.getBooleanPref((String)"HelpSearchShowAllProducts", (!Matlab.isStudentVersion() ? 1 : 0) != 0);
        mWExclusiveGroup.setSelectedItem((MWExclusiveGroupItem)(bl2 ? this.fAllProductsCheckbox : this.fSelectedProductsCheckbox));
        MWGroupbox mWGroupbox = new MWGroupbox();
        mWGroupbox.setLayout(new GridBagLayout());
        mWGroupbox.setHiddenEdge(1);
        mWGroupbox.setInsets(new Insets(0, 0, 0, 0));
        mWGroupbox.setMargins(new Insets(0, 0, 0, 0));
        mWGroupbox.setFont(font);
        mWGroupbox.add((Component)new MWLabel(sRes.getString("filter.product_filter")));
        MWPanel mWPanel = new MWPanel((LayoutManager)new FlowLayout());
        mWPanel.add((Component)this.fAllProductsCheckbox);
        mWPanel.add((Component)this.fSelectedProductsCheckbox);
        mWPanel.add((Component)((Object)this.fFilterButton));
        mWGroupbox.add((Component)mWPanel);
        MWPanel mWPanel2 = new MWPanel((LayoutManager)new BorderLayout());
        mWPanel2.add((Component)((Object)helpNavigatorTitleBar), "North");
        mWPanel2.add((Component)mWGroupbox, "South");
        MWGroupbox mWGroupbox2 = new MWGroupbox();
        mWGroupbox2.setLayout(new BorderLayout());
        mWGroupbox2.setMargins(new Insets(5, 2, 2, 2));
        mWGroupbox2.setHiddenEdge(1);
        mWGroupbox2.add((Component)this.fTabPanel, "Center");
        this.fNavigatorPanel = new MWPanel((LayoutManager)new BorderLayout());
        this.fNavigatorPanel.add((Component)mWGroupbox2, "Center");
        this.fNavigatorPanel.add((Component)mWPanel2, "North");
        this.requestFocus();
        this.fIceBrowserPanel = new MWGroupbox();
        this.fIceBrowserPanel.setLayout(new BorderLayout());
        this.fIceBrowserPanel.add((Component)((Object)this.fIceContainer), "Center");
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = this.getPreferredSize().width;
        int n2 = this.getPreferredSize().height;
        int n3 = Math.max(0, dimension.width - n - 50);
        int n4 = 50;
        if (n2 + n4 > dimension.height) {
            n4 = 0;
        }
        this.fFrame = new MWFrameProxy((MWWindowOwner)this, sRes.getString("hb.helpbrowser"));
        ResLoader resLoader = new ResLoader((Component)((Object)this));
        Image image = PlatformInfo.isWindows() ? resLoader.loadImage("/com/mathworks/ide/resources/help32.gif") : resLoader.loadImage("/com/mathworks/ide/resources/help48.gif");
        this.fFrame.setIconImage(image);
        boolean bl3 = Prefs.getBooleanPref((String)"HelpShowNavigator", (boolean)true);
        this.fMenubar = new HelpBrowserMenubar(this.fFrame, this.fCenter, bl3);
        MWMenuBar mWMenuBar = this.fMenubar.getMenubar();
        this.fFrame.setMenuBar(mWMenuBar);
        this.fFrame.setFrameSize(n, n2);
        this.fFrame.setFrameLocation(n3, n4);
        this.fFrame.add((Component)((Object)this));
        this.showNavigator(bl3, true);
        HelpPrefListener helpPrefListener = new HelpPrefListener();
        Prefs.addListener((PrefListener)helpPrefListener, (String)"HelpDocRoot");
        Prefs.addListener((PrefListener)helpPrefListener, (String)"HelpSelectedProducts");
        if (this.fDesktop == null) {
            this.fStatusBar = new MWStatusBar();
            ((Container)((Object)this)).add((Component)this.fStatusBar, "South");
        }
        ((Component)((Object)this)).setName("Help");
        if (bl) {
            this.validateDocRoot();
            if (!this.isDocrootValid()) {
                this.fContentsPanel.resetDocRoot(this.fDocRoot, false);
            } else {
                File file = new File(this.fDocRoot, "begin_here.html");
                if (file.exists()) {
                    this.setCurrentLocation(String.valueOf(this.fDocRoot) + "/begin_here.html");
                }
            }
            this.fContentsPanel.selectFirstEntry(false);
        }
        this.fInitialized = true;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = Math.min(this.fTabPanel.getPreferredSize().width * 4 * 3, dimension.width);
        int n2 = Math.min(600, dimension.height);
        return new Dimension(n, n2);
    }

    public static HelpBrowser getHelpBrowser() {
        if (sHelpBrowser == null) {
            sHelpBrowser = new HelpBrowser(false);
        }
        return sHelpBrowser;
    }

    public static HelpBrowser createHelpBrowser() {
        if (sHelpBrowser == null) {
            sHelpBrowser = new HelpBrowser(true);
        }
        return sHelpBrowser;
    }

    public static void invoke() {
        boolean bl = sHelpBrowser != null;
        HelpBrowser.createHelpBrowser();
        boolean bl2 = ((Component)((Object)sHelpBrowser)).isShowing();
        if (!bl2) {
            HelpBrowser.sHelpBrowser.fMatlab.evalConsoleOutput("doc");
            if (bl) {
                HelpBrowser.sHelpBrowser.fContentsPanel.collapseAllItems();
            }
        }
        sHelpBrowser.showHelpBrowser();
    }

    public ICEBrowserContainer getIceBrowser() {
        return this.fIceContainer;
    }

    public void setStatusText(String string) {
        if (this.fDesktop != null) {
            if (this.fFrame.isVisible()) {
                this.fFrame.setStatusText(string);
                return;
            }
        } else {
            this.fStatusBar.setStatusText(string);
        }
    }

    public void setStatusTextToDefault() {
        this.setStatusText(this.fCurrentDefaultStatusText);
    }

    private void setDefaultStatusText(String string) {
        this.fCurrentDefaultStatusText = string;
        this.setStatusTextToDefault();
    }

    public ContentsTree getContentsTree() {
        return this.fContentsPanel;
    }

    public void reload() {
        this.fIceContainer.reload();
    }

    public String getSelectedTabName() {
        return this.fTabPanel.getPanelNameID(this.fTabPanel.getSelectedIndex());
    }

    private void loadNavigatorData(boolean bl, boolean bl2) {
        if (!this.fNavigatorInitialized) {
            if (bl) {
                this.validateDocRoot();
                this.loadingDataBeginning();
                HelpProductList.buildProductList(this.fDocRoot);
                this.fContentsPanel.resetDocRoot(this.fDocRoot, this.areAnyProductsSelected());
                this.fIndexPanel.resetDocRoot(this.fDocRoot);
                this.fSearchPanel.resetDocRoot(this.fDocRoot);
            } else {
                if (sMatlabRoot == null) {
                    sMatlabRoot = "";
                }
                this.loadData(bl2);
            }
            this.fNavigatorInitialized = true;
        }
    }

    private void loadData(boolean bl) {
        this.validateDocRoot();
        this.loadingDataBeginning();
        boolean bl2 = this.fAllProductsCheckbox.getState();
        boolean bl3 = this.areAnyProductsSelected();
        this.fContentsPanel.loadData(bl2, bl3, bl);
        if (bl3) {
            this.fIndexPanel.loadData(bl2);
            this.fSearchPanel.loadData(bl2);
        }
    }

    private void loadingDataBeginning() {
        this.setDefaultStatusText(sRes.getString("status.loading_data"));
        if (this.areAnyProductsSelected() && this.isDocrootValid()) {
            this.fNumThreadsRunning = 3;
            return;
        }
        this.fNumThreadsRunning = 1;
    }

    public void loadingDataFinished() {
        --this.fNumThreadsRunning;
        if (this.fNumThreadsRunning == 0) {
            this.setDefaultStatusText(sRes.getString("status.ready"));
        }
    }

    public void showProductPage(String string) {
        this.fTabPanel.selectPanel(sContentsTabName);
        this.fContentsPanel.setIsShowing(true);
        this.setCurrentLocation(true, null, string);
    }

    private void showHelpBrowser() {
        if (this.fDesktop != null) {
            if (this.fInitialized) {
                this.fDesktop.showClient(sHelpBrowserName);
                return;
            }
        } else {
            this.fFrame.setVisible(true);
            this.fFrame.toFront();
        }
    }

    public void setHtmlText(String string, String string2, String string3) {
        this.showHelpBrowser();
        this.fIceContainer.setHtmlText(string, string2, string3);
        if (this.fNavigatorShowing && !this.fNavigatorInitialized) {
            this.loadNavigatorData(false, false);
        }
    }

    public void setCurrentLocation(String string) {
        this.setCurrentLocation(null, string);
    }

    public void setCurrentLocation(String string, boolean bl) {
        this.setCurrentLocation(null, string, bl);
    }

    public void setCurrentLocation(String string, String string2, boolean bl) {
        if (this.fIceContainer.getCurrentLocation().equals("")) {
            this.showNavigator(false, false);
        }
        this.setCurrentLocation(false, string, string2);
    }

    public void setCurrentLocation(String string, String string2) {
        this.setCurrentLocation(false, string, string2);
    }

    public void setCurrentLocation(boolean bl, String string, String string2) {
        this.showHelpBrowser();
        this.fIceContainer.setCurrentLocation(bl, string, string2);
        if (this.fNavigatorShowing && !this.fNavigatorInitialized) {
            this.loadNavigatorData(false, false);
        }
    }

    public void displayTopic(String string, File file, String string2, Frame frame) {
        if (this.isDocrootValid()) {
            if (file.exists()) {
                CSHelpTopicMap cSHelpTopicMap = new CSHelpTopicMap(file);
                String string3 = cSHelpTopicMap.mapID(string2);
                if (string3 != null) {
                    this.setCurrentLocation(string, string3);
                    return;
                }
                Object[] objectArray = new Object[]{file.getName(), string2};
                String string4 = HelpBrowser.getMessage(objectArray, sRes.getString("hb.invalid_topic_id"));
                if (frame != null) {
                    new MWAlert(frame, sRes.getString("hb.helpbrowser"), string4, 1);
                    return;
                }
                System.out.println(string4);
                return;
            }
            Object[] objectArray = new Object[]{file.getName()};
            String string5 = HelpBrowser.getMessage(objectArray, sRes.getString("hb.invalid_map_path"));
            if (frame != null) {
                new MWAlert(frame, sRes.getString("hb.helpbrowser"), string5, 1);
                return;
            }
            System.out.println(string5);
            return;
        }
        HelpBrowser.showHelpErrPage();
    }

    public void displayTopic(String string, File file, String string2) {
        this.displayTopic(string, file, string2, null);
    }

    public void displayTopic(String string, String string2, String string3, Frame frame) {
        File file = new File(String.valueOf(HelpPrefs.getDocRoot()) + "/mapfiles/" + string2 + ".map");
        this.displayTopic(string, file, string3, frame);
    }

    public void displayTopic(String string, String string2, String string3) {
        this.displayTopic(string, string2, string3, null);
    }

    public static void showHelpErrPage() {
        HelpBrowser.getHelpBrowser().setCurrentLocation(String.valueOf(Matlab.matlabRoot()) + "/toolbox/local/helperr.html");
    }

    public String getCurrentLocation() {
        return this.fIceContainer.getCurrentLocation();
    }

    public void requestFocus() {
        this.fIceContainer.requestFocus();
    }

    public void doCommand(int n) {
        boolean bl = true;
        if (this.fCenter.getCommandEnabled(n)) {
            switch (n) {
                case 910: {
                    this.fIceContainer.doCopy();
                    return;
                }
                case -103: {
                    this.fFrame.setVisible(false);
                    return;
                }
                case 44: {
                    PrefsDialog.showPrefsDialog(sPrefsRes.getString("area.help"));
                    return;
                }
                case 4: {
                    this.fIceContainer.doEvalSelection();
                    return;
                }
                case 5: {
                    this.fIceContainer.doOpenSelection();
                    return;
                }
                case 6: {
                    this.fIceContainer.doHelpOnSelection();
                    return;
                }
                case 2245: 
                case 2246: {
                    this.showNavigator(!this.fNavigatorShowing, false);
                    return;
                }
                case 550: {
                    this.fIceContainer.doPrint();
                    return;
                }
                case 2250: {
                    this.fIceContainer.viewSource();
                    return;
                }
                case 1: {
                    this.fIceContainer.goBack();
                    return;
                }
                case 2: {
                    this.fIceContainer.goForward();
                    return;
                }
                case 3: {
                    this.fIceContainer.reload();
                    return;
                }
            }
            bl = false;
            return;
        }
    }

    public boolean isNavigatorShowing() {
        return this.fNavigatorShowing;
    }

    public void showNavigator(boolean bl, boolean bl2) {
        if (bl) {
            if (!bl2) {
                ((Container)((Object)this)).remove((Component)((Object)this.fIceContainer));
            }
            this.addTopLevelPanels();
            ((Container)((Object)this)).validate();
            if (!bl2 && !this.fNavigatorInitialized) {
                this.loadNavigatorData(false, false);
            }
            this.fNavigatorShowing = true;
            this.fIceContainer.removeShowNavigatorToolbarIcon();
            if (!bl2 && this.getSelectedTabName().equals(sContentsTabName)) {
                this.fContentsPanel.setIsShowing(true);
                this.fContentsPanel.syncContentsTree(this.fIceContainer.getCurrentFilename());
            }
        } else {
            this.fContentsPanel.setIsShowing(false);
            if (!bl2 && this.fNavigatorShowing) {
                ((Container)((Object)this)).remove((Component)this.fSplitter);
            }
            ((Container)((Object)this)).add((Component)this.fIceBrowserPanel);
            ((Container)((Object)this)).validate();
            this.fNavigatorShowing = false;
            this.fIceContainer.addShowNavigatorToolbarIcon();
        }
        this.fMenubar.setShowingHelpNavigator(this.fNavigatorShowing);
        Prefs.setBooleanPref((String)"HelpShowNavigator", (boolean)this.fNavigatorShowing);
    }

    public boolean isDocrootValid() {
        String string = StringUtils.fromJavaPath((String)(String.valueOf(this.fDocRoot) + "/toolbox"));
        String string2 = StringUtils.fromJavaPath((String)(String.valueOf(this.fDocRoot) + "/techdoc/ref"));
        File file = new File(string);
        File file2 = new File(string2);
        return file.exists() || file2.exists();
    }

    private void validateDocRoot() {
        MWFrame mWFrame;
        boolean bl = this.isDocrootValid();
        this.setupTabPanels(bl && this.areAnyProductsSelected());
        this.enableProductFilter(bl);
        if (!bl && Prefs.getIntegerPref((String)"HelpDocSourceType") == 1 && (mWFrame = (MWFrame)this.getFrame()) != null) {
            MWAlert mWAlert = new MWAlert((Frame)mWFrame, sHelpBrowserName, sRes.getString("alert.insert_cd_message"), 8);
            int n = mWAlert.getReply();
            if (n == 3) {
                this.validateDocRoot();
                return;
            }
            if (n == 2) {
                PrefsDialog.showPrefsDialog(sPrefsRes.getString("area.help"));
                return;
            }
        }
    }

    private void setupTabPanels(boolean bl) {
        if (!bl) {
            if (this.fValidDocroot) {
                this.fTabPanel.removePanel(sRes.getString("hb.tab.index"));
                this.fTabPanel.removePanel(sRes.getString("hb.tab.search"));
            }
            if (this.fFirstTime) {
                this.fTabPanel.addPanel(sRes.getString("hb.tab.favorites"), (Component)((Object)this.fFavoritesPanel));
                this.fFirstTime = false;
            }
            this.fTabPanel.selectPanel(sContentsTabName);
            this.fContentsPanel.setIsShowing(true);
        } else if (!this.fValidDocroot) {
            String string;
            if (!this.fFirstTime) {
                this.fTabPanel.removePanel(sRes.getString("hb.tab.favorites"));
            }
            this.fTabPanel.addPanel(sRes.getString("hb.tab.index"), (Component)((Object)this.fIndexPanel));
            this.fTabPanel.addPanel(sRes.getString("hb.tab.search"), (Component)((Object)this.fSearchPanel));
            this.fTabPanel.addPanel(sRes.getString("hb.tab.favorites"), (Component)((Object)this.fFavoritesPanel));
            String string2 = string = sContentsTabName;
            if (this.fFirstTime) {
                string2 = Prefs.getStringPref((String)"HelpForwardTab", (String)string2);
            }
            if (string2.equals(string)) {
                this.fContentsPanel.setIsShowing(true);
            }
            this.fTabPanel.selectPanel(string2);
            this.fFirstTime = false;
        }
        this.fValidDocroot = bl;
        this.fTabPanel.invalidate();
        ((Container)((Object)this)).validate();
    }

    private boolean areAnyProductsSelected() {
        String[] stringArray;
        boolean bl = true;
        if (!this.fAllProductsCheckbox.getState() && (stringArray = HelpPrefs.getDirectoryPrefs(Prefs.getStringPref((String)"HelpSelectedProducts"))).length == 1 && stringArray[0].equals("")) {
            bl = false;
        }
        return bl;
    }

    private void filtersChanged() {
        if (this.isDocrootValid()) {
            FilterChangedThread filterChangedThread = new FilterChangedThread();
            filterChangedThread.start();
        }
    }

    public void enableProductFilter(boolean bl) {
        this.fAllProductsCheckbox.setEnabled(bl);
        this.fSelectedProductsCheckbox.setEnabled(bl);
        this.fFilterButton.setEnabled(bl);
    }

    private void addTopLevelPanels() {
        this.fSplitter = new MWSplitter((Component)this.fNavigatorPanel, (Component)this.fIceBrowserPanel, 0);
        this.fSplitter.setDividerLocation(0.34);
        ((Container)((Object)this)).add((Component)this.fSplitter, "Center");
    }

    private void setDocRoot() {
        this.fDocRoot = HelpPrefs.getDocRoot();
        if (this.fDocRoot != null && !this.fDocRoot.equals("")) {
            this.fDocRootForBrowser = this.fDocRoot.replace('\\', '/');
        }
    }

    public static void addEntryToFavorites(String string) {
        if (sHelpBrowser == null) {
            new HelpBrowser();
        }
        HelpBrowser.sHelpBrowser.fFavoritesPanel.addEntry(HelpBrowser.sHelpBrowser.fIceContainer, string);
    }

    public static void addEntryToFavorites(String string, String string2) {
        if (sHelpBrowser == null) {
            new HelpBrowser();
        }
        HelpBrowser.sHelpBrowser.fFavoritesPanel.addEntry(string, string2);
    }

    static String getMessage(Object[] objectArray, String string) {
        MessageFormat messageFormat = new MessageFormat("");
        messageFormat.setLocale(Locale.getDefault());
        messageFormat.applyPattern(string);
        return messageFormat.format(objectArray);
    }

    public String getDocRoot() {
        return this.fDocRoot;
    }

    public String getDocRootForBrowser() {
        return this.fDocRootForBrowser;
    }

    public void restoreState(DataInputStream dataInputStream) {
    }

    public void saveState(DataOutputStream dataOutputStream) {
        Prefs.setStringPref((String)"HelpForwardTab", (String)this.fTabPanel.getPanelName(this.fTabPanel.getSelectedIndex()));
    }

    public String getSplayConstraint() {
        return "";
    }

    public int getApplicationType() {
        return 1;
    }

    public MWMenuBar mergeMenus(MWMenuBar mWMenuBar) {
        return this.fMenubar.mergeMenus(mWMenuBar);
    }

    public int desktopSaveAction() {
        return 1;
    }

    public void setActive(boolean bl) {
    }

    public int closeWindow() {
        this.fFrame.setVisible(false);
        if (this.fDesktop == null) {
            Prefs.setStringPref((String)"HelpForwardTab", (String)this.fTabPanel.getPanelName(this.fTabPanel.getSelectedIndex()));
            return 1;
        }
        return 0;
    }

    public String getShortName() {
        return sHelpBrowserName;
    }

    public String getLongName() {
        return sHelpBrowserName;
    }

    static /* synthetic */ boolean access$12(HelpBrowser helpBrowser) {
        return helpBrowser.fNavigatorInitialized;
    }

    static {
        fSeparator = PlatformInfo.getPlatform() == 2 ? "/" : "\\";
        sMatlabRoot = Matlab.matlabRoot();
        sRes = ResourceBundle.getBundle("com.mathworks.ide.help.resources.RES_HelpBrowser");
        sPrefsRes = ResourceBundle.getBundle("com.mathworks.ide.prefs.resources.RES_Prefs");
        sHelpBrowserName = sRes.getString("hb.helpbrowser");
        sInvalidDocroot = sRes.getString("hb.invalid_docroot");
        sContentsTabName = sRes.getString("hb.tab.contents");
    }

    private class FilterCheckboxItemListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            Prefs.setBooleanPref((String)"HelpSearchShowAllProducts", (boolean)HelpBrowser.this.fAllProductsCheckbox.getState());
            HelpBrowser.this.filtersChanged();
        }

        FilterCheckboxItemListener() {
            HelpBrowser.this = HelpBrowser.this;
        }
    }

    private class FilterChangedThread
    extends Thread {
        private boolean fDocRootChanged;

        FilterChangedThread() {
            HelpBrowser.this = HelpBrowser.this;
        }

        public void run() {
            HelpBrowser.this.loadingDataBeginning();
            boolean bl = HelpBrowser.this.areAnyProductsSelected();
            HelpBrowser.this.setupTabPanels(HelpBrowser.this.isDocrootValid() && bl);
            boolean bl2 = HelpBrowser.this.fAllProductsCheckbox.getState();
            HelpBrowser.this.fContentsPanel.filterChanged(bl2, bl);
            if (bl) {
                HelpBrowser.this.fIndexPanel.filterChanged(bl2);
                HelpBrowser.this.fSearchPanel.filterChanged(bl2);
            }
        }
    }

    private class TabItemListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            HelpBrowser.this.setStatusTextToDefault();
            if (HelpBrowser.this.fTabPanel.getPanelName(HelpBrowser.this.fTabPanel.getSelectedIndex()).equals(sContentsTabName)) {
                HelpBrowser.this.fContentsPanel.setIsShowing(true);
                HelpBrowser.this.fContentsPanel.syncContentsTree(HelpBrowser.this.fIceContainer.getCurrentFilename());
                return;
            }
            HelpBrowser.this.fContentsPanel.setIsShowing(false);
        }

        TabItemListener() {
            HelpBrowser.this = HelpBrowser.this;
        }
    }

    private class FilterButtonActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            PrefsDialog.showPrefsDialog(sPrefsRes.getString("area.help"));
        }

        FilterButtonActionListener() {
            HelpBrowser.this = HelpBrowser.this;
        }
    }

    private class HelpPrefListener
    implements PrefListener {
        public void prefChanged(PrefEvent prefEvent) {
            String string = prefEvent.getPrefKey();
            if (string.equals("HelpDocRoot")) {
                HelpBrowser.this.setDocRoot();
                HelpBrowser.this.fNavigatorInitialized = false;
                HelpBrowser.this.loadNavigatorData(true, true);
                return;
            }
            if (string.equals("HelpSelectedProducts") && !HelpBrowser.this.fAllProductsCheckbox.getState()) {
                HelpBrowser.this.filtersChanged();
            }
        }

        HelpPrefListener() {
            HelpBrowser.this = HelpBrowser.this;
        }
    }

    private class MyButton
    extends MWButton {
        public MyButton(String string) {
            super(string);
            HelpBrowser.this = HelpBrowser.this;
        }

        public Dimension getPreferredSize() {
            Dimension dimension = this.getMinimumSize();
            return dimension;
        }
    }

    private class HelpNavigatorTitleBar
    extends MWGroupbox {
        public HelpNavigatorTitleBar(String string, MWCommandCenter mWCommandCenter, int n, boolean bl) {
            HelpBrowser.this = HelpBrowser.this;
            ((Container)((Object)this)).setLayout(new BorderLayout());
            this.setMargins(new Insets(2, 4, 2, 2));
            MWPanel mWPanel = new MWPanel((LayoutManager)new BorderLayout());
            ((Container)((Object)this)).add((Component)mWPanel, "Center");
            MWLabel mWLabel = new MWLabel(string);
            mWPanel.add((Component)mWLabel, "Center");
            mWPanel.add((Component)new MWCloseBox(mWCommandCenter, n), "East");
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            dimension.height = 22;
            return dimension;
        }
    }
}

