/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.help;

import com.mathworks.ide.help.Favorites;
import com.mathworks.ide.help.HelpBrowser;
import com.mathworks.ide.help.HelpFontPrefs;
import com.mathworks.ide.help.HelpPrefs;
import com.mathworks.ide.help.ICEBrowserContainer;
import com.mathworks.mwt.MWListbox;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.MWTextField;
import com.mathworks.mwt.table.LabeledImageResource;
import com.mathworks.mwt.table.TableAdapter;
import com.mathworks.mwt.table.TableEvent;
import com.mathworks.mwt.table.TableListener;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.ResLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.PopupMenu;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class Favorites
extends MWPanel {
    private HelpBrowser fParent;
    private MWListbox fFavoritesList;
    private PopupMenu fFavoritesListPopupMenu;
    private int fNextID;
    private ResLoader resources = new ResLoader((Component)((Object)this));
    private Image fIcon;
    private String fDocRoot;
    private MWTextField fSearchField;
    private int fStartSearchAtItem = -2;
    private String fSearchString = "";
    private String fHelpFile;

    public Favorites(HelpBrowser helpBrowser) {
        this.fParent = helpBrowser;
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.fIcon = this.resources.loadImage("/com/mathworks/mwt/resources/htmlicon.gif");
        this.fFavoritesList = new MWListbox();
        this.fFavoritesList.setColumnCount(2);
        this.fFavoritesList.setMultiSelection(true);
        this.fFavoritesList.getColumnOptions().setResizable(false);
        this.fFavoritesList.setResizeZeroWidthColumns(false);
        this.fFavoritesList.setColumnWidth(0, 150);
        this.fFavoritesList.setAutoExpandColumn(0);
        this.fFavoritesList.setColumnWidth(1, 0);
        this.fFavoritesList.setEditable(false);
        this.fFavoritesList.setName("Favorites");
        this.fFavoritesList.setContextTriggerAware(true);
        ((Container)((Object)this)).add((Component)this.fFavoritesList, "Center");
        this.fFavoritesList.addMouseListener(new FavoritesListMouseListener());
        this.fFavoritesList.addItemListener((ItemListener)new FavoritesListItemListener());
        this.fFavoritesList.addKeyListener(new FavoritesListKeyListener());
        this.fFavoritesList.addTableListener((TableListener)new FavoritesValueListener());
        this.setFont();
        HelpPrefs.addFontListeners(new FontChangeListener());
        this.fFavoritesListPopupMenu = new FavoritesListPopupMenu();
        this.fFavoritesList.add(this.fFavoritesListPopupMenu);
        this.fHelpFile = String.valueOf(Prefs.getPropertyDirectory()) + HelpBrowser.fSeparator + "matlab_help.hst";
        File file = new File(this.fHelpFile);
        if (file.exists()) {
            this.loadFavorites();
        } else {
            Object[] objectArray = new String[]{HelpBrowser.sRes.getString("favorites.tech_support_entry"), "http://www.mathworks.com/support"};
            this.fFavoritesList.addItem(objectArray);
            this.fFavoritesList.setCellData(this.fFavoritesList.getItemCount() - 1, 0, (Object)new LabeledImageResource(this.fIcon, (String)objectArray[0]));
        }
        this.resources.waitForPendingImages();
        ((Component)((Object)this)).repaint();
    }

    public Dimension getPreferredSize() {
        return new Dimension(10, 10);
    }

    private void setFont() {
        this.fFavoritesList.setFont(HelpFontPrefs.getHelpNavigatorFont());
        this.fFavoritesList.repaint();
    }

    public void addEntry(ICEBrowserContainer iCEBrowserContainer, String string) {
        this.addEntry(iCEBrowserContainer.getPageTitle(string), string);
    }

    public void addEntry(String string, String string2) {
        Object[] objectArray = new String[]{string, string2};
        this.fFavoritesList.addItem(objectArray);
        this.fFavoritesList.setCellData(this.fFavoritesList.getItemCount() - 1, 0, (Object)new LabeledImageResource(this.fIcon, (String)objectArray[0]));
        Object[] objectArray2 = new Object[]{objectArray[0]};
        String string3 = HelpBrowser.getMessage(objectArray2, HelpBrowser.sRes.getString("favorites.status_message"));
        this.setStatusText(string3);
        this.saveFavorites();
    }

    private void setStatusText(String string) {
        if (this.fParent != null) {
            this.fParent.setStatusText(string);
        }
    }

    public void loadFavorites() {
        BufferedReader bufferedReader = null;
        FileReader fileReader = null;
        String string = null;
        try {
            fileReader = new FileReader(this.fHelpFile);
            bufferedReader = new BufferedReader(fileReader);
        }
        catch (FileNotFoundException fileNotFoundException) {}
        if (bufferedReader != null) {
            try {
                while ((string = bufferedReader.readLine()) != null) {
                    int n = string.lastIndexOf("::");
                    if (n == -1) {
                        n = string.length();
                    }
                    Object[] objectArray = new String[]{string.substring(0, n), ""};
                    if (n < string.length()) {
                        objectArray[1] = string.substring(n + 2);
                    }
                    this.fFavoritesList.addItem(objectArray);
                    this.fFavoritesList.setCellData(this.fFavoritesList.getItemCount() - 1, 0, (Object)new LabeledImageResource(this.fIcon, (String)objectArray[0]));
                }
                bufferedReader.close();
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }
    }

    public void saveFavorites() {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(this.fHelpFile));
            if (bufferedWriter != null) {
                int n = 0;
                while (n < this.fFavoritesList.getItemCount()) {
                    bufferedWriter.write(String.valueOf(this.fFavoritesList.getItem(n, 0)) + "::" + this.fFavoritesList.getItem(n, 1) + "\n");
                    ++n;
                }
                bufferedWriter.close();
                return;
            }
        }
        catch (IOException iOException) {}
    }

    private void sendSelectedFileToBrowser() {
        int n = this.fFavoritesList.getSelectedIndex();
        if (n != -2) {
            String string = this.fFavoritesList.getItem(n, 0);
            String string2 = this.fFavoritesList.getItem(n, 1);
            if (string2.startsWith("matlab:")) {
                this.fParent.getIceBrowser().evalCommandInMatlab(string2.substring(7));
                return;
            }
            this.fParent.getIceBrowser().setCurrentLocation(string, string2);
        }
    }

    private void deleteFavorites() {
        int[] nArray = this.fFavoritesList.getSelectedIndexes();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            this.fFavoritesList.removeItem(n3);
            this.fFavoritesList.deselectAll();
            int[] nArray2 = new int[n - n2 - 1];
            int n4 = 0;
            int n5 = n2 + 1;
            while (n5 < n) {
                if (nArray[n5] > n3) {
                    int n6 = n5;
                    nArray[n6] = nArray[n6] - 1;
                }
                nArray2[n4++] = nArray[n5];
                ++n5;
            }
            this.fFavoritesList.setSelectedIndexes(nArray2);
            ++n2;
        }
        this.saveFavorites();
        this.sendSelectedFileToBrowser();
    }

    private void renameFavorite() {
        int n = this.fFavoritesList.getFirstSelectedRow();
        if (n != -2) {
            this.fFavoritesList.setEditable(true);
            this.fFavoritesList.getCell(n, 0).beginEdit(n, 0);
        }
    }

    static /* synthetic */ void access$3(Favorites favorites) {
        favorites.renameFavorite();
    }

    private class FontChangeListener
    implements PrefListener {
        public void prefChanged(PrefEvent prefEvent) {
            if (prefEvent.getEventType() == 1) {
                String string = prefEvent.getPrefKey();
                if (string.equals("HelpNavigatorFont") || string.equals("HelpUseDesktopFont")) {
                    Favorites.this.setFont();
                    return;
                }
                if (string.equals("GeneralFont") && HelpFontPrefs.getUseDesktopFont()) {
                    Favorites.this.setFont();
                }
            }
        }

        FontChangeListener() {
            Favorites.this = Favorites.this;
        }
    }

    private class FavoritesListMouseListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            if (PlatformInfo.getPlatform() == 2) {
                this.doStuff(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (PlatformInfo.getPlatform() != 2) {
                this.doStuff(mouseEvent);
            }
        }

        public void doStuff(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                int[] nArray = Favorites.this.fFavoritesList.getSelectedIndexes();
                if (nArray.length != 1) {
                    Favorites.this.fFavoritesListPopupMenu.getItem(0).setEnabled(false);
                } else {
                    Favorites.this.fFavoritesListPopupMenu.getItem(0).setEnabled(true);
                }
                if (Favorites.this.fFavoritesList.getSelectedIndex() != -2) {
                    Favorites.this.fFavoritesListPopupMenu.show((Component)Favorites.this.fFavoritesList, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }

        FavoritesListMouseListener() {
            Favorites.this = Favorites.this;
        }
    }

    private class FavoritesValueListener
    extends TableAdapter {
        public void editCommitted(TableEvent tableEvent) {
            Favorites.this.saveFavorites();
            Favorites.this.fFavoritesList.setEditable(false);
        }

        public void editCancelled(TableEvent tableEvent) {
            Favorites.this.fFavoritesList.setEditable(false);
        }

        FavoritesValueListener() {
            Favorites.this = Favorites.this;
        }
    }

    private class FavoritesListPopupMenu
    extends PopupMenu {
        public FavoritesListPopupMenu() {
            Favorites.this = Favorites.this;
            this.add("Rename");
            this.addSeparator();
            this.add("Delete");
            this.addActionListener(new 1(this));
        }

        static /* synthetic */ Favorites access$0(FavoritesListPopupMenu favoritesListPopupMenu) {
            return favoritesListPopupMenu.Favorites.this;
        }
    }

    private class FavoritesListKeyListener
    extends KeyAdapter {
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 127) {
                Favorites.this.deleteFavorites();
            }
        }

        FavoritesListKeyListener() {
            Favorites.this = Favorites.this;
        }
    }

    private class FavoritesListItemListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            Favorites.this.sendSelectedFileToBrowser();
        }

        FavoritesListItemListener() {
            Favorites.this = Favorites.this;
        }
    }
}

