/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.help;

import com.mathworks.ide.help.DBBTree;
import com.mathworks.ide.help.DBBTreeNode;
import java.io.IOException;

class DBBTreePage {
    DBBTree dbFile;
    protected byte[] rawPage;

    byte[] getRawPage() {
        return this.rawPage;
    }

    public int getFlags() {
        return this.dbFile.bytesToInt(this.rawPage, 12);
    }

    boolean isBTree() {
        return (this.getFlags() & 3) != 0;
    }

    boolean isLeaf() {
        return (this.getFlags() & 0x12) != 0;
    }

    boolean isOverflow() {
        return (this.getFlags() & 4) != 0;
    }

    public short getLower() {
        return this.dbFile.bytesToShort(this.rawPage, 16);
    }

    protected short lastOffset() {
        return (short)((this.getLower() - 20) / 2);
    }

    public DBBTreePage(DBBTree dBBTree, byte[] byArray) {
        this.dbFile = dBBTree;
        this.rawPage = byArray;
        this.isBTree();
    }

    public DBBTreeNode getNodeBTree(int n) throws IndexOutOfBoundsException {
        if (this.isOverflow()) {
            System.err.println("*** Internal failure: request for offset on overflow page");
            throw new IndexOutOfBoundsException();
        }
        int n2 = 20 + 2 * n;
        if (n2 >= this.getLower()) {
            System.err.println("*** Internal failure: request for node that doesn't exist");
            throw new IndexOutOfBoundsException();
        }
        short s = this.dbFile.bytesToShort(this.rawPage, n2);
        return new DBBTreeNode(this, s);
    }

    public byte[] search(byte[] byArray) throws IOException {
        Object object;
        int n = 0;
        int n2 = this.lastOffset() - 1;
        while (n2 > n) {
            int n3 = (n + n2) / 2;
            object = this.getNodeBTree(n3);
            int n4 = ((DBBTreeNode)object).compareTo(byArray);
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            if (n4 < 0) {
                n = n3;
                if (this.isLeaf()) {
                    ++n;
                    continue;
                }
                if (n2 - n != 1) continue;
                DBBTreeNode dBBTreeNode = this.getNodeBTree(n2);
                if (dBBTreeNode.compareTo(byArray) > 0) {
                    DBBTreePage dBBTreePage = this.dbFile.readPage(((DBBTreeNode)object).getPageNumber());
                    return dBBTreePage.search(byArray);
                }
                DBBTreePage dBBTreePage = this.dbFile.readPage(dBBTreeNode.getPageNumber());
                return dBBTreePage.search(byArray);
            }
            if (this.isLeaf()) {
                return ((DBBTreeNode)object).dataAsBytes();
            }
            DBBTreePage dBBTreePage = this.dbFile.readPage(((DBBTreeNode)object).getPageNumber());
            return dBBTreePage.search(byArray);
        }
        DBBTreeNode dBBTreeNode = this.getNodeBTree(n);
        if (this.isLeaf()) {
            if (dBBTreeNode.compareTo(byArray) == 0) {
                return dBBTreeNode.dataAsBytes();
            }
            return null;
        }
        object = this.dbFile.readPage(dBBTreeNode.getPageNumber());
        return ((DBBTreePage)object).search(byArray);
    }
}

