/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.help;

import com.mathworks.ide.help.DBBTree;
import com.mathworks.ide.help.DBBTreePage;

class DBBTreeNode {
    private DBBTree dbFile;
    private DBBTreePage sourcePage;
    private int nodeOffset;
    private int keyLength;
    private int pageNumber;
    private byte flags;
    private short[] key;

    int getPageNumber() {
        return this.pageNumber;
    }

    boolean isOverflowKey() {
        return (this.flags & 2) != 0;
    }

    boolean isOverflowData() {
        return (this.flags & 1) != 0;
    }

    public DBBTreeNode(DBBTreePage dBBTreePage, int n) {
        byte[] byArray = dBBTreePage.getRawPage();
        this.dbFile = dBBTreePage.dbFile;
        this.sourcePage = dBBTreePage;
        this.nodeOffset = n;
        this.keyLength = this.dbFile.bytesToInt(byArray, n);
        this.pageNumber = this.dbFile.bytesToInt(byArray, n + 4);
        this.flags = byArray[n + 8];
    }

    private void getKey() {
        int n = this.nodeOffset + 9;
        byte[] byArray = this.sourcePage.getRawPage();
        this.key = new short[this.keyLength];
        int n2 = 0;
        while (n2 < this.keyLength) {
            this.key[n2] = (short)(byArray[n + n2] & 0xFF);
            ++n2;
        }
    }

    int compareTo(byte[] byArray) {
        int n = 0;
        if (this.key == null) {
            this.getKey();
        }
        while (n < byArray.length && n < this.keyLength) {
            short s = (short)(byArray[n] & 0xFF);
            if (s < this.key[n]) {
                return 1;
            }
            if (s > this.key[n]) {
                return -1;
            }
            ++n;
        }
        if (n < byArray.length) {
            return -1;
        }
        if (n < this.keyLength) {
            return 1;
        }
        return 0;
    }

    public byte[] keyAsBytes() {
        if (!this.isOverflowKey()) {
            byte[] byArray = new byte[this.keyLength];
            System.arraycopy(this.sourcePage.getRawPage(), this.nodeOffset + 9, byArray, 0, this.keyLength);
            return byArray;
        }
        System.err.println("*** Overflow keys not yet supported");
        return null;
    }

    public byte[] dataAsBytes() {
        if (!this.isOverflowData()) {
            byte[] byArray = new byte[this.pageNumber];
            System.arraycopy(this.sourcePage.getRawPage(), this.nodeOffset + 9 + this.keyLength, byArray, 0, this.pageNumber);
            return byArray;
        }
        System.err.println("*** Overflow data not yet supported");
        return null;
    }
}

