/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.help;

import com.mathworks.ide.help.DBBTreePage;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class DBBTree {
    protected RandomAccessFile file;
    protected File fileName;
    private int pageSize;
    private boolean msbFirst;
    int[] cachePageNumbers;
    byte[][] cachePages;

    public String getFilename() {
        return this.fileName.getAbsolutePath();
    }

    public RandomAccessFile getFile() {
        return this.file;
    }

    public void close() {
        if (this.file == null) {
            return;
        }
        try {
            this.file.close();
        }
        catch (Exception exception) {
            System.err.println("File close on " + this.fileName + " failed: " + exception);
        }
        this.file = null;
    }

    public void open() throws IOException {
        try {
            if (this.file == null) {
                this.file = new RandomAccessFile(this.fileName, "r");
                return;
            }
        }
        catch (SecurityException securityException) {
            throw new IOException("Wrong permissions for " + this.fileName + ": " + securityException);
        }
        catch (IOException iOException) {
            throw new IOException("file open failed: " + iOException);
        }
    }

    public DBBTree(String string) throws IOException {
        this(new File(string));
    }

    public DBBTree(File file) throws IOException {
        this.fileName = file;
        try {
            this.file = new RandomAccessFile(file, "r");
        }
        catch (SecurityException securityException) {
            throw new IOException("Wrong permissions for " + file + ": " + securityException);
        }
        catch (IOException iOException) {
            throw new IOException("file open failed: " + iOException);
        }
        this.pageSize = 256;
        byte[] byArray = this.readRawPage(0);
        this.msbFirst = true;
        int n = this.bytesToInt(byArray, 0);
        if (n != 340322) {
            this.msbFirst = false;
            n = this.bytesToInt(byArray, 0);
        }
        int n2 = this.bytesToInt(byArray, 4);
        if (n != 340322 || n2 != 3) {
            throw new IOException("Not a DB file (magic: 0x" + Integer.toHexString(n) + ", version: " + Integer.toString(n2) + ")");
        }
        this.pageSize = this.bytesToInt(byArray, 8);
        this.setCacheSize(8);
        this.primeCache();
    }

    public byte[] search(byte[] byArray) throws IOException {
        return this.readPage(1).search(byArray);
    }

    protected byte[] readRawPage(int n) throws IOException {
        try {
            byte[] byArray = new byte[this.pageSize];
            this.file.seek(n * this.pageSize);
            this.file.read(byArray);
            return byArray;
        }
        catch (IOException iOException) {
            throw new IOException("readRawPage(" + n + ") failed: " + iOException);
        }
    }

    public void setCacheSize(int n) {
        int n2;
        int[] nArray = new int[n];
        if (this.cachePageNumbers != null) {
            n2 = 0;
            while (n2 < n && n2 < this.cachePageNumbers.length) {
                nArray[n2] = this.cachePageNumbers[n2];
                ++n2;
            }
        } else {
            n2 = 0;
            while (n2 < n) {
                nArray[n2] = 0;
                ++n2;
            }
        }
        this.cachePageNumbers = nArray;
        byte[][] byArray = new byte[n][];
        if (this.cachePages != null) {
            int n3 = 0;
            while (n3 < n && n3 < this.cachePages.length) {
                byArray[n3] = this.cachePages[n3];
                ++n3;
            }
        }
        this.cachePages = byArray;
    }

    public void primeCache() throws IOException {
        int n = 1;
        while (this.cachePageNumbers[this.cachePageNumbers.length - 1] == 0) {
            this.readPage(n);
            ++n;
        }
    }

    DBBTreePage readPage(int n) throws IOException {
        int n2 = 0;
        while (n2 < this.cachePageNumbers.length) {
            if (this.cachePageNumbers[n2] == n) {
                byte[] byArray = this.cachePages[n2];
                if (n2 > 0) {
                    System.arraycopy(this.cachePageNumbers, 0, this.cachePageNumbers, 1, n2);
                    System.arraycopy(this.cachePages, 0, this.cachePages, 1, n2);
                    this.cachePageNumbers[0] = n;
                    this.cachePages[0] = byArray;
                }
                return new DBBTreePage(this, byArray);
            }
            ++n2;
        }
        byte[] byArray = this.readRawPage(n);
        System.arraycopy(this.cachePageNumbers, 0, this.cachePageNumbers, 1, this.cachePageNumbers.length - 1);
        System.arraycopy(this.cachePages, 0, this.cachePages, 1, this.cachePages.length - 1);
        this.cachePageNumbers[0] = n;
        this.cachePages[0] = byArray;
        return new DBBTreePage(this, byArray);
    }

    int bytesToInt(byte[] byArray, int n) {
        if (this.msbFirst) {
            return 0x1000000 * (byArray[n] & 0xFF) + 65536 * (byArray[n + 1] & 0xFF) + 256 * (byArray[n + 2] & 0xFF) + (byArray[n + 3] & 0xFF);
        }
        return (byArray[n] & 0xFF) + 256 * (byArray[n + 1] & 0xFF) + 65536 * (byArray[n + 2] & 0xFF) + 0x1000000 * (byArray[n + 3] & 0xFF);
    }

    short bytesToShort(byte[] byArray, int n) {
        if (this.msbFirst) {
            return (short)(256 * ((short)byArray[n] & 0xFF) + ((short)byArray[n + 1] & 0xFF));
        }
        return (short)(((short)byArray[n] & 0xFF) + 256 * ((short)byArray[n + 1] & 0xFF));
    }
}

