/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.help;

import com.mathworks.ide.help.ContentsTree;
import com.mathworks.ide.help.HelpBrowser;
import com.mathworks.ide.help.HelpFontPrefs;
import com.mathworks.ide.help.HelpPrefs;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwt.MWLabel;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.MWTList;
import com.mathworks.mwt.MWTListEvent;
import com.mathworks.mwt.MWTListListener;
import com.mathworks.mwt.MWTextField;
import com.mathworks.mwt.dialog.MWAlert;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.QueueEvent;
import com.mathworks.util.ResLoader;
import com.mathworks.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Image;
import java.awt.PopupMenu;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;

public class ContentsTree
extends MWPanel {
    private HelpBrowser fParent;
    private MWTList fContentsList = new MWTList(true, true);
    private MWTList fHiddenList = new MWTList(false, true, 4);
    private PopupMenu fContentsListPopupMenu;
    private int fNextID;
    private ResLoader resources = new ResLoader((Component)((Object)this));
    private Image fHtmlIcon;
    private Image fBookIcon;
    private Image fMissingIcon;
    private String fDocRoot;
    private MWTextField fSearchField;
    private String fSearchString = "";
    private MWPanel fNorthPanel;
    private Vector fSyncLookupTable = new Vector();
    private boolean fIsShowing = false;
    private SyncContentsTreeThread fSyncThread;
    private LoadDataThread fLoadDataThread;
    private boolean fSearchAllProducts = HelpPrefs.areAllProductsSelected();
    private boolean fAnyProductsSelected;
    private boolean fStopRequested;
    private MWLabel fWaitMsgLabel;

    public ContentsTree(HelpBrowser helpBrowser) {
        this.fParent = helpBrowser;
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.fHtmlIcon = this.resources.loadImage("/com/mathworks/mwt/resources/htmlicon.gif");
        this.fBookIcon = this.resources.loadImage("/com/mathworks/ide/help/resources/book.gif");
        this.fMissingIcon = this.resources.loadImage("/com/mathworks/mwt/resources/help.gif");
        this.fContentsList.setWholeItemSelect(true);
        this.fContentsList.setDrawColumnLines(false);
        this.fContentsList.addMWTListListener((MWTListListener)new fContentsListMWTListListener());
        this.fContentsList.addMouseListener(new ContentsListMouseListener());
        this.fContentsList.addItemListener((ItemListener)new HitListItemListener());
        this.fContentsList.addKeyListener(new HitListKeyListener());
        this.fContentsListPopupMenu = new ContentsListPopupMenu();
        this.fContentsList.add(this.fContentsListPopupMenu);
        this.fContentsList.setName("Contents");
        this.setFont();
        HelpPrefs.addFontListeners(new HelpPrefsListener());
    }

    public void loadData(boolean bl, boolean bl2, boolean bl3) {
        this.removeAndLoadNewData(true, bl, bl2, bl3);
    }

    public void resetDocRoot(String string, boolean bl) {
        this.fDocRoot = string;
        this.fAnyProductsSelected = bl;
        this.removeAndLoadNewData(false, this.fSearchAllProducts, this.fAnyProductsSelected, true);
    }

    public void filterChanged(boolean bl, boolean bl2) {
        boolean bl3 = false;
        if (this.fAnyProductsSelected != bl2) {
            bl3 = true;
        }
        this.removeAndLoadNewData(false, bl, bl2, bl3);
    }

    private void removeAndLoadNewData(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.stopLoadContentsThread();
        this.fSearchAllProducts = bl2;
        this.fAnyProductsSelected = bl3;
        this.removeData(bl);
        if (this.fParent.isDocrootValid() && !bl3) {
            this.fContentsList.add(-1, this.fNextID, HelpBrowser.sRes.getString("contents.no_products_selected"), this.resources.loadImage("/com/mathworks/mwt/resources/alerticon.gif"), false);
            if (bl4) {
                this.fContentsList.selectItem(this.fNextID);
            }
            String[] stringArray = new String[]{"", "", "", ""};
            this.fHiddenList.add(-1, this.fNextID++, stringArray, null, false);
        }
        this.stopLoadContentsThread();
        this.fLoadDataThread = new LoadDataThread(bl4);
        this.fLoadDataThread.start();
    }

    private void removeData(boolean bl) {
        if (bl) {
            this.clearLists();
            this.fWaitMsgLabel = new MWLabel(HelpBrowser.sRes.getString("contents.loading_contents"), 1);
            this.fWaitMsgLabel.setFont(new Font("Dialog", 1, 10));
            ((Container)((Object)this)).add((Component)this.fWaitMsgLabel, "Center");
        } else {
            ((Container)((Object)this)).removeAll();
            this.clearLists();
            ((Container)((Object)this)).add((Component)this.fContentsList, "Center");
        }
        ((Container)((Object)this)).invalidate();
        ((Container)((Object)this)).validate();
    }

    private void clearLists() {
        this.fContentsList.removeAll();
        this.fHiddenList.removeAll();
        this.fSyncLookupTable.removeAllElements();
        this.fNextID = 0;
    }

    private void stopLoadContentsThread() {
        if (this.fLoadDataThread != null && this.fLoadDataThread.isAlive()) {
            this.fStopRequested = true;
            try {
                this.fLoadDataThread.join();
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    private void initContentsTree(boolean bl) {
    }

    public void selectFirstEntry(boolean bl) {
        if (this.fContentsList.getFirstItem() != -1) {
            this.fContentsList.selectItem(0);
        }
        if (bl) {
            this.sendSelectedFileToBrowser();
        }
    }

    public void setIsShowing(boolean bl) {
        this.fIsShowing = bl;
    }

    private void showError(String string) {
        MWLabel mWLabel = new MWLabel(string, 1);
        mWLabel.setFont(new Font("Dialog", 1, 10));
        ((Container)((Object)this)).add((Component)mWLabel, "Center");
        ((Container)((Object)this)).validate();
    }

    private void setFont() {
        this.fContentsList.setFont(HelpFontPrefs.getHelpNavigatorFont());
        ((Container)((Object)this)).validate();
    }

    /*
     * Unable to fully structure code
     */
    public void parseContentsFile(String var1_1, int var2_2, boolean var3_3, boolean var4_4, boolean var5_5, boolean var6_6) {
        block35: {
            if (this.fLoadDataThread != null && this.fLoadDataThread.isAlive() && this.fStopRequested) {
                return;
            }
            var7_7 = var2_2;
            var8_8 = new File(var1_1);
            var9_9 = var8_8.getParent();
            var9_9 = var9_9.replace('\\', '/');
            if (!var8_8.exists()) {
                return;
            }
            var10_10 = null;
            var11_11 = null;
            try {
                var10_10 = new BufferedReader(new FileReader(var1_1));
            }
            catch (FileNotFoundException v0) {}
            if (var10_10 == null) break block35;
            try {
                var12_12 = new String[4];
                var13_13 = true;
                while ((var11_11 = var10_10.readLine()) != null) {
                    if (!(var11_11 = var11_11.trim()).startsWith("<tocitem>") && !var11_11.startsWith("<tocitem target")) ** GOTO lbl82
                    if (var4_4 && var13_13) {
                        var13_13 = false;
                    } else {
                        var14_14 = var11_11.indexOf(">") + 1;
                        var15_15 = var11_11.indexOf("</tocitem");
                        if (var15_15 == -1) {
                            var15_15 = var11_11.length();
                        }
                        var12_12[0] = var11_11.substring(var14_14, var15_15);
                        if (var11_11.startsWith("<tocitem target")) {
                            var16_16 = var11_11.indexOf("target=") + 8;
                            var17_19 = var11_11.indexOf(">", var16_16) - 1;
                            var18_20 = var11_11.substring(var16_16, var17_19);
                            var19_21 = "";
                            var20_23 = var18_20;
                            var21_25 = "";
                            if (!var18_20.startsWith("http://")) {
                                var22_27 = var18_20.indexOf(35);
                                if (var22_27 > -1) {
                                    var20_23 = var18_20.substring(0, var22_27);
                                    var21_25 = var18_20.substring(var22_27, var18_20.length());
                                }
                                if (var9_9.length() > this.fDocRoot.length()) {
                                    var19_21 = String.valueOf(var9_9.substring(this.fDocRoot.length() + 1)) + "/";
                                }
                            }
                            var12_12[1] = String.valueOf(var19_21) + var20_23;
                            var12_12[2] = var21_25;
                        } else {
                            var12_12[1] = "";
                            var12_12[2] = "";
                        }
                        this.fContentsList.setItemKiddable(var2_2, true);
                        this.fHiddenList.setItemKiddable(var2_2, true);
                        this.fHiddenList.setItemTwisted(var2_2, true);
                        if (var2_2 == var7_7 && var5_5) {
                            if (var12_12[0].equals("Documentation Not Found")) {
                                this.fContentsList.add(var2_2, this.fNextID, var12_12[0], this.resources.loadImage("/com/mathworks/mwt/resources/alerticon.gif"), false);
                            } else {
                                this.fContentsList.add(var2_2, this.fNextID, var12_12[0], this.fHtmlIcon, false);
                            }
                        }
                        if (!var3_3) {
                            var12_12[3] = "";
                            this.fHiddenList.add(var2_2, this.fNextID, var12_12, null, false);
                            if (var6_6 && this.fNextID == 0) {
                                this.selectFirstEntry(true);
                            }
                            ++this.fNextID;
                        } else {
                            var16_17 = this.getDirectoryForLookupTable(var12_12[1]);
                            if (!this.isDirectoryInTable(var16_17)) {
                                this.addToSyncLookupTable(var16_17, this.fNextID);
                            }
                            var12_12[3] = var1_1;
                            this.fHiddenList.add(var2_2, this.fNextID, var12_12, null, false);
                            if (var6_6 && this.fNextID == 0) {
                                this.selectFirstEntry(true);
                            }
                            var17_19 = 0;
                            while ((var11_11 = var10_10.readLine()) != null) {
                                if (!(var11_11 = var11_11.trim()).startsWith("<tocitem") && !var11_11.startsWith("<subtoc")) continue;
                                this.fContentsList.setItemKiddable(this.fNextID, true);
                                if (var2_2 == -1) {
                                    this.fContentsList.setItemIcon(this.fNextID, this.fBookIcon);
                                }
                                var17_19 = 1;
                                break;
                            }
                            if (var17_19 == 0) {
                                this.fHiddenList.setItemString(this.fNextID, 3, "");
                            }
                            var2_2 = this.fNextID++;
                            break;
lbl82:
                            // 1 sources

                            if (var11_11.startsWith("<subtoc location")) {
                                var14_14 = var11_11.indexOf("=") + 2;
                                var15_15 = var11_11.indexOf("\"", var14_14 + 1);
                                if (var15_15 == -1) {
                                    var15_15 = var11_11.length();
                                }
                                var16_18 = String.valueOf(var9_9) + HelpBrowser.fSeparator + var11_11.substring(var14_14, var15_15);
                                var17_19 = 0;
                                if (var2_2 == var7_7) {
                                    var18_20 = "";
                                    var19_22 = true;
                                    var20_24 = var11_11.indexOf("product=", var15_15 + 1);
                                    if (var20_24 != -1) {
                                        var21_26 = var11_11.indexOf("\"", (var20_24 += 9) + 1);
                                        var18_20 = var11_11.substring(var20_24, var21_26);
                                        var19_22 = HelpPrefs.isProductSelected(var18_20);
                                    }
                                    if (this.fSearchAllProducts || var19_22) {
                                        var17_19 = 1;
                                    }
                                } else {
                                    var17_19 = 1;
                                }
                                if (var17_19 != 0) {
                                    if (PlatformInfo.getPlatform() == 1) {
                                        var16_18 = var16_18.replace('/', '\\');
                                    }
                                    this.parseContentsFile(var16_18, var2_2, true, false, var5_5, var6_6);
                                }
                            }
                        }
                    }
                    if (!var11_11.endsWith("</tocitem>")) continue;
                    var2_2 = this.fHiddenList.getParentId(var2_2);
                }
                var10_10.close();
                if (var2_2 == var7_7) {
                    this.fContentsList.setItemKiddable(var7_7, true);
                }
            }
            catch (IOException v1) {}
        }
        this.resources.waitForPendingImages();
        this.repaint();
    }

    private String getDirectoryForLookupTable(String string) {
        String string2 = string;
        int n = string2.indexOf(47);
        if (n != -1) {
            int n2 = string2.indexOf(47, n + 1);
            string2 = n2 != -1 ? string2.substring(0, n2) : string2.substring(0, n);
        }
        return string2;
    }

    private void printSyncLookupTable() {
        int n = 0;
        while (n < this.fSyncLookupTable.size()) {
            SyncLookupTableElement syncLookupTableElement = (SyncLookupTableElement)this.fSyncLookupTable.elementAt(n);
            System.out.println(String.valueOf(n) + ": " + syncLookupTableElement.getDirectory() + " " + syncLookupTableElement.getItemID());
            ++n;
        }
    }

    private boolean isDirectoryInTable(String string) {
        int n = 0;
        while (n < this.fSyncLookupTable.size()) {
            SyncLookupTableElement syncLookupTableElement = (SyncLookupTableElement)this.fSyncLookupTable.elementAt(n);
            if (syncLookupTableElement.getDirectory().equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private int getItemIdFromSyncLookupTable(String string) {
        int n = 0;
        while (n < this.fSyncLookupTable.size()) {
            SyncLookupTableElement syncLookupTableElement = (SyncLookupTableElement)this.fSyncLookupTable.elementAt(n);
            if (syncLookupTableElement.getDirectory().equals(string)) {
                return syncLookupTableElement.getItemID();
            }
            ++n;
        }
        return -1;
    }

    private void addToSyncLookupTable(String string, int n) {
        this.fSyncLookupTable.addElement(new SyncLookupTableElement(string, n));
    }

    private void expandMe(int n) {
        int[] nArray = this.fHiddenList.getChildren(n);
        if (nArray.length == 0) {
            String string = this.fHiddenList.getItemString(n, 3);
            if (!string.equals("")) {
                this.parseContentsFile(string, n, false, true, true, false);
                return;
            }
        } else {
            this.fContentsList.setItemTwisted(n, true);
            int n2 = 0;
            while (n2 < nArray.length) {
                int n3 = nArray[n2];
                Image image = this.fHiddenList.getItemString(n3, 1).equals("") ? (this.fHiddenList.getItemString(n3, 3).equals("") && this.fHiddenList.getChildren(n3).length == 0 ? this.fMissingIcon : this.fBookIcon) : this.fHtmlIcon;
                this.fContentsList.add(n, n3, this.fHiddenList.getItemString(n3, 0), image, false);
                int[] nArray2 = this.fHiddenList.getChildren(n3);
                String string = this.fHiddenList.getItemString(n3, 3);
                if (nArray2.length > 0 || !string.equals("")) {
                    this.fContentsList.setItemKiddable(n3, true);
                }
                ++n2;
            }
        }
    }

    public void collapseAllItems() {
        int[] nArray = this.fContentsList.getChildren(-1);
        int n = 0;
        while (n < nArray.length) {
            this.collapseMe(nArray[n]);
            ++n;
        }
    }

    private void collapseMe(int n) {
        this.fContentsList.removeDescendants(n);
    }

    private String[] getAncestryTree(int n) {
        if (n != -1) {
            int n2 = n;
            int n3 = 0;
            while (n2 != -1) {
                n2 = this.fHiddenList.getParentId(n2);
                ++n3;
            }
            String[] stringArray = new String[n3];
            n2 = n;
            int n4 = n3 - 1;
            while (n4 >= 0) {
                stringArray[n4] = this.fHiddenList.getItemString(n2);
                n2 = this.fHiddenList.getParentId(n2);
                --n4;
            }
            return stringArray;
        }
        return null;
    }

    private String formatItemText(String[] stringArray) {
        int n = stringArray.length;
        String string = stringArray[n - 1];
        if (n > 2) {
            string = String.valueOf(stringArray[1]) + ":  " + string;
        } else if (n > 1) {
            string = String.valueOf(stringArray[0]) + ":  " + string;
        }
        return string;
    }

    private void sendSelectedFileToBrowser() {
        int n = this.fContentsList.getFirstSelectedItem();
        if (n != -1) {
            String string = this.fHiddenList.getItemString(n, 1);
            if (string.equals("")) {
                return;
            }
            String string2 = string = String.valueOf(string) + this.fHiddenList.getItemString(n, 2);
            if (!string2.startsWith("http://")) {
                string2 = String.valueOf(this.fDocRoot) + "/" + string;
            }
            this.stopSyncing();
            this.fParent.getIceBrowser().setCurrentLocation(string2, false);
        }
    }

    private boolean searchTree(String string) {
        int n = string.length();
        boolean bl = false;
        int n2 = this.fContentsList.getFirstSelectedItem();
        if (n2 == -1) {
            n2 = this.fHiddenList.getFirstItem();
        }
        int n3 = n2;
        while (!bl && n2 != -1) {
            String string2 = this.fHiddenList.getItemString(n2, 0);
            int n4 = string2.length();
            int n5 = 0;
            if (n3 != n2) {
                while (!bl && n5 + n < n4 + 1) {
                    if (string2.substring(n5, n + n5).equalsIgnoreCase(string)) {
                        bl = true;
                    }
                    ++n5;
                }
            }
            if (bl) continue;
            int[] nArray = this.fHiddenList.getChildren(n2);
            String string3 = this.fHiddenList.getItemString(n2, 3);
            if (nArray.length == 0 && !string3.equals("")) {
                this.parseContentsFile(string3, n2, false, true, false, false);
            }
            n2 = this.fHiddenList.getNextItem(n2);
        }
        if (bl) {
            this.expandAndSelectItem(n2, false);
            this.sendSelectedFileToBrowser();
        } else {
            Toolkit.getDefaultToolkit().beep();
            Object[] objectArray = new Object[]{string};
            String string4 = HelpBrowser.getMessage(objectArray, HelpBrowser.sRes.getString("alert.searchstring_not_found"));
            new MWAlert(this.getFrame(), HelpBrowser.sHelpBrowserName, string4, 1);
        }
        this.fSearchString = string;
        return bl;
    }

    private void stopSyncing() {
        if (this.fSyncThread != null && this.fSyncThread.isAlive()) {
            this.fStopRequested = true;
            try {
                this.fSyncThread.join();
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    public synchronized void syncContentsTree(String string) {
        this.syncContentsTree(string, false);
    }

    public synchronized void syncContentsTree(String string, boolean bl) {
        if (this.fLoadDataThread != null && this.fLoadDataThread.isAlive()) {
            try {
                this.fLoadDataThread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.stopSyncing();
        this.fSyncThread = new SyncContentsTreeThread(string, bl);
        this.fSyncThread.start();
    }

    private void expandAndSelectItem(int n, boolean bl) {
        Vector<Integer> vector = new Vector<Integer>();
        int n2 = this.fHiddenList.getParentId(n);
        while (n2 != -1) {
            vector.addElement(new Integer(n2));
            n2 = this.fHiddenList.getParentId(n2);
        }
        int n3 = vector.size() - 1;
        while (n3 >= 0) {
            Integer n4 = (Integer)vector.elementAt(n3);
            int n5 = n4;
            if (!this.fContentsList.isItemTwisted(n5)) {
                this.expandMe(n5);
            }
            --n3;
        }
        this.fContentsList.selectItem(n);
        this.fContentsList.showFirstSelectedItem();
        if (bl && !this.fContentsList.isItemTwisted(n)) {
            this.expandMe(n);
            this.fContentsList.setItemTwisted(n, true);
        }
    }

    private void expandOrCollapseItem() {
        int n = this.fContentsList.getFirstSelectedItem();
        if (this.fContentsList.isItemKiddable(n)) {
            if (this.fContentsList.isItemTwisted(n)) {
                this.fContentsList.setItemTwisted(n, false);
                this.collapseMe(n);
                return;
            }
            this.expandMe(n);
            this.fContentsList.setItemTwisted(n, true);
        }
    }

    private class ContentsQueueEvent
    extends QueueEvent {
        public void dispatch() {
            Component[] componentArray = ((Container)((Object)ContentsTree.this)).getComponents();
            if (componentArray[0] instanceof MWLabel) {
                ((Container)((Object)ContentsTree.this)).remove((Component)ContentsTree.this.fWaitMsgLabel);
                ((Container)((Object)ContentsTree.this)).add((Component)ContentsTree.this.fContentsList, "Center");
                ((Container)((Object)ContentsTree.this)).invalidate();
                ((Container)((Object)ContentsTree.this)).validate();
            }
            ContentsTree.this.fParent.loadingDataFinished();
        }

        ContentsQueueEvent() {
            ContentsTree.this = ContentsTree.this;
        }
    }

    private class LoadDataThread
    extends Thread {
        private boolean fDocRootChanged;

        LoadDataThread(boolean bl) {
            ContentsTree.this = ContentsTree.this;
            this.fDocRootChanged = bl;
            ContentsTree.this.fStopRequested = false;
        }

        public void run() {
            Object object;
            File file;
            ContentsTree.this.fDocRoot = HelpPrefs.getDocRoot();
            String string = "r12doctoc.xml";
            boolean bl = true;
            String string2 = "";
            if (ContentsTree.this.fDocRoot != null && ContentsTree.this.fParent.isDocrootValid() && (file = new File(string2 = String.valueOf(ContentsTree.this.fDocRoot) + HelpBrowser.fSeparator + string)).exists()) {
                bl = false;
            }
            if (bl) {
                object = StringUtils.fromJavaPath((String)(String.valueOf(Matlab.matlabRoot()) + "/help"));
                string2 = StringUtils.fromJavaPath((String)(String.valueOf(object) + "/r12nodoctoc.xml"));
                file = new File(string2);
                if (!file.exists()) {
                    ContentsTree.this.showError(HelpBrowser.sRes.getString("index.docroot_not_set"));
                    return;
                }
                ContentsTree.this.fDocRoot = (String)object;
            }
            ContentsTree.this.parseContentsFile(string2, -1, false, false, true, this.fDocRootChanged);
            object = new File(ContentsTree.this.fDocRoot);
            String[] stringArray = ((File)object).list();
            if (stringArray != null) {
                int n = 0;
                while (n < stringArray.length) {
                    String string3 = stringArray[n];
                    File file2 = new File(ContentsTree.this.fDocRoot, string3);
                    if (string3.startsWith("r12doctoc") && string3.endsWith(".xml") && file2.isFile() && !string3.equals("r12doctoc.xml")) {
                        ContentsTree.this.parseContentsFile(file2.getAbsolutePath(), -1, false, false, true, false);
                    }
                    ++n;
                }
            }
            QueueEvent.postQueueEvent((QueueEvent)new ContentsQueueEvent());
        }
    }

    private class HelpPrefsListener
    implements PrefListener {
        public void prefChanged(PrefEvent prefEvent) {
            if (prefEvent.getEventType() == 1) {
                String string = prefEvent.getPrefKey();
                if (string.equals("HelpNavigatorFont") || string.equals("HelpUseDesktopFont")) {
                    ContentsTree.this.setFont();
                    return;
                }
                if (string.equals("GeneralFont") && HelpFontPrefs.getUseDesktopFont()) {
                    ContentsTree.this.setFont();
                }
            }
        }

        HelpPrefsListener() {
            ContentsTree.this = ContentsTree.this;
        }
    }

    private class SyncLookupTableElement {
        private String fDirectory;
        private int fItemID;

        public SyncLookupTableElement(String string, int n) {
            ContentsTree.this = ContentsTree.this;
            this.fDirectory = string;
            this.fItemID = n;
        }

        public String getDirectory() {
            return this.fDirectory;
        }

        public int getItemID() {
            return this.fItemID;
        }
    }

    private class SyncContentsTreeThread
    extends Thread {
        private String fSearchString;
        private boolean fExpandSelectedItem;

        SyncContentsTreeThread(String string, boolean bl) {
            ContentsTree.this = ContentsTree.this;
            this.fSearchString = string;
            this.fExpandSelectedItem = bl;
            ContentsTree.this.fStopRequested = false;
        }

        public void run() {
            Object object;
            File file;
            if (!ContentsTree.this.fIsShowing || !Prefs.getBooleanPref((String)"HelpAutosyncContents", (boolean)true)) {
                return;
            }
            if (ContentsTree.this.fDocRoot == null) {
                return;
            }
            int n = ContentsTree.this.fContentsList.getFirstSelectedItem();
            if (this.fSearchString.equals(ContentsTree.this.fHiddenList.getItemString(n, 3))) {
                if (this.fExpandSelectedItem && !ContentsTree.this.fContentsList.isItemTwisted(n)) {
                    ContentsTree.this.expandMe(n);
                    ContentsTree.this.fContentsList.setItemTwisted(n, true);
                }
                return;
            }
            if (this.fSearchString.startsWith("file:") && this.fSearchString.length() > 5) {
                this.fSearchString = this.fSearchString.substring(5);
            }
            if (this.fSearchString.length() <= ContentsTree.this.fDocRoot.length()) {
                return;
            }
            String string = ContentsTree.this.fDocRoot.replace('\\', '/');
            if (PlatformInfo.isWindows() ? !this.fSearchString.toLowerCase().startsWith(string.toLowerCase()) : !this.fSearchString.startsWith(string)) {
                return;
            }
            String string2 = this.fSearchString;
            int n2 = string2.lastIndexOf(35);
            if (n2 != -1) {
                string2 = this.fSearchString.substring(0, n2);
            }
            if (!(file = new File(string2)).exists()) {
                return;
            }
            this.fSearchString = this.fSearchString.substring(ContentsTree.this.fDocRoot.length() + 1);
            if (this.fSearchString.startsWith("mapfiles/../")) {
                this.fSearchString = this.fSearchString.substring(12);
            }
            if (this.fSearchString.startsWith("techdoc/ref") || this.fSearchString.equals("techdoc/matlab_env/tips_product_page.html")) {
                return;
            }
            String string3 = ContentsTree.this.getDirectoryForLookupTable(this.fSearchString);
            int n3 = ContentsTree.this.getItemIdFromSyncLookupTable(string3);
            if (n3 == -1 && this.fSearchString.startsWith("techdoc")) {
                object = ContentsTree.this.fHiddenList.getChildren(n3);
                int n4 = 0;
                if (!ContentsTree.this.fAnyProductsSelected) {
                    n4 = 1;
                }
                while (n3 == -1 && n4 < ((Object)object).length) {
                    if (!ContentsTree.this.fStopRequested) {
                        String string4 = ContentsTree.this.fHiddenList.getItemString((int)object[n4], 3);
                        int[] nArray = ContentsTree.this.fHiddenList.getChildren((int)object[n4]);
                        if (nArray.length == 0 && !string4.equals("")) {
                            ContentsTree.this.parseContentsFile(string4, (int)object[n4], false, true, false, false);
                        }
                        n3 = ContentsTree.this.getItemIdFromSyncLookupTable(string3);
                        ++n4;
                        continue;
                    }
                    return;
                }
                if (n3 == -1) {
                    n3 = ContentsTree.this.getItemIdFromSyncLookupTable("techdoc");
                }
            }
            object = this.fSearchString;
            String string5 = "";
            int n5 = this.fSearchString.indexOf(35);
            if (n5 > -1) {
                object = this.fSearchString.substring(0, n5);
                string5 = this.fSearchString.substring(n5, this.fSearchString.length());
            }
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = true;
            int n6 = -1;
            while (!bl3 && !bl && n3 != -1) {
                if (ContentsTree.this.fHiddenList.getItemString(n3, 1).equals(object)) {
                    if (ContentsTree.this.fHiddenList.getItemString(n3, 2).equals(string5)) {
                        bl = true;
                        n6 = n3;
                    } else {
                        bl2 = true;
                        if (bl4) {
                            n6 = n3;
                        }
                    }
                    bl4 = false;
                } else if (bl2) {
                    bl = true;
                }
                if (ContentsTree.this.fStopRequested) {
                    return;
                }
                if (bl) continue;
                int[] nArray = ContentsTree.this.fHiddenList.getChildren(n3);
                String string6 = ContentsTree.this.fHiddenList.getItemString(n3, 3);
                if (nArray.length == 0 && !string6.equals("")) {
                    ContentsTree.this.parseContentsFile(string6, n3, false, true, false, false);
                }
                n3 = ContentsTree.this.fHiddenList.getNextItem(n3);
                if (ContentsTree.this.fHiddenList.getParentId(n3) != -1 || ContentsTree.this.fHiddenList.getItemString(n3, 1).startsWith(string3)) continue;
                bl3 = true;
            }
            if (bl2) {
                bl = true;
            }
            if (bl) {
                ContentsTree.this.expandAndSelectItem(n6, this.fExpandSelectedItem);
            }
        }
    }

    private class fContentsListMWTListListener
    implements MWTListListener {
        public void collapseItem(MWTListEvent mWTListEvent) {
            ContentsTree.this.collapseMe(mWTListEvent.getItemId());
        }

        public void expandItem(MWTListEvent mWTListEvent) {
            ContentsTree.this.expandMe(mWTListEvent.getItemId());
        }

        public void scrollList(MWTListEvent mWTListEvent) {
        }

        fContentsListMWTListListener() {
            ContentsTree.this = ContentsTree.this;
        }
    }

    private class ContentsListMouseListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            if (PlatformInfo.getPlatform() == 2) {
                this.doStuff(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (PlatformInfo.getPlatform() != 2) {
                this.doStuff(mouseEvent);
            }
        }

        public void doStuff(MouseEvent mouseEvent) {
            MWTList mWTList = (MWTList)mouseEvent.getSource();
            if (mouseEvent.isPopupTrigger()) {
                int n = ContentsTree.this.fContentsList.getFirstSelectedItem();
                if (n != -1) {
                    String string = ContentsTree.this.fHiddenList.getItemString(n, 1);
                    if (string.equals("")) {
                        ContentsTree.this.fContentsListPopupMenu.getItem(0).setEnabled(false);
                    } else {
                        ContentsTree.this.fContentsListPopupMenu.getItem(0).setEnabled(true);
                    }
                    ContentsTree.this.fContentsListPopupMenu.show((Component)mWTList, mouseEvent.getX(), mouseEvent.getY());
                    return;
                }
            } else if (mouseEvent.getClickCount() == 2) {
                ContentsTree.this.expandOrCollapseItem();
            }
        }

        ContentsListMouseListener() {
            ContentsTree.this = ContentsTree.this;
        }
    }

    public class ContentsListPopupMenu
    extends PopupMenu {
        public ContentsListPopupMenu() {
            ContentsTree.this = ContentsTree.this;
            this.add(HelpBrowser.sRes.getString("icecontainer.addtofavorites"));
            this.addActionListener(new 1(this));
        }

        static /* synthetic */ ContentsTree access$0(ContentsListPopupMenu contentsListPopupMenu) {
            return contentsListPopupMenu.ContentsTree.this;
        }
    }

    private class HitListItemListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            ContentsTree.this.sendSelectedFileToBrowser();
        }

        HitListItemListener() {
            ContentsTree.this = ContentsTree.this;
        }
    }

    private class HitListKeyListener
    extends KeyAdapter {
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                ContentsTree.this.expandOrCollapseItem();
            }
        }

        HitListKeyListener() {
            ContentsTree.this = ContentsTree.this;
        }
    }

    private class SearchActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = ContentsTree.this.fSearchField.getText();
            ContentsTree.this.searchTree(string);
        }

        SearchActionListener() {
            ContentsTree.this = ContentsTree.this;
        }
    }
}

