/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.help;

import com.mathworks.ide.browsers.HTMLBrowser;
import com.mathworks.ide.browsers.HTMLBrowser50;
import com.mathworks.ide.help.CSHelpTopicMap;
import com.mathworks.ide.help.CSHelpTopicMapRegistry;
import com.mathworks.mwt.MWFrame;
import com.mathworks.mwt.MWHelpListener;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.MWToolbar;
import com.mathworks.mwt.command.MWCommandCenter;
import com.mathworks.mwt.command.MWCommandTarget;
import com.mathworks.services.Prefs;
import com.mathworks.util.FactoryUtilAdapter;
import ice.htmlbrowser.MouseOverLinkEvent;
import ice.htmlbrowser.MouseOverLinkListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class CSHelpViewer
extends FactoryUtilAdapter {
    Dimension minSize;
    int fAnchor = 10;
    Viewer viewer;
    private static CSHelpViewer sTheViewer;

    protected CSHelpViewer() {
    }

    private Viewer createViewer() {
        Viewer viewer = new Viewer();
        MWFrame mWFrame = new MWFrame("MATLAB Help Viewer");
        mWFrame.add((Component)((Object)viewer), "Center");
        mWFrame.addWindowListener(new 1());
        mWFrame.pack();
        if (this.minSize != null) {
            viewer.setMinSize(this.minSize);
        }
        viewer.setAnchor(this.fAnchor);
        return viewer;
    }

    public void displayTopic(CSHelpTopicMap cSHelpTopicMap, String string) {
        if (cSHelpTopicMap == null) {
            throw new IllegalArgumentException("topicMap is null.");
        }
        if (string == null) {
            throw new IllegalArgumentException("topicID is null.");
        }
        String string2 = cSHelpTopicMap.mapID(string);
        if (string2 != null) {
            if (this.viewer == null) {
                this.viewer = this.createViewer();
            }
            this.viewer.displayPage(string2);
            this.viewer.setVisible(true);
        }
    }

    public static CSHelpTopicMap getTopicMap(Component component) {
        while (component != null) {
            CSHelpTopicMap cSHelpTopicMap;
            if (!((component = component.getParent()) instanceof Container) || (cSHelpTopicMap = CSHelpTopicMapRegistry.getTopicMap((Container)component)) == null) continue;
            return cSHelpTopicMap;
        }
        return null;
    }

    public static String getTopicKey(Component component) {
        while (component != null) {
            MWHelpListener mWHelpListener;
            String string;
            if (component instanceof MWHelpListener && (string = (mWHelpListener = (MWHelpListener)component).getHelpTopicKey()) != null) {
                return string;
            }
            component = component.getParent();
        }
        return null;
    }

    public static String getTopicPath(Component component) {
        CSHelpTopicMap cSHelpTopicMap = CSHelpViewer.getTopicMap(component);
        if (cSHelpTopicMap == null) {
            return null;
        }
        String string = CSHelpViewer.getTopicKey(component);
        if (string == null) {
            return null;
        }
        String string2 = cSHelpTopicMap.mapID(string);
        if (string2 == null) {
            System.out.println("Error: could not find topic " + string + " in topic map.");
            System.out.println("  Map location: " + cSHelpTopicMap.getFile() + ".");
        }
        return string2;
    }

    public void dispose() {
        if (this.viewer != null) {
            this.viewer.dispose();
        }
    }

    public void setMinSize(Dimension dimension) {
        if (this.viewer != null) {
            this.viewer.setMinSize(dimension);
        }
        this.minSize = new Dimension(dimension);
    }

    public void setAnchor(int n) {
        if (this.viewer != null) {
            this.viewer.setAnchor(n);
        }
        this.fAnchor = n;
    }

    public Object getValue() {
        return null;
    }

    public void callVoidMethod(Object object) {
        String string = CSHelpViewer.getTopicPath((Component)object);
        if (string != null) {
            if (this.viewer == null) {
                this.viewer = this.createViewer();
            }
            this.viewer.displayPage(string);
            this.viewer.setVisible(true);
        }
    }

    public static CSHelpViewer getTheViewer() {
        if (sTheViewer == null) {
            sTheViewer = new CSHelpViewer();
        }
        return sTheViewer;
    }

    class Viewer
    extends MWPanel
    implements MWCommandTarget {
        private HTMLBrowser fIceBrowser;
        private HTMLBrowser50 fIceBrowser50;
        private boolean fUseIceBrowser50 = false;
        private MWToolbar fToolbar;
        private MWCommandCenter fCommandCenter;

        public Viewer() {
            CSHelpViewer.this = CSHelpViewer.this;
            ((Container)((Object)this)).setLayout(new BorderLayout());
            this.setOpaque(false);
            this.fCommandCenter = new MWCommandCenter((MWCommandTarget)this);
            if (Prefs.getIntegerPref((String)"HelpIceBrowserVersion", (int)4) == 5) {
                this.fUseIceBrowser50 = true;
            }
            if (this.fUseIceBrowser50) {
                MWPanel mWPanel = new MWPanel((LayoutManager)new BorderLayout());
                this.fIceBrowser50 = new HTMLBrowser50(mWPanel, this.fCommandCenter);
                ((Container)((Object)this)).add((Component)mWPanel, "Center");
            } else {
                this.fIceBrowser = new HTMLBrowser(this.fCommandCenter);
                this.fIceBrowser.addMouseOverLinkListener(new HyperlinkListener());
                ((Container)((Object)this)).add((Component)((Object)this.fIceBrowser), "Center");
            }
            ((Container)((Object)this)).add((Component)((Object)new Toolbar(this.fCommandCenter)), "North");
        }

        private void enableCommands() {
            if (this.fUseIceBrowser50) {
                this.fCommandCenter.setCommandEnabled(1, this.fIceBrowser50.getBackHistory().size() != 0);
                this.fCommandCenter.setCommandEnabled(2, this.fIceBrowser50.getForwardHistory().size() != 0);
                return;
            }
            this.fCommandCenter.setCommandEnabled(1, this.fIceBrowser.getBackHistory().size() != 0);
            this.fCommandCenter.setCommandEnabled(2, this.fIceBrowser.getForwardHistory().size() != 0);
        }

        public void doCommand(int n) {
            if (this.fCommandCenter.getCommandEnabled(n)) {
                switch (n) {
                    case 1: {
                        if (this.fUseIceBrowser50) {
                            this.fIceBrowser50.goBack();
                            break;
                        }
                        this.fIceBrowser.goBack();
                        break;
                    }
                    case 2: {
                        if (this.fUseIceBrowser50) {
                            this.fIceBrowser50.goForward();
                            break;
                        }
                        this.fIceBrowser.goForward();
                        break;
                    }
                }
                this.enableCommands();
            }
        }

        public void setVisible(boolean bl) {
            ((Component)((Frame)((Component)((Object)this)).getParent())).setVisible(bl);
        }

        public void dispose() {
            ((Frame)((Component)((Object)this)).getParent()).dispose();
        }

        public void setMinSize(Dimension dimension) {
            Frame frame = (Frame)((Component)((Object)this)).getParent();
            Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dimension3 = frame.getSize();
            if (dimension3.height < dimension.height) {
                dimension3.height = Math.min(dimension.height, dimension2.height);
            }
            if (dimension3.width < dimension.width) {
                dimension3.width = Math.min(dimension.width, dimension2.width);
            }
            ((Component)frame).setSize(dimension3);
        }

        public void setAnchor(int n) {
            Frame frame = (Frame)((Component)((Object)this)).getParent();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dimension2 = frame.getSize();
            if (n == 13) {
                ((Component)frame).setLocation(dimension.width - dimension2.width - 5, (dimension.height - dimension2.height) / 2);
                return;
            }
            if (n == 10) {
                ((Component)frame).setLocation((dimension.width - dimension2.width) / 2, dimension.height / 3 - dimension2.height / 2);
            }
        }

        private String getCanonicalUrl(String string) {
            String string2 = "file://localhost";
            String string3 = new String(string);
            if (string.startsWith("file:") && string.length() > 5) {
                string = string.substring(5);
            }
            if (!string.startsWith("http://") && !string.startsWith(string2)) {
                String string4 = "";
                if (!string.startsWith("//") && !string.startsWith("\\\\")) {
                    string4 = "//";
                }
                string3 = new String(String.valueOf(string2) + string4 + string);
            }
            string3 = string3.replace('\\', '/');
            return string3;
        }

        public void displayPage(String string) {
            String string2 = this.getCanonicalUrl(string);
            if (this.fUseIceBrowser50) {
                this.fIceBrowser50.gotoLocation(string2);
            } else {
                this.fIceBrowser.gotoLocation(string2);
            }
            this.enableCommands();
        }

        class Toolbar
        extends MWToolbar {
            public Toolbar(MWCommandCenter mWCommandCenter) {
                Viewer.this = Viewer.this;
                this.addImageButton("/com/mathworks/ide/help/resources/backarrow.gif", 1, "Back", mWCommandCenter);
                this.addImageButton("/com/mathworks/ide/help/resources/forwardarrow.gif", 2, "Forward", mWCommandCenter);
            }
        }

        private class HyperlinkListener
        implements MouseOverLinkListener {
            public void mouseOverLinkEntered(MouseOverLinkEvent mouseOverLinkEvent) {
            }

            public void mouseOverLinkExited(MouseOverLinkEvent mouseOverLinkEvent) {
            }

            public void mouseOverLinkMoved(MouseOverLinkEvent mouseOverLinkEvent) {
            }

            public void mouseOverLinkClicked(MouseOverLinkEvent mouseOverLinkEvent) {
                Viewer.this.enableCommands();
            }

            HyperlinkListener() {
                Viewer.this = Viewer.this;
            }
        }
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            ((Component)((Frame)windowEvent.getSource())).setVisible(false);
        }

        /* synthetic */ 1() {
        }
    }
}

