/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.filtermgr;

import com.mathworks.ide.filtermgr.FilterEditor;
import com.mathworks.ide.filtermgr.FilterList;
import com.mathworks.ide.filtermgr.FilterManagerEvent;
import com.mathworks.ide.filtermgr.FilterManagerListener;
import com.mathworks.ide.filtermgr.PropertyFilter;
import com.mathworks.mwt.MWFrame;
import com.mathworks.mwt.window.MWWindowActivater;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.WindowListener;
import java.util.Hashtable;
import java.util.Vector;

public class FilterManager {
    public static final int NEW_FILTER = -1;
    private FilterEditor fEditor = null;
    private Rectangle fEditorLocation;
    private String fPrefsKey;
    private Vector fClasses;
    private Hashtable fFilters;
    private int fUntitledCount;
    private Vector fFilterManagerListeners;

    public FilterManager(String string) {
        this.fPrefsKey = string;
        this.fClasses = new Vector();
        this.fFilters = new Hashtable();
        this.fUntitledCount = 0;
        this.fFilterManagerListeners = new Vector();
        this.loadStoredFilters();
    }

    public PropertyFilter[] getFilters(String string) {
        FilterList filterList = null;
        if (string != null) {
            filterList = (FilterList)this.fFilters.get(string);
            if (filterList == null) {
                this.fClasses.addElement(string);
                filterList = new FilterList();
                this.fFilters.put(string, filterList);
            }
        } else {
            filterList = new FilterList();
        }
        return filterList.getFilters();
    }

    public int getFilterIndex(PropertyFilter propertyFilter) {
        String string = propertyFilter.getClassName();
        FilterList filterList = (FilterList)this.fFilters.get(string);
        int n = -1;
        if (filterList != null) {
            n = filterList.getFilterIndex(propertyFilter);
        }
        return n;
    }

    public PropertyFilter getFilter(String string, int n) {
        PropertyFilter propertyFilter = null;
        FilterList filterList = (FilterList)this.fFilters.get(string);
        if (filterList != null) {
            propertyFilter = filterList.getFilter(n);
        }
        return propertyFilter;
    }

    public PropertyFilter getActiveFilter(String string) {
        PropertyFilter propertyFilter = null;
        FilterList filterList = (FilterList)this.fFilters.get(string);
        if (filterList != null) {
            propertyFilter = filterList.getActiveFilter();
        }
        return propertyFilter;
    }

    public int getActiveFilterIndex(String string) {
        int n = -1;
        FilterList filterList = (FilterList)this.fFilters.get(string);
        if (filterList != null) {
            n = filterList.getActiveFilterIndex();
        }
        return n;
    }

    public void setActiveFilter(String string, int n) {
        FilterList filterList = (FilterList)this.fFilters.get(string);
        if (filterList != null && n != filterList.getActiveFilterIndex()) {
            filterList.setActiveFilter(n);
            FilterManagerEvent filterManagerEvent = new FilterManagerEvent(this, 2, filterList.getActiveFilter());
            this.fireFilterManagerEvent(filterManagerEvent);
        }
    }

    public void removeFilter(String string, int n) {
        PropertyFilter propertyFilter;
        FilterList filterList = (FilterList)this.fFilters.get(string);
        if (filterList != null && (propertyFilter = filterList.getFilter(n)) != null) {
            FilterManagerEvent filterManagerEvent = new FilterManagerEvent(this, 1, propertyFilter);
            filterList.removeFilter(n);
            this.fireFilterManagerEvent(filterManagerEvent);
        }
    }

    public void writeFilter(PropertyFilter propertyFilter, int n) {
        FilterList filterList;
        if (propertyFilter != null && (filterList = (FilterList)this.fFilters.get(propertyFilter.getClassName())) != null) {
            PropertyFilter propertyFilter2 = new PropertyFilter(propertyFilter);
            filterList.setFilterAt(propertyFilter2, n);
            FilterManagerEvent filterManagerEvent = new FilterManagerEvent(this, 3, propertyFilter2);
            this.fireFilterManagerEvent(filterManagerEvent);
        }
    }

    public void addFilter(PropertyFilter propertyFilter) {
        if (propertyFilter != null) {
            String string = propertyFilter.getClassName();
            FilterList filterList = (FilterList)this.fFilters.get(string);
            if (filterList == null) {
                this.fClasses.addElement(string);
                filterList = new FilterList();
                this.fFilters.put(string, filterList);
            }
            filterList.addFilter(new PropertyFilter(propertyFilter));
            FilterManagerEvent filterManagerEvent = new FilterManagerEvent(this, 0, propertyFilter);
            this.fireFilterManagerEvent(filterManagerEvent);
        }
    }

    void editorClosed() {
        this.fEditorLocation = this.fEditor.getWindowPosition();
        this.fEditor = null;
    }

    public void editFilter(String string, String string2) {
        int n = -1;
        PropertyFilter[] propertyFilterArray = this.getFilters(string);
        if (this.fEditor == null) {
            MWFrame mWFrame = new MWFrame("Filter Editor: " + string);
            this.fEditor = new FilterEditor(this, mWFrame);
            mWFrame.add((Component)((Object)this.fEditor), "Center");
            mWFrame.addWindowListener((WindowListener)new MWWindowActivater((Component)((Object)this.fEditor)));
            if (this.fEditorLocation == null) {
                Dimension dimension = ((Container)((Object)this.fEditor)).getPreferredSize();
                Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
                mWFrame.setContentSize(dimension);
                mWFrame.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
            } else {
                mWFrame.setBounds(this.fEditorLocation);
            }
        }
        if (string2 == null) {
            string2 = this.fUntitledCount == 0 ? "untitled" : "untitled " + this.fUntitledCount;
            ++this.fUntitledCount;
        } else {
            int n2 = 0;
            while (n2 < propertyFilterArray.length && !string2.equals(propertyFilterArray[n2].getName())) {
                ++n2;
            }
            if (n2 < propertyFilterArray.length) {
                n = n2;
            }
        }
        if (n == -1) {
            this.fEditor.setEditFilter(string, string2, n);
        } else {
            this.fEditor.setEditFilter(propertyFilterArray[n], n);
        }
        this.fEditor.makeActive();
    }

    public void addFilterManagerListener(FilterManagerListener filterManagerListener) {
        if (this.fFilterManagerListeners.indexOf(filterManagerListener) == -1) {
            this.fFilterManagerListeners.addElement(filterManagerListener);
        }
    }

    public void removeFilterManagerListener(FilterManagerListener filterManagerListener) {
        if (this.fFilterManagerListeners.indexOf(filterManagerListener) != -1) {
            this.fFilterManagerListeners.removeElement(filterManagerListener);
        }
    }

    private void fireFilterManagerEvent(FilterManagerEvent filterManagerEvent) {
        Vector vector = (Vector)this.fFilterManagerListeners.clone();
        int n = 0;
        while (n < vector.size()) {
            FilterManagerListener filterManagerListener = (FilterManagerListener)vector.elementAt(n);
            switch (filterManagerEvent.getEventType()) {
                case 0: {
                    filterManagerListener.filterAdded(filterManagerEvent);
                    break;
                }
                case 1: {
                    filterManagerListener.filterRemoved(filterManagerEvent);
                    break;
                }
                case 2: {
                    filterManagerListener.filterSelected(filterManagerEvent);
                    break;
                }
                case 3: {
                    filterManagerListener.filterChanged(filterManagerEvent);
                    break;
                }
            }
            ++n;
        }
    }

    private void loadStoredFilters() {
        this.loadDefaultFilters();
        this.loadCustomFilters();
    }

    private void loadDefaultFilters() {
    }

    private void loadCustomFilters() {
    }
}

