/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.filtermgr;

import com.mathworks.ide.filtermgr.PropertyFilter;
import java.util.Vector;

class FilterList {
    static final int NONE = -1;
    private int fActiveIndex = -1;
    private Vector fFilters = new Vector();

    FilterList() {
    }

    PropertyFilter getActiveFilter() {
        PropertyFilter propertyFilter = null;
        if (this.fActiveIndex != -1) {
            propertyFilter = (PropertyFilter)this.fFilters.elementAt(this.fActiveIndex);
        }
        return propertyFilter;
    }

    int getActiveFilterIndex() {
        return this.fActiveIndex;
    }

    void setActiveFilter(int n) {
        if (n >= -1 && n < this.fFilters.size()) {
            this.fActiveIndex = n;
        }
    }

    void setActiveFilter(PropertyFilter propertyFilter) {
        this.setActiveFilter(this.fFilters.indexOf(propertyFilter));
    }

    int getFilterIndex(PropertyFilter propertyFilter) {
        return this.fFilters.indexOf(propertyFilter);
    }

    PropertyFilter getFilter(int n) {
        PropertyFilter propertyFilter = null;
        if (n != -1) {
            propertyFilter = (PropertyFilter)this.fFilters.elementAt(n);
        }
        return propertyFilter;
    }

    void setFilterAt(PropertyFilter propertyFilter, int n) {
        if (n >= 0 && n < this.fFilters.size()) {
            this.fFilters.setElementAt(propertyFilter, n);
        }
    }

    void addFilter(PropertyFilter propertyFilter) {
        if (this.fFilters.indexOf(propertyFilter) == -1) {
            this.fFilters.addElement(propertyFilter);
        }
    }

    void removeFilter(int n) {
        if (n >= 0 && n < this.fFilters.size()) {
            if (this.fFilters.size() == 1) {
                this.fActiveIndex = -1;
            } else if (this.fActiveIndex > n) {
                --this.fActiveIndex;
            } else if (this.fActiveIndex == n) {
                this.fActiveIndex = 0;
            }
            this.fFilters.removeElementAt(n);
        }
    }

    void removeFilter(PropertyFilter propertyFilter) {
        this.removeFilter(this.fFilters.indexOf(propertyFilter));
    }

    PropertyFilter[] getFilters() {
        PropertyFilter[] propertyFilterArray = new PropertyFilter[this.fFilters.size()];
        int n = 0;
        while (n < propertyFilterArray.length) {
            propertyFilterArray[n] = (PropertyFilter)this.fFilters.elementAt(n);
            ++n;
        }
        return propertyFilterArray;
    }
}

