/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.filtermgr;

import com.mathworks.ide.filtermgr.FilterManager;
import com.mathworks.ide.filtermgr.FilterManagerEvent;
import com.mathworks.ide.filtermgr.FilterManagerListener;
import com.mathworks.ide.filtermgr.FilterNameTextField;
import com.mathworks.ide.filtermgr.FilterTList;
import com.mathworks.ide.filtermgr.InsetPanel;
import com.mathworks.ide.filtermgr.PropertyFilter;
import com.mathworks.mwt.MWButton;
import com.mathworks.mwt.MWCanvas;
import com.mathworks.mwt.MWCenterLayout;
import com.mathworks.mwt.MWChoice;
import com.mathworks.mwt.MWFrame;
import com.mathworks.mwt.MWLabel;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.MWTextField;
import com.mathworks.mwt.MWToolbar;
import com.mathworks.mwt.MWTwoColumnLayout;
import com.mathworks.mwt.command.MWCommandCenter;
import com.mathworks.mwt.command.MWCommandSource;
import com.mathworks.mwt.command.MWCommandTarget;
import com.mathworks.mwt.dialog.MWAlert;
import com.mathworks.mwt.window.MWWindowActivater;
import com.mathworks.mwt.window.MWWindowOwner;
import com.mathworks.mwt.window.WindowRegistry;
import com.mathworks.util.jarloader.SimpleClassLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowListener;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;

public class FilterEditor
extends MWPanel
implements MWCommandTarget,
ItemListener,
MWWindowOwner,
FilterManagerListener {
    private static final int ADD = 0;
    private static final int REMOVE = 1;
    private static final int DUPLICATE = 3;
    private static final int DELETE = 4;
    private static final int SET_NAME = 5;
    private static final String MWT_RES = "/com/mathworks/mwt/resources/";
    private static final String FLT_RES = "/com/mathworks/ide/filtermgr/resources/";
    private static final String MY_NAME = "Filter Editor";
    private FilterTList fSrcList;
    private FilterTList fDestList;
    private MWButton fAddButton;
    private MWButton fRemoveButton;
    private MWChoice fFilterPopup;
    private MWToolbar fToolbar;
    private MWTextField fNameField;
    private FilterManager fFilterManager;
    private String fClassName;
    private int fFilterIndex = -1;
    private PropertyFilter fFilter;
    private boolean fDirty = false;
    private MWCommandCenter fCommandCenter;
    private MWFrame fFrame;

    public FilterEditor() {
        this(null, null);
    }

    public FilterEditor(FilterManager filterManager, MWFrame mWFrame) {
        this.fFilterManager = filterManager;
        this.fFilterManager.addFilterManagerListener(this);
        this.fFrame = mWFrame;
        this.fCommandCenter = new MWCommandCenter((MWCommandTarget)this);
        this.setOpaque(false);
        ((Component)((Object)this)).setFont(new Font("SansSerif", 0, 10));
        this.fToolbar = new MWToolbar();
        this.fToolbar.addImageButton("/com/mathworks/mwt/resources/new.gif", -101, this.fCommandCenter);
        this.fToolbar.addImageButton("/com/mathworks/mwt/resources/save.gif", -104, this.fCommandCenter);
        this.fToolbar.addSpacer();
        this.fToolbar.addImageButton("/com/mathworks/ide/filtermgr/resources/duplicatefilter.gif", 3, this.fCommandCenter);
        this.fToolbar.addImageButton("/com/mathworks/ide/filtermgr/resources/deletefilter.gif", 4, this.fCommandCenter);
        this.fToolbar.addSpacer();
        MWPanel mWPanel = new MWPanel((LayoutManager)new FlowLayout(0, 0, 3));
        mWPanel.add((Component)new MWLabel("Filter:"));
        mWPanel.add((Component)new MWCanvas(3, 3));
        this.fFilterPopup = new MWChoice();
        this.fFilterPopup.addItemListener((ItemListener)this);
        mWPanel.add((Component)this.fFilterPopup);
        this.fToolbar.addComponent((Component)mWPanel);
        MWPanel mWPanel2 = new MWPanel((LayoutManager)new MWCenterLayout(4));
        MWPanel mWPanel3 = new MWPanel((LayoutManager)new GridLayout(0, 1, 0, 4));
        mWPanel2.add((Component)mWPanel3);
        this.fAddButton = this.buildCommandButton("Add  >>", 0);
        mWPanel3.add((Component)this.fAddButton);
        this.fRemoveButton = this.buildCommandButton("Remove", 1);
        mWPanel3.add((Component)this.fRemoveButton);
        MWPanel mWPanel4 = new MWPanel((LayoutManager)new MWTwoColumnLayout());
        mWPanel4.setOpaque(false);
        mWPanel4.add((Component)new MWCanvas(mWPanel2.getPreferredSize().width, 2), "Center");
        mWPanel4.add((Component)new MWLabel("Available properties:"), "West");
        MWPanel mWPanel5 = new MWPanel((LayoutManager)new BorderLayout(3, 0));
        mWPanel5.setOpaque(false);
        mWPanel5.add((Component)new MWLabel("Filter Name:"), "West");
        this.fNameField = new FilterNameTextField(this.fCommandCenter, 5);
        this.fNameField.setFont(this.getFont());
        this.fNameField.setColumns(15);
        mWPanel5.add((Component)this.fNameField, "Center");
        mWPanel5.add((Component)new MWCanvas(3, 3), "North");
        mWPanel5.add((Component)new MWCanvas(3, 3), "South");
        mWPanel4.add((Component)mWPanel5, "East");
        this.fSrcList = this.buildList();
        this.fDestList = this.buildList();
        InsetPanel insetPanel = new InsetPanel(0, 8, 8, 8);
        insetPanel.setOpaque(false);
        ((Container)((Object)insetPanel)).setLayout((LayoutManager)new MWTwoColumnLayout());
        ((Container)((Object)insetPanel)).add((Component)mWPanel4, "North");
        ((Container)((Object)insetPanel)).add((Component)((Object)this.fSrcList), "West");
        ((Container)((Object)insetPanel)).add((Component)mWPanel2, "Center");
        ((Container)((Object)insetPanel)).add((Component)((Object)this.fDestList), "East");
        ((Container)((Object)this)).setLayout(new BorderLayout());
        ((Container)((Object)this)).add((Component)this.fToolbar, "North");
        ((Container)((Object)this)).add((Component)((Object)insetPanel), "Center");
        this.initContents();
        this.updateControls();
        if (this.fFrame != null) {
            WindowRegistry.getRegistry().register((MWWindowOwner)this);
        }
    }

    private FilterTList buildList() {
        FilterTList filterTList = new FilterTList();
        filterTList.setFont(this.getFont());
        filterTList.setMultiSelection(true);
        filterTList.setHiliteItemHilite(true);
        filterTList.setWholeItemSelect(true);
        filterTList.setWholeItemHilite(true);
        filterTList.setDrawRowLines(false);
        filterTList.addItemListener(this);
        return filterTList;
    }

    private MWButton buildCommandButton(String string, int n) {
        MWButton mWButton = new MWButton(string);
        this.fCommandCenter.addCommandSource((MWCommandSource)mWButton, n);
        return mWButton;
    }

    private void doAdd() {
        int n = this.fSrcList.getFirstSelectedItem();
        boolean bl = ((Component)((Object)this.fDestList)).isVisible();
        if (bl) {
            this.fDestList.setVisible(false);
        }
        while (n != -1) {
            String string = this.fSrcList.getItemString(n);
            int n2 = this.fDestList.getFirstItem();
            while (n2 != -1 && !string.equals(this.fDestList.getItemString(n2))) {
                n2 = this.fDestList.getNextItem();
            }
            if (n2 == -1) {
                this.fDestList.add(string);
                this.fFilter.add(string);
            }
            n = this.fSrcList.getNextSelectedItem(n);
        }
        if (bl) {
            this.fDestList.setVisible(true);
        }
        this.fDirty = true;
        this.updateControls();
    }

    private void doRemove() {
        int n = this.fDestList.getFirstSelectedItem();
        boolean bl = ((Component)((Object)this.fDestList)).isVisible();
        if (bl) {
            this.fDestList.setVisible(false);
        }
        while (n != -1) {
            if (this.fFilter != null) {
                this.fFilter.remove(this.fDestList.getItemString(n));
            }
            this.fDestList.remove(n);
            n = this.fDestList.getFirstSelectedItem();
        }
        if (bl) {
            this.fDestList.setVisible(true);
        }
        this.fDirty = true;
        this.updateControls();
    }

    private void doNew() {
        if (this.fFilterManager != null) {
            this.fFilterManager.editFilter(this.fClassName, null);
        }
    }

    private void doSave() {
        if (this.fFilter != null) {
            if (this.fFilterIndex == -1) {
                int n = this.fFilterManager.getFilters(this.fClassName).length;
                this.fFilterManager.addFilter(this.fFilter);
                this.fFilterIndex = n;
            } else {
                this.fFilterManager.writeFilter(this.fFilter, this.fFilterIndex);
            }
        }
        this.fDirty = false;
        this.updateControls();
    }

    private void doDuplicate() {
        this.doSave();
        if (this.fFilter != null) {
            PropertyFilter propertyFilter = new PropertyFilter(this.fFilter);
            propertyFilter.setName(String.valueOf(propertyFilter.getName()) + " copy");
            this.fFilterIndex = -1;
            this.fFilter = propertyFilter;
            this.fNameField.setText(this.fFilter.getName());
            this.fNameField.getView().setHScrollAmount(0);
            this.fNameField.getView().bufferSelect();
            this.fNameField.requestFocus();
            this.fDirty = true;
            this.initContents();
            this.updateControls();
        }
    }

    private void doDelete() {
        if (this.fFilterManager != null && this.fFilter != null && this.fFilterIndex != -1) {
            this.fFilterManager.removeFilter(this.fClassName, this.fFilterIndex);
        }
    }

    private void doSetName() {
        if (this.fFilter != null) {
            this.fFilter.setName(this.fNameField.getText());
        }
        this.fDirty = true;
        this.updateControls();
    }

    private void doClose() {
        this.closeWindow();
    }

    public void doCommand(int n) {
        switch (n) {
            case 0: {
                this.doAdd();
                return;
            }
            case 1: {
                this.doRemove();
                return;
            }
            case 3: {
                this.doDuplicate();
                return;
            }
            case 4: {
                this.doDelete();
                return;
            }
            case 5: {
                this.doSetName();
                return;
            }
            case -101: {
                this.doNew();
                return;
            }
            case -104: {
                this.doSave();
                return;
            }
            case -103: {
                this.doClose();
                return;
            }
        }
    }

    private void growPopup() {
        Container container = this.fFilterPopup.getParent();
        this.fFilterPopup.invalidate();
        container.setSize(((Component)container).getPreferredSize());
        this.fToolbar.validate();
        container.repaint(5L);
    }

    private void updateControls() {
        boolean bl = this.fFilter != null;
        PropertyFilter[] propertyFilterArray = bl ? this.fFilterManager.getFilters(this.fClassName) : new PropertyFilter[]{};
        this.fFilterPopup.removeAll();
        int n = 0;
        while (n < propertyFilterArray.length) {
            this.fFilterPopup.add(propertyFilterArray[n].getName());
            ++n;
        }
        if (this.fFilterIndex == -1) {
            if (bl) {
                this.fFilterPopup.add(this.fFilter.getName());
                this.fFilterPopup.select(propertyFilterArray.length);
            }
        } else {
            this.fFilterPopup.select(this.fFilterIndex);
        }
        this.fFilterPopup.setEnabled(bl);
        this.fCommandCenter.setCommandEnabled(-101, true);
        this.fCommandCenter.setCommandEnabled(-104, this.fDirty && bl);
        this.fCommandCenter.setCommandEnabled(-103, true);
        this.fCommandCenter.setCommandEnabled(0, this.fSrcList.getSelectedIds().length > 0);
        this.fCommandCenter.setCommandEnabled(1, this.fDestList.getSelectedIds().length > 0);
        this.fCommandCenter.setCommandEnabled(3, bl);
        this.fCommandCenter.setCommandEnabled(4, bl);
        this.fCommandCenter.setCommandEnabled(5, bl);
        this.growPopup();
    }

    private void initContents() {
        String[] stringArray;
        String[] stringArray2;
        if (this.fFilter != null) {
            stringArray2 = this.getPropertyNames(this.fClassName);
            stringArray = this.fFilter.getEntries();
        } else {
            stringArray2 = new String[]{};
            stringArray = new String[]{};
        }
        this.fSrcList.removeAll();
        this.sortStringArray(stringArray2);
        int n = 0;
        while (n < stringArray2.length) {
            this.fSrcList.add(stringArray2[n]);
            ++n;
        }
        this.fDestList.removeAll();
        int n2 = 0;
        while (n2 < stringArray.length) {
            this.fDestList.add(stringArray[n2]);
            ++n2;
        }
    }

    private String[] getPropertyNames(String string) {
        BeanInfo beanInfo = null;
        PropertyDescriptor[] propertyDescriptorArray = null;
        String[] stringArray = new String[]{};
        try {
            Class clazz = SimpleClassLoader.ourLoader.loadClass(string);
            if (clazz != null) {
                beanInfo = Introspector.getBeanInfo(clazz);
            }
            if (beanInfo != null) {
                propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            }
            if (propertyDescriptorArray != null) {
                stringArray = new String[propertyDescriptorArray.length];
                int n = 0;
                while (n < stringArray.length) {
                    stringArray[n] = propertyDescriptorArray[n].getDisplayName();
                    ++n;
                }
            }
        }
        catch (Exception exception) {}
        return stringArray;
    }

    private void sortStringArray(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            int n2 = n;
            int n3 = n + 1;
            while (n3 < stringArray.length) {
                if (stringArray[n3].compareTo(stringArray[n2]) < 0) {
                    n2 = n3;
                }
                ++n3;
            }
            String string = stringArray[n2];
            stringArray[n2] = stringArray[n];
            stringArray[n] = string;
            ++n;
        }
    }

    public void setEditFilter(PropertyFilter propertyFilter, int n) {
        if (this.ensureSaved()) {
            this.fClassName = propertyFilter.getClassName();
            this.fFilterIndex = n;
            this.fFilter = new PropertyFilter(propertyFilter);
            this.fNameField.setText(this.fFilter.getName());
            this.fNameField.getView().setHScrollAmount(0);
            this.fNameField.getView().bufferSelect();
            this.fNameField.requestFocus();
            this.fDirty = false;
            this.initContents();
            this.updateControls();
        }
    }

    public void setEditFilter(String string, String string2, int n) {
        if (this.ensureSaved()) {
            this.fClassName = string;
            this.fFilterIndex = n;
            this.fFilter = new PropertyFilter(string, string2);
            this.fNameField.setText(this.fFilter.getName());
            this.fNameField.getView().setHScrollAmount(0);
            this.fNameField.getView().bufferSelect();
            this.fNameField.requestFocus();
            this.fDirty = true;
            this.initContents();
            this.updateControls();
        }
    }

    private boolean ensureSaved() {
        boolean bl = true;
        if (this.fDirty) {
            String string = this.fFilter != null ? this.fFilter.getName() : "";
            String string2 = "Save changes to " + string + "?";
            int n = new MWAlert((Frame)this.fFrame, "MATLAB Filter Editor", string2, 4).getReply();
            if (n == 1) {
                this.doSave();
            } else if (n == 4) {
                bl = false;
            }
        }
        return bl;
    }

    public void filterAdded(FilterManagerEvent filterManagerEvent) {
        this.updateControls();
    }

    public void filterRemoved(FilterManagerEvent filterManagerEvent) {
        PropertyFilter[] propertyFilterArray = this.fFilterManager.getFilters(this.fClassName);
        if (propertyFilterArray.length > 0) {
            this.fFilterIndex = 0;
            this.fFilter = new PropertyFilter(propertyFilterArray[0]);
            this.fNameField.setText(this.fFilter.getName());
        } else {
            this.fFilterIndex = -1;
            this.fFilter = null;
            this.fNameField.setText("");
        }
        this.fNameField.getView().setHScrollAmount(0);
        this.fNameField.getView().bufferSelect();
        this.fNameField.requestFocus();
        this.fDirty = false;
        this.initContents();
        this.updateControls();
    }

    public void filterSelected(FilterManagerEvent filterManagerEvent) {
    }

    public void filterChanged(FilterManagerEvent filterManagerEvent) {
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.fFilterPopup && this.fFilter != null) {
            PropertyFilter[] propertyFilterArray = this.fFilterManager.getFilters(this.fClassName);
            int n = this.fFilterPopup.getSelectedIndex();
            PropertyFilter propertyFilter = propertyFilterArray[n];
            this.setEditFilter(propertyFilter, n);
        }
        this.updateControls();
    }

    void makeActive() {
        if (this.fFrame != null) {
            if (!this.fFrame.isVisible()) {
                this.fFrame.setVisible(true);
            }
            this.fFrame.toFront();
        }
    }

    Rectangle getWindowPosition() {
        Rectangle rectangle = null;
        if (this.fFrame != null) {
            rectangle = this.fFrame.getBounds();
        }
        return rectangle;
    }

    public int closeWindow() {
        if (this.ensureSaved()) {
            if (this.fFilterManager != null) {
                this.fFilterManager.removeFilterManagerListener(this);
                this.fFilterManager.editorClosed();
            }
            if (this.fFrame != null) {
                WindowRegistry.getRegistry().unregister((MWWindowOwner)this);
                this.fFrame.dispose();
            }
            return 0;
        }
        return 1;
    }

    public void setActive(boolean bl) {
    }

    public String getShortName() {
        return MY_NAME;
    }

    public String getLongName() {
        return MY_NAME;
    }

    public static void main(String[] stringArray) {
        try {
            MWFrame mWFrame = new MWFrame(MY_NAME);
            FilterEditor filterEditor = new FilterEditor(null, mWFrame);
            mWFrame.add((Component)((Object)filterEditor), "Center");
            mWFrame.addWindowListener((WindowListener)new MWWindowActivater((Component)((Object)filterEditor)));
            mWFrame.setContentSize(((Container)((Object)filterEditor)).getPreferredSize());
            mWFrame.setVisible(true);
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }
}

