/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.editor;

import com.mathworks.ide.editor.MWTwoPartWidget;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;

public class VertFlowLayout
extends FlowLayout {
    public static final int CENTER = 1;
    public static final int BOTTOM = 2;
    public static final int TOP = 3;
    public static final int STRETCH = 4;
    private int fAlignment = 1;
    private boolean fMaximizeHorizontally = false;

    public VertFlowLayout() {
    }

    public VertFlowLayout(int n) {
        this.fAlignment = n;
    }

    public VertFlowLayout(int n, int n2, int n3) {
        super(1, n2, n3);
        this.fAlignment = n;
    }

    public VertFlowLayout(int n, boolean bl) {
        this.fAlignment = n;
        this.fMaximizeHorizontally = bl;
    }

    public void setAlignment(int n) {
        this.fAlignment = n;
    }

    public int getAlignment() {
        return this.fAlignment;
    }

    public void setMaximizeHorizontally(boolean bl) {
        this.fMaximizeHorizontally = bl;
    }

    public boolean getMaximizeHorizontally() {
        return this.fMaximizeHorizontally;
    }

    public Dimension minimumLayoutSize(Container container) {
        Dimension dimension = this.preferredLayoutSize(container);
        return dimension;
    }

    public Dimension preferredLayoutSize(Container container) {
        Cloneable cloneable;
        Dimension dimension = new Dimension(1, 1);
        int n = container.getComponentCount();
        if (n <= 0) {
            return dimension;
        }
        Component[] componentArray = container.getComponents();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            cloneable = componentArray[n4].getPreferredSize();
            n2 = Math.max(((Dimension)cloneable).width + this.getHgap(), n2);
            n3 += ((Dimension)cloneable).height + this.getVgap();
            ++n4;
        }
        cloneable = container.getInsets();
        dimension.width = n2 += cloneable.left + cloneable.right;
        dimension.height = n3 += cloneable.top + cloneable.bottom - this.getVgap();
        return dimension;
    }

    public void layoutContainer(Container container) {
        int n = container.getComponentCount();
        if (n <= 0) {
            return;
        }
        Dimension dimension = container.getSize();
        if (dimension.width <= 0 || dimension.height <= 0) {
            return;
        }
        Insets insets = container.getInsets();
        int n2 = dimension.height - insets.top - insets.bottom;
        int n3 = dimension.width - insets.left - insets.right;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        Component[] componentArray = container.getComponents();
        int n7 = 0;
        while (n7 < n) {
            MWTwoPartWidget mWTwoPartWidget;
            Dimension dimension2 = componentArray[n7].getPreferredSize();
            n6 += dimension2.height;
            n5 += dimension2.height + this.getVgap();
            if (componentArray[n7] instanceof MWTwoPartWidget && (mWTwoPartWidget = (MWTwoPartWidget)((Object)componentArray[n7])).isHasPrompt()) {
                n4 = Math.max(n4, mWTwoPartWidget.getPrompt().getPreferredSize().width);
            }
            ++n7;
        }
        n5 = Math.min(n5 - this.getVgap(), n2);
        int n8 = insets.left;
        int n9 = insets.top;
        int n10 = this.getVgap();
        switch (this.fAlignment) {
            case 1: {
                double d = ((double)n2 - (double)n5 + 0.5) / 2.0;
                n9 = (int)d;
                break;
            }
            case 3: {
                n9 = 0;
                break;
            }
            case 2: {
                n9 = n2 - n5;
                break;
            }
            case 4: {
                n9 = 0;
                if (n <= 1) break;
                n10 = (n2 - n6) / (n - 1);
                break;
            }
        }
        if (n9 < 0) {
            n9 = 0;
            n10 = Math.max(1, n2 / n);
        }
        n9 += insets.top;
        n7 = 0;
        while (n7 < n) {
            Dimension dimension3 = componentArray[n7].getPreferredSize();
            if (this.fMaximizeHorizontally) {
                dimension3.width = n3;
            }
            if (componentArray[n7] instanceof MWTwoPartWidget) {
                ((MWTwoPartWidget)((Object)componentArray[n7])).setSize(dimension3, n4);
            } else {
                componentArray[n7].setSize(dimension3);
            }
            componentArray[n7].setLocation(n8, n9);
            n9 += dimension3.height + n10;
            ++n7;
        }
    }
}

