/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.editor;

import com.mathworks.ide.browsers.FileBrowser;
import com.mathworks.ide.browsers.FindView;
import com.mathworks.ide.editor.EditorApplication;
import com.mathworks.ide.editor.EditorViewContainer;
import com.mathworks.ide.editor.MWReplaceEvent;
import com.mathworks.ide.editor.MWReplaceListener;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwt.MWBorderLayout;
import com.mathworks.mwt.MWButton;
import com.mathworks.mwt.MWCheckbox;
import com.mathworks.mwt.MWCombobox;
import com.mathworks.mwt.MWFrame;
import com.mathworks.mwt.MWLabel;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.MWTabPanel;
import com.mathworks.mwt.MWTextField;
import com.mathworks.mwt.command.MWCommandCenter;
import com.mathworks.mwt.command.MWCommandTarget;
import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.mwt.dialog.MWAlert;
import com.mathworks.mwt.message.MWLooper;
import com.mathworks.mwt.window.MWWindowActivater;
import com.mathworks.mwt.window.MWWindowOwner;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;

public class MWReplaceDialog
extends MWPanel
implements MWCommandTarget,
MWWindowOwner {
    private static ResourceBundle sRes;
    public static final int MATCH_CASE = 1;
    public static final int WRAP_AROUND = 2;
    public static final int WHOLE_WORD = 4;
    public static final int REVERSE = 8;
    public static final int EDITOR = 1;
    public static final int FILEBROWSER = 2;
    public static final int MATLAB = 3;
    public static final int FIND_ACTION = 1;
    public static final int REPLACE_ACTION = 2;
    public static final int REPLACE_ALL_ACTION = 3;
    public static final int STOP_ACTION = 4;
    public static final int CLOSE_ACTION = 5;
    public static final int EDITOR_SEARCH_FILTERS = 1;
    public static final int FILEBROWSER_SEARCH_FILTERS = 2;
    public static final int MATLAB_SEARCH_FILTERS = 4;
    private static String sCurrentFileStr;
    private static String sCurrentFilesDirStr;
    private static String MY_NAME;
    private MWCommandCenter fCenter;
    private String fFindString;
    private String fReplaceString;
    private MyButton fFindButton;
    private MyButton fReplaceButton;
    private MyButton fReplaceAllButton;
    private MyButton fCloseButton;
    private MyButton fCancel;
    private MWCheckbox fMatchCase;
    private MWCheckbox fWrapAround;
    private MWCheckbox fWholeWord;
    private MWCheckbox fCommentBlockOnly;
    private MyCombobox fText;
    private MyCombobox fReplaceText;
    private MyCombobox fSearchFilter;
    private Label fLabel;
    private MWReplaceListener fReplaceListener;
    private int fOptions;
    private MyButton fDefaultButton;
    private FindView findList;
    private boolean fDialogIsExpanded = false;
    private MWTabPanel fCenterPanel;
    private String fEditorDirectoryName;
    private FindInFilesThread fFindThread;
    private boolean fThreadInProgress = false;
    private boolean fInterruptFind = false;
    private String fCurrentMatlabDir;
    private MWFrame fMyFrame;
    private int fCurrentFilters;
    private Dimension fDefaultSize;
    private int fWidth;
    private int fHeight;
    private static MWReplaceDialog sReplaceDialog;

    public MWReplaceDialog(Frame frame, int n, MWReplaceListener mWReplaceListener, String string, int n2) {
        sRes = EditorApplication.getSRes();
        sCurrentFileStr = sRes.getString("filter.EditorCurrentFile");
        sCurrentFilesDirStr = sRes.getString("filter.EditorCurrentFilesDirectory");
        MY_NAME = sRes.getString("title.FindAndReplace");
        sReplaceDialog = this;
        this.fFindString = string;
        this.fReplaceString = "";
        this.fReplaceListener = mWReplaceListener;
        ((Container)((Object)this)).setLayout((LayoutManager)new MWBorderLayout());
        ((Component)((Object)this)).setBackground(Decorations.getColor((int)1));
        MWPanel mWPanel = new MWPanel((LayoutManager)new GridLayout(3, 1, 4, 4));
        mWPanel.add((Component)new MWLabel(sRes.getString("label.Findwhat")));
        mWPanel.add((Component)new MWLabel(sRes.getString("label.Replacewith")));
        mWPanel.add((Component)new MWLabel(sRes.getString("label.Lookin")));
        MyActionListener myActionListener = new MyActionListener();
        this.fFindButton = new MyButton(sRes.getString("button.Find"));
        this.fFindButton.addActionListener(myActionListener);
        this.fFindButton.setActionCommand("Find");
        this.fFindButton.setEnabled(false);
        this.fReplaceButton = new MyButton(sRes.getString("button.Replace"));
        this.fReplaceButton.addActionListener(myActionListener);
        this.fReplaceAllButton = new MyButton(sRes.getString("button.ReplaceAll"));
        this.fReplaceAllButton.addActionListener(myActionListener);
        this.fCloseButton = new MyButton(sRes.getString("button.Close"));
        this.fCloseButton.setActionCommand("Close");
        this.fCloseButton.addActionListener(myActionListener);
        MWPanel mWPanel2 = new MWPanel((LayoutManager)new GridLayout(3, 1, 4, 4));
        mWPanel2.add((Component)((Object)this.fFindButton));
        mWPanel2.add((Component)((Object)this.fReplaceButton));
        mWPanel2.add((Component)((Object)this.fReplaceAllButton));
        String[] stringArray = new String[]{null};
        if (!this.fFindString.equals("")) {
            stringArray[0] = this.fFindString;
        }
        SearchFilterListener searchFilterListener = new SearchFilterListener();
        this.fText = new MyCombobox(this.fFindString, stringArray, 1);
        ((Component)((Object)this.fText)).setName("Find Field");
        ((Component)((Object)this.fText)).addFocusListener(new TextFieldFocusListener(this.fFindButton));
        this.fText.addActionListener(searchFilterListener);
        String[] stringArray2 = new String[]{null};
        this.fReplaceText = new MyCombobox("", stringArray2, 2);
        ((Component)((Object)this.fReplaceText)).setName("Replace Field");
        this.fReplaceText.addActionListener(searchFilterListener);
        ((Component)((Object)this.fReplaceText)).addFocusListener(new TextFieldFocusListener(this.fReplaceButton));
        String[] stringArray3 = new String[]{sCurrentFileStr};
        this.fSearchFilter = new MyCombobox("", stringArray3, 1);
        ((Component)((Object)this.fSearchFilter)).setName("Look In Field");
        this.fSearchFilter.addActionListener(searchFilterListener);
        this.addAllAppropriateSearchFilters();
        MWPanel mWPanel3 = new MWPanel((LayoutManager)new GridLayout(3, 1, 4, 4));
        mWPanel3.add((Component)((Object)this.fText));
        mWPanel3.add((Component)((Object)this.fReplaceText));
        mWPanel3.add((Component)((Object)this.fSearchFilter));
        MWPanel mWPanel4 = new MWPanel((LayoutManager)new BorderLayout(5, 5));
        mWPanel4.setOpaque(false);
        mWPanel4.setInsets(new Insets(7, 5, 3, 5));
        mWPanel4.add((Component)mWPanel, "West");
        mWPanel4.add((Component)mWPanel3, "Center");
        mWPanel4.add((Component)mWPanel2, "East");
        this.fMatchCase = new MWCheckbox(sRes.getString("option.Matchcase"));
        this.fMatchCase.setState((n2 & 1) != 0);
        this.fWholeWord = new MWCheckbox(sRes.getString("option.Wholeword"));
        this.fWholeWord.setState((n2 & 4) != 0);
        this.fWrapAround = new MWCheckbox(sRes.getString("option.Subdirectories"));
        this.fWrapAround.setState((n2 & 2) != 0);
        MWPanel mWPanel5 = new MWPanel((LayoutManager)new GridLayout(1, 3));
        mWPanel5.add((Component)this.fMatchCase);
        mWPanel5.add((Component)this.fWholeWord);
        mWPanel5.add((Component)this.fWrapAround);
        MWPanel mWPanel6 = new MWPanel((LayoutManager)new BorderLayout(5, 5));
        mWPanel6.setInsets(new Insets(7, 5, 3, 5));
        mWPanel6.add((Component)mWPanel5, "Center");
        mWPanel6.add((Component)((Object)this.fCloseButton), "East");
        MWPanel mWPanel7 = new MWPanel((LayoutManager)new BorderLayout());
        mWPanel7.add((Component)mWPanel4, "North");
        mWPanel7.add((Component)mWPanel6, "South");
        ((Container)((Object)this)).add((Component)mWPanel7, "North");
        this.fCenterPanel = new MWTabPanel(-1, 0, false);
        this.fCenterPanel.setOpaque(false);
        this.fCenterPanel.setInsets(new Insets(5, 0, 0, 0));
        this.fCenter = new MWCommandCenter((MWCommandTarget)this);
        this.addDialogToFrame(frame);
    }

    private void addDialogToFrame(Frame frame) {
        this.fMyFrame = new MWFrame(MY_NAME);
        this.fMyFrame.add((Component)((Object)this), "Center");
        this.fMyFrame.addWindowListener((WindowListener)new MWWindowActivater((Component)((Object)this)));
        this.fMyFrame.setResizable(false);
        this.fDialogIsExpanded = false;
        if (this.fDefaultSize == null) {
            this.fMyFrame.pack();
            this.fWidth = this.fMyFrame.getSize().width;
            this.fHeight = this.fMyFrame.getSize().height;
            this.fDefaultSize = new Dimension(this.fWidth, this.fHeight);
        }
        Rectangle rectangle = frame.getBounds();
        rectangle.x += rectangle.width / 2 - this.fWidth / 2;
        rectangle.y += rectangle.height / 3 - this.fHeight / 2;
        this.fMyFrame.setBounds(rectangle.x, rectangle.y, this.fWidth, this.fHeight);
        this.fMyFrame.show();
    }

    private void addAllAppropriateSearchFilters() {
        this.fSearchFilter.removeAllItems();
        if (EditorApplication.getOpenDocuments().size() > 0) {
            this.addEditorFilters();
        }
        this.addMatlabFilters();
        FileBrowser fileBrowser = FileBrowser.getFileBrowser();
        if (fileBrowser != null && fileBrowser.isVisible()) {
            this.addFileBrowserFilters();
        }
    }

    public static MWReplaceDialog invoke(Frame frame, int n, MWReplaceListener mWReplaceListener, String string, int n2) {
        int n3 = 0;
        while (n3 < string.length()) {
            if (string.charAt(n3) != '\n') break;
            ++n3;
        }
        string = string.substring(n3);
        int n4 = string.indexOf("\n");
        if (n4 != -1) {
            string = string.substring(0, n4 - 1);
        }
        if (sReplaceDialog == null) {
            sReplaceDialog = new MWReplaceDialog(frame, n, mWReplaceListener, string, n2);
        } else if (MWReplaceDialog.sReplaceDialog.fMyFrame == null) {
            sReplaceDialog.addDialogToFrame(frame);
        } else {
            MWReplaceDialog.sReplaceDialog.fMyFrame.toFront();
        }
        MWReplaceDialog.sReplaceDialog.fText.setText(string);
        MWReplaceDialog.sReplaceDialog.fText.requestFocus();
        sReplaceDialog.updateComboboxes();
        MWReplaceDialog.sReplaceDialog.fText.selectAll();
        sReplaceDialog.setSearchFilterText(n);
        return sReplaceDialog;
    }

    public static MWReplaceDialog getReplaceDialog() {
        return sReplaceDialog;
    }

    public MWCombobox getSearchFilter() {
        return this.fSearchFilter;
    }

    public void setEditorFilename(String string) {
        File file = new File(string);
        this.fEditorDirectoryName = file.getParent();
        if (this.fEditorDirectoryName == null) {
            this.fSearchFilter.removeItem(sCurrentFilesDirStr);
        } else if (!this.fSearchFilter.contains(sCurrentFilesDirStr)) {
            this.addAllAppropriateSearchFilters();
        }
        String string2 = file.getName();
        String[] stringArray = this.fSearchFilter.getItems();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].length() > 20 && stringArray[n].substring(0, sCurrentFileStr.length()).equals(sCurrentFileStr)) {
                stringArray[n] = String.valueOf(sCurrentFileStr) + " (" + string2 + ")";
                this.fSearchFilter.setItems(stringArray);
                if (this.fSearchFilter.getText().length() < sCurrentFileStr.length() || !this.fSearchFilter.getText().substring(0, sCurrentFileStr.length()).equals(sCurrentFileStr)) break;
                this.fSearchFilter.setText(stringArray[n]);
                this.grayOutOptions();
                return;
            }
            ++n;
        }
    }

    public void addSearchFilters(int n) {
        if ((this.fCurrentFilters & n) == n) {
            return;
        }
        this.fSearchFilter.removeAllItems();
        this.fCurrentFilters |= n;
        if ((this.fCurrentFilters & 1) == 1) {
            this.addEditorFilters();
        }
        this.addMatlabFilters();
        if ((this.fCurrentFilters & 2) == 2) {
            this.addFileBrowserFilters();
        }
    }

    public void addReplaceListener(MWReplaceListener mWReplaceListener) {
        this.fReplaceListener = mWReplaceListener;
    }

    public void removeSearchFilters(int n) {
        String string = null;
        if (n == 1) {
            string = sRes.getString("filter.Editor");
        } else if (n == 2) {
            string = sRes.getString("filter.CurrentDirectorySelectedFiles");
        } else {
            return;
        }
        this.fCurrentFilters &= ~n;
        String[] stringArray = this.fSearchFilter.getItems();
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].length() >= string.length() && stringArray[n2].substring(0, string.length()).equals(string)) {
                this.fSearchFilter.removeItem(stringArray[n2]);
            }
            ++n2;
        }
        if (string.length() <= this.fSearchFilter.getText().length() && this.fSearchFilter.getText().substring(0, string.length()).equals(string)) {
            String[] stringArray2 = this.fSearchFilter.getItems();
            this.fSearchFilter.setText(stringArray2[0]);
        }
        this.grayOutOptions();
    }

    private void addEditorFilters() {
        this.fSearchFilter.addItem(sCurrentFileStr);
        this.fSearchFilter.addItem(sCurrentFilesDirStr);
        this.fSearchFilter.addItem(sRes.getString("filter.EditorAllOpenFiles"));
        this.fCurrentFilters |= 1;
    }

    private void addFileBrowserFilters() {
        this.fSearchFilter.addItem(sRes.getString("filter.CurrentDirectorySelectedFiles"));
        this.fCurrentFilters |= 2;
    }

    private void addMatlabFilters() {
        this.fSearchFilter.addItem(sRes.getString("filter.CurrentDirectory"));
        this.fCurrentFilters |= 4;
    }

    private void setSearchFilterText(int n) {
        if (n == 1) {
            this.fSearchFilter.setText(sCurrentFileStr);
        } else if (n == 2 || n == 3) {
            this.fSearchFilter.setText(sRes.getString("filter.CurrentDirectory"));
        }
        this.grayOutOptions();
    }

    private void grayOutOptions() {
        if (this.fThreadInProgress) {
            return;
        }
        this.fFindButton.setLabel(sRes.getString("button.Find"));
        this.fFindButton.setActionCommand("Find");
        String string = this.fSearchFilter.getText();
        if (this.fText.getText().equals("")) {
            this.fFindButton.setEnabled(false);
            this.fReplaceButton.setEnabled(false);
            this.fReplaceAllButton.setEnabled(false);
        } else {
            this.fFindButton.setEnabled(true);
        }
        if (string.length() >= sCurrentFileStr.length() && string.substring(0, sCurrentFileStr.length()).equals(sCurrentFileStr) && !string.equals(sCurrentFilesDirStr)) {
            if (!this.fText.getText().equals("")) {
                this.fReplaceButton.setEnabled(true);
                this.fReplaceAllButton.setEnabled(true);
            }
            this.fReplaceText.setEnabled(true);
        } else {
            this.fReplaceButton.setEnabled(false);
            this.fReplaceAllButton.setEnabled(false);
            this.fReplaceText.setEnabled(false);
        }
        if (string.length() >= sCurrentFileStr.length() && string.substring(0, sCurrentFileStr.length()).equals(sCurrentFileStr) && !string.equals(sRes.getString("filter.EditorCurrentFilesDirectory"))) {
            this.fWrapAround.setLabel(sRes.getString("option.Wraparound"));
            this.fWrapAround.setEnabled(true);
            return;
        }
        if (!string.equals(sRes.getString("filter.EditorAllOpenFiles"))) {
            this.fWrapAround.setLabel(sRes.getString("option.Subdirectories"));
            this.fWrapAround.setEnabled(true);
            return;
        }
        this.fWrapAround.setEnabled(false);
    }

    public void doCommand(int n) {
        boolean bl = true;
        if (this.fCenter.getCommandEnabled(n)) {
            switch (n) {
                case 5: {
                    this.fCenterPanel.removePanel(this.fCenterPanel.getSelectedIndex());
                    if (this.fCenterPanel.getPanelCount() != 0) break;
                    ((Container)((Object)this)).remove((Component)this.fCenterPanel);
                    this.resetDialogToDefaultSize();
                    return;
                }
                default: {
                    bl = false;
                    return;
                }
            }
        }
    }

    private void resetDialogToDefaultSize() {
        ((Container)((Object)this)).invalidate();
        this.fMyFrame.setSize(this.fDefaultSize);
        this.fDialogIsExpanded = false;
        this.fMyFrame.setResizable(false);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    private void stopSearch() {
        this.findList.setSearchLabel(sRes.getString("msg.Findcancelledbyuser"));
        this.findList.setPathCheckboxEnabled(true);
        this.fInterruptFind = true;
        this.findList.interruptFind();
    }

    private void doActionStuff(int n) {
        if (n == 5) {
            if (this.fFindThread != null && this.fThreadInProgress) {
                this.stopSearch();
            }
            this.closeWindow();
            return;
        }
        if (n == 4) {
            this.stopSearch();
            return;
        }
        this.fFindString = this.fText.getText();
        this.fReplaceString = this.fReplaceText.getText();
        MWReplaceEvent mWReplaceEvent = new MWReplaceEvent(this, this.fFindString, this.fReplaceString, this.getOptions());
        if (this.fFindString.length() == 0 && n != -1) {
            return;
        }
        MWPanel mWPanel = new MWPanel();
        mWPanel.setLayout(new BorderLayout());
        this.updateComboboxes();
        if (!this.fSearchFilter.getText().equals(sCurrentFilesDirStr) && this.fSearchFilter.getText().length() >= sCurrentFileStr.length() && this.fSearchFilter.getText().substring(0, sCurrentFileStr.length()).equals(sCurrentFileStr) && this.fReplaceListener != null) {
            if (n == 1) {
                this.fReplaceListener.findRequested(mWReplaceEvent);
                return;
            }
            if (n == 2) {
                this.fReplaceListener.replaceRequested(mWReplaceEvent);
                return;
            }
            if (n == 3) {
                this.fReplaceListener.replaceAllRequested(mWReplaceEvent);
                return;
            }
        } else {
            if (this.fSearchFilter.getText().equals(sRes.getString("filter.CurrentDirectory"))) {
                Matlab matlab = new Matlab(new MWLooper("MWReplaceDialog for cd"));
                matlab.eval("cd", (CompletionObserver)new CwdCallback());
                return;
            }
            if (this.fThreadInProgress) {
                return;
            }
            this.fFindThread = new FindInFilesThread(this.fFindString);
            this.fFindThread.start();
        }
    }

    private void updateComboboxes() {
        this.updateCombobox(this.fText);
        this.updateCombobox(this.fReplaceText);
        String string = this.fSearchFilter.getText();
        if (!string.equals("") && !this.fSearchFilter.contains(string)) {
            this.fSearchFilter.insertItem(string, 0);
        }
    }

    private void updateCombobox(MWCombobox mWCombobox) {
        String string = mWCombobox.getText();
        if (string.equals("")) {
            return;
        }
        if (!mWCombobox.contains(string)) {
            mWCombobox.addItem(string);
        }
        if (mWCombobox.contains(string, true)) {
            mWCombobox.removeItem(string, true);
        }
        String[] stringArray = mWCombobox.getItems();
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = string;
        int n = 0;
        while (n < stringArray.length) {
            stringArray2[n + 1] = stringArray[n];
            ++n;
        }
        mWCombobox.setItems(stringArray2);
    }

    public String getText() {
        return this.fFindString;
    }

    public String getReplaceText() {
        return this.fReplaceString;
    }

    public int getOptions() {
        this.fOptions = 0;
        if (this.fMatchCase.getState()) {
            ++this.fOptions;
        }
        if (this.fWrapAround.getState()) {
            this.fOptions += 2;
        }
        if (this.fWholeWord.getState()) {
            this.fOptions += 4;
        }
        return this.fOptions;
    }

    public int closeWindow() {
        this.fMyFrame.remove((Component)((Object)sReplaceDialog));
        this.fMyFrame.dispose();
        this.fMyFrame = null;
        int n = this.fCenterPanel.getPanelCount();
        int n2 = n - 1;
        while (n2 >= 0) {
            this.fCenterPanel.removePanel(n2);
            --n2;
        }
        ((Container)((Object)this)).remove((Component)this.fCenterPanel);
        return 0;
    }

    public void setActive(boolean bl) {
    }

    public String getShortName() {
        return MY_NAME;
    }

    public String getLongName() {
        return MY_NAME;
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame(sRes.getString("MATLABEditor"));
        ((Component)frame).setBounds(500, 500, 500, 500);
        ((Component)frame).setVisible(true);
        new MWReplaceDialog(frame, 1, null, "findstring", 0);
    }

    static /* synthetic */ boolean access$19(MWReplaceDialog mWReplaceDialog) {
        return mWReplaceDialog.fThreadInProgress;
    }

    static {
        sReplaceDialog = null;
    }

    private class SearchFilterListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MWReplaceDialog.this.grayOutOptions();
        }

        SearchFilterListener() {
            MWReplaceDialog.this = MWReplaceDialog.this;
        }
    }

    private class MyActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            int n = -1;
            if (actionEvent.getSource() == MWReplaceDialog.this.fFindButton) {
                n = MWReplaceDialog.this.fFindButton.getActionCommand().equals("Find") ? 1 : 4;
            } else if (actionEvent.getSource() == MWReplaceDialog.this.fReplaceButton) {
                n = 2;
            } else if (actionEvent.getSource() == MWReplaceDialog.this.fReplaceAllButton) {
                n = 3;
            } else if (actionEvent.getSource() == MWReplaceDialog.this.fCloseButton) {
                n = 5;
            }
            MWReplaceDialog.this.doActionStuff(n);
        }

        MyActionListener() {
            MWReplaceDialog.this = MWReplaceDialog.this;
        }
    }

    private class MyCombobox
    extends MWCombobox {
        private int fAction;
        private MWTextField fTextField;

        public MyCombobox(String string, String[] stringArray, int n) {
            super(string, stringArray);
            MWReplaceDialog.this = MWReplaceDialog.this;
            this.fAction = n;
            this.setRestrictWidth(false);
            this.fTextField = this.getTextField();
            this.fTextField.selectAll();
            this.fTextField.addKeyListener((KeyListener)new MyKeyListener());
        }

        public void selectAll() {
            this.fTextField.selectAll();
        }

        private class MyKeyListener
        extends KeyAdapter {
            public void keyReleased(KeyEvent keyEvent) {
                if (MyCombobox.this.fAction == 1) {
                    MWReplaceDialog.this.grayOutOptions();
                }
            }

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    MWReplaceDialog.this.doActionStuff(MyCombobox.this.fAction);
                    return;
                }
                if (keyEvent.getKeyCode() == 27) {
                    MWReplaceDialog.this.closeWindow();
                }
            }

            MyKeyListener() {
                MyCombobox.this = MyCombobox.this;
            }
        }
    }

    class TextFieldFocusListener
    extends FocusAdapter {
        MyButton fButton;

        public TextFieldFocusListener(MyButton myButton) {
            MWReplaceDialog.this = MWReplaceDialog.this;
            this.fButton = myButton;
        }

        public void focusGained(FocusEvent focusEvent) {
            MWReplaceDialog.this.fDefaultButton = this.fButton;
            MWReplaceDialog.this.fDefaultButton.setDefault(true);
            ((Component)((Object)MWReplaceDialog.this.fDefaultButton)).repaint();
        }

        public void focusLost(FocusEvent focusEvent) {
            MWReplaceDialog.this.fDefaultButton.setDefault(false);
            ((Component)((Object)MWReplaceDialog.this.fDefaultButton)).repaint();
        }
    }

    private class MyMWTextField
    extends MWTextField {
        public MyMWTextField(String string, int n) {
            super(string, n);
            MWReplaceDialog.this = MWReplaceDialog.this;
        }

        public Dimension getMinimumSize() {
            return new Dimension(this.fWidth, this.fHeight);
        }
    }

    class FindInFilesThread
    extends Thread {
        private String fSearchStr;
        private String fSearchType;

        FindInFilesThread(String string) {
            MWReplaceDialog.this = MWReplaceDialog.this;
            this.fSearchStr = string;
            MWReplaceDialog.this.findList = new FindView(2, MWReplaceDialog.this.fCenter);
            MWReplaceDialog.this.findList.setPathCheckboxEnabled(false);
            Object[] objectArray = new Object[]{MWReplaceDialog.this.fFindString};
            MWReplaceDialog.this.fCenterPanel.addPanel(MessageFormat.format(sRes.getString("tablabel.Find"), objectArray), (Component)((Object)MWReplaceDialog.this.findList));
            MWReplaceDialog.this.fCenterPanel.setOrientation(3);
            if (MWReplaceDialog.this.fCenterPanel.getPanelCount() == 1) {
                ((Container)((Object)MWReplaceDialog.this)).add((Component)MWReplaceDialog.this.fCenterPanel, "Center");
            }
            if (!MWReplaceDialog.this.fDialogIsExpanded) {
                MWReplaceDialog.this.fMyFrame.pack();
                MWReplaceDialog.this.fMyFrame.setSize(((MWReplaceDialog)MWReplaceDialog.this).fMyFrame.getSize().width, ((MWReplaceDialog)MWReplaceDialog.this).fMyFrame.getSize().height + 50);
                ((Container)((Object)MWReplaceDialog.this)).invalidate();
                ((Container)((Object)MWReplaceDialog.this)).validate();
                MWReplaceDialog.this.fDialogIsExpanded = true;
                MWReplaceDialog.this.fMyFrame.setResizable(true);
            }
            MWReplaceDialog.this.fInterruptFind = false;
        }

        public void run() {
            Object[] objectArray = null;
            boolean bl = true;
            MWReplaceDialog.this.fThreadInProgress = true;
            if (MWReplaceDialog.this.fSearchFilter.getText().equals(sRes.getString("filter.CurrentDirectorySelectedFiles"))) {
                objectArray = FileBrowser.getFileBrowser().getSelectedFiles();
                bl = false;
            } else if (MWReplaceDialog.this.fSearchFilter.getText().equals(sCurrentFilesDirStr)) {
                objectArray = new Object[]{MWReplaceDialog.this.fEditorDirectoryName};
            } else if (MWReplaceDialog.this.fSearchFilter.getText().equals(sRes.getString("filter.EditorAllOpenFiles"))) {
                Vector vector = EditorApplication.getOpenDocuments();
                objectArray = new Object[vector.size()];
                int n = 0;
                while (n < vector.size()) {
                    objectArray[n] = ((EditorViewContainer)vector.elementAt(n)).getLongName();
                    ++n;
                }
                bl = false;
            } else if (MWReplaceDialog.this.fSearchFilter.getText().equals(sRes.getString("filter.CurrentDirectory"))) {
                objectArray = new Object[]{MWReplaceDialog.this.fCurrentMatlabDir};
            } else {
                if (MWReplaceDialog.this.fSearchFilter.getText().equals(sRes.getString("filter.EntireMATLABPath"))) {
                    new MWAlert(MWReplaceDialog.this.getFrame(), MY_NAME, "Not implemented yet.", 1);
                    return;
                }
                String string = MWReplaceDialog.this.fSearchFilter.getText();
                File file = new File(string);
                if (file.exists()) {
                    objectArray = new Object[]{string};
                } else {
                    Object[] objectArray2 = new Object[]{string};
                    new MWAlert(MWReplaceDialog.this.getFrame(), MY_NAME, MessageFormat.format(sRes.getString("error.doesnotexist"), objectArray2), 1);
                    return;
                }
            }
            if (objectArray == null) {
                new MWAlert(MWReplaceDialog.this.getFrame(), MY_NAME, sRes.getString("error.Nothingtosearch"), 1);
                return;
            }
            MWReplaceDialog.this.fReplaceButton.setEnabled(false);
            MWReplaceDialog.this.fReplaceAllButton.setEnabled(false);
            ((Component)((Object)MWReplaceDialog.this.fFindButton)).setVisible(false);
            MWReplaceDialog.this.fFindButton.setLabel(sRes.getString("button.StopFind"));
            MWReplaceDialog.this.fFindButton.setActionCommand("Stop");
            ((Component)((Object)MWReplaceDialog.this.fFindButton)).setVisible(true);
            this.doFind(objectArray, bl);
            ((Component)((Object)MWReplaceDialog.this.fFindButton)).setVisible(false);
            MWReplaceDialog.this.fThreadInProgress = false;
            MWReplaceDialog.this.grayOutOptions();
            ((Component)((Object)MWReplaceDialog.this.fFindButton)).setVisible(true);
        }

        private void doFind(Object[] objectArray, boolean bl) {
            Object object;
            String string;
            String string2 = sRes.getString("label.Directoriessearched");
            if (!bl) {
                string2 = sRes.getString("label.Filessearched");
            }
            int n = 0;
            String string3 = "";
            int n2 = 0;
            while (n2 < objectArray.length && !MWReplaceDialog.this.fInterruptFind) {
                string = (String)objectArray[n2];
                object = new File(string);
                if (((File)object).isDirectory()) {
                    n += MWReplaceDialog.this.findList.findInFiles(string, MWReplaceDialog.this.fFindString, n2 == 0, MWReplaceDialog.this.fMatchCase.getState(), MWReplaceDialog.this.fWholeWord.getState(), MWReplaceDialog.this.fWrapAround.getState(), n);
                } else {
                    int n3 = MWReplaceDialog.this.findList.grepFile(string, MWReplaceDialog.this.fFindString, MWReplaceDialog.this.fMatchCase.getState(), MWReplaceDialog.this.fWholeWord.getState());
                    objectArray[n2] = ((File)object).getName();
                    if (n3 > 0) {
                        ++n;
                    }
                }
                if (n2 > 0) {
                    string3 = String.valueOf(string3) + "; ";
                }
                string3 = String.valueOf(string3) + (String)objectArray[n2];
                ++n2;
            }
            if (MWReplaceDialog.this.fInterruptFind) {
                return;
            }
            MWReplaceDialog.this.findList.setPathCheckboxEnabled(true);
            string = "";
            object = "";
            String string4 = "";
            if (MWReplaceDialog.this.fMatchCase.getState()) {
                string = String.valueOf(sRes.getString("label.matchingcase")) + " ";
            }
            if (MWReplaceDialog.this.fWholeWord.getState()) {
                object = String.valueOf(sRes.getString("label.wholewordonly")) + " ";
            }
            if (MWReplaceDialog.this.fWrapAround.getState() && MWReplaceDialog.this.fWrapAround.isEnabled()) {
                string4 = String.valueOf(sRes.getString("label.includingsubdirectories")) + " ";
            }
            Object[] objectArray2 = new Object[]{Integer.toString(MWReplaceDialog.this.findList.getFileListView().getItemCount()), this.fSearchStr, Integer.toString(n)};
            String string5 = String.valueOf(MessageFormat.format(sRes.getString("msg.XmatchesofYinZfiles"), objectArray2)) + " " + string4 + string + (String)object;
            MWReplaceDialog.this.findList.setResultsLabel(string5, string2, string3);
        }
    }

    private class MyButton
    extends MWButton {
        public MyButton(String string) {
            super(string);
            MWReplaceDialog.this = MWReplaceDialog.this;
        }

        public Dimension getPreferredSize() {
            Dimension dimension = new Dimension(super.getPreferredSize().width, ((MWReplaceDialog)MWReplaceDialog.this).fText.getMinimumSize().height);
            return dimension;
        }
    }

    class CwdCallback
    implements CompletionObserver {
        int fReplyType;

        public CwdCallback() {
            MWReplaceDialog.this = MWReplaceDialog.this;
        }

        public void completed(int n, Object object) {
            String string = (String)object;
            MWReplaceDialog.this.fCurrentMatlabDir = string.trim();
            MWReplaceDialog.this.fFindThread = new FindInFilesThread(MWReplaceDialog.this.fFindString);
            MWReplaceDialog.this.fFindThread.start();
        }
    }
}

