/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.editor;

import com.mathworks.mwt.MWCanvas;
import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.mwt.text.MWTextAdapter;
import com.mathworks.mwt.text.MWTextComponent;
import com.mathworks.mwt.text.MWTextEvent;
import com.mathworks.mwt.text.MWTextListener;
import com.mathworks.mwt.text.MWTextViewAdapter;
import com.mathworks.mwt.text.MWTextViewEvent;
import com.mathworks.mwt.text.MWTextViewListener;
import com.mathworks.util.Offscreen;
import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;

public class LineNumberDisplay
extends MWCanvas {
    private MWTextComponent fText;
    private int fTopLine;
    private int fLineCount;
    private FontMetrics fFontInfo;
    private Offscreen fOffscreen;

    private void repaintAfterChange() {
        if (this.fText.getView().getTopLine() != this.fTopLine || this.fText.getModel().getNumLines() != this.fLineCount) {
            ((Component)((Object)this)).repaint(5L);
        }
    }

    public Dimension getPreferredSize() {
        int n;
        if (this.fFontInfo == null) {
            n = PlatformInfo.isUnix() ? 35 : 30;
            Graphics graphics = ((Component)((Object)this)).getGraphics();
            if (graphics != null && ((Component)((Object)this)).getFont() != null) {
                this.fFontInfo = graphics.getFontMetrics(((Component)((Object)this)).getFont());
                graphics.dispose();
                n = this.fFontInfo.stringWidth("9999") + 4;
            }
        } else {
            n = this.fFontInfo.stringWidth("9999") + 4;
        }
        return new Dimension(n, 100);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.fFontInfo = null;
        Graphics graphics = ((Component)((Object)this)).getGraphics();
        if (graphics != null) {
            this.fFontInfo = graphics.getFontMetrics(font);
            graphics.dispose();
            ((Component)((Object)this)).invalidate();
        }
    }

    private int numberToString(byte[] byArray, int n) {
        int n2 = 0;
        do {
            byArray[n2++] = (byte)(n % 10 + 48);
        } while ((n /= 10) > 0);
        int n3 = n2 >> 1;
        int n4 = 0;
        while (n4 < n3) {
            byte by = byArray[n4];
            byArray[n4] = byArray[n2 - n4 - 1];
            byArray[n2 - n4 - 1] = by;
            ++n4;
        }
        return n2;
    }

    private int numberToString(char[] cArray, int n) {
        int n2 = 0;
        do {
            cArray[n2++] = (char)(n % 10 + 48);
        } while ((n /= 10) > 0);
        int n3 = n2 >> 1;
        int n4 = 0;
        while (n4 < n3) {
            char c = cArray[n4];
            cArray[n4] = cArray[n2 - n4 - 1];
            cArray[n2 - n4 - 1] = c;
            ++n4;
        }
        return n2;
    }

    public synchronized void paint(Graphics graphics) {
        char[] cArray = null;
        byte[] byArray = null;
        Graphics graphics2 = this.fOffscreen.startRender(graphics);
        if (graphics2 == null) {
            return;
        }
        Rectangle rectangle = ((Component)((Object)this)).getBounds();
        rectangle.y = 0;
        rectangle.x = 0;
        graphics2.setFont(((Component)((Object)this)).getFont());
        graphics2.setColor(Decorations.getColor((int)1));
        graphics2.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (this.fFontInfo == null) {
            this.fFontInfo = graphics2.getFontMetrics();
        }
        graphics2.setColor(Color.black);
        int n = this.fText.getModel().getFontHeight();
        this.fTopLine = this.fText.getView().getTopLine();
        this.fLineCount = this.fText.getModel().getNumLines();
        int n2 = this.fTopLine;
        int n3 = this.fLineCount;
        Dimension dimension = this.fText.getView().getSize();
        dimension.height = Math.min(dimension.height, rectangle.height);
        int n4 = (dimension.height + n * 3 / 10) / n;
        if (n3 > n2 + n4) {
            n3 = n2 + n4;
        }
        int n5 = this.fText.getView().pixelYFromLine(n2) + this.fText.getModel().getFontBaseline();
        if (PlatformInfo.isUnix()) {
            cArray = new char[32];
        } else {
            byArray = new byte[32];
        }
        n4 = n2;
        while (n4 < n3) {
            int n6;
            int n7;
            int n8 = 2;
            if (PlatformInfo.isUnix()) {
                n7 = this.numberToString(cArray, n4 + 1);
                n6 = rectangle.width - this.fFontInfo.charsWidth(cArray, 0, n7) - n8;
                graphics2.drawChars(cArray, 0, n7, n6, n5);
            } else {
                n7 = this.numberToString(byArray, n4 + 1);
                n6 = rectangle.width - this.fFontInfo.bytesWidth(byArray, 0, n7) - n8;
                graphics2.drawBytes(byArray, 0, n7, n6, n5);
            }
            n5 += n;
            ++n4;
        }
        graphics2.setColor(Color.white);
        graphics2.drawLine(0, 0, 0, rectangle.height - 1);
        graphics2.drawLine(1, 0, rectangle.width - 1, 0);
        graphics2.setColor(Color.darkGray);
        graphics2.drawLine(0, rectangle.height - 1, rectangle.width - 1, rectangle.height - 1);
        graphics2.drawLine(rectangle.width - 1, 0, rectangle.width - 1, rectangle.height - 2);
        this.fOffscreen.finishRender(graphics);
    }

    public LineNumberDisplay(MWTextComponent mWTextComponent) {
        this.fText = mWTextComponent;
        this.fTopLine = -1;
        this.fLineCount = 0;
        this.fOffscreen = new Offscreen((Component)((Object)this));
        this.fText.getModel().addTextListener((MWTextListener)new TextEventHandler());
        this.fText.getView().addTextViewListener((MWTextViewListener)new TextViewEventHandler());
    }

    private class TextEventHandler
    extends MWTextAdapter {
        public void lineChange(MWTextEvent mWTextEvent) {
            LineNumberDisplay.this.repaintAfterChange();
        }

        TextEventHandler() {
            LineNumberDisplay.this = LineNumberDisplay.this;
        }
    }

    private class TextViewEventHandler
    extends MWTextViewAdapter {
        public void topLineChanged(MWTextViewEvent mWTextViewEvent) {
            LineNumberDisplay.this.repaintAfterChange();
        }

        TextViewEventHandler() {
            LineNumberDisplay.this = LineNumberDisplay.this;
        }
    }
}

