/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.editor;

import com.mathworks.ide.editor.EditorDocument;
import com.mathworks.ide.widgets.MFilePathUtil;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwt.MWCanvas;
import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.mwt.message.MWMessage;
import com.mathworks.mwt.text.MWStyle;
import com.mathworks.mwt.text.MWTextAdapter;
import com.mathworks.mwt.text.MWTextComponent;
import com.mathworks.mwt.text.MWTextEvent;
import com.mathworks.mwt.text.MWTextListener;
import com.mathworks.mwt.text.MWTextViewAdapter;
import com.mathworks.mwt.text.MWTextViewEvent;
import com.mathworks.mwt.text.MWTextViewListener;
import com.mathworks.util.Offscreen;
import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.util.Vector;

class ExecutionArrowDisplay
extends MWCanvas {
    private static final int DEBUG_MESSAGE = 1;
    private static final int STACK_MESSAGE = 2;
    private static final int SCOPE_MESSAGE = 3;
    private static final int ARROW_WIDTH = 10;
    private static final int NO_LINE = -1;
    private static final int EXEC_ARROW = 1;
    private static final int OUT_ARROW = 2;
    private static final int AFTER_ARROW = 3;
    private static Matlab sMatlab;
    private static Vector sDebugInterests;
    private static Vector sScopeInterests;
    private static Object[] sInterestCookies;
    private File fFile;
    private MWTextComponent fText;
    private int fTopLine;
    private int fLineCount;
    private int fCurrentLine;
    private boolean fIsAfterLine;
    private Vector fExecLines;
    private Offscreen fOffscreen;
    private Matlab fMatlab;
    private ArrowCallback fDebugCallback;
    private ArrowCallback fScopeCallback;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;

    private void repaintAfterChange() {
        if (this.fText.getView().getTopLine() != this.fTopLine || this.fText.getModel().getNumLines() != this.fLineCount) {
            ((Component)((Object)this)).repaint(5L);
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(10, 100);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    private static void addExecutionArrowInterests(ExecutionArrowDisplay executionArrowDisplay, Matlab matlab, CompletionObserver completionObserver, CompletionObserver completionObserver2) {
        if (matlab != null && completionObserver != null && completionObserver2 != null) {
            if (sMatlab == null) {
                sMatlab = matlab;
                sInterestCookies = new Object[4];
                sDebugInterests = new Vector();
                DebugDispatch debugDispatch = executionArrowDisplay.new DebugDispatch();
                ExecutionArrowDisplay.sInterestCookies[0] = sMatlab.registerInterest(1, 0x10000000, (CompletionObserver)debugDispatch);
                ExecutionArrowDisplay.sInterestCookies[1] = sMatlab.registerInterest(1, 0x8000000, (CompletionObserver)debugDispatch);
                ExecutionArrowDisplay.sInterestCookies[2] = sMatlab.registerInterest(1, 0x4000000, (CompletionObserver)debugDispatch);
                sScopeInterests = new Vector();
                ScopeDispatch scopeDispatch = executionArrowDisplay.new ScopeDispatch();
                ExecutionArrowDisplay.sInterestCookies[3] = sMatlab.registerInterest(3, Integer.MIN_VALUE, (CompletionObserver)scopeDispatch);
            }
            sDebugInterests.addElement(completionObserver);
            sScopeInterests.addElement(completionObserver2);
        }
    }

    private static void removeExecutionArrowInterests(CompletionObserver completionObserver, CompletionObserver completionObserver2) {
        if (completionObserver != null && sDebugInterests != null && completionObserver2 != null && sScopeInterests != null) {
            sDebugInterests.removeElement(completionObserver);
            sScopeInterests.removeElement(completionObserver2);
            if (sDebugInterests.size() == 0) {
                sMatlab.unregisterInterest(sInterestCookies[0]);
                sMatlab.unregisterInterest(sInterestCookies[1]);
                sMatlab.unregisterInterest(sInterestCookies[2]);
                sMatlab.unregisterInterest(sInterestCookies[3]);
                sInterestCookies = null;
                sDebugInterests = null;
                sScopeInterests = null;
                sMatlab = null;
            }
        }
    }

    public void addNotify() {
        this.setupMatlabAndInterests();
        super.addNotify();
    }

    private void setupMatlabAndInterests() {
        if (this.fMatlab != null && this.fDebugCallback == null) {
            this.fDebugCallback = new ArrowCallback(1);
            this.fScopeCallback = new ArrowCallback(3);
            ExecutionArrowDisplay.addExecutionArrowInterests(this, this.fMatlab, this.fDebugCallback, this.fScopeCallback);
        }
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.fDebugCallback != null) {
            ExecutionArrowDisplay.removeExecutionArrowInterests(this.fDebugCallback, this.fScopeCallback);
            this.fDebugCallback = null;
            this.fScopeCallback = null;
        }
    }

    public void setBackgroundStyle(MWStyle mWStyle) {
        if (mWStyle.isAutoColor()) {
            ((Component)((Object)this)).setBackground(Decorations.getColor((int)0));
            return;
        }
        ((Component)((Object)this)).setBackground(mWStyle.getColor());
    }

    private void drawArrowAt(Graphics graphics, int n, int n2) {
        Rectangle rectangle = ((Component)((Object)this)).getBounds();
        int n3 = (rectangle.width - 10) / 2;
        int n4 = this.fText.getView().pixelYFromLine(n);
        this.drawArrow(graphics, n3, n4, n2);
    }

    private void drawArrow(Graphics graphics, int n, int n2, int n3) {
        int[] nArray = new int[8];
        nArray[1] = 4;
        nArray[2] = 4;
        nArray[3] = 8;
        nArray[4] = 4;
        nArray[5] = 4;
        int[] nArray2 = nArray;
        int[] nArray3 = new int[]{-4, -4, -2, -6, -10, -8, -8, -4};
        int[] nArray4 = new int[8];
        nArray4[1] = 2;
        nArray4[2] = 2;
        nArray4[3] = 6;
        nArray4[4] = 6;
        nArray4[5] = 8;
        nArray4[6] = 4;
        int[] nArray5 = nArray4;
        int[] nArray6 = new int[]{4, 4, 1, 1, 4, 4, 9, 4};
        int n4 = n2 - this.fText.getModel().getFontHeight() / 2 - 4;
        n2 -= (this.fText.getModel().getFontHeight() - 10) / 2 - 1;
        ++n;
        int n5 = 0;
        int n6 = nArray2.length;
        while (n5 < n6) {
            int n7 = n5;
            nArray2[n7] = nArray2[n7] + n;
            int n8 = n5;
            nArray3[n8] = nArray3[n8] + n2;
            int n9 = n5;
            nArray5[n9] = nArray5[n9] + n;
            int n10 = n5++;
            nArray6[n10] = nArray6[n10] + n4;
        }
        if (n3 == 1) {
            graphics.setColor(Color.green);
            graphics.fillPolygon(nArray2, nArray3, nArray2.length);
            graphics.setColor(Color.black);
            graphics.drawPolygon(nArray2, nArray3, nArray2.length);
            return;
        }
        if (n3 == 2) {
            graphics.setColor(Color.black);
            graphics.drawPolygon(nArray2, nArray3, nArray2.length);
            return;
        }
        if (n3 == 3) {
            graphics.setColor(Color.green);
            graphics.fillPolygon(nArray5, nArray6, nArray5.length);
            graphics.setColor(Color.black);
            graphics.drawPolygon(nArray5, nArray6, nArray5.length);
        }
    }

    public synchronized void paint(Graphics graphics) {
        Graphics graphics2 = this.fOffscreen.startRender(graphics);
        if (graphics2 == null) {
            return;
        }
        Rectangle rectangle = ((Component)((Object)this)).getBounds();
        rectangle.y = 0;
        rectangle.x = 0;
        graphics2.setFont(((Component)((Object)this)).getFont());
        graphics2.setColor(((Component)((Object)this)).getBackground());
        graphics2.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (this.fCurrentLine != -1) {
            if (this.fIsAfterLine) {
                this.drawArrowAt(graphics2, this.fCurrentLine, 3);
            } else {
                this.drawArrowAt(graphics2, this.fCurrentLine, 1);
            }
        }
        int n = 0;
        while (n < this.fExecLines.size()) {
            this.drawArrowAt(graphics2, (Integer)this.fExecLines.elementAt(n), 2);
            ++n;
        }
        this.fOffscreen.finishRender(graphics);
    }

    private void interestDebugStop(MWMessage mWMessage) {
        if (mWMessage == null || this.fFile == null) {
            return;
        }
        boolean bl = true;
        String string = (String)mWMessage.findData("string", class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = ExecutionArrowDisplay.class$("java.lang.String")));
        Integer n = (Integer)mWMessage.findData("lineno", class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = ExecutionArrowDisplay.class$("java.lang.Integer")));
        String string2 = MFilePathUtil.mFileToJavaPath(string);
        if (PlatformInfo.getPlatform() == 2 && string2.equals(this.fFile.getPath()) || PlatformInfo.getPlatform() != 2 && string2.equalsIgnoreCase(this.fFile.getPath())) {
            this.fCurrentLine = n;
            if (this.fCurrentLine < 0) {
                this.fCurrentLine = -this.fCurrentLine;
                this.fIsAfterLine = true;
            } else {
                this.fIsAfterLine = false;
            }
            if (this.fCurrentLine != -1) {
                Rectangle rectangle = ((Component)((Object)this)).getBounds();
                rectangle.y = 0;
                rectangle.x = 0;
                int n2 = this.fText.getView().pixelYFromLine(this.fCurrentLine);
                if (n2 < 0 || n2 > rectangle.height) {
                    this.fText.getView().scrollLineToPercent(this.fCurrentLine - 1, 50);
                    bl = false;
                }
            }
        } else {
            this.fCurrentLine = -1;
        }
        if (bl) {
            ((Component)((Object)this)).repaint(5L);
        }
    }

    private void interestDebugGo() {
        this.fCurrentLine = -1;
        ((Component)((Object)this)).repaint(5L);
    }

    private void interestDebugExit() {
        this.fCurrentLine = -1;
        this.fExecLines.removeAllElements();
        ((Component)((Object)this)).repaint(5L);
    }

    private void handleDebugInterest(Object object) {
        MWMessage mWMessage = (MWMessage)object;
        Integer n = (Integer)mWMessage.findData("eventid", class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = ExecutionArrowDisplay.class$("java.lang.Integer")));
        if (n == null) {
            return;
        }
        int n2 = n;
        if (n2 == 0x8000000) {
            this.interestDebugGo();
            return;
        }
        if (n2 == 0x10000000) {
            this.interestDebugExit();
            return;
        }
        if (n2 == 0x4000000) {
            this.interestDebugStop(mWMessage);
            return;
        }
        if (n2 == 0x2000000) {
            this.interestDebugStop(mWMessage);
        }
    }

    void setFile(File file) {
        this.fFile = file;
        this.fCurrentLine = -1;
        ((Component)((Object)this)).repaint(5L);
    }

    void setFile(File file, int n) {
        this.fFile = file;
        this.fCurrentLine = n;
        ((Component)((Object)this)).repaint(5L);
    }

    private void initDisplay() {
        if (this.fMatlab != null) {
            this.fMatlab.eval("dbstack", (CompletionObserver)new ArrowCallback(2), 512);
        }
    }

    private char getPathnameSeparator() {
        if (PlatformInfo.getPlatform() == 1) {
            return '\\';
        }
        if (PlatformInfo.getPlatform() == 2) {
            return '/';
        }
        if (PlatformInfo.getPlatform() == 0) {
            return ':';
        }
        return '/';
    }

    private void stackReply(String string) {
        String string2 = " at line ";
        String string3 = " after line ";
        if (string == null || string.length() < 5 || this.fFile == null) {
            return;
        }
        int n = 0;
        boolean bl = false;
        this.fExecLines.removeAllElements();
        char c = this.getPathnameSeparator();
        int n2 = 0;
        String string4 = EditorDocument.getFullPathname(this.fFile.getPath());
        if (PlatformInfo.getPlatform() != 2) {
            string4 = string4.toLowerCase();
        }
        while (n2 < string.length()) {
            boolean bl2;
            boolean bl3 = string.charAt(n2) == '>';
            int n3 = string.indexOf(string2, n2);
            if (n3 == -1) {
                bl2 = true;
                this.fIsAfterLine = true;
                n3 = string.indexOf(string3, n2);
                if (n3 == -1) {
                    break;
                }
            } else {
                bl2 = false;
                if (bl3) {
                    this.fIsAfterLine = false;
                }
            }
            if (n3 != -1) {
                String string5 = string.substring(n2, n3);
                if (PlatformInfo.getPlatform() != 2) {
                    string5 = string5.toLowerCase();
                }
                if (string5.indexOf(string4) != -1) {
                    int n4 = bl2 ? n3 + string3.length() : n3 + string2.length();
                    int n5 = 0;
                    char[] cArray = new char[256];
                    while (n5 < string.length() && Character.isDigit(string.charAt(n4))) {
                        cArray[n5++] = string.charAt(n4++);
                    }
                    n = new Integer(new String(cArray, 0, n5));
                    if (bl3) {
                        this.fCurrentLine = n;
                    } else {
                        this.fExecLines.addElement(new Integer(n));
                    }
                }
            }
            while (n2 < string.length() && string.charAt(n2) != '\r' && string.charAt(n2) != '\n') {
                ++n2;
            }
            while (n2 < string.length() && (string.charAt(n2) == '\r' || string.charAt(n2) == '\n')) {
                ++n2;
            }
        }
        ((Component)((Object)this)).repaint(5L);
    }

    private void handleScopeInterest() {
        this.fCurrentLine = -1;
        this.initDisplay();
    }

    ExecutionArrowDisplay(MWTextComponent mWTextComponent, Matlab matlab) {
        this.fText = mWTextComponent;
        this.fMatlab = matlab;
        this.fTopLine = -1;
        this.fLineCount = 0;
        this.fCurrentLine = -1;
        this.fIsAfterLine = false;
        this.fExecLines = new Vector();
        this.fOffscreen = new Offscreen((Component)((Object)this));
        this.fText.getModel().addTextListener((MWTextListener)new TextEventHandler());
        this.fText.getView().addTextViewListener((MWTextViewListener)new TextViewEventHandler());
        this.setupMatlabAndInterests();
        this.initDisplay();
        GutterClicker gutterClicker = new GutterClicker();
        ((Component)((Object)this)).addMouseListener(gutterClicker);
        ((Component)((Object)this)).addMouseMotionListener(gutterClicker);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ int access$4() {
        return 1;
    }

    static /* synthetic */ int access$6() {
        return 3;
    }

    static /* synthetic */ int access$8() {
        return 2;
    }

    private class TextEventHandler
    extends MWTextAdapter {
        public void textChanged(MWTextEvent mWTextEvent) {
            ExecutionArrowDisplay.this.repaintAfterChange();
        }

        TextEventHandler() {
            ExecutionArrowDisplay.this = ExecutionArrowDisplay.this;
        }
    }

    private class TextViewEventHandler
    extends MWTextViewAdapter {
        public void topLineChanged(MWTextViewEvent mWTextViewEvent) {
            ExecutionArrowDisplay.this.repaintAfterChange();
        }

        TextViewEventHandler() {
            ExecutionArrowDisplay.this = ExecutionArrowDisplay.this;
        }
    }

    private class GutterClicker
    extends MouseAdapter
    implements MouseMotionListener {
        public void mousePressed(MouseEvent mouseEvent) {
            if (PlatformInfo.isUnix() && (mouseEvent.getModifiers() & 8) != 0) {
                ExecutionArrowDisplay.this.fText.getView().paste();
                return;
            }
            ExecutionArrowDisplay.this.fText.getView().startDrag(this.lineStartFromEvent(mouseEvent), 3, mouseEvent.isShiftDown());
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (PlatformInfo.isUnix() && (mouseEvent.getModifiers() & 8) != 0) {
                return;
            }
            ExecutionArrowDisplay.this.fText.getView().continueDrag(this.lineStartFromEvent(mouseEvent));
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            ExecutionArrowDisplay.this.fText.getView().finishDrag(this.lineStartFromEvent(mouseEvent));
            ExecutionArrowDisplay.this.fText.getView().requestFocus();
            if (PlatformInfo.isUnix()) {
                ExecutionArrowDisplay.this.fText.getView().copy();
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        private int lineStartFromEvent(MouseEvent mouseEvent) {
            int n = ExecutionArrowDisplay.this.fText.getView().lineFromPixelY(mouseEvent.getPoint().y);
            int n2 = Math.max(Math.min(n, ExecutionArrowDisplay.this.fText.getModel().getNumLines() - 1), 0);
            return ExecutionArrowDisplay.this.fText.getModel().getLineStart(n2);
        }

        GutterClicker() {
            ExecutionArrowDisplay.this = ExecutionArrowDisplay.this;
        }
    }

    class DebugDispatch
    implements CompletionObserver {
        public void completed(int n, Object object) {
            int n2 = 0;
            while (n2 < sDebugInterests.size()) {
                CompletionObserver completionObserver = (CompletionObserver)sDebugInterests.elementAt(n2);
                completionObserver.completed(n, object);
                ++n2;
            }
        }

        DebugDispatch() {
            ExecutionArrowDisplay.this = ExecutionArrowDisplay.this;
        }
    }

    class ScopeDispatch
    implements CompletionObserver {
        public void completed(int n, Object object) {
            int n2 = 0;
            while (n2 < sScopeInterests.size()) {
                CompletionObserver completionObserver = (CompletionObserver)sScopeInterests.elementAt(n2);
                completionObserver.completed(n, object);
                ++n2;
            }
        }

        ScopeDispatch() {
            ExecutionArrowDisplay.this = ExecutionArrowDisplay.this;
        }
    }

    class ArrowCallback
    implements CompletionObserver {
        int fReplyType;

        public ArrowCallback(int n) {
            ExecutionArrowDisplay.this = ExecutionArrowDisplay.this;
            this.fReplyType = n;
        }

        public void completed(int n, Object object) {
            if (this.fReplyType == ExecutionArrowDisplay.access$4()) {
                ExecutionArrowDisplay.this.handleDebugInterest(object);
                return;
            }
            if (this.fReplyType == ExecutionArrowDisplay.access$6()) {
                ExecutionArrowDisplay.this.handleScopeInterest();
                return;
            }
            if (this.fReplyType == ExecutionArrowDisplay.access$8()) {
                ExecutionArrowDisplay.this.stackReply((String)object);
            }
        }
    }
}

