/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.editor;

import com.mathworks.ide.desktop.DTApplication;
import com.mathworks.ide.desktop.DTDockPath;
import com.mathworks.ide.desktop.DTExternalFrame;
import com.mathworks.ide.desktop.Desktop;
import com.mathworks.ide.desktop.MLDesktop;
import com.mathworks.ide.desktop.MLMainFrame;
import com.mathworks.ide.editor.EditorApplication;
import com.mathworks.ide.editor.EditorCommand;
import com.mathworks.ide.editor.EditorDocument;
import com.mathworks.ide.editor.EditorMRUFiles;
import com.mathworks.ide.editor.EditorMenubar;
import com.mathworks.ide.editor.EditorOptions;
import com.mathworks.ide.editor.MWReplaceDialog;
import com.mathworks.ide.editor.editorobject.EditorObject;
import com.mathworks.ide.help.HelpBrowser;
import com.mathworks.ide.prefs.PrefsDialog;
import com.mathworks.ide.workspace.StackDisplay;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwt.MWButton;
import com.mathworks.mwt.MWCloseBox;
import com.mathworks.mwt.MWFrame;
import com.mathworks.mwt.MWFrameProxy;
import com.mathworks.mwt.MWMenuBar;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.MWStatusBar;
import com.mathworks.mwt.MWTabPanel;
import com.mathworks.mwt.MWToolTip;
import com.mathworks.mwt.MWToolbar;
import com.mathworks.mwt.command.MWCommandCenter;
import com.mathworks.mwt.command.MWCommandChain;
import com.mathworks.mwt.command.MWCommandPanel;
import com.mathworks.mwt.command.MWCommandTarget;
import com.mathworks.mwt.message.MWMessage;
import com.mathworks.mwt.window.MWWindowOwner;
import com.mathworks.mwt.window.WindowRegistry;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.ResLoader;
import com.mathworks.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ResourceBundle;
import java.util.Vector;

public class EditorViewContainer
extends MWCommandPanel
implements MWWindowOwner,
DTApplication {
    private static ResourceBundle sRes;
    private static final int DEBUG_INTEREST = 1;
    private static final int WORKSPACE_INTEREST = 2;
    private static final int STACK_MESSAGE = 3;
    private static final int STATUS_MESSAGE = 4;
    private boolean fIsDebugger;
    private EditorDocument fEditorDocument;
    private MWFrameProxy fFrame;
    private Matlab fMatlab;
    private EditorMenubar fMenubar;
    private MWToolbar fToolbarSegment;
    private MWPanel fToolbar;
    private MWStatusBar fStatusBar;
    private StackDisplay fStackDisplay;
    private InterestCallback fDebugCallback;
    private PrefListener fPrefListener;
    private DebugStateListener fDebugStateListener;
    private MWButton fRunButton;
    private MWToolTip fRunButtonTooltip;
    private boolean fFirstDTExternalActivate;
    private static boolean sStopIfError;
    private static boolean sStopIfWarning;
    private static boolean sStopIfNanInf;
    private static boolean sInlineDebugger;
    private static Matlab sMatlab;
    private static Vector sDebugInterests;
    private static Object[] sInterestCookies;
    private static Image sEditorIcon;
    static /* synthetic */ Class class$java$lang$Integer;

    public EditorViewContainer() {
        this(null);
    }

    public EditorViewContainer(String string) {
        ResLoader resLoader;
        sRes = EditorApplication.getSRes();
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.setOpaque(false);
        this.setupCommandCenter();
        ((Component)((Object)this)).setBounds(EditorOptions.getEditorWindowBounds());
        this.fIsDebugger = false;
        this.fMatlab = EditorApplication.getMatlab();
        if (string == null) {
            this.fEditorDocument = new EditorDocument(this, this.fMatlab, this.getCommandCenter());
            new EditorMRUFiles();
        } else {
            this.fEditorDocument = new EditorDocument(this, this.fMatlab, this.getCommandCenter(), string);
        }
        this.fEditorDocument.setNextTarget((MWCommandChain)this);
        ((Container)((Object)this)).add((Component)((Object)this.fEditorDocument.getEditorView()), "Center");
        EditorApplication.addDocument(this);
        WindowRegistry.getRegistry().register((MWWindowOwner)this);
        this.fFrame = new MWFrameProxy((MWWindowOwner)this, StringUtils.fromJavaPath((String)this.fEditorDocument.getPathOrUntitledName()));
        if (!PlatformInfo.isMacintosh()) {
            if (sEditorIcon == null) {
                resLoader = new ResLoader((Component)((Object)this));
                String string2 = PlatformInfo.isWindows() ? "/com/mathworks/ide/resources/editor32.gif" : "/com/mathworks/ide/resources/editor48.gif";
                sEditorIcon = resLoader.loadImage(string2);
                resLoader.waitForPendingImages();
            }
            this.fFrame.setIconImage(sEditorIcon);
        }
        this.fMenubar = new EditorMenubar(this.fFrame, this, false, EditorOptions.isTabMode(), true);
        resLoader = this.fMenubar.getMenubar();
        this.fFrame.setMenuBar((MWMenuBar)resLoader);
        this.createToolbar();
        this.setKeyBindingScheme();
        this.fFrame.setBounds(EditorOptions.getEditorWindowBounds());
        this.fFrame.setFrameLimits(300, 100, Integer.MAX_VALUE, Integer.MAX_VALUE);
        this.fFrame.setFrameSize(EditorOptions.getEditorWindowBounds().width, EditorOptions.getEditorWindowBounds().height);
        this.fFrame.setFrameLocation(EditorOptions.getEditorWindowBounds().x, EditorOptions.getEditorWindowBounds().y);
        this.fFrame.add((Component)((Object)this), "Center");
        ((Component)((Object)this)).setVisible(true);
        if (MLDesktop.getMLDesktop() == null) {
            this.fFirstDTExternalActivate = true;
        }
        this.enableDebugDependentCommands(false);
        if (this.fMatlab != null) {
            this.fDebugStateListener = new DebugStateListener();
            EditorApplication.addDebugStateListener(this.fDebugStateListener);
        }
        if (this.fMatlab != null && (sInlineDebugger || this.fIsDebugger)) {
            this.fDebugCallback = new InterestCallback(1);
            EditorViewContainer.addEditorViewContainerInterests(this, this.fMatlab, this.fDebugCallback);
            this.fMatlab.eval("dbstatus", (CompletionObserver)new InterestCallback(4), 512);
            EditorApplication.initializeInDebugMode();
        }
        this.fPrefListener = new EditorPrefListener();
        Prefs.addListener((PrefListener)this.fPrefListener, (String)"EditorInlineDebugger");
        Prefs.addListener((PrefListener)this.fPrefListener, (String)"EditorKeyBindingScheme");
        Prefs.addListener((PrefListener)this.fPrefListener, (String)"EditorShowToolbar");
        EditorObject.refresh();
    }

    private static void addEditorViewContainerInterests(EditorViewContainer editorViewContainer, Matlab matlab, CompletionObserver completionObserver) {
        if (matlab != null && completionObserver != null) {
            if (sMatlab == null) {
                sMatlab = matlab;
                sInterestCookies = new Object[1];
                sDebugInterests = new Vector();
                DebugDispatch debugDispatch = editorViewContainer.new DebugDispatch();
                EditorViewContainer.sInterestCookies[0] = sMatlab.registerInterest(1, 0x2000000, (CompletionObserver)debugDispatch);
            }
            sDebugInterests.addElement(completionObserver);
        }
    }

    private static void removeEditorViewContainerInterests(CompletionObserver completionObserver) {
        if (completionObserver != null && sDebugInterests != null) {
            sDebugInterests.removeElement(completionObserver);
            if (sDebugInterests.size() == 0) {
                sMatlab.unregisterInterest(sInterestCookies[0]);
                sInterestCookies = null;
                sDebugInterests = null;
                sMatlab = null;
            }
        }
    }

    public void requestFocus() {
        this.fEditorDocument.getEditorView().requestFocus();
    }

    void showLine(int n) {
        this.showLine(n, false);
    }

    void showLine(int n, boolean bl) {
        this.fEditorDocument.getEditorView().goToLine(Math.abs(n), bl);
    }

    void setFilename(String string) {
    }

    void showFunction(String string, String string2) {
        this.fEditorDocument.getEditorView().goToFunction(string, string2);
    }

    void setContents(String string) {
        this.fEditorDocument.getEditorView().setContents(string);
    }

    boolean isDockedInDesktop() {
        boolean bl = false;
        if (this.fFrame != null) {
            Container container = this.fFrame.getParent();
            while (container != null) {
                if (container instanceof MLMainFrame) {
                    bl = true;
                    break;
                }
                container = container.getParent();
            }
        }
        return bl;
    }

    MWFrame getExternalFrame() {
        if (this.fFrame != null) {
            Container container = this.fFrame.getParent();
            while (container != null) {
                if (container instanceof DTExternalFrame && !(container instanceof MLMainFrame)) {
                    return (MWFrame)container;
                }
                container = container.getParent();
            }
        }
        return null;
    }

    boolean isDirty() {
        return this.fEditorDocument.isDirty();
    }

    public boolean close() {
        return this.closeWindow() == 0;
    }

    public int closeWindow() {
        if (this.fEditorDocument == null) {
            return 0;
        }
        if (this.fEditorDocument.closeFile()) {
            EditorOptions.setExternal(!this.isDockedInDesktop());
            if (this.fFrame != null && this.fFrame.getParent() != null) {
                if (this.isDockedInDesktop()) {
                    DTDockPath dTDockPath = this.fFrame.getDTClient().getDockPath();
                    EditorOptions.setDockPath(dTDockPath.getPathString());
                    Container container = this.fFrame.getParent();
                    if (container instanceof MWTabPanel) {
                        container = container.getParent();
                    }
                    Dimension dimension = container != null ? container.getSize() : ((Component)((Object)this)).getSize();
                    Rectangle rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
                    EditorOptions.setEditorWindowBounds(rectangle);
                } else {
                    Rectangle rectangle = new Rectangle();
                    int n = 0;
                    MWFrame mWFrame = this.getExternalFrame();
                    if (mWFrame != null) {
                        if (mWFrame.isMaximized()) {
                            n = 1;
                            rectangle.setLocation(mWFrame.getRestoredLocation());
                            rectangle.setSize(mWFrame.getRestoredSize());
                        } else {
                            rectangle = mWFrame.getBounds();
                        }
                    } else {
                        rectangle = this.fFrame.getParent().getBounds();
                    }
                    EditorOptions.setEditorWindowMinMaxState(n);
                    EditorOptions.setEditorWindowBounds(rectangle);
                }
            }
            WindowRegistry.getRegistry().unregister((MWWindowOwner)this);
            EditorApplication.removeDocument(this);
            EditorObject.refresh();
            this.fEditorDocument.dispose();
            if (this.fMenubar != null) {
                this.fMenubar.removeAll();
            }
            if (this.fFrame != null) {
                this.fFrame.dispose();
            }
            if (this.fDebugCallback != null) {
                EditorViewContainer.removeEditorViewContainerInterests(this.fDebugCallback);
            }
            this.fDebugCallback = null;
            this.fFrame = null;
            this.fToolbar = null;
            Prefs.removeListener((PrefListener)this.fPrefListener);
            if (this.fDebugStateListener != null) {
                EditorApplication.removeDebugStateListener(this.fDebugStateListener);
            }
            if (EditorApplication.isStandalone() && EditorApplication.getOpenDocuments().size() == 0) {
                System.exit(0);
            }
            return 0;
        }
        return 1;
    }

    public void setActive(boolean bl) {
        if (bl) {
            MWReplaceDialog mWReplaceDialog;
            if (PlatformInfo.getAppearance() == 0 && PlatformInfo.getVendor() != 1) {
                this.getCommandCenter().setActive(bl);
            }
            if (this.fFirstDTExternalActivate) {
                this.fFirstDTExternalActivate = false;
                this.requestFocus();
            }
            this.setTitleBar(this.fEditorDocument.getPathOrUntitledName());
            this.fEditorDocument.reloadFileIfChanged();
            if (bl && (mWReplaceDialog = MWReplaceDialog.getReplaceDialog()) != null) {
                this.fEditorDocument.getEditorView().addReplaceListener();
            }
        }
    }

    public String getShortName() {
        return this.fEditorDocument.getFilename();
    }

    public String getLongName() {
        return this.fEditorDocument.getPathname();
    }

    public void save() {
        this.fEditorDocument.saveFile(false);
    }

    void reloadFileNoPrompt() {
        this.fEditorDocument.reloadFileIfChangedNoPrompt();
    }

    public void toFront() {
        if (this.fFrame != null) {
            this.fFrame.toFront();
        }
    }

    void addReplaceListener() {
        this.fEditorDocument.addReplaceListener();
    }

    private void setupCommandCenter() {
        MWCommandCenter mWCommandCenter = new MWCommandCenter((MWCommandTarget)this);
        this.setCommandCenter(mWCommandCenter);
        mWCommandCenter.setCommandEnabled(1600, false);
        mWCommandCenter.setCommandEnabled(1601, false);
        mWCommandCenter.setCommandEnabled(1602, false);
        mWCommandCenter.setCommandEnabled(1603, false);
        mWCommandCenter.setCommandEnabled(1650, false);
        mWCommandCenter.setCommandEnabled(1651, false);
        mWCommandCenter.setCommandEnabled(1800, false);
        mWCommandCenter.setCommandEnabled(1801, false);
        mWCommandCenter.setCommandEnabled(1802, false);
        mWCommandCenter.setCommandEnabled(1701, false);
    }

    private void resetRunLabels() {
        if (EditorApplication.isStandalone()) {
            return;
        }
        String string = sRes.getString("tooltip.Continue");
        if (this.fMenubar != null) {
            this.fMenubar.setRunMenuLabel();
            string = this.fMenubar.getRunMenuLabel(true);
        }
        if (this.fRunButtonTooltip == null) {
            this.fRunButtonTooltip = new MWToolTip((Component)this.fRunButton, string);
            return;
        }
        this.fRunButtonTooltip.setText(string);
    }

    void dirtyStatusChanged() {
        this.setTitleBar(this.fEditorDocument.getPathOrUntitledName());
        this.resetRunLabels();
    }

    public void setTitleBar(String string) {
        if (this.fFrame == null) {
            return;
        }
        if (this.fEditorDocument.isFileReadOnly()) {
            string = String.valueOf(string) + " " + sRes.getString("label.ReadOnly");
        }
        if (this.fEditorDocument.isDirty() && PlatformInfo.getAppearance() != 0) {
            string = String.valueOf(string) + "*";
        }
        if (this.fFrame.getTitle() == null || !this.fFrame.getTitle().equals(string)) {
            this.fFrame.setTitle(string);
        }
    }

    void fileNameChange(String string, String string2) {
        this.setTitleBar(this.fEditorDocument.getPathOrUntitledName());
        this.fMenubar.setCloseMenuLabel();
        WindowRegistry.getRegistry().nameChange((MWWindowOwner)this);
        EditorObject.refresh();
    }

    private void createStatusBar() {
        this.fStatusBar = new MWStatusBar();
        this.fStatusBar.setStatusBarDepth(true);
        ((Container)((Object)this)).add((Component)this.fStatusBar, "South");
    }

    private void createToolbar() {
        MWCommandCenter mWCommandCenter = this.getCommandCenter();
        String string = PlatformInfo.getAppearance() == 1 ? "_win.gif" : ".gif";
        this.fToolbarSegment = new MWToolbar();
        if (!this.fIsDebugger) {
            this.fToolbarSegment.addImageButton("/com/mathworks/mwt/resources/new.gif", 100, sRes.getString("tooltip.NewMfile"), mWCommandCenter);
            this.fToolbarSegment.addImageButton("/com/mathworks/mwt/resources/open.gif", 130, sRes.getString("tooltip.Openfile"), mWCommandCenter);
            this.fToolbarSegment.addImageButton("/com/mathworks/mwt/resources/save.gif", 350, sRes.getString("tooltip.Save"), mWCommandCenter);
            this.fToolbarSegment.addImageButton("/com/mathworks/mwt/resources/print.gif", 550, sRes.getString("tooltip.Print"), mWCommandCenter);
            this.fToolbarSegment.addSpacer();
            this.fToolbarSegment.addImageButton("/com/mathworks/mwt/resources/cut.gif", 900, sRes.getString("tooltip.Cut"), mWCommandCenter);
            this.fToolbarSegment.addImageButton("/com/mathworks/mwt/resources/copy.gif", 910, sRes.getString("tooltip.Copy"), mWCommandCenter);
            this.fToolbarSegment.addImageButton("/com/mathworks/mwt/resources/paste.gif", 920, sRes.getString("tooltip.Paste"), mWCommandCenter);
            this.fToolbarSegment.addImageButton("/com/mathworks/mwt/resources/undo.gif", 800, sRes.getString("tooltip.Undo"), mWCommandCenter);
            this.fToolbarSegment.addImageButton("/com/mathworks/mwt/resources/redo.gif", 810, sRes.getString("tooltip.Redo"), mWCommandCenter);
            this.fToolbarSegment.addSpacer();
            this.fToolbarSegment.addImageButton("/com/mathworks/mwt/resources/find_win.gif", 1101, sRes.getString("tooltip.Findtext"), mWCommandCenter);
            this.fToolbarSegment.addImageButton("/com/mathworks/mwt/resources/function.gif", 115, sRes.getString("tooltip.Showfunction"), mWCommandCenter);
            if (sInlineDebugger) {
                this.addDebugStuffToToolbar(mWCommandCenter);
            } else {
                this.fToolbarSegment.addImageButton("/com/mathworks/mwt/resources/debugger.gif", 113, sRes.getString("tooltip.Mfiledebugger"), mWCommandCenter);
            }
        } else {
            this.fToolbarSegment.addImageButton("/com/mathworks/mwt/resources/open.gif", 130, sRes.getString("tooltip.Openfile"), mWCommandCenter);
            this.fToolbarSegment.addSpacer();
            this.addDebuggerButtons(mWCommandCenter);
            this.fToolbarSegment.addSpacer();
            this.fToolbarSegment.addImageButton("/com/mathworks/mwt/resources/find" + string, 1101, sRes.getString("tooltip.Findtext"), mWCommandCenter);
            this.fToolbarSegment.addImageButton("/com/mathworks/mwt/resources/function.gif", 115, sRes.getString("tooltip.Showfunction"), mWCommandCenter);
            this.fToolbarSegment.addSpacer();
            this.fToolbarSegment.addImageButton("/com/mathworks/mwt/resources/editor.gif", 114, sRes.getString("tooltip.Mfileeditor"), mWCommandCenter);
            this.fToolbarSegment.addSpacer();
            this.fStackDisplay = new StackDisplay(this.fMatlab);
            this.fToolbarSegment.addComponent((Component)((Object)this.fStackDisplay), "Debug Stack Display");
        }
        this.fToolbar = new MWPanel((LayoutManager)new BorderLayout());
        this.fToolbar.setInsets(new Insets(0, 0, 0, 0));
        this.fToolbar.add((Component)this.fToolbarSegment, "Center");
        if (EditorOptions.isTabMode() && !this.fIsDebugger) {
            MWToolbar mWToolbar = new MWToolbar();
            MWCloseBox mWCloseBox = new MWCloseBox(mWCommandCenter, sRes.getString("tooltip.CloseCurrentFile"));
            mWCloseBox.setFocusBehavior(false);
            mWToolbar.addComponent((Component)mWCloseBox);
            if (PlatformInfo.getAppearance() != 1) {
                mWToolbar.addSpacer(5);
            }
            this.fToolbar.add((Component)mWToolbar, "East");
        }
        if (EditorOptions.getShowToolbar()) {
            ((Container)((Object)this)).add((Component)this.fToolbar, "North");
        }
    }

    private void addDebugStuffToToolbar(MWCommandCenter mWCommandCenter) {
        if (EditorApplication.isStandalone()) {
            this.fToolbarSegment.addSpacer();
            this.fStackDisplay = new StackDisplay(this.fMatlab);
            return;
        }
        this.fToolbarSegment.addBandSpacer("Debug Band Spacer");
        this.addDebuggerButtons(mWCommandCenter);
        this.fToolbarSegment.addSpacer("Debug Spacer");
        this.fStackDisplay = new StackDisplay(this.fMatlab);
        this.fToolbarSegment.addComponent((Component)((Object)this.fStackDisplay), "Debug Stack Display");
    }

    private void addDebuggerButtons(MWCommandCenter mWCommandCenter) {
        String string = "/com/mathworks/mwt/resources/";
        String string2 = PlatformInfo.getAppearance() != 0 ? "_win.gif" : ".gif";
        this.fToolbarSegment.addImageButton(String.valueOf(string) + "setbkpt.gif", 1700, sRes.getString("tooltip.Setclearbreakpoint"), mWCommandCenter);
        this.fToolbarSegment.addImageButton(String.valueOf(string) + "clearallbkpt.gif", 1701, sRes.getString("tooltip.Clearallbreakpoints"), mWCommandCenter);
        this.fToolbarSegment.addSpacer();
        this.fToolbarSegment.addImageButton(String.valueOf(string) + "step" + string2, 1600, sRes.getString("tooltip.Step"), mWCommandCenter);
        this.fToolbarSegment.addImageButton(String.valueOf(string) + "stepin" + string2, 1601, sRes.getString("tooltip.Stepin"), mWCommandCenter);
        this.fToolbarSegment.addImageButton(String.valueOf(string) + "stepout" + string2, 1602, sRes.getString("tooltip.Stepout"), mWCommandCenter);
        this.fRunButton = this.fToolbarSegment.addImageButton(String.valueOf(string) + "go" + string2, 1603, sRes.getString("tooltip.Run"), mWCommandCenter);
        this.resetRunLabels();
        this.fToolbarSegment.addImageButton(String.valueOf(string) + "exit" + string2, 1651, sRes.getString("tooltip.ExitDebugMode"), mWCommandCenter);
    }

    Point getToolLocation(int n) {
        return this.fToolbarSegment.getTool(n).getLocation();
    }

    private void enableDebugDependentCommands(boolean bl) {
        MWCommandCenter mWCommandCenter = this.getCommandCenter();
        boolean bl2 = EditorApplication.isStandalone();
        if (bl2) {
            bl = false;
        }
        mWCommandCenter.setCommandEnabled(1800, !bl2);
        mWCommandCenter.setCommandEnabled(1801, !bl2);
        mWCommandCenter.setCommandEnabled(1802, !bl2);
        mWCommandCenter.setCommandEnabled(1701, !bl2);
        mWCommandCenter.setCommandEnabled(1600, bl);
        mWCommandCenter.setCommandEnabled(1601, bl);
        mWCommandCenter.setCommandEnabled(1602, bl);
        mWCommandCenter.setCommandEnabled(1603, bl2);
        mWCommandCenter.setCommandEnabled(1650, bl);
        mWCommandCenter.setCommandEnabled(1651, bl);
        this.resetRunLabels();
    }

    private void handleStatusReply(String string) {
        if (string != null) {
            sStopIfError = string.indexOf(" if error.") != -1;
            sStopIfWarning = string.indexOf(" if warning.") != -1;
            sStopIfNanInf = string.indexOf(" if naninf.") != -1;
            this.setCheckboxDebugStates();
        }
    }

    private void handleDebugInterest(Object object) {
        MWMessage mWMessage = (MWMessage)object;
        Integer n = (Integer)mWMessage.findData("eventid", class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = EditorViewContainer.class$("java.lang.Integer")));
        int n2 = n;
        if (n2 == 0x2000000) {
            this.interestDebugStopIf(mWMessage);
        }
    }

    private void interestDebugStopIf(MWMessage mWMessage) {
        if (mWMessage == null) {
            return;
        }
        Integer n = (Integer)mWMessage.findData("value", class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = EditorViewContainer.class$("java.lang.Integer")));
        int n2 = n;
        sStopIfError = (n2 & 1) != 0;
        sStopIfWarning = (n2 & 2) != 0;
        sStopIfNanInf = (n2 & 4) != 0;
        this.setCheckboxDebugStates();
    }

    private void setCheckboxDebugStates() {
        this.fMenubar.getStopIfErrorMenuItem().setState(sStopIfError);
        this.fMenubar.getStopIfWarningMenuItem().setState(sStopIfWarning);
        this.fMenubar.getStopIfNanInfMenuItem().setState(sStopIfNanInf);
    }

    public void doCommand(int n) {
        switch (n) {
            case -103: {
                this.closeWindow();
                return;
            }
            case 135: {
                this.closeWindow();
                return;
            }
            case 701: {
                EditorApplication.orderedCloseAll();
                return;
            }
            case 510: {
                this.doOptions();
                return;
            }
            case 4051: {
                this.showHelp();
                return;
            }
            case 1600: {
                this.doStep();
                return;
            }
            case 1601: {
                this.doStepIn();
                return;
            }
            case 1602: {
                this.doStepOut();
                return;
            }
            case 1603: {
                this.doGo();
                return;
            }
            case 1651: {
                this.doExit();
                return;
            }
            case 1800: {
                this.doStopIfError();
                return;
            }
            case 1801: {
                this.doStopIfWarning();
                return;
            }
            case 1802: {
                this.doStopIfNanInf();
                return;
            }
            case 1701: {
                this.doClearAll();
                return;
            }
        }
        super.doCommand(n);
    }

    public boolean isCommandEnabled(int n) {
        switch (n) {
            case 1600: 
            case 1601: 
            case 1602: 
            case 1650: 
            case 1651: {
                return EditorApplication.getInDebugMode();
            }
            case 1603: 
            case 1701: 
            case 1800: 
            case 1801: 
            case 1802: {
                return !EditorApplication.isStandalone();
            }
        }
        return super.isCommandEnabled(n);
    }

    private void showHelp() {
        HelpBrowser.getHelpBrowser().displayTopic(null, "matlab_env", "matlabenvironment_editordebugger", this.getFrame());
    }

    private void doOptions() {
        if (EditorApplication.isStandalone()) {
            PrefsDialog.showPrefsDialog("Editor/Debugger", 1);
            return;
        }
        PrefsDialog.showPrefsDialog("Editor/Debugger");
    }

    private void setInlineDebugger() {
        boolean bl = EditorOptions.isInlineDebugger();
        this.convertToolbar(bl);
    }

    private void setKeyBindingScheme() {
        this.fMenubar.modifyShortcutsInMenubar();
        this.changeCommandKeyBindings();
        if (PlatformInfo.getAppearance() == 1) {
            this.getCommandCenter().addKey(115, -103);
        }
    }

    private void convertToolbar(boolean bl) {
        if (bl) {
            this.fToolbarSegment.removeComponent("Debug Spacer");
            this.fToolbarSegment.removeComponent(sRes.getString("tooltip.Mfiledebugger"));
            this.addDebugStuffToToolbar(this.getCommandCenter());
        } else {
            this.fToolbarSegment.removeComponent("Debug Band Spacer");
            this.fToolbarSegment.removeComponent(sRes.getString("tooltip.Step"));
            this.fToolbarSegment.removeComponent(sRes.getString("tooltip.Stepin"));
            this.fToolbarSegment.removeComponent(sRes.getString("tooltip.Stepout"));
            this.fToolbarSegment.removeComponent(sRes.getString("tooltip.Continue"));
            this.fToolbarSegment.removeComponent(sRes.getString("tooltip.ExitDebugMode"));
            this.fToolbarSegment.removeComponent("Debug Spacer");
            this.fToolbarSegment.removeComponent("Debug Stack Display");
            this.fStackDisplay = null;
            this.fToolbarSegment.addImageButton("/com/mathworks/mwt/resources/debugger.gif", 113, sRes.getString("tooltip.Mfiledebugger"), this.getCommandCenter());
            this.fToolbarSegment.addSpacer("Debug Spacer");
        }
        this.fToolbarSegment.repaint();
    }

    private void changeCommand(int n, boolean bl) {
        int n2 = EditorCommand.getKbdAcc(n);
        this.getCommandCenter().addKey(n2, n);
    }

    private void changeCommandKeyBindings() {
        this.getCommandCenter().clearAllKeys();
        this.changeCommand(100, true);
        this.changeCommand(130, true);
        this.changeCommand(135, true);
        this.changeCommand(350, true);
        this.changeCommand(351, true);
        this.changeCommand(352, true);
        this.changeCommand(550, true);
        this.changeCommand(-111, true);
        this.changeCommand(800, false);
        this.changeCommand(810, false);
        this.changeCommand(900, false);
        this.changeCommand(910, false);
        this.changeCommand(920, true);
        this.changeCommand(1050, false);
        this.changeCommand(1060, true);
        this.changeCommand(1300, true);
        this.changeCommand(1301, true);
        this.changeCommand(1400, true);
        this.changeCommand(1401, true);
        this.changeCommand(1500, true);
        this.changeCommand(1501, true);
        this.changeCommand(1502, false);
        this.changeCommand(132, false);
        this.changeCommand(560, false);
        this.changeCommand(1101, true);
        this.changeCommand(1102, false);
        this.changeCommand(1103, false);
        this.changeCommand(1100, true);
        this.changeCommand(1200, true);
        this.changeCommand(1104, false);
        this.changeCommand(1105, false);
        this.changeCommand(1600, false);
        this.changeCommand(1601, false);
        this.changeCommand(1602, false);
        this.changeCommand(1603, false);
        this.changeCommand(1650, false);
        this.changeCommand(1651, false);
        this.changeCommand(113, true);
        this.changeCommand(115, true);
        this.changeCommand(224, true);
        this.changeCommand(225, true);
        this.changeCommand(1800, true);
        this.changeCommand(1801, true);
        this.changeCommand(1802, true);
        this.changeCommand(1700, false);
        this.changeCommand(1701, true);
    }

    private void doStep() {
        this.fMatlab.eval("dbstep", null, 1024);
    }

    private void doStepIn() {
        this.fMatlab.eval("dbstep in", null, 1024);
    }

    private void doStepOut() {
        this.fMatlab.eval("dbstep out", null, 1024);
    }

    private void doGo() {
        if (EditorApplication.getInDebugMode()) {
            this.fMatlab.eval("dbcont", null, 1024);
            return;
        }
        this.fEditorDocument.saveAndExecute();
    }

    private void doExit() {
        this.fMatlab.eval("dbquit", null, 1024);
    }

    private void doStopIfError() {
        this.toggleStopState("error", sStopIfError);
    }

    private void doStopIfWarning() {
        this.toggleStopState("warning", sStopIfWarning);
    }

    private void doStopIfNanInf() {
        this.toggleStopState("naninf", sStopIfNanInf);
    }

    private void toggleStopState(String string, boolean bl) {
        String string2 = " if " + string;
        string2 = bl ? "dbclear" + string2 : "dbstop" + string2;
        this.fMatlab.evalConsoleOutput(string2);
    }

    private void doClearAll() {
        this.fEditorDocument.getEditorView().doClearAllBreakpoints();
    }

    public int desktopSaveAction() {
        if (EditorOptions.getReloadFiles()) {
            return 1;
        }
        return 2;
    }

    public void setDesktop(Desktop desktop) {
    }

    public void restoreState(DataInputStream dataInputStream) {
        try {
            String string = dataInputStream.readUTF();
            ((Container)((Object)this)).remove((Component)((Object)this.fEditorDocument.getEditorView()));
            this.fEditorDocument = new EditorDocument(this, this.fMatlab, this.getCommandCenter(), string);
            this.fEditorDocument.setNextTarget((MWCommandChain)this);
            WindowRegistry.getRegistry().nameChange((MWWindowOwner)this);
            ((Container)((Object)this)).add((Component)((Object)this.fEditorDocument.getEditorView()), "Center");
            this.enableDebugDependentCommands(false);
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public void saveState(DataOutputStream dataOutputStream) {
        try {
            String string = this.fEditorDocument.getPathname();
            dataOutputStream.writeUTF(string);
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public String getSplayConstraint() {
        return "";
    }

    public int getApplicationType() {
        return 2;
    }

    public MWMenuBar mergeMenus(MWMenuBar mWMenuBar) {
        return this.fMenubar.mergeMenus(mWMenuBar);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ int access$0() {
        return 1;
    }

    static /* synthetic */ int access$2() {
        return 4;
    }

    static {
        sInlineDebugger = EditorOptions.isInlineDebugger();
        sEditorIcon = null;
    }

    class DebugDispatch
    implements CompletionObserver {
        public void completed(int n, Object object) {
            int n2 = 0;
            while (n2 < sDebugInterests.size()) {
                CompletionObserver completionObserver = (CompletionObserver)sDebugInterests.elementAt(n2);
                completionObserver.completed(n, object);
                ++n2;
            }
        }

        DebugDispatch() {
            EditorViewContainer.this = EditorViewContainer.this;
        }
    }

    class InterestCallback
    implements CompletionObserver {
        int fReplyType;

        public InterestCallback(int n) {
            EditorViewContainer.this = EditorViewContainer.this;
            this.fReplyType = n;
        }

        public void completed(int n, Object object) {
            if (this.fReplyType == EditorViewContainer.access$0()) {
                EditorViewContainer.this.handleDebugInterest(object);
                return;
            }
            if (this.fReplyType == EditorViewContainer.access$2()) {
                EditorViewContainer.this.handleStatusReply((String)object);
            }
        }
    }

    private class EditorPrefListener
    implements PrefListener {
        public void prefChanged(PrefEvent prefEvent) {
            String string = prefEvent.getPrefKey();
            if (string.equals("EditorInlineDebugger")) {
                EditorViewContainer.this.setInlineDebugger();
                return;
            }
            if (string.equals("EditorKeyBindingScheme")) {
                EditorViewContainer.this.setKeyBindingScheme();
                return;
            }
            if (string.equals("EditorShowToolbar")) {
                if (EditorViewContainer.this.fFrame == null) {
                    return;
                }
                if (EditorOptions.getShowToolbar()) {
                    ((Container)((Object)EditorViewContainer.this)).add((Component)EditorViewContainer.this.fToolbar, "North");
                } else {
                    ((Container)((Object)EditorViewContainer.this)).remove((Component)EditorViewContainer.this.fToolbar);
                }
                ((Container)((Object)EditorViewContainer.this)).validate();
            }
        }

        EditorPrefListener() {
            EditorViewContainer.this = EditorViewContainer.this;
        }
    }

    private class DebugStateListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().equals("DebugStateChanged")) {
                EditorViewContainer.this.enableDebugDependentCommands(EditorApplication.getInDebugMode());
            }
        }

        DebugStateListener() {
            EditorViewContainer.this = EditorViewContainer.this;
        }
    }
}

