/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.editor;

import com.mathworks.ide.desktop.MenuUtils;
import com.mathworks.ide.editor.BreakpointDisplay;
import com.mathworks.ide.editor.DataTip;
import com.mathworks.ide.editor.EditorApplication;
import com.mathworks.ide.editor.EditorDocument;
import com.mathworks.ide.editor.EditorMenubar;
import com.mathworks.ide.editor.EditorOptions;
import com.mathworks.ide.editor.ExecutionArrowDisplay;
import com.mathworks.ide.editor.LineNumberDisplay;
import com.mathworks.ide.editor.MWReplaceDialog;
import com.mathworks.ide.editor.MWReplaceEvent;
import com.mathworks.ide.editor.MWReplaceListener;
import com.mathworks.ide.prefs.GeneralPrefsColorPanel;
import com.mathworks.ide.widgets.MatlabCommandWidget;
import com.mathworks.ide.widgets.SyntaxTextArea;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwt.MWCanvas;
import com.mathworks.mwt.MWClipboardListener;
import com.mathworks.mwt.MWClipboardMonitor;
import com.mathworks.mwt.MWFrame;
import com.mathworks.mwt.MWMenu;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.MWPopupList;
import com.mathworks.mwt.MWScrollbar;
import com.mathworks.mwt.command.MWCommandCenter;
import com.mathworks.mwt.command.MWCommandChain;
import com.mathworks.mwt.command.MWCommandPanel;
import com.mathworks.mwt.dialog.MWAlert;
import com.mathworks.mwt.dialog.MWGotoDialog;
import com.mathworks.mwt.floater.Floater;
import com.mathworks.mwt.text.MWKeyMap;
import com.mathworks.mwt.text.MWStyle;
import com.mathworks.mwt.text.MWTextComponent;
import com.mathworks.mwt.text.MWTextModel;
import com.mathworks.mwt.text.MWTextView;
import com.mathworks.mwt.text.MWTextViewAdapter;
import com.mathworks.mwt.text.MWTextViewEvent;
import com.mathworks.mwt.text.MWTextViewListener;
import com.mathworks.mwt.undo.UndoListener;
import com.mathworks.mwt.undo.UndoManager;
import com.mathworks.mwt.window.MWWindowActivater;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import com.mathworks.util.CharBuffer;
import com.mathworks.util.IntBuffer;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.Range;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

class EditorView
extends MWCommandPanel
implements MWClipboardListener {
    private static ResourceBundle sRes;
    private EditorDocument fEditorDoc;
    private Matlab fMatlab;
    private MWPanel fWestPanel;
    private MWPanel fCenterPanel;
    private MWCommandCenter fCenter;
    private SyntaxTextArea fText;
    private LineNumberDisplay fLineNumberDisplay;
    private BreakpointDisplay fBreakpoints;
    private ExecutionArrowDisplay fExecutionArrowDisplay;
    private boolean fShowingLineNumbers = false;
    private boolean fShowingBreakpoints = false;
    private boolean fShowingExecutionArrow = false;
    private boolean fClipboardHasString = false;
    private MWMenu fContextMenu;
    private EditorMenubar fMenubar;
    private IntBuffer fFunctionLines;
    private GoFunction fGoFunc;
    private TextViewEventHandler fViewHandler;
    private static String fFindString;
    private static int fFindOptions;
    private int fPrinterLineCounter;
    private char[] fPrintBuffer;
    private Font fFont;
    private DataTip fDataTip;
    private PrefListener fPrefListener;
    private MWPopupList fPopup;

    EditorView(EditorDocument editorDocument, Matlab matlab) {
        this(editorDocument, null, matlab);
    }

    EditorView(String string) {
        this(null, string, null);
    }

    EditorView(String string, int n) {
        this(null, string, null);
        this.goToLine(n);
    }

    EditorView(EditorDocument editorDocument, String string, Matlab matlab) {
        sRes = EditorApplication.getSRes();
        this.fMatlab = matlab;
        this.fText = new SyntaxTextArea();
        if (editorDocument != null) {
            this.fEditorDoc = editorDocument;
            this.setupView(editorDocument.readFileContents(this.fText.getModel().getCharBuffer()));
        }
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.setOpaque(false);
        this.fCenterPanel = new MWPanel((LayoutManager)new BorderLayout());
        this.fCenterPanel.setOpaque(false);
        ((Container)((Object)this)).add((Component)this.fCenterPanel, "Center");
        this.fWestPanel = new MWPanel((LayoutManager)new BorderLayout());
        this.fWestPanel.setOpaque(false);
        ((Container)((Object)this)).add((Component)this.fWestPanel, "West");
        this.fCenterPanel.add((Component)((Object)this.fText), "Center");
        this.fText.setGutterWidth(6);
        ((Component)((Object)this.fText)).setVisible(true);
        this.fText.setBevelOn(false);
        this.fCenter = editorDocument.getCommandCenter();
        this.setCommandCenter(this.fCenter);
        this.fCenter.setCurrentTarget((MWCommandChain)this);
        this.setFileType();
        this.setupFont(EditorOptions.getEditorFont());
        if (this.fMatlab != null) {
            this.fDataTip = new DataTip(this, this.fMatlab);
        }
        if (EditorOptions.getShowLineNumbers()) {
            this.showLineNumbers(true);
        }
        if (EditorApplication.isStandalone() || !this.fEditorDoc.isMFileOrUntitled()) {
            this.showBreakpointAlley(false);
            this.showCurrentStatementAlley(false);
        } else {
            this.showBreakpointAlley(true);
            this.showCurrentStatementAlley(true);
        }
        MWScrollbar mWScrollbar = new MWScrollbar(1);
        MWScrollbar mWScrollbar2 = new MWScrollbar(0);
        EditMWCanvas editMWCanvas = new EditMWCanvas(mWScrollbar2.getPreferredSize().width, mWScrollbar.getPreferredSize().height);
        MWPanel mWPanel = new MWPanel((LayoutManager)new BorderLayout());
        mWPanel.add((Component)mWScrollbar, "Center");
        mWPanel.add((Component)((Object)editMWCanvas), "East");
        this.fCenterPanel.add((Component)mWPanel, "South");
        this.fText.getView().setRemoteHScroll(mWScrollbar);
        this.fViewHandler = new TextViewEventHandler();
        this.fText.getView().addTextViewListener((MWTextViewListener)this.fViewHandler);
        this.fText.getView().addKeyFilter((KeyListener)new KeyEventFilter());
        this.createContextMenu();
        this.fText.getView().addMouseListener((MouseListener)new ContextListener());
        this.setInitialCommandStates();
        this.fText.setEmacsStyleTabEnabled(EditorOptions.isEmacsStyleTab());
        this.fText.setTabUsingSpaces(EditorOptions.isTabChangedToSpaces());
        this.fText.setSpacesPerIndent(EditorOptions.getSpacesPerIndent());
        this.fText.setSpacesPerTab(EditorOptions.getSpacesPerTab());
        boolean bl = false;
        if (this.fEditorDoc != null) {
            bl = this.fEditorDoc.isMFileOrUntitled();
        }
        if (bl) {
            this.fText.setIndenterType(EditorOptions.getIndentMode());
        } else {
            this.fText.setIndenterType("BlockIndent");
        }
        this.fText.setSyntaxHighlightingEnabled(EditorOptions.isSyntaxHighlightingEnabled());
        this.fText.setKeyBindingScheme(EditorOptions.getKeyBindingScheme());
        this.setHighlightColors();
        this.fText.setFont(EditorOptions.getEditorFont());
        this.setDataTips();
        EditorApplication.addDebugStateListener(new DebugStateListener());
        MWStyle mWStyle = EditorOptions.getBackgroundColor();
        this.fText.setBackgroundStyle(mWStyle);
        if (this.fShowingExecutionArrow) {
            this.fExecutionArrowDisplay.setBackgroundStyle(mWStyle);
        }
        this.fText.setTextStyle(EditorOptions.getTextColor());
        this.adjustKeyMap();
        this.fPrefListener = new EditorPrefListener();
        Prefs.addListener((PrefListener)this.fPrefListener, (String)"EditorSyntaxHighlighting");
        Prefs.addListener((PrefListener)this.fPrefListener, (String)"EditorInlineDebugger");
        Prefs.addListener((PrefListener)this.fPrefListener, (String)"EditorKeyBindingScheme");
        Prefs.addListener((PrefListener)this.fPrefListener, (String)"EditorShowLineNumbers");
        Prefs.addListener((PrefListener)this.fPrefListener, (String)"EditorSpacesPerTab");
        Prefs.addListener((PrefListener)this.fPrefListener, (String)"EditorSpacesPerIndent");
        Prefs.addListener((PrefListener)this.fPrefListener, (String)"EditorFont");
        Prefs.addListener((PrefListener)this.fPrefListener, (String)"EditorUseDesktopFont");
        Prefs.addListener((PrefListener)this.fPrefListener, (String)"EditorBackgroundColor");
        Prefs.addListener((PrefListener)this.fPrefListener, (String)"EditorEnableDataTips");
        Prefs.addListener((PrefListener)this.fPrefListener, (String)"EditorTextColor");
        Prefs.addListener((PrefListener)this.fPrefListener, (String)"GeneralFont");
        Prefs.addListener((PrefListener)this.fPrefListener, (String)"Syncolor");
        Prefs.addListener((PrefListener)this.fPrefListener, (String)"EditorIndentMode");
        Prefs.addListener((PrefListener)this.fPrefListener, (String)"EditorTabToSpaces");
        Prefs.addListener((PrefListener)this.fPrefListener, (String)"EditorEmacsTab");
        Prefs.addListener((PrefListener)this.fPrefListener, (String)"EditorPrintHeader");
        Prefs.addListener((PrefListener)this.fPrefListener, (String)"EditorPrintStyle");
        if (PlatformInfo.isUnix()) {
            this.fClipboardHasString = true;
        } else {
            MWClipboardMonitor.addListener((MWClipboardListener)this);
            this.clipboardContentTypeChanged(((Component)((Object)this)).getToolkit().getSystemClipboard().getContents((Object)this));
        }
        this.fCenter.setCommandEnabled(920, this.areClipboardCommandsEnabled());
    }

    public void floaterAutoCollapsed(Floater floater) {
        ((Component)((Object)this)).repaint();
    }

    void reloadFile(EditorDocument editorDocument) {
        CharBuffer charBuffer = this.fText.getModel().getCharBuffer();
        this.fText.getModel().delete(0, charBuffer.length());
        this.setupView(editorDocument.readFileContents(charBuffer));
    }

    void fileDirtied(boolean bl) {
        if (this.fBreakpoints != null) {
            this.fBreakpoints.listenToMatlab(!bl);
        }
    }

    void fileSaved() {
        if (this.fBreakpoints != null) {
            this.fBreakpoints.listenToMatlab(true);
        }
    }

    private void adjustKeyMap() {
        if (EditorOptions.getKeyBindingScheme() == 2) {
            MWKeyMap mWKeyMap = this.fText.getKeyMap();
            mWKeyMap.removeKeyBinding(8, 70);
            mWKeyMap.removeKeyBinding(8, 66);
            mWKeyMap.removeKeyBinding(8, 86);
        }
    }

    private void setEditorFont() {
        Font font = EditorOptions.getEditorFont();
        this.fText.setFont(font);
        this.setupFont(font);
        if (this.fLineNumberDisplay != null) {
            this.fLineNumberDisplay.setFont(this.fFont);
        }
        if (this.fBreakpoints != null) {
            ((Component)((Object)this.fBreakpoints)).setFont(this.fFont);
        }
        ((Container)((Object)this)).validate();
    }

    private void setDataTips() {
        if (this.fDataTip != null) {
            this.fDataTip.setDataTipEnabled(EditorOptions.getDataTips());
        }
    }

    private void setHighlightColors() {
        MWStyle[] mWStyleArray = GeneralPrefsColorPanel.getSyntaxHighlightingStyles();
        this.fText.setHighlightStyles("M-code", mWStyleArray);
    }

    private void setupFont(Font font) {
        int n;
        int n2 = this.fFont == null ? 0 : this.fFont.getSize();
        if (n2 != (n = font.getSize())) {
            this.fFont = new Font("SansSerif", 0, n);
        }
    }

    public void dispose() {
        this.showBreakpointAlley(false);
        this.showCurrentStatementAlley(false);
        Prefs.removeListener((PrefListener)this.fPrefListener);
        this.fContextMenu.removeAll();
        this.fMatlab = null;
    }

    public void requestFocus() {
        if (this.fText != null && ((Component)((Object)this)).isShowing()) {
            this.fText.getView().requestFocus();
        }
    }

    SyntaxTextArea getSyntaxArea() {
        return this.fText;
    }

    public void setFilename(String string, File file) {
        this.setFileType();
        if (this.fBreakpoints != null) {
            this.fBreakpoints.setFile(file);
        }
        if (this.fExecutionArrowDisplay != null) {
            this.fExecutionArrowDisplay.setFile(file);
        }
    }

    /*
     * Unable to fully structure code
     */
    public String getFunctionName(int var1_1) {
        block9: {
            var2_2 = this.fText.getModel().getLineText(var1_1);
            if (var2_2.indexOf("function") == -1) {
                return null;
            }
            var3_3 = this.fText.getModel().getLineStart(var1_1);
            var4_4 = false;
            var5_5 = var3_3 + this.fText.getModel().getLineLengthNoEOL(var1_1);
            while (var3_3 < var5_5) {
                if (this.fText.getModel().charAt(var3_3) == '=') {
                    var4_4 = true;
                    break;
                }
                ++var3_3;
            }
            var3_3 = this.fText.getModel().getLineStart(var1_1);
            var5_5 = var3_3 + this.fText.getModel().length();
            if (!var4_4) ** GOTO lbl22
            while (var3_3 < var5_5 && this.fText.getModel().charAt(var3_3) != '=') {
                ++var3_3;
            }
            ++var3_3;
            break block9;
lbl-1000:
            // 1 sources

            {
                ++var3_3;
lbl22:
                // 2 sources

                ** while (var3_3 < var5_5 && !Character.isWhitespace((char)this.fText.getModel().charAt((int)var3_3)))
            }
        }
        while (var3_3 < var5_5 && Character.isWhitespace(this.fText.getModel().charAt(var3_3))) {
            ++var3_3;
        }
        if (var3_3 < var5_5 - 3 && this.fText.getModel().charAt(var3_3) == '.' && this.fText.getModel().charAt(var3_3 + 1) == '.' && this.fText.getModel().charAt(var3_3 + 2) == '.') {
            var3_3 += 3;
            while (var3_3 < var5_5 && Character.isWhitespace(this.fText.getModel().charAt(var3_3))) {
                ++var3_3;
            }
        }
        var6_6 = 0;
        var7_7 = var3_3;
        while (var3_3 < var5_5 && (Character.isLetterOrDigit(this.fText.getModel().charAt(var3_3)) || this.fText.getModel().charAt(var3_3) == '_')) {
            ++var6_6;
            ++var3_3;
        }
        return this.fText.getModel().getText(var7_7, var7_7 + var6_6);
    }

    String readViewContents() {
        return this.fText.getText();
    }

    void addUndoListener(UndoManager undoManager) {
        this.fText.getModel().addUndoListener((UndoListener)undoManager);
    }

    void beginDeferUpdates() {
        this.fText.getView().beginDeferUpdates();
    }

    void endDeferUpdates() {
        this.fText.getView().endDeferUpdates();
    }

    private void createContextMenu() {
        this.fContextMenu = new MWMenu(sRes.getString("contextmenu.Editor"));
        MenuUtils.addMenuItem(this.fCenter, this.fContextMenu, sRes.getString("contextmenuitem.EvaluateSelection"), 1502, -1);
        MenuUtils.addMenuItem(this.fCenter, this.fContextMenu, sRes.getString("contextmenuitem.OpenSelection"), 132, -1);
        MenuUtils.addMenuItem(this.fCenter, this.fContextMenu, sRes.getString("contextmenuitem.HelponSelection"), 123, -1);
        MenuUtils.addMenuItem(this.fCenter, this.fContextMenu, "SEPARATOR", -1, -1);
        MenuUtils.addMenuItem(this.fCenter, this.fContextMenu, sRes.getString("contextmenuitem.Cut"), 900, -1);
        MenuUtils.addMenuItem(this.fCenter, this.fContextMenu, sRes.getString("contextmenuitem.Copy"), 910, -1);
        MenuUtils.addMenuItem(this.fCenter, this.fContextMenu, sRes.getString("contextmenuitem.Paste"), 920, -1);
        MenuUtils.addMenuItem(this.fCenter, this.fContextMenu, "SEPARATOR", -1, -1);
        MenuUtils.addMenuItem(this.fCenter, this.fContextMenu, sRes.getString("contextmenuitem.SmartIndent"), 1501, -1);
        MenuUtils.addMenuItem(this.fCenter, this.fContextMenu, sRes.getString("contextmenuitem.Comment"), 1300, -1);
        MenuUtils.addMenuItem(this.fCenter, this.fContextMenu, sRes.getString("contextmenuitem.Uncomment"), 1301, -1);
        MenuUtils.addMenuItem(this.fCenter, this.fContextMenu, "SEPARATOR", -1, -1);
        MenuUtils.addMenuItem(this.fCenter, this.fContextMenu, sRes.getString("contextmenuitem.SetClearBreakpoint"), 1700, -1);
        MenuUtils.addMenuItem(this.fCenter, this.fContextMenu, sRes.getString("contextmenuitem.GoUntilHere"), 1650, -1);
        this.fContextMenu.attachTo((Component)((Object)this));
    }

    private void doContextMenu(MouseEvent mouseEvent) {
        Point point;
        MWTextView mWTextView = this.fText.getView();
        int n = mWTextView.selectionPosFromPoint(point = mouseEvent.getPoint());
        if (n < 0) {
            mWTextView.setSel(-n);
            Graphics graphics = mWTextView.getGraphics();
            if (graphics != null) {
                mWTextView.paint(graphics);
                graphics.dispose();
            }
        }
        this.fContextMenu.show((Component)mWTextView, point.x + mWTextView.getGutterWidth(), point.y);
    }

    public void doCommand(int n) {
        switch (n) {
            case 1101: {
                this.doFind();
                return;
            }
            case 1102: {
                this.doFindAgain();
                return;
            }
            case 1103: {
                this.doFindSel();
                return;
            }
            case 1104: {
                this.doFindAgainBack();
                return;
            }
            case 1105: {
                this.doFindSelBack();
                return;
            }
            case 1100: {
                this.doReplace();
                return;
            }
            case 1200: {
                this.doGoto();
                return;
            }
            case 1300: {
                this.doComment();
                return;
            }
            case 1301: {
                this.doUncomment();
                return;
            }
            case 1400: {
                this.doShiftLeft();
                return;
            }
            case 1401: {
                this.doShiftRight();
                return;
            }
            case 1500: {
                this.doBalance();
                return;
            }
            case 1501: {
                this.doIndent();
                return;
            }
            case 1650: {
                this.doGoUntil();
                return;
            }
            case 1700: {
                this.doSetClearBreakpoint();
                return;
            }
            case 1502: {
                this.doEvalSel();
                return;
            }
            case 132: {
                this.doOpenSel();
                return;
            }
            case 560: {
                this.doPrintSel();
                return;
            }
            case 123: {
                this.doHelpSel();
                return;
            }
            case 115: {
                this.doFunctionMenu();
                return;
            }
            case 900: {
                this.doCut();
                return;
            }
            case 910: {
                this.doCopy();
                return;
            }
            case 920: {
                this.doPaste();
                return;
            }
            case 1050: {
                this.doClear();
                return;
            }
            case 1060: {
                this.doSelectAll();
                return;
            }
            case 550: {
                this.doPrint(null);
                return;
            }
        }
        super.doCommand(n);
    }

    public boolean isCommandEnabled(int n) {
        switch (n) {
            case 1700: {
                return !EditorApplication.isStandalone() && this.fEditorDoc.isMFile() && this.fEditorDoc.getFile() != null;
            }
            case 123: 
            case 132: 
            case 1502: {
                if (EditorApplication.isStandalone()) {
                    return false;
                }
                return !this.fText.getSelText().equals("");
            }
            case 560: {
                return !this.fText.getSelText().equals("");
            }
            case 1300: 
            case 1301: {
                return this.fEditorDoc.isMFileOrUntitled();
            }
            case 900: 
            case 910: 
            case 1050: 
            case 1103: 
            case 1105: {
                return !this.fText.getSelText().equals("");
            }
            case 1102: 
            case 1104: {
                return !fFindString.equals("");
            }
            case 115: 
            case 225: 
            case 550: 
            case 1060: 
            case 1100: 
            case 1101: 
            case 1200: 
            case 1400: 
            case 1401: 
            case 1500: 
            case 1501: {
                return true;
            }
            case 920: {
                return this.areClipboardCommandsEnabled();
            }
        }
        return super.isCommandEnabled(n);
    }

    private void setInitialCommandStates() {
        this.fCenter.setCommandEnabled(560, true);
        this.fCenter.updateCommand(1101);
        this.fCenter.updateCommand(1102);
        this.fCenter.updateCommand(1103);
        this.fCenter.updateCommand(1104);
        this.fCenter.updateCommand(1105);
        this.fCenter.updateCommand(1100);
        this.fCenter.updateCommand(1200);
        this.fCenter.updateCommand(1300);
        this.fCenter.updateCommand(1301);
        this.fCenter.updateCommand(1400);
        this.fCenter.updateCommand(1401);
        this.fCenter.updateCommand(1500);
        this.fCenter.updateCommand(1501);
        this.fCenter.updateCommand(1700);
        this.fCenter.updateCommand(1502);
        this.fCenter.updateCommand(132);
        this.fCenter.updateCommand(560);
        this.fCenter.updateCommand(123);
        this.fCenter.updateCommand(115);
        this.fCenter.updateCommand(900);
        this.fCenter.updateCommand(910);
        this.fCenter.updateCommand(920);
        this.fCenter.updateCommand(1050);
        this.fCenter.updateCommand(1060);
    }

    private void enableSelectionDependentCommands(boolean bl) {
        if (!EditorOptions.isInlineDebugger()) {
            this.fCenter.setCommandEnabled(900, false);
            this.fCenter.setCommandEnabled(1050, false);
        } else {
            this.fCenter.setCommandEnabled(900, bl);
            this.fCenter.setCommandEnabled(1050, bl);
        }
        this.fCenter.setCommandEnabled(910, bl);
        this.fCenter.setCommandEnabled(1103, bl);
        this.fCenter.setCommandEnabled(1105, bl);
        this.fCenter.setCommandEnabled(560, bl);
        if (EditorApplication.isStandalone()) {
            this.fCenter.setCommandEnabled(1502, false);
            this.fCenter.setCommandEnabled(132, false);
            this.fCenter.setCommandEnabled(123, false);
            return;
        }
        this.fCenter.setCommandEnabled(1502, bl);
        this.fCenter.setCommandEnabled(132, bl);
        this.fCenter.setCommandEnabled(123, bl);
    }

    private boolean areClipboardCommandsEnabled() {
        return EditorOptions.isInlineDebugger() && this.fClipboardHasString;
    }

    public void clipboardContentTypeChanged(Transferable transferable) {
        this.fClipboardHasString = transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor);
        this.fCenter.setCommandEnabled(920, this.areClipboardCommandsEnabled());
    }

    private void doFind() {
        this.doReplace();
    }

    private void doFindAgain() {
        if (fFindString.equals("")) {
            return;
        }
        this.fText.getView().findString(fFindString, fFindOptions, false);
    }

    private void doFindAgainBack() {
        if (fFindString.equals("")) {
            return;
        }
        this.fText.getView().findString(fFindString, fFindOptions + 8, false);
    }

    private void doFindSel() {
        this.getFrame().toFront();
        fFindString = this.fText.getView().getSelText();
        if (!fFindString.equals("")) {
            this.fText.getView().findString(fFindString, fFindOptions, false);
            this.fCenter.setCommandEnabled(1102, true);
            this.fCenter.setCommandEnabled(1104, true);
            return;
        }
        this.fCenter.setCommandEnabled(1102, false);
        this.fCenter.setCommandEnabled(1104, false);
    }

    private void doFindSelBack() {
        fFindString = this.fText.getView().getSelText();
        if (!fFindString.equals("")) {
            this.fText.getView().findString(fFindString, fFindOptions + 8, false);
            this.fCenter.setCommandEnabled(1102, true);
            this.fCenter.setCommandEnabled(1104, true);
            return;
        }
        this.fCenter.setCommandEnabled(1102, false);
        this.fCenter.setCommandEnabled(1104, false);
    }

    private void replaceAll(String string, String string2) {
        MWTextView mWTextView = this.fText.getView();
        boolean bl = mWTextView.isBeepOn();
        mWTextView.setBeepOn(false);
        Range range = mWTextView.getSel();
        mWTextView.setSel(0, 0);
        boolean bl2 = mWTextView.findString(string, 5, true);
        while (bl2) {
            mWTextView.replaceSel(string2);
            bl2 = mWTextView.findString(string, 5, false);
        }
        mWTextView.setSel(range);
        mWTextView.setBeepOn(bl);
    }

    void addReplaceListener() {
        MWReplaceDialog mWReplaceDialog = MWReplaceDialog.getReplaceDialog();
        if (mWReplaceDialog != null) {
            mWReplaceDialog.addReplaceListener(new DoReplaceContinued());
            mWReplaceDialog.setEditorFilename(this.fEditorDoc.getPathname());
        }
    }

    private void doReplace() {
        String string = this.fText.getView().getSelText();
        if (!string.equals("")) {
            fFindString = string;
        }
        DoReplaceContinued doReplaceContinued = new DoReplaceContinued();
        MWReplaceDialog mWReplaceDialog = MWReplaceDialog.invoke(this.getFrame(), 1, doReplaceContinued, fFindString, fFindOptions);
        mWReplaceDialog.addReplaceListener(doReplaceContinued);
        mWReplaceDialog.setEditorFilename(this.fEditorDoc.getPathname());
    }

    private void doPrintSel() {
        Range range;
        int n;
        Range range2 = this.fText.getView().getSel();
        int n2 = range2.getMin();
        if (n2 == (n = range2.getMax())) {
            range = null;
        } else {
            if (n2 > n) {
                int n3 = n2;
                n2 = n;
                n = n3;
            }
            range = new Range(n2, n);
        }
        this.doPrint(range);
    }

    private void doPrint(Range range) {
        MWStyle[] mWStyleArray = null;
        int n = 8;
        int n2 = EditorOptions.getPrintStyleType();
        boolean bl = EditorOptions.isPrintHeader();
        Font font = null;
        if (n2 == EditorOptions.PRINTSTYLE_STYLED) {
            MWStyle[] mWStyleArray2 = GeneralPrefsColorPanel.getSyntaxHighlightingStyles();
            mWStyleArray = new MWStyle[]{mWStyleArray2[1], mWStyleArray2[2]};
        }
        if (bl) {
            ++n;
        }
        if (n2 == EditorOptions.PRINTSTYLE_COLOR) {
            n += 2;
        }
        if (!EditorOptions.getUseEditorFont()) {
            font = EditorOptions.getPrintFont();
        }
        this.fText.printDocument(this.fEditorDoc.getPathname(), n, mWStyleArray, range, font);
    }

    private void doGoto() {
        int n = this.fText.getModel().lineFromPos(this.fText.getSelEnd());
        MWGotoDialog mWGotoDialog = new MWGotoDialog(this.getFrame(), n + 1);
        n = mWGotoDialog.getLineNumber();
        if (n != -1) {
            this.goToLine(n);
            this.fText.getView().scrollLineToCenter(n - 1);
            this.fText.requestFocus();
        }
    }

    void goToLine(int n, boolean bl) {
        if (n <= 0) {
            n = 1;
        } else if (n > this.fText.getModel().getNumLines()) {
            n = this.fText.getModel().getNumLines();
        }
        int n2 = this.fText.getModel().getLineStart(n - 1);
        if (n - 1 > this.fText.getView().getBottomCompleteLine()) {
            this.fText.getView().scrollLineToCenter(n - 1);
        }
        int n3 = n2;
        if (bl) {
            n3 = this.fText.getModel().getLineEndNoEOL(n - 1);
        }
        this.fText.getView().setSel(n2, n3);
    }

    void goToLine(int n) {
        this.goToLine(n, false);
    }

    /*
     * Unable to fully structure code
     */
    private String gimmeFunctionName(int var1_1) {
        block9: {
            var7_2 = this.fText;
            var8_3 = var7_2.getModel().getLineText(var1_1);
            if (var8_3.indexOf("function") == -1) {
                return null;
            }
            var4_4 = var7_2.getModel().getLineStart(var1_1);
            var6_5 = false;
            var5_6 = var4_4 + var7_2.getModel().getLineLengthNoEOL(var1_1);
            while (var4_4 < var5_6) {
                if (var7_2.getModel().charAt(var4_4) == '=') {
                    var6_5 = true;
                    break;
                }
                ++var4_4;
            }
            var4_4 = var7_2.getModel().getLineStart(var1_1);
            var5_6 = var4_4 + var7_2.getModel().length();
            if (!var6_5) ** GOTO lbl23
            while (var4_4 < var5_6 && var7_2.getModel().charAt(var4_4) != '=') {
                ++var4_4;
            }
            ++var4_4;
            break block9;
lbl-1000:
            // 1 sources

            {
                ++var4_4;
lbl23:
                // 2 sources

                ** while (var4_4 < var5_6 && !Character.isWhitespace((char)var7_2.getModel().charAt((int)var4_4)))
            }
        }
        while (var4_4 < var5_6 && Character.isWhitespace(var7_2.getModel().charAt(var4_4))) {
            ++var4_4;
        }
        if (var4_4 < var5_6 - 3 && var7_2.getModel().charAt(var4_4) == '.' && var7_2.getModel().charAt(var4_4 + 1) == '.' && var7_2.getModel().charAt(var4_4 + 2) == '.') {
            var4_4 += 3;
            while (var4_4 < var5_6 && Character.isWhitespace(var7_2.getModel().charAt(var4_4))) {
                ++var4_4;
            }
        }
        var2_7 = 0;
        var3_8 = var4_4;
        while (var4_4 < var5_6 && (Character.isLetterOrDigit(var7_2.getModel().charAt(var4_4)) || var7_2.getModel().charAt(var4_4) == '_')) {
            ++var2_7;
            ++var4_4;
        }
        return var7_2.getModel().getText(var3_8, var3_8 + var2_7);
    }

    void goToFunction(String string, String string2) {
        SyntaxTextArea syntaxTextArea = this.fText;
        int n = syntaxTextArea.getModel().getNumLines();
        int n2 = 0;
        while (n2 < n) {
            if (this.isFunctionLine(n2)) {
                String string3 = this.gimmeFunctionName(n2);
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ()");
                if (stringTokenizer.hasMoreTokens() && stringTokenizer.nextToken().equals(string3)) {
                    this.goToLine(n2 + 1);
                    break;
                }
            }
            ++n2;
        }
        if (n2 >= n) {
            String string4 = System.getProperty("line.separator");
            n = syntaxTextArea.getModel().length();
            syntaxTextArea.getModel().startCommand("New Function");
            try {
                if (string2 != null) {
                    syntaxTextArea.getModel().insert(n, String.valueOf(string4) + string4 + string2 + string4);
                } else {
                    syntaxTextArea.getModel().insert(n, String.valueOf(string4) + string4 + "%------------------------------------------------------" + string4);
                }
                syntaxTextArea.getModel().insert(syntaxTextArea.getModel().length(), "function " + string + string4);
                syntaxTextArea.getView().setSel(syntaxTextArea.getModel().length());
                return;
            }
            finally {
                Object var9_10 = null;
                syntaxTextArea.getModel().endCommand();
            }
        }
    }

    void setContents(String string) {
        this.fText.getModel().startCommand("Insert Text");
        try {
            this.fText.setText(string);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.fText.getModel().endCommand();
            throw throwable;
        }
        Object var3_2 = null;
        this.fText.getModel().endCommand();
    }

    private void showLineNumbers(boolean bl) {
        if (bl && !this.fShowingLineNumbers) {
            if (this.fLineNumberDisplay == null) {
                this.fLineNumberDisplay = new LineNumberDisplay((MWTextComponent)this.fText);
            }
            this.fWestPanel.add((Component)((Object)this.fLineNumberDisplay), "West");
            this.fLineNumberDisplay.setFont(this.fFont);
            ((Container)((Object)this)).validate();
        } else if (!bl && this.fShowingLineNumbers) {
            if (this.fLineNumberDisplay != null) {
                this.fWestPanel.remove((Component)((Object)this.fLineNumberDisplay));
            }
            this.fLineNumberDisplay = null;
            ((Container)((Object)this)).validate();
        }
        this.fShowingLineNumbers = bl;
    }

    private void showBreakpointAlley(boolean bl) {
        if (bl && !this.fShowingBreakpoints) {
            this.fBreakpoints = new BreakpointDisplay((MWTextComponent)this.fText, this.fMatlab);
            this.fBreakpoints.setFile(this.fEditorDoc.getFile());
            this.fWestPanel.add((Component)((Object)this.fBreakpoints), "Center");
            ((Component)((Object)this.fBreakpoints)).setFont(this.fFont);
            ((Container)((Object)this)).validate();
        } else if (!bl && this.fShowingBreakpoints) {
            if (this.fBreakpoints != null) {
                this.fWestPanel.remove((Component)((Object)this.fBreakpoints));
            }
            this.fBreakpoints = null;
            ((Container)((Object)this)).validate();
        }
        this.fShowingBreakpoints = bl;
    }

    private void showCurrentStatementAlley(boolean bl) {
        if (bl && !this.fShowingExecutionArrow) {
            this.fExecutionArrowDisplay = new ExecutionArrowDisplay((MWTextComponent)this.fText, this.fMatlab);
            this.fExecutionArrowDisplay.setFile(this.fEditorDoc.getFile());
            this.fCenterPanel.add((Component)((Object)this.fExecutionArrowDisplay), "West");
            ((Container)((Object)this)).validate();
        } else if (!bl && this.fShowingExecutionArrow) {
            if (this.fExecutionArrowDisplay != null) {
                this.fCenterPanel.remove((Component)((Object)this.fExecutionArrowDisplay));
            }
            this.fExecutionArrowDisplay = null;
            ((Container)((Object)this)).validate();
        }
        this.fShowingExecutionArrow = bl;
    }

    private void doComment() {
        this.commentCode(true);
    }

    private void doUncomment() {
        this.commentCode(false);
    }

    private void commentCode(boolean bl) {
        MWTextModel mWTextModel;
        block11: {
            int n;
            int n2;
            MWTextView mWTextView = this.fText.getView();
            mWTextModel = this.fText.getModel();
            int n3 = mWTextView.getSelStart();
            if (n3 > (n2 = mWTextView.getSelEnd())) {
                n = n3;
                n3 = n2;
                n2 = n;
            }
            int n4 = mWTextModel.lineFromPos(n3);
            int n5 = mWTextModel.lineFromPos(n2);
            if (n4 < 0) {
                n4 = 0;
            }
            if (n3 != n2 && n2 == mWTextModel.getLineStart(n5)) {
                n5 = Math.max(n5 - 1, 0);
            }
            mWTextModel.startCommand(bl ? "Uncomment" : "Comment");
            try {
                n = n4;
                while (n <= n5) {
                    int n6 = mWTextModel.getLineStart(n);
                    if (bl) {
                        mWTextModel.insert(n6, "% ");
                    } else {
                        int n7 = 1;
                        if (mWTextModel.charAtNoExc(n6) == '%') {
                            if (mWTextModel.charAtNoExc(n6 + 1) == ' ') {
                                n7 = 2;
                            }
                            mWTextModel.delete(n6, n6 + n7);
                        }
                    }
                    ++n;
                }
                if (mWTextModel.getNumLines() - 1 > n5) {
                    mWTextView.setSel(mWTextModel.getLineStart(n4), mWTextModel.getLineStart(n5 + 1));
                    break block11;
                }
                mWTextView.setSel(mWTextModel.getLineStart(n4), mWTextModel.getLineEnd(n5));
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                mWTextModel.endCommand();
                throw throwable;
            }
        }
        Object var10_11 = null;
        mWTextModel.endCommand();
    }

    private void doShiftLeft() {
        this.doShift(1400);
    }

    private void doShiftRight() {
        this.doShift(1401);
    }

    private void doShift(int n) {
        MWTextModel mWTextModel;
        block14: {
            int n2;
            int n3;
            MWTextView mWTextView = this.fText.getView();
            mWTextModel = this.fText.getModel();
            int n4 = Math.max(1, EditorOptions.getSpacesPerTab());
            int n5 = mWTextView.getSelStart();
            if (n5 > (n3 = mWTextView.getSelEnd())) {
                n2 = n5;
                n5 = n3;
                n3 = n2;
            }
            int n6 = mWTextModel.lineFromPos(n5);
            int n7 = mWTextModel.lineFromPos(n3);
            if (n6 < 0) {
                n6 = 0;
            }
            if (n5 != n3 && n3 == mWTextModel.getLineStart(n7)) {
                n7 = Math.max(n7 - 1, 0);
            }
            mWTextModel.startCommand("Shift " + (n == 1400 ? "Left" : "Right"));
            try {
                n2 = n6;
                while (n2 <= n7) {
                    int n8 = mWTextModel.getLineStart(n2);
                    if (n == 1400) {
                        if (mWTextModel.charAtNoExc(n8) == '\t') {
                            mWTextModel.delete(n8, n8 + 1);
                        } else {
                            int n9 = 0;
                            int n10 = n8;
                            while (n10 < n8 + n4) {
                                if (mWTextModel.charAtNoExc(n10) != ' ') break;
                                ++n9;
                                ++n10;
                            }
                            mWTextModel.delete(n8, n8 + n9);
                        }
                    } else if (mWTextModel.charAtNoExc(n8) == ' ') {
                        mWTextModel.insert(n8, "    ");
                    } else {
                        mWTextModel.insert(n8, '\t');
                    }
                    ++n2;
                }
                if (n7 == mWTextModel.getNumLines() - 1) {
                    mWTextView.setSel(mWTextModel.getLineStart(n6), mWTextModel.length());
                    break block14;
                }
                mWTextView.setSel(mWTextModel.getLineStart(n6), mWTextModel.getLineStart(n7 + 1));
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                mWTextModel.endCommand();
                throw throwable;
            }
        }
        Object var11_13 = null;
        mWTextModel.endCommand();
    }

    private void doIndent() {
        String string = null;
        if (this.fEditorDoc.isMFileOrUntitled()) {
            string = this.fText.getIndenterType();
            this.fText.setIndenterType("SmartIndent");
        }
        this.fText.indentSel();
        if (string != null) {
            this.fText.setIndenterType(string);
        }
    }

    private void doGoUntil() {
        int n = this.fText.getView().getSelEnd();
        int n2 = this.fText.getModel().lineFromPos(n);
        this.fBreakpoints.goUntil(n2 + 1);
    }

    private void doSetClearBreakpoint() {
        int n = this.fText.getView().getSelStart();
        int n2 = this.fText.getModel().lineFromPos(n);
        if (this.fBreakpoints.breakpointAt(n2)) {
            this.fBreakpoints.clearBreakpoint(n2);
            return;
        }
        this.fBreakpoints.setBreakpoint(n2);
    }

    void doClearAllBreakpoints() {
        this.fBreakpoints.clearAllBreakpoints();
    }

    private void doBalance() {
        this.fText.doBalance();
    }

    private void doEvalSel() {
        MatlabCommandWidget.executeCommand(this.fText.getSelText());
    }

    private void doOpenSel() {
        if (this.fMatlab != null) {
            this.fMatlab.eval("edit " + this.fText.getSelText(), (CompletionObserver)new DisplayErrors());
        }
    }

    private void doHelpSel() {
        if (this.fMatlab != null) {
            this.fMatlab.evalNoOutput("doc " + this.fText.getSelText());
        }
    }

    private void doCut() {
        this.fText.getView().cut();
    }

    private void doCopy() {
        this.fText.getView().copy();
    }

    private void doPaste() {
        this.fText.getView().paste();
    }

    private void doClear() {
        this.fText.getView().charLeftDelete();
    }

    private void doSelectAll() {
        this.fText.getView().bufferSelect();
    }

    private void doFunctionMenu() {
        this.fFunctionLines = new IntBuffer();
        int n = this.fText.getModel().getNumLines();
        int n2 = 0;
        while (n2 < n) {
            if (this.isFunctionLine(n2)) {
                this.fFunctionLines.append(n2);
            }
            ++n2;
        }
        if (this.fGoFunc == null) {
            this.fGoFunc = new GoFunction();
            this.fPopup = new MWPopupList();
            this.fPopup.addItemListener((ItemListener)this.fGoFunc);
        } else {
            this.fPopup.removeAllItems();
        }
        n2 = 0;
        while (n2 < this.fFunctionLines.length()) {
            String string = this.getFunctionName(this.fFunctionLines.getAt(n2));
            this.fPopup.addItem(string);
            ++n2;
        }
        if (this.fFunctionLines.length() == 0) {
            this.fPopup.addItem(sRes.getString("menuitem.Nofunctionsfound"));
        }
        Point point = this.fEditorDoc.getToolLocation(115);
        this.fPopup.setSelectedIndex(-1);
        this.fPopup.show((Component)((Object)this), point.x, 0, 100, 2);
    }

    private boolean isFunctionLine(int n) {
        String string = "function";
        if (n < this.fText.getModel().getNumLines()) {
            String string2;
            int n2 = this.fText.getModel().getLineStart(n);
            int n3 = this.fText.getModel().getLineLengthNoEOL(n);
            while (n3 > 0 && Character.isWhitespace(this.fText.getModel().charAt(n2))) {
                ++n2;
                --n3;
            }
            if (n3 > string.length() && (string2 = this.fText.getModel().getText(n2, n2 + string.length())).equals(string)) {
                return true;
            }
        }
        return false;
    }

    private void gotoFunction(String string) {
    }

    private void setupView(CharBuffer charBuffer) {
        if (charBuffer != null) {
            this.fText.getModel().setCharBuffer(charBuffer);
            this.fText.getView().setSel(0);
        }
    }

    private void setFileType() {
        boolean bl = this.fEditorDoc.isMFileOrUntitled();
        String string = bl ? "M-code" : "Text";
        this.fText.setFileType(string);
        if (bl) {
            this.fText.setIndenterType(EditorOptions.getIndentMode());
        } else {
            this.fText.setIndenterType("BlockIndent");
        }
        this.fCenter.updateCommand(1700);
        this.fCenter.updateCommand(1300);
        this.fCenter.updateCommand(1301);
        this.fCenter.updateCommand(113);
        this.showBreakpointAlley(bl);
        this.showCurrentStatementAlley(bl);
        if (this.fDataTip != null) {
            this.fDataTip.setDataTipEnabled(bl);
        }
    }

    public static void main(String[] stringArray) {
        EditorView editorView = new EditorView("g:\\v5\\toolbox\\matlab\\general\\ls.m");
        MWFrame mWFrame = new MWFrame("EditorView");
        mWFrame.add((Component)((Object)editorView), "Center");
        mWFrame.setLocation(20, 40);
        mWFrame.setSize(900, 700);
        mWFrame.setVisible(true);
        mWFrame.addWindowListener((WindowListener)new MWWindowActivater((Component)mWFrame));
    }

    static {
        fFindString = "";
    }

    private class EditorPrefListener
    implements PrefListener {
        public void prefChanged(PrefEvent prefEvent) {
            String string = prefEvent.getPrefKey();
            if (string.equals("EditorSyntaxHighlighting")) {
                EditorView.this.fText.setSyntaxHighlightingEnabled(EditorOptions.isSyntaxHighlightingEnabled());
                return;
            }
            if (string.equals("EditorBackgroundColor")) {
                MWStyle mWStyle = EditorOptions.getBackgroundColor();
                if (EditorView.this.fShowingExecutionArrow) {
                    EditorView.this.fExecutionArrowDisplay.setBackgroundStyle(mWStyle);
                    ((Component)((Object)EditorView.this.fExecutionArrowDisplay)).repaint();
                }
                EditorView.this.fText.setBackgroundStyle(mWStyle);
                ((Component)((Object)EditorView.this.fText)).repaint();
                return;
            }
            if (string.equals("EditorTextColor")) {
                EditorView.this.fText.setTextStyle(EditorOptions.getTextColor());
                EditorView.this.setHighlightColors();
                return;
            }
            if (string.equals("EditorInlineDebugger")) {
                EditorView.this.showCurrentStatementAlley(EditorOptions.isInlineDebugger());
                return;
            }
            if (string.equals("EditorKeyBindingScheme")) {
                EditorView.this.fText.setKeyBindingScheme(EditorOptions.getKeyBindingScheme());
                EditorView.this.adjustKeyMap();
                return;
            }
            if (string.equals("EditorShowLineNumbers")) {
                EditorView.this.showLineNumbers(EditorOptions.getShowLineNumbers());
                return;
            }
            if (string.equals("Syncolor")) {
                EditorView.this.setHighlightColors();
                return;
            }
            if (string.equals("EditorEnableDataTips")) {
                EditorView.this.setDataTips();
                return;
            }
            if (string.equals("EditorSpacesPerTab")) {
                EditorView.this.fText.setSpacesPerTab(EditorOptions.getSpacesPerTab());
                return;
            }
            if (string.equals("EditorSpacesPerIndent")) {
                EditorView.this.fText.setSpacesPerIndent(EditorOptions.getSpacesPerIndent());
                return;
            }
            if (string.equals("EditorFont") || string.equals("EditorUseDesktopFont")) {
                EditorView.this.setEditorFont();
                return;
            }
            if (string.equals("GeneralFont")) {
                if (EditorOptions.getUseDesktopFont()) {
                    EditorView.this.setEditorFont();
                    return;
                }
            } else {
                if (string.equals("EditorIndentMode")) {
                    EditorView.this.fText.setIndenterType(EditorOptions.getIndentMode());
                    return;
                }
                if (string.equals("EditorTabToSpaces")) {
                    EditorView.this.fText.setTabUsingSpaces(EditorOptions.isTabChangedToSpaces());
                    return;
                }
                if (string.equals("EditorEmacsTab")) {
                    EditorView.this.fText.setEmacsStyleTabEnabled(EditorOptions.isEmacsStyleTab());
                }
            }
        }

        EditorPrefListener() {
            EditorView.this = EditorView.this;
        }
    }

    private class DebugStateListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().equals("DebugStateChanged") && EditorView.this.fDataTip != null) {
                if (EditorApplication.getInDebugMode()) {
                    EditorView.this.fDataTip.setDataTipEnabled(true);
                    return;
                }
                EditorView.this.fDataTip.setDataTipEnabled(EditorOptions.getDataTips());
            }
        }

        DebugStateListener() {
            EditorView.this = EditorView.this;
        }
    }

    class ContextListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                EditorView.this.doContextMenu(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                EditorView.this.doContextMenu(mouseEvent);
            }
        }

        ContextListener() {
            EditorView.this = EditorView.this;
        }
    }

    private class DoReplaceContinued
    implements MWReplaceListener {
        public void findRequested(MWReplaceEvent mWReplaceEvent) {
            fFindString = mWReplaceEvent.getFindString();
            fFindOptions = mWReplaceEvent.getOptions();
            EditorView.this.fText.getView().findString(fFindString, fFindOptions, false);
            EditorView.this.fCenter.setCommandEnabled(1102, true);
            EditorView.this.fCenter.setCommandEnabled(1104, true);
        }

        public void replaceRequested(MWReplaceEvent mWReplaceEvent) {
            this.doReplace(mWReplaceEvent);
        }

        public void replaceAllRequested(MWReplaceEvent mWReplaceEvent) {
            int n;
            MWTextView mWTextView = EditorView.this.fText.getView();
            int n2 = n = mWTextView.getSel().getEnd();
            boolean bl = true;
            boolean bl2 = false;
            do {
                bl = this.doReplace(mWReplaceEvent);
                int n3 = mWTextView.getSel().getEnd();
                if (n3 < n2) {
                    bl2 = true;
                }
                if (bl2 && n3 > n) {
                    bl = false;
                }
                n2 = mWTextView.getSel().getEnd();
            } while (bl);
        }

        private boolean doReplace(MWReplaceEvent mWReplaceEvent) {
            fFindString = mWReplaceEvent.getFindString();
            fFindOptions = mWReplaceEvent.getOptions();
            String string = mWReplaceEvent.getReplaceString();
            MWTextView mWTextView = EditorView.this.fText.getView();
            Range range = mWTextView.getSel();
            boolean bl = mWTextView.findString(fFindString, fFindOptions, true);
            if (bl && mWTextView.compareSel(range)) {
                mWTextView.replaceSel(string);
                bl = mWTextView.findString(fFindString, fFindOptions, false);
            }
            return bl;
        }

        DoReplaceContinued() {
            EditorView.this = EditorView.this;
        }
    }

    private class DisplayErrors
    implements CompletionObserver {
        public void completed(int n, Object object) {
            if (object == null) {
                return;
            }
            if (((String)object).length() == 0) {
                return;
            }
            new MWAlert(EditorView.this.getFrame(), sRes.getString("MATLABEditor"), (String)object, 1);
        }

        DisplayErrors() {
            EditorView.this = EditorView.this;
        }
    }

    private class TextViewEventHandler
    extends MWTextViewAdapter {
        public void selectionChanged(MWTextViewEvent mWTextViewEvent) {
            boolean bl = !mWTextViewEvent.getSelAfter().isEmpty();
            EditorView.this.enableSelectionDependentCommands(bl);
        }

        TextViewEventHandler() {
            EditorView.this = EditorView.this;
        }
    }

    class GoFunction
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            if (EditorView.this.fPopup.getSelectedIndex() != -1) {
                String string = EditorView.this.fPopup.getSelectedItem();
                if (!string.equals(sRes.getString("menuitem.Nofunctionsfound"))) {
                    int n = EditorView.this.fPopup.getSelectedIndex();
                    int n2 = EditorView.this.fText.getModel().getLineStart(EditorView.this.fFunctionLines.getAt(n));
                    EditorView.this.fText.getView().setSel(n2, n2);
                    EditorView.this.fText.getView().scrollLineToCenter(EditorView.this.fText.getModel().lineFromPos(n2));
                }
                EditorView.this.fText.getView().requestFocus();
            }
        }

        GoFunction() {
            EditorView.this = EditorView.this;
        }
    }

    private class KeyEventFilter
    extends KeyAdapter {
        private final int KEY_MASK = 14;
        private boolean fCtrlXMode;
        private boolean fSaveAllState;
        private boolean fSaveAsState;

        private void deCommand(int n) {
            if (EditorView.this.getCommandCenter().getCommandEnabled(n)) {
                EditorView.this.doCommand(n);
            }
        }

        private boolean isEmacsMode() {
            return EditorOptions.getKeyBindingScheme() == 2;
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = 0;
            int n2 = keyEvent.getModifiers();
            int n3 = keyEvent.getKeyCode();
            if (this.isEmacsMode()) {
                if (this.fCtrlXMode) {
                    this.fCtrlXMode = false;
                    n = 1;
                    EditorView.this.getCommandCenter().addKey(83, 1101);
                    EditorView.this.getCommandCenter().addKey(83, 1100);
                    EditorView.this.getCommandCenter().addKey(87, 900);
                    if (n2 == 2) {
                        switch (n3) {
                            case 67: {
                                this.deCommand(-111);
                                break;
                            }
                            case 70: {
                                this.deCommand(130);
                                break;
                            }
                            case 83: {
                                this.deCommand(350);
                                break;
                            }
                            case 87: {
                                this.deCommand(351);
                                break;
                            }
                            default: {
                                n = -1;
                                break;
                            }
                        }
                    } else if ((n2 & 0xE) == 0) {
                        switch (n3) {
                            case 83: {
                                this.deCommand(352);
                                break;
                            }
                            case 75: {
                                this.deCommand(135);
                                break;
                            }
                            case 85: {
                                this.deCommand(800);
                                break;
                            }
                            default: {
                                n = -1;
                                break;
                            }
                        }
                    } else {
                        n = -1;
                    }
                } else if (n2 == 2 && n3 == 88) {
                    this.fCtrlXMode = true;
                    EditorView.this.getCommandCenter().removeKey(83);
                    EditorView.this.getCommandCenter().removeKey(87);
                    n = 1;
                }
                if (n != 0) {
                    keyEvent.consume();
                    if (n == -1) {
                        ((Component)((Object)EditorView.this)).getToolkit().beep();
                    }
                }
            }
        }

        KeyEventFilter() {
            EditorView.this = EditorView.this;
        }
    }

    private class EditMWCanvas
    extends MWCanvas {
        public EditMWCanvas(int n, int n2) {
            super(n, n2);
            EditorView.this = EditorView.this;
        }
    }
}

