/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.editor;

import com.mathworks.ide.editor.EditorApplication;
import com.mathworks.ide.editor.EditorOptions;
import com.mathworks.ide.editor.VertFlowLayout;
import com.mathworks.mwt.MWCheckbox;
import com.mathworks.mwt.MWExclusiveGroup;
import com.mathworks.mwt.MWGroupbox;
import com.mathworks.mwt.MWPanel;
import com.mathworks.widgets.DesktopFontPicker;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Insets;

public class EditorPrefsPrintPanel
extends MWPanel {
    private static EditorPrefsPrintPanel sPrefsPanel = null;
    private MWCheckbox fSyntaxAsBW;
    private MWCheckbox fSyntaxAsColor;
    private MWCheckbox fSyntaxAsStyle;
    private DesktopFontPicker fFontEditor;
    private MWCheckbox fHeader;

    public EditorPrefsPrintPanel() {
        MWGroupbox mWGroupbox = new MWGroupbox(EditorApplication.intlString("pref.print.SyntaxHighlighting"), 0);
        mWGroupbox.setName("SyntaxHighlighting");
        mWGroupbox.setLayout(new VertFlowLayout(3, 0, 5));
        MWExclusiveGroup mWExclusiveGroup = new MWExclusiveGroup();
        int n = EditorOptions.getPrintStyleType();
        this.fSyntaxAsBW = new MWCheckbox(EditorApplication.intlString("pref.print.BandW"), n == EditorOptions.PRINTSTYLE_BW, mWExclusiveGroup);
        this.fSyntaxAsBW.setName("BandW");
        this.fSyntaxAsBW.setBehavior(1);
        this.fSyntaxAsColor = new MWCheckbox(EditorApplication.intlString("pref.print.Colored"), n == EditorOptions.PRINTSTYLE_COLOR, mWExclusiveGroup);
        this.fSyntaxAsColor.setName("Colored");
        this.fSyntaxAsColor.setBehavior(1);
        this.fSyntaxAsStyle = new MWCheckbox(EditorApplication.intlString("pref.print.Styled"), n == EditorOptions.PRINTSTYLE_STYLED, mWExclusiveGroup);
        this.fSyntaxAsStyle.setName("Styled");
        this.fSyntaxAsStyle.setBehavior(1);
        mWGroupbox.add((Component)this.fSyntaxAsBW);
        mWGroupbox.add((Component)this.fSyntaxAsColor);
        mWGroupbox.add((Component)this.fSyntaxAsStyle);
        MWGroupbox mWGroupbox2 = new MWGroupbox(EditorApplication.intlString("pref.print.Header"), 0);
        mWGroupbox2.setLayout(new VertFlowLayout());
        this.fHeader = new MWCheckbox(EditorApplication.intlString("pref.print.PrintHeader"), EditorOptions.isPrintHeader());
        this.fHeader.setName("PrintHeader");
        mWGroupbox2.add((Component)this.fHeader);
        this.fFontEditor = new DesktopFontPicker(EditorOptions.getUseEditorFont(), EditorOptions.getDefaultPrintFont());
        this.fFontEditor.setUseDesktopFontLabel(EditorApplication.intlString("pref.print.Usefont"));
        MWGroupbox mWGroupbox3 = new MWGroupbox(EditorApplication.intlString("pref.font.Font"));
        mWGroupbox3.setName("Font");
        mWGroupbox3.setLayout(new FlowLayout(0, 0, 0));
        mWGroupbox3.add((Component)this.fFontEditor);
        VertFlowLayout vertFlowLayout = new VertFlowLayout(3, 10, 10);
        vertFlowLayout.setMaximizeHorizontally(true);
        ((Container)((Object)this)).setLayout(vertFlowLayout);
        this.setInsets(new Insets(0, 0, 0, 0));
        ((Container)((Object)this)).add((Component)mWGroupbox);
        ((Container)((Object)this)).add((Component)mWGroupbox2);
        ((Container)((Object)this)).add((Component)mWGroupbox3);
    }

    public static MWPanel createPrefsPanel() {
        if (sPrefsPanel != null) {
            sPrefsPanel = null;
        }
        sPrefsPanel = new EditorPrefsPrintPanel();
        return sPrefsPanel;
    }

    public static void commitPrefsChanges() {
        if (sPrefsPanel != null) {
            sPrefsPanel.saveOptions();
        }
    }

    private void saveOptions() {
        if (this.fSyntaxAsBW.getState()) {
            EditorOptions.setPrintStyleType(EditorOptions.PRINTSTYLE_BW);
        } else if (this.fSyntaxAsColor.getState()) {
            EditorOptions.setPrintStyleType(EditorOptions.PRINTSTYLE_COLOR);
        } else if (this.fSyntaxAsStyle.getState()) {
            EditorOptions.setPrintStyleType(EditorOptions.PRINTSTYLE_STYLED);
        }
        EditorOptions.setPrintHeader(this.fHeader.getState());
        EditorOptions.setUseEditorFont(this.fFontEditor.getUseDesktopFont());
        EditorOptions.setPrintFont(this.fFontEditor.getSelectedFont());
    }
}

