/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.editor;

import com.mathworks.ide.editor.EditorApplication;
import com.mathworks.ide.editor.EditorOptions;
import com.mathworks.ide.editor.VertFlowLayout;
import com.mathworks.mwt.MWCheckbox;
import com.mathworks.mwt.MWExclusiveGroup;
import com.mathworks.mwt.MWExclusiveGroupItem;
import com.mathworks.mwt.MWGroupbox;
import com.mathworks.mwt.MWLabel;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.MWTextField;
import com.mathworks.util.PlatformInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;

public class EditorPrefsKeyboardPanel
extends MWPanel {
    private static EditorPrefsKeyboardPanel sPrefsPanel = null;
    private MWCheckbox fWindowsKeyBindings;
    private MWCheckbox fEmacsKeyBindings;
    private MWCheckbox fMacKeyBindings;
    private MWTextField fSpacesPerTabInputField;
    private MWTextField fSpacesPerIndentInputField;
    private MWCheckbox fChangeTabsToSpaces;
    private MWCheckbox fEmacsStyleTab;
    private MWCheckbox fNoIndent;
    private MWCheckbox fAutoIndent;
    private MWCheckbox fSmartIndent;

    public EditorPrefsKeyboardPanel() {
        GridLayout gridLayout = new GridLayout(2, 1, 0, 10);
        int n = EditorOptions.getKeyBindingScheme();
        MWGroupbox mWGroupbox = new MWGroupbox(EditorApplication.intlString("pref.key.GroupKeyBindings"), 0);
        mWGroupbox.setLayout(gridLayout);
        MWExclusiveGroup mWExclusiveGroup = new MWExclusiveGroup();
        this.fWindowsKeyBindings = new MWCheckbox(EditorApplication.intlString("pref.key.Windows"), n == 1, mWExclusiveGroup);
        this.fWindowsKeyBindings.setBehavior(1);
        this.fEmacsKeyBindings = new MWCheckbox(EditorApplication.intlString("pref.key.Emacs"), n == 2, mWExclusiveGroup);
        this.fEmacsKeyBindings.setBehavior(1);
        this.fMacKeyBindings = new MWCheckbox(EditorApplication.intlString("pref.key.Macintosh"), n == 3, mWExclusiveGroup);
        this.fMacKeyBindings.setBehavior(1);
        if (n == 1) {
            mWExclusiveGroup.setSelectedItem((MWExclusiveGroupItem)this.fWindowsKeyBindings);
        } else if (n == 2) {
            mWExclusiveGroup.setSelectedItem((MWExclusiveGroupItem)this.fEmacsKeyBindings);
        } else if (n == 3) {
            mWExclusiveGroup.setSelectedItem((MWExclusiveGroupItem)this.fMacKeyBindings);
        }
        mWGroupbox.add((Component)this.fWindowsKeyBindings);
        mWGroupbox.add((Component)this.fEmacsKeyBindings);
        if (PlatformInfo.isMacintosh()) {
            mWGroupbox.setLayout(new GridLayout(3, 1));
            mWGroupbox.add((Component)this.fMacKeyBindings);
        }
        MWGroupbox mWGroupbox2 = new MWGroupbox(EditorApplication.intlString("pref.key.GroupEnterKey"), 0);
        mWGroupbox2.setLayout(new VertFlowLayout(3, 0, 5));
        MWExclusiveGroup mWExclusiveGroup2 = new MWExclusiveGroup();
        String string = EditorOptions.getIndentMode();
        this.fNoIndent = new MWCheckbox(EditorApplication.intlString("pref.key.NoIndent"), string.equals("NoIndent"), mWExclusiveGroup2);
        this.fNoIndent.setBehavior(1);
        this.fAutoIndent = new MWCheckbox(EditorApplication.intlString("pref.key.BlockIndent"), string.equals("BlockIndent"), mWExclusiveGroup2);
        this.fAutoIndent.setBehavior(1);
        this.fSmartIndent = new MWCheckbox(EditorApplication.intlString("pref.key.SmartIndent"), string.equals("SmartIndent"), mWExclusiveGroup2);
        this.fSmartIndent.setBehavior(1);
        mWGroupbox2.add((Component)this.fNoIndent);
        mWGroupbox2.add((Component)this.fAutoIndent);
        mWGroupbox2.add((Component)this.fSmartIndent);
        MWGroupbox mWGroupbox3 = new MWGroupbox(EditorApplication.intlString("pref.key.GroupIndents"), 0);
        mWGroupbox3.setLayout(new VertFlowLayout(3, 0, 5));
        MWPanel mWPanel = new MWPanel((LayoutManager)new FlowLayout(0, 0, 0));
        this.fSpacesPerIndentInputField = new MWTextField(String.valueOf(EditorOptions.getSpacesPerIndent()), 3);
        mWPanel.add((Component)new MWLabel(EditorApplication.intlString("pref.key.IndentSize")));
        mWPanel.add((Component)new MWLabel(" "));
        mWPanel.add((Component)this.fSpacesPerIndentInputField);
        this.fEmacsStyleTab = new MWCheckbox(EditorApplication.intlString("pref.key.EmacsStyle"), EditorOptions.isEmacsStyleTab());
        mWGroupbox3.add((Component)mWPanel);
        mWGroupbox3.add((Component)this.fEmacsStyleTab);
        MWGroupbox mWGroupbox4 = new MWGroupbox(EditorApplication.intlString("pref.key.GroupTabs"), 0);
        mWGroupbox4.setLayout(new VertFlowLayout(3, 0, 5));
        MWPanel mWPanel2 = new MWPanel((LayoutManager)new FlowLayout(0, 0, 0));
        this.fSpacesPerTabInputField = new MWTextField(String.valueOf(EditorOptions.getSpacesPerTab()), 3);
        mWPanel2.add((Component)new MWLabel(EditorApplication.intlString("pref.key.TabSize")));
        mWPanel2.add((Component)new MWLabel(" "));
        mWPanel2.add((Component)this.fSpacesPerTabInputField);
        this.fChangeTabsToSpaces = new MWCheckbox(EditorApplication.intlString("pref.key.Spaces"), EditorOptions.isTabChangedToSpaces());
        mWGroupbox4.add((Component)mWPanel2);
        mWGroupbox4.add((Component)this.fChangeTabsToSpaces);
        VertFlowLayout vertFlowLayout = new VertFlowLayout(3, 10, 10);
        vertFlowLayout.setMaximizeHorizontally(true);
        ((Container)((Object)this)).setLayout(vertFlowLayout);
        this.setInsets(new Insets(0, 0, 0, 0));
        ((Container)((Object)this)).add((Component)mWGroupbox);
        ((Container)((Object)this)).add((Component)mWGroupbox2);
        ((Container)((Object)this)).add((Component)mWGroupbox3);
        ((Container)((Object)this)).add((Component)mWGroupbox4);
    }

    public static MWPanel createPrefsPanel() {
        if (sPrefsPanel != null) {
            sPrefsPanel = null;
        }
        sPrefsPanel = new EditorPrefsKeyboardPanel();
        return sPrefsPanel;
    }

    public static void commitPrefsChanges() {
        if (sPrefsPanel != null) {
            sPrefsPanel.saveOptions();
        }
    }

    private void saveOptions() {
        if (this.fWindowsKeyBindings.getState()) {
            EditorOptions.setKeyBindingScheme(1);
        } else if (this.fEmacsKeyBindings.getState()) {
            EditorOptions.setKeyBindingScheme(2);
        } else if (this.fMacKeyBindings.getState()) {
            EditorOptions.setKeyBindingScheme(3);
        }
        Integer n = new Integer(this.fSpacesPerTabInputField.getText());
        int n2 = Math.max(1, n);
        EditorOptions.setSpacesPerTab(n2);
        Integer n3 = new Integer(this.fSpacesPerIndentInputField.getText());
        n2 = Math.max(1, n3);
        EditorOptions.setSpacesPerIndent(n2);
        if (this.fNoIndent.getState()) {
            EditorOptions.setIndentMode("NoIndent");
        } else if (this.fAutoIndent.getState()) {
            EditorOptions.setIndentMode("BlockIndent");
        } else if (this.fSmartIndent.getState()) {
            EditorOptions.setIndentMode("SmartIndent");
        }
        EditorOptions.setTabChangedToSpaces(this.fChangeTabsToSpaces.getState());
        EditorOptions.setEmacsStyleTab(this.fEmacsStyleTab.getState());
    }
}

