/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.editor;

import com.mathworks.ide.editor.EditorApplication;
import com.mathworks.ide.editor.EditorOptions;
import com.mathworks.ide.editor.VertFlowLayout;
import com.mathworks.ide.prefs.GeneralPrefsColorPanel;
import com.mathworks.ide.prefs.PrefsDialog;
import com.mathworks.ide.widgets.ColorCombobox;
import com.mathworks.ide.widgets.Highlighter;
import com.mathworks.mwt.MWButton;
import com.mathworks.mwt.MWCheckbox;
import com.mathworks.mwt.MWGroupbox;
import com.mathworks.mwt.MWLabel;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.text.MWStyle;
import com.mathworks.widgets.DesktopFontPicker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;

public class EditorPrefsFontPanel
extends MWPanel
implements ActionListener {
    private static EditorPrefsFontPanel sPrefsPanel = null;
    private DesktopFontPicker fFontEditor;
    private ColorCombobox fBackgroundColorCombobox;
    private ColorCombobox fTextColorCombobox;
    private MWCheckbox fSyntaxHighlightingCheckbox;
    private static ResourceBundle sColorNameRes = ResourceBundle.getBundle("com.mathworks.ide.prefs.resources.RES_Prefs");

    public EditorPrefsFontPanel() {
        VertFlowLayout vertFlowLayout = new VertFlowLayout(3, 10, 10);
        vertFlowLayout.setMaximizeHorizontally(true);
        this.fFontEditor = new DesktopFontPicker(EditorOptions.getUseDesktopFont(), EditorOptions.getFont());
        MWGroupbox mWGroupbox = new MWGroupbox(EditorApplication.intlString("pref.font.Font"));
        mWGroupbox.setName("Font");
        mWGroupbox.setLayout(new FlowLayout(0, 0, 0));
        mWGroupbox.add((Component)this.fFontEditor);
        Color[] colorArray = new Color[Highlighter.PALETTE.length];
        String[] stringArray = new String[Highlighter.PALETTE.length];
        int n = 0;
        while (n < Highlighter.PALETTE.length) {
            stringArray[n] = GeneralPrefsColorPanel.getTextForCombo(Highlighter.PALETTE[n]);
            colorArray[n] = GeneralPrefsColorPanel.getColorForCombo(Highlighter.PALETTE[n]);
            ++n;
        }
        MWStyle mWStyle = EditorOptions.getTextColor();
        this.fTextColorCombobox = new ColorCombobox(GeneralPrefsColorPanel.getTextForCombo(mWStyle), GeneralPrefsColorPanel.getColorForCombo(mWStyle), stringArray, colorArray);
        this.fTextColorCombobox.setOpaque(false);
        this.fTextColorCombobox.setSelectionType(2);
        this.fTextColorCombobox.setRestrictWidth(true);
        this.fTextColorCombobox.addActionListener(this);
        MWPanel mWPanel = new MWPanel();
        mWPanel.setLayout(new GridLayout(1, 2, 5, 5));
        mWPanel.add((Component)new MWLabel(EditorApplication.intlString("pref.font.TextColor")));
        mWPanel.add((Component)((Object)this.fTextColorCombobox));
        MWStyle mWStyle2 = EditorOptions.getBackgroundColor();
        this.fBackgroundColorCombobox = new ColorCombobox(GeneralPrefsColorPanel.getTextForCombo(mWStyle2), GeneralPrefsColorPanel.getColorForCombo(mWStyle2), stringArray, colorArray);
        this.fBackgroundColorCombobox.setOpaque(false);
        this.fBackgroundColorCombobox.setSelectionType(2);
        this.fBackgroundColorCombobox.setRestrictWidth(true);
        this.setBackgroundEnabled();
        MWPanel mWPanel2 = new MWPanel();
        mWPanel2.setLayout(new GridLayout(1, 2, 5, 5));
        mWPanel2.add((Component)new MWLabel(EditorApplication.intlString("pref.font.BackgroundColor")));
        mWPanel2.add((Component)((Object)this.fBackgroundColorCombobox));
        this.fSyntaxHighlightingCheckbox = new MWCheckbox(EditorApplication.intlString("pref.font.SyntaxHighlighting"));
        this.fSyntaxHighlightingCheckbox.setName("SyntaxHighlighting");
        this.fSyntaxHighlightingCheckbox.setState(EditorOptions.isSyntaxHighlightingEnabled());
        MWButton mWButton = new MWButton(EditorApplication.intlString("pref.font.SetColors"));
        mWButton.setName("SyntaxButton");
        mWButton.addActionListener((ActionListener)new ButtonListener());
        MWPanel mWPanel3 = new MWPanel((LayoutManager)new FlowLayout(1, 15, 0));
        mWPanel3.add((Component)this.fSyntaxHighlightingCheckbox);
        mWPanel3.add((Component)mWButton);
        mWPanel3.setInsets(new Insets(0, 0, 0, 0));
        MWGroupbox mWGroupbox2 = new MWGroupbox(EditorApplication.intlString("pref.font.Colors"), 0);
        mWGroupbox2.setName("Colors");
        mWGroupbox2.setLayout(vertFlowLayout);
        mWGroupbox2.setInsets(new Insets(0, 0, 0, 0));
        mWGroupbox2.add((Component)mWPanel);
        mWGroupbox2.add((Component)mWPanel2);
        mWGroupbox2.add((Component)mWPanel3);
        ((Container)((Object)this)).setLayout(vertFlowLayout);
        this.setInsets(new Insets(0, 0, 0, 0));
        ((Container)((Object)this)).add((Component)mWGroupbox);
        ((Container)((Object)this)).add((Component)mWGroupbox2);
    }

    public static MWPanel createPrefsPanel() {
        if (sPrefsPanel != null) {
            sPrefsPanel = null;
        }
        sPrefsPanel = new EditorPrefsFontPanel();
        return sPrefsPanel;
    }

    public static void commitPrefsChanges() {
        if (sPrefsPanel != null) {
            sPrefsPanel.saveOptions();
        }
    }

    private void saveOptions() {
        EditorOptions.setUseDesktopFont(this.fFontEditor.getUseDesktopFont());
        EditorOptions.setFont(this.fFontEditor.getSelectedFont());
        EditorOptions.setTextColor(GeneralPrefsColorPanel.getStyleFromCombobox(this.fTextColorCombobox));
        EditorOptions.setBackgroundColor(GeneralPrefsColorPanel.getStyleFromCombobox(this.fBackgroundColorCombobox));
        EditorOptions.setSyntaxHighlightingEnabled(this.fSyntaxHighlightingCheckbox.getState());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.setBackgroundEnabled();
    }

    private void setBackgroundEnabled() {
        if (this.fTextColorCombobox.getSelectedIndex() == 0) {
            this.fBackgroundColorCombobox.setEnabled(false);
            return;
        }
        this.fBackgroundColorCombobox.setEnabled(true);
    }

    private class ButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            PrefsDialog.showPrefsDialog(sColorNameRes.getString("area.general.fontandcolors"));
        }

        ButtonListener() {
            EditorPrefsFontPanel.this = EditorPrefsFontPanel.this;
        }
    }
}

