/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.editor;

import com.mathworks.ide.prefs.GeneralPrefsColorPanel;
import com.mathworks.mwt.text.MWStyle;
import com.mathworks.services.Prefs;
import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;

public class EditorOptions {
    static final String INDENT_MODE = "IndentMode";
    static final String TAB_TO_SPACE = "TabToSpaces";
    static final String EMACS_STYLE_TAB = "EmacsTab";
    static final String SPACES_PER_INDENT = "SpacesPerIndent";
    static final String MOSTRECENTLYUSED = "MRU";
    static final String MRU_SIZE = "MRUSize";
    static final String PRINT_HEADER = "PrintHeader";
    static final String PRINT_STYLE = "PrintStyle";
    static final String PRINT_USEEDITORFONT = "PrintUseEditorFont";
    static final String PRINT_FONT = "PrintFont";
    static final String WINDOWMINMAXSTATE = "MinMaxState";
    static final int WINDOW_RESTORED = 0;
    static final int WINDOW_MAX = 1;
    static final String EXTERNAL = "External";
    static final String DOCKPATH = "DockPath";
    private static final String DEFAULT_PATH = "EN";
    static final String NO_INDENT = "NoIndent";
    static final String AUTO_INDENT = "BlockIndent";
    static final String SMART_INDENT = "SmartIndent";
    private static boolean sTabMode;
    private static boolean sBuiltinEditor;
    private static String sOtherEditor;
    private static boolean sShowToolbar;
    private static boolean sShowLineNumbers;
    private static boolean sDataTips;
    private static boolean sReloadFiles;
    private static boolean sSyntaxHighlightingEnabled;
    private static int sKeyBindingScheme;
    private static MWStyle sBackgroundColor;
    private static MWStyle sTextColor;
    private static Font sFont;
    private static boolean sUseDesktopFont;
    private static boolean sGraphicalDebugging;
    private static int sSpacesPerTab;
    private static int sSpacesPerIndent;
    private static boolean sChangeTabsToSpaces;
    private static String sIndentMode;
    private static boolean sEmacsStyleTab;
    private static int sMRUSize;
    private static boolean sPrintHeader;
    private static int sPrintStyleType;
    static int PRINTSTYLE_BW;
    static int PRINTSTYLE_COLOR;
    static int PRINTSTYLE_STYLED;
    private static Font sPrintFont;
    private static boolean sPrintUseEditorFont;
    private static Rectangle sEditorBounds;
    private static boolean sExternal;
    private static String sDockPath;
    private static int sWindowMinMaxState;
    private static boolean sInlineDebugger;
    private static String sSourceControlSystem;

    public static boolean isPrintHeader() {
        return sPrintHeader;
    }

    public static void setPrintHeader(boolean bl) {
        if (sPrintHeader != bl) {
            sPrintHeader = bl;
            Prefs.setBooleanPref((String)"EditorPrintHeader", (boolean)bl);
        }
    }

    public static int getPrintStyleType() {
        return sPrintStyleType;
    }

    public static void setPrintStyleType(int n) {
        if (sPrintStyleType != n) {
            sPrintStyleType = n;
            Prefs.setIntegerPref((String)"EditorPrintStyle", (int)n);
        }
    }

    public static int getMRUSize() {
        return sMRUSize;
    }

    public static void setMRUSize(int n) {
        if (sMRUSize != n && n >= 0 && n <= 9) {
            sMRUSize = n;
            Prefs.setIntegerPref((String)"EditorMRUSize", (int)n);
        }
    }

    public static boolean isTabMode() {
        return sTabMode;
    }

    public static void setTabMode(boolean bl) {
        if (sTabMode != bl) {
            sTabMode = bl;
            Prefs.setBooleanPref((String)"EditorTabMode", (boolean)sTabMode);
        }
    }

    public static boolean getShowToolbar() {
        return sShowToolbar;
    }

    public static void setShowToolbar(boolean bl) {
        if (sShowToolbar != bl) {
            sShowToolbar = bl;
            Prefs.setBooleanPref((String)"EditorShowToolbar", (boolean)sShowToolbar);
        }
    }

    public static boolean getShowLineNumbers() {
        return sShowLineNumbers;
    }

    public static void setShowLineNumbers(boolean bl) {
        if (sShowLineNumbers != bl) {
            sShowLineNumbers = bl;
            Prefs.setBooleanPref((String)"EditorShowLineNumbers", (boolean)sShowLineNumbers);
        }
    }

    public static String getOtherEditor() {
        return new String(sOtherEditor);
    }

    public static void setOtherEditor(String string) {
        if (sOtherEditor != string) {
            sOtherEditor = string;
            Prefs.setStringPref((String)"EditorOtherEditor", (String)sOtherEditor);
        }
    }

    public static boolean getGraphicalDebugging() {
        return sGraphicalDebugging;
    }

    public static void setGraphicalDebugging(boolean bl) {
        if (sGraphicalDebugging != bl) {
            sGraphicalDebugging = bl;
            Prefs.setBooleanPref((String)"EditorGraphicalDebugging", (boolean)sGraphicalDebugging);
        }
    }

    public static boolean getDataTips() {
        return sDataTips;
    }

    public static void setDataTips(boolean bl) {
        if (sDataTips != bl) {
            sDataTips = bl;
            Prefs.setBooleanPref((String)"EditorEnableDataTips", (boolean)sDataTips);
        }
    }

    public static boolean getReloadFiles() {
        return sReloadFiles;
    }

    public static void setReloadFiles(boolean bl) {
        if (sReloadFiles != bl) {
            sReloadFiles = bl;
            Prefs.setBooleanPref((String)"EditorReloadFiles", (boolean)sReloadFiles);
        }
    }

    public static boolean getBuiltinEditor() {
        return sBuiltinEditor;
    }

    public static void setBuiltinEditor(boolean bl) {
        if (sBuiltinEditor != bl) {
            sBuiltinEditor = bl;
            Prefs.setBooleanPref((String)"EditorBuiltinEditor", (boolean)sBuiltinEditor);
        }
    }

    public static String getSourceControlSystem() {
        return new String(sSourceControlSystem);
    }

    public static void setSourceControlSystem(String string) {
        if (!sSourceControlSystem.equals(string)) {
            sSourceControlSystem = string;
            Prefs.setStringPref((String)"EditorSourceControlSystem", (String)sSourceControlSystem);
        }
    }

    public static int getSpacesPerTab() {
        return sSpacesPerTab;
    }

    public static void setSpacesPerTab(int n) {
        if (sSpacesPerTab != n) {
            sSpacesPerTab = n;
            Prefs.setIntegerPref((String)"EditorSpacesPerTab", (int)sSpacesPerTab);
        }
    }

    public static int getSpacesPerIndent() {
        return sSpacesPerIndent;
    }

    public static void setSpacesPerIndent(int n) {
        if (sSpacesPerIndent != n) {
            sSpacesPerIndent = n;
            Prefs.setIntegerPref((String)"EditorSpacesPerIndent", (int)sSpacesPerIndent);
        }
    }

    public static String getIndentMode() {
        return new String(sIndentMode);
    }

    public static void setIndentMode(String string) {
        if (sIndentMode != string) {
            sIndentMode = string;
            Prefs.setStringPref((String)"EditorIndentMode", (String)sIndentMode);
        }
    }

    public static boolean isTabChangedToSpaces() {
        return sChangeTabsToSpaces;
    }

    public static void setTabChangedToSpaces(boolean bl) {
        if (sChangeTabsToSpaces != bl) {
            sChangeTabsToSpaces = bl;
            Prefs.setBooleanPref((String)"EditorTabToSpaces", (boolean)sChangeTabsToSpaces);
        }
    }

    public static boolean isEmacsStyleTab() {
        return sEmacsStyleTab;
    }

    public static void setEmacsStyleTab(boolean bl) {
        if (sEmacsStyleTab != bl) {
            sEmacsStyleTab = bl;
            Prefs.setBooleanPref((String)"EditorEmacsTab", (boolean)sEmacsStyleTab);
        }
    }

    public static Font getFont() {
        return sFont;
    }

    public static Font getEditorFont() {
        if (sUseDesktopFont) {
            return GeneralPrefsColorPanel.getDesktopFont();
        }
        return sFont;
    }

    public static void setFont(Font font) {
        if (!sFont.equals(font)) {
            sFont = font;
            Prefs.setFontPref((String)"EditorFont", (Font)sFont);
        }
    }

    static Font getDefaultPrintFont() {
        return sPrintFont;
    }

    public static Font getPrintFont() {
        if (sPrintUseEditorFont) {
            return sFont;
        }
        return sPrintFont;
    }

    public static void setPrintFont(Font font) {
        if (!sPrintFont.equals(font)) {
            sPrintFont = font;
            Prefs.setFontPref((String)"EditorPrintFont", (Font)sPrintFont);
        }
    }

    public static MWStyle getBackgroundColor() {
        return sBackgroundColor;
    }

    public static void setBackgroundColor(MWStyle mWStyle) {
        if (!sBackgroundColor.equals((Object)mWStyle)) {
            sBackgroundColor = mWStyle;
            Prefs.setStringPref((String)"EditorBackgroundColor", (String)GeneralPrefsColorPanel.getColorString(mWStyle));
        }
    }

    public static MWStyle getTextColor() {
        return sTextColor;
    }

    public static void setTextColor(MWStyle mWStyle) {
        if (!sTextColor.equals((Object)mWStyle)) {
            sTextColor = mWStyle;
            Prefs.setStringPref((String)"EditorTextColor", (String)GeneralPrefsColorPanel.getColorString(mWStyle));
        }
    }

    public static boolean getUseDesktopFont() {
        return sUseDesktopFont;
    }

    public static void setUseDesktopFont(boolean bl) {
        if (sUseDesktopFont != bl) {
            sUseDesktopFont = bl;
            Prefs.setBooleanPref((String)"EditorUseDesktopFont", (boolean)sUseDesktopFont);
        }
    }

    public static boolean getUseEditorFont() {
        return sPrintUseEditorFont;
    }

    public static void setUseEditorFont(boolean bl) {
        if (sPrintUseEditorFont != bl) {
            sPrintUseEditorFont = bl;
            Prefs.setBooleanPref((String)"EditorPrintUseEditorFont", (boolean)sPrintUseEditorFont);
        }
    }

    public static boolean isInlineDebugger() {
        return true;
    }

    public static void setInlineDebugger(boolean bl) {
        if (sInlineDebugger != bl) {
            sInlineDebugger = bl;
            sInlineDebugger = true;
            Prefs.setBooleanPref((String)"EditorInlineDebugger", (boolean)sInlineDebugger);
        }
    }

    public static boolean isSyntaxHighlightingEnabled() {
        return sSyntaxHighlightingEnabled;
    }

    public static void setSyntaxHighlightingEnabled(boolean bl) {
        if (sSyntaxHighlightingEnabled != bl) {
            sSyntaxHighlightingEnabled = bl;
            Prefs.setBooleanPref((String)"EditorSyntaxHighlighting", (boolean)sSyntaxHighlightingEnabled);
        }
    }

    public static void setKeyBindingScheme(int n) {
        if (sKeyBindingScheme != n) {
            sKeyBindingScheme = n;
            Prefs.setIntegerPref((String)"EditorKeyBindingScheme", (int)sKeyBindingScheme);
        }
    }

    public static int getKeyBindingScheme() {
        return sKeyBindingScheme;
    }

    public static void setEditorWindowBounds(Rectangle rectangle) {
        sEditorBounds = rectangle;
        if (rectangle == null) {
            return;
        }
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            return;
        }
        Prefs.setRectanglePref((String)"EditorSaveWindowPos", (Rectangle)sEditorBounds);
    }

    public static Rectangle getEditorWindowBounds() {
        return new Rectangle(sEditorBounds);
    }

    static void setEditorWindowMinMaxState(int n) {
        if (sWindowMinMaxState != n) {
            sWindowMinMaxState = n;
            Prefs.setIntegerPref((String)"EditorMinMaxState", (int)n);
        }
    }

    static int getEditorWindowMinMaxState() {
        return sWindowMinMaxState;
    }

    static String getDockPath() {
        return new String(sDockPath);
    }

    static void setDockPath(String string) {
        if (string != null && string.length() > 0) {
            Prefs.setStringPref((String)"EditorDockPath", (String)string);
            sDockPath = string;
            return;
        }
        Prefs.setStringPref((String)"EditorDockPath", (String)DEFAULT_PATH);
        sDockPath = DEFAULT_PATH;
    }

    static boolean isExternal() {
        return sExternal;
    }

    static void setExternal(boolean bl) {
        Prefs.setBooleanPref((String)"EditorExternal", (boolean)bl);
        sExternal = bl;
    }

    static {
        PRINTSTYLE_BW = 1;
        PRINTSTYLE_COLOR = 2;
        PRINTSTYLE_STYLED = 3;
        if (PlatformInfo.isMicrosoftVM()) {
            sFont = new Font("Courier", 0, 12);
            sPrintFont = new Font("Courier", 0, 12);
        } else {
            sFont = new Font("Monospaced", 0, 12);
            sPrintFont = new Font("Monospaced", 0, 12);
        }
        sKeyBindingScheme = PlatformInfo.isUnix() ? 2 : (PlatformInfo.isWindows() ? 1 : 3);
        sEditorBounds = Prefs.getRectanglePref((String)"EditorSaveWindowPos");
        if (sEditorBounds == null || !(sEditorBounds instanceof Rectangle) || EditorOptions.sEditorBounds.width <= 0 || EditorOptions.sEditorBounds.height <= 0) {
            sEditorBounds = PlatformInfo.isUnix() ? new Rectangle(0, 0, 685, 480) : (PlatformInfo.isWindows() ? new Rectangle(0, 0, 657, 470) : new Rectangle(0, 0, 657, 470));
        }
        sWindowMinMaxState = Prefs.getIntegerPref((String)"EditorMinMaxState", (int)0);
        sExternal = Prefs.getBooleanPref((String)"EditorExternal", (boolean)true);
        sDockPath = Prefs.getStringPref((String)"EditorDockPath", (String)DEFAULT_PATH);
        sBackgroundColor = new MWStyle(Color.white);
        sTextColor = new MWStyle(true);
        sBuiltinEditor = Prefs.getBooleanPref((String)"EditorBuiltinEditor", (boolean)true);
        sOtherEditor = Prefs.getStringPref((String)"EditorOtherEditor", (String)"");
        sTabMode = Prefs.getBooleanPref((String)"EditorTabMode", (boolean)true);
        sInlineDebugger = Prefs.getBooleanPref((String)"EditorInlineDebugger", (boolean)true);
        sSourceControlSystem = Prefs.getStringPref((String)"EditorSourceControlSystem", (String)"None");
        sShowToolbar = Prefs.getBooleanPref((String)"EditorShowToolbar", (boolean)true);
        sShowLineNumbers = Prefs.getBooleanPref((String)"EditorShowLineNumbers", (boolean)true);
        sGraphicalDebugging = Prefs.getBooleanPref((String)"EditorGraphicalDebugging", (boolean)true);
        sDataTips = Prefs.getBooleanPref((String)"EditorEnableDataTips", (boolean)true);
        sReloadFiles = Prefs.getBooleanPref((String)"EditorReloadFiles", (boolean)true);
        sSyntaxHighlightingEnabled = Prefs.getBooleanPref((String)"EditorSyntaxHighlighting", (boolean)true);
        sKeyBindingScheme = Prefs.getIntegerPref((String)"EditorKeyBindingScheme", (int)sKeyBindingScheme);
        sSpacesPerTab = Prefs.getIntegerPref((String)"EditorSpacesPerTab", (int)4);
        sSpacesPerIndent = Prefs.getIntegerPref((String)"EditorSpacesPerIndent", (int)4);
        sChangeTabsToSpaces = Prefs.getBooleanPref((String)"EditorTabToSpaces", (boolean)true);
        sIndentMode = Prefs.getStringPref((String)"EditorIndentMode", (String)SMART_INDENT);
        sEmacsStyleTab = Prefs.getBooleanPref((String)"EditorEmacsTab", (boolean)false);
        sUseDesktopFont = Prefs.getBooleanPref((String)"EditorUseDesktopFont", (boolean)true);
        sPrintUseEditorFont = Prefs.getBooleanPref((String)"EditorPrintUseEditorFont", (boolean)true);
        sFont = Prefs.getFontPref((String)"EditorFont", (Font)sFont);
        sPrintFont = Prefs.getFontPref((String)"EditorPrintFont", (Font)sPrintFont);
        sBackgroundColor = GeneralPrefsColorPanel.getStyleFromString(Prefs.getStringPref((String)"EditorBackgroundColor", (String)GeneralPrefsColorPanel.getColorString(sBackgroundColor)));
        sTextColor = GeneralPrefsColorPanel.getStyleFromString(Prefs.getStringPref((String)"EditorTextColor", (String)GeneralPrefsColorPanel.getColorString(sTextColor)));
        sMRUSize = Prefs.getIntegerPref((String)"EditorMRUSize", (int)4);
        sPrintHeader = Prefs.getBooleanPref((String)"EditorPrintHeader", (boolean)true);
        sPrintStyleType = Prefs.getIntegerPref((String)"EditorPrintStyle", (int)PRINTSTYLE_BW);
    }
}

