/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.editor;

import com.mathworks.ide.desktop.DTMenu;
import com.mathworks.ide.desktop.DTMenuBar;
import com.mathworks.ide.desktop.MenuUtils;
import com.mathworks.ide.editor.EditorApplication;
import com.mathworks.ide.editor.EditorCommand;
import com.mathworks.ide.editor.EditorOptions;
import com.mathworks.ide.editor.EditorViewContainer;
import com.mathworks.mwt.MWCheckboxMenuItem;
import com.mathworks.mwt.MWFrameProxy;
import com.mathworks.mwt.MWMenu;
import com.mathworks.mwt.MWMenuBar;
import com.mathworks.mwt.MWMenuComponent;
import com.mathworks.mwt.MWMenuItem;
import com.mathworks.mwt.MWUtils;
import com.mathworks.mwt.command.MWCommandCenter;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class EditorMenubar
extends MWMenuBar {
    private static ResourceBundle sRes;
    private MWMenuBar fMenubar;
    private DTMenu fSourceControlMenu;
    private DTMenu fTextMenu;
    private DTMenu fDebugMenu;
    private DTMenu fBreakpointMenu;
    private boolean fIsDebugger;
    private boolean fIsInlineDebugger;
    private boolean fIsTabMode;
    private MWCommandCenter fCommandCenter;
    private EditorViewContainer fEditorContainer;
    private MWCheckboxMenuItem fShowToolbarMenuItem;
    private MWCheckboxMenuItem fShowLineNumbersMenuItem;
    private MWCheckboxMenuItem fStopIfErrorMenuItem;
    private MWCheckboxMenuItem fStopIfWarningMenuItem;
    private MWCheckboxMenuItem fStopIfNanInfMenuItem;
    private MWMenuItem fRunMenuItem;
    private MWMenuItem fCloseMenuItem;

    EditorMenubar(MWFrameProxy mWFrameProxy, EditorViewContainer editorViewContainer, boolean bl, boolean bl2, boolean bl3) {
        super(editorViewContainer.getCommandCenter());
        sRes = EditorApplication.getSRes();
        this.fIsDebugger = bl;
        this.fIsInlineDebugger = bl3;
        this.fIsTabMode = bl2;
        this.fEditorContainer = editorViewContainer;
        this.fCommandCenter = editorViewContainer.getCommandCenter();
        DTMenuBar dTMenuBar = DTMenuBar.createComponentMenubar(mWFrameProxy);
        this.fMenubar = dTMenuBar.getMenubar();
        this.createSourceControlMenu();
        this.fTextMenu = new DTMenu(sRes.getString("menu.Text"), this.fCommandCenter);
        this.setupTextMenu(this.fTextMenu);
        if (this.fIsInlineDebugger || this.fIsDebugger) {
            this.fDebugMenu = new DTMenu(sRes.getString("menu.Debug"), this.fCommandCenter);
            this.setupDebugMenu(this.fDebugMenu);
        }
        this.fBreakpointMenu = new DTMenu(sRes.getString("menu.Breakpoints"), this.fCommandCenter);
        this.setupBreakpointsMenu(this.fBreakpointMenu);
        this.fMenubar = this.mergeMenus(this.fMenubar);
        dTMenuBar.autoAddSeparators();
    }

    public MWMenuBar getMenubar() {
        return this.fMenubar;
    }

    private void createSourceControlMenu() {
        this.fSourceControlMenu = new DTMenu(sRes.getString("menu.SourceControl"), this.fCommandCenter);
        this.addMenuItem(this.fSourceControlMenu, 400);
        this.addMenuItem(this.fSourceControlMenu, 401);
        this.addMenuItem(this.fSourceControlMenu, 402);
        this.fSourceControlMenu.addSeparator();
        this.addMenuItem(this.fSourceControlMenu, 403);
    }

    private void setupTextMenu(DTMenu dTMenu) {
        if (!this.fIsDebugger) {
            this.addMenuItem(dTMenu, 1300);
            this.addMenuItem(dTMenu, 1301);
            this.addMenuItem(dTMenu, 1400);
            this.addMenuItem(dTMenu, 1401);
            this.addMenuItem(dTMenu, 1500);
            this.addMenuItem(dTMenu, 1501);
        }
        this.addMenuItem(dTMenu, 1502);
    }

    private void setupDebugMenu(DTMenu dTMenu) {
        this.fRunMenuItem = this.addMenuItem(dTMenu, 1603);
        this.addMenuItem(dTMenu, 1600);
        this.addMenuItem(dTMenu, 1601);
        this.addMenuItem(dTMenu, 1602);
        this.addMenuItem(dTMenu, 1650);
        this.addMenuItem(dTMenu, 1651);
    }

    private void setupBreakpointsMenu(DTMenu dTMenu) {
        this.addMenuItem(dTMenu, 1700);
        this.addMenuItem(dTMenu, 1701);
        if (this.fStopIfErrorMenuItem == null) {
            this.fStopIfErrorMenuItem = this.addCheckboxMenuItem(dTMenu, 1800);
            this.fStopIfWarningMenuItem = this.addCheckboxMenuItem(dTMenu, 1801);
            this.fStopIfNanInfMenuItem = this.addCheckboxMenuItem(dTMenu, 1802);
        }
    }

    public MWCheckboxMenuItem getShowToolbarMenuItem() {
        return this.fShowToolbarMenuItem;
    }

    public MWCheckboxMenuItem getShowLineNumbersMenuItem() {
        return this.fShowLineNumbersMenuItem;
    }

    public MWCheckboxMenuItem getStopIfErrorMenuItem() {
        return this.fStopIfErrorMenuItem;
    }

    public MWCheckboxMenuItem getStopIfWarningMenuItem() {
        return this.fStopIfWarningMenuItem;
    }

    public MWCheckboxMenuItem getStopIfNanInfMenuItem() {
        return this.fStopIfNanInfMenuItem;
    }

    public void modifyShortcutsInMenubar() {
        int n = 0;
        while (n < this.fMenubar.getMenuCount()) {
            this.redoShortcuts(this.fMenubar.getMenu(n));
            ++n;
        }
    }

    private void redoShortcuts(MWMenu mWMenu) {
        this.checkMenuMneumonic(mWMenu);
        int n = mWMenu.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            MWMenuComponent mWMenuComponent = mWMenu.getItem(n2);
            if (mWMenuComponent instanceof MWMenuItem) {
                MWMenuItem mWMenuItem = (MWMenuItem)mWMenuComponent;
                int n3 = mWMenuItem.getCommand();
                String string = this.getMenuLabel(n3);
                if (!string.equals("")) {
                    mWMenuItem.setLabel(string);
                    mWMenuItem.setKey(EditorCommand.getKbdAcc(n3));
                }
            } else if (mWMenuComponent instanceof MWMenu) {
                this.redoShortcuts((MWMenu)mWMenuComponent);
            }
            ++n2;
        }
    }

    private void checkMenuMneumonic(MWMenu mWMenu) {
        if (EditorOptions.getKeyBindingScheme() == 2 && mWMenu.getLabel().equals(sRes.getString("menuitem.Window.windows"))) {
            mWMenu.setLabel(sRes.getString("menuitem.Window.emacs"));
        }
    }

    private String getMenuLabel(int n) {
        switch (n) {
            case 100: {
                return sRes.getString("menuitem.File.Mfile");
            }
            case 130: {
                return sRes.getString("menuitem.File.Open");
            }
            case 132: {
                return sRes.getString("menuitem.File.OpenSelection");
            }
            case 135: {
                return sRes.getString("menuitem.File.CloseFile");
            }
            case 701: {
                return sRes.getString("menuitem.File.Exit");
            }
            case 350: {
                return sRes.getString("menuitem.File.Save");
            }
            case 351: {
                return sRes.getString("menuitem.File.SaveAs");
            }
            case 352: {
                return sRes.getString("menuitem.File.SaveAll");
            }
            case 400: {
                return sRes.getString("menuitem.File.SCCheckIn");
            }
            case 401: {
                return sRes.getString("menuitem.File.SCCheckOut");
            }
            case 402: {
                return sRes.getString("menuitem.File.SCUndoCheckOut");
            }
            case 403: {
                return sRes.getString("menuitem.File.SCPreferences");
            }
            case 550: {
                return DTMenuBar.getMenuLabel(550);
            }
            case 560: {
                return DTMenuBar.getMenuLabel(560);
            }
            case 510: {
                return sRes.getString("menuitem.File.Preferences");
            }
            case 800: {
                return DTMenuBar.getMenuLabel(800);
            }
            case 810: {
                return DTMenuBar.getMenuLabel(810);
            }
            case 900: {
                return DTMenuBar.getMenuLabel(900);
            }
            case 910: {
                return DTMenuBar.getMenuLabel(910);
            }
            case 920: {
                return DTMenuBar.getMenuLabel(920);
            }
            case 1050: {
                return sRes.getString("menuitem.Edit.Clear");
            }
            case 1060: {
                return DTMenuBar.getMenuLabel(1060);
            }
            case 1101: {
                return sRes.getString("menuitem.Edit.Find");
            }
            case 1100: {
                return sRes.getString("menuitem.Edit.FindAndReplace");
            }
            case 1102: {
                return sRes.getString("menuitem.Edit.FindNext");
            }
            case 1103: {
                return sRes.getString("menuitem.Edit.FindSelection");
            }
            case 1200: {
                return sRes.getString("menuitem.Edit.GoToLine");
            }
            case 1300: {
                return sRes.getString("menuitem.Text.Comment");
            }
            case 1301: {
                return sRes.getString("menuitem.Text.Uncomment");
            }
            case 1400: {
                return sRes.getString("menuitem.Text.DecreaseIndent");
            }
            case 1401: {
                return sRes.getString("menuitem.Text.IncreaseIndent");
            }
            case 1500: {
                return sRes.getString("menuitem.Text.BalanceDelimiters");
            }
            case 1501: {
                return sRes.getString("menuitem.Text.SmartIndent");
            }
            case 1502: {
                return sRes.getString("menuitem.Text.EvaluateSelection");
            }
            case 1600: {
                return sRes.getString("menuitem.Debug.Step");
            }
            case 1601: {
                return sRes.getString("menuitem.Debug.StepIn");
            }
            case 1602: {
                return sRes.getString("menuitem.Debug.StepOut");
            }
            case 1603: {
                return this.getRunMenuLabel(false);
            }
            case 1650: {
                return sRes.getString("menuitem.Debug.GoUntilCursor");
            }
            case 1651: {
                return sRes.getString("menuitem.Debug.ExitDebugMode");
            }
            case 1700: {
                return sRes.getString("menuitem.Breakpoints.SetClearBreakpoint");
            }
            case 1701: {
                return sRes.getString("menuitem.Breakpoints.ClearAllBreakpoints");
            }
            case 1800: {
                return sRes.getString("menuitem.Breakpoints.StopIfError");
            }
            case 1801: {
                return sRes.getString("menuitem.Breakpoints.StopIfWarning");
            }
            case 1802: {
                return sRes.getString("menuitem.Breakpoints.StopIfNaNOrInf");
            }
        }
        return "";
    }

    String getRunMenuLabel(boolean bl) {
        String string = EditorApplication.getInDebugMode() ? sRes.getString("menuitem.Debug.Continue") : (this.fEditorContainer.isDirty() ? sRes.getString("menuitem.Debug.SaveandRun") : sRes.getString("menuitem.Debug.Run"));
        if (bl) {
            string = MWUtils.stripMenuItemLabel((String)string);
        }
        return string;
    }

    void setRunMenuLabel() {
        String string = this.getRunMenuLabel(false);
        this.fRunMenuItem.setLabel(string);
    }

    void setCloseMenuLabel() {
        Object[] objectArray = new Object[]{this.fEditorContainer.getShortName()};
        String string = MessageFormat.format(sRes.getString("menuitem.File.CloseThisFile"), objectArray);
        this.fCloseMenuItem.setLabel(string);
    }

    private MWCheckboxMenuItem addCheckboxMenuItem(MWMenu mWMenu, int n) {
        MWCheckboxMenuItem mWCheckboxMenuItem = MenuUtils.addCheckboxMenuItem(this.fCommandCenter, mWMenu, this.getMenuLabel(n), n);
        return mWCheckboxMenuItem;
    }

    private MWMenuItem addMenuItem(DTMenu dTMenu, int n) {
        return dTMenu.addMenuItem(this.fCommandCenter, this.getMenuLabel(n), n, EditorCommand.getKbdAcc(n));
    }

    private MWMenuItem addCloseMenuItem(DTMenu dTMenu, int n) {
        Object[] objectArray = new Object[]{this.fEditorContainer.getShortName()};
        String string = MessageFormat.format(sRes.getString("menuitem.File.CloseThisFile"), objectArray);
        this.fCloseMenuItem = dTMenu.addMenuItem(this.fCommandCenter, string, n, EditorCommand.getKbdAcc(n));
        return this.fCloseMenuItem;
    }

    private MWMenuItem addQuitMenuItem(DTMenu dTMenu, int n) {
        return dTMenu.addMenuItem(this.fCommandCenter, this.getMenuLabel(n), n, EditorCommand.getKbdAcc(n));
    }

    public MWMenuBar mergeMenus(MWMenuBar mWMenuBar) {
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n < mWMenuBar.getMenuCount()) {
            MWMenu mWMenu = mWMenuBar.getMenu(n);
            this.checkMenuMneumonic(mWMenu);
            if (mWMenu instanceof DTMenu) {
                DTMenu dTMenu = (DTMenu)mWMenu;
                if (dTMenu.getLabel().equals(DTMenuBar.sRes.getString("menu.File")) || dTMenu.getLabel().equals(DTMenuBar.sRes.getString("menu.FileNoAmpersand"))) {
                    MWMenuComponent mWMenuComponent = dTMenu.getItem(0);
                    if (mWMenuComponent instanceof MWMenu) {
                        this.redoShortcuts((MWMenu)mWMenuComponent);
                    }
                    this.addMenuItem(dTMenu, 130);
                    this.addCloseMenuItem(dTMenu, 135);
                    this.addMenuItem(dTMenu, 132);
                    this.addMenuItem(dTMenu, 350);
                    this.addMenuItem(dTMenu, 351);
                    this.addMenuItem(dTMenu, 352);
                    this.addMenuItem(dTMenu, 550);
                    this.addMenuItem(dTMenu, 560);
                    this.addMenuItem(dTMenu, 510);
                    if (EditorApplication.isStandalone()) {
                        this.addQuitMenuItem(dTMenu, 701);
                    }
                    if (!EditorApplication.isStandalone()) {
                        dTMenu.addMenuItem(DTMenuBar.getMenuLabel(460), 460, -1);
                    }
                    int n2 = 0;
                    while (n2 < dTMenu.getItemCount()) {
                        if (dTMenu.getItem(n2).getLabel().equals(sRes.getString("menu.SourceControl"))) {
                            dTMenu.remove(n2);
                            if (!dTMenu.getItem(n2).getLabel().equals("-")) break;
                            dTMenu.remove(n2);
                            break;
                        }
                        ++n2;
                    }
                    dTMenu.addMenu(this.fSourceControlMenu);
                } else if (dTMenu.getLabel().equals(DTMenuBar.sRes.getString("menu.Edit")) || dTMenu.getLabel().equals(DTMenuBar.sRes.getString("menu.EditNoAmpersand"))) {
                    this.addMenuItem(dTMenu, 800);
                    this.addMenuItem(dTMenu, 810);
                    this.addMenuItem(dTMenu, 900);
                    this.addMenuItem(dTMenu, 910);
                    this.addMenuItem(dTMenu, 920);
                    this.addMenuItem(dTMenu, 1060);
                    this.addMenuItem(dTMenu, 1050);
                    if (this.fIsDebugger) {
                        this.addMenuItem(dTMenu, 1101);
                    } else {
                        this.addMenuItem(dTMenu, 1100);
                    }
                    this.addMenuItem(dTMenu, 1102);
                    this.addMenuItem(dTMenu, 1103);
                    this.addMenuItem(dTMenu, 1200);
                } else if (dTMenu.getLabel().equals(sRes.getString("menu.Text")) || dTMenu.getLabel().equals(sRes.getString("menu.TextNoAmpersand"))) {
                    this.setupTextMenu(dTMenu);
                    bl = true;
                } else if (dTMenu.getLabel().equals(DTMenuBar.sRes.getString("menu.View")) || dTMenu.getLabel().equals(DTMenuBar.sRes.getString("menu.ViewNoAmpersand"))) {
                    bl2 = true;
                } else if (dTMenu.getLabel().equals(sRes.getString("menu.Debug")) || dTMenu.getLabel().equals(sRes.getString("menu.DebugNoAmpersand"))) {
                    this.setupDebugMenu(dTMenu);
                } else if (dTMenu.getLabel().equals(sRes.getString("menu.Breakpoints")) || dTMenu.getLabel().equals(sRes.getString("menu.BreakpointsNoAmpersand"))) {
                    this.setupBreakpointsMenu(dTMenu);
                } else if ((dTMenu.getLabel().equals(DTMenuBar.sRes.getString("menu.Help")) || dTMenu.getLabel().equals(DTMenuBar.sRes.getString("menu.HelpNoAmpersand"))) && !EditorApplication.isStandalone()) {
                    dTMenu.addMenuItem(this.fCommandCenter, sRes.getString("menuitem.Help.UsingtheMfileEditor"), 4051);
                }
            }
            ++n;
        }
        if (!bl) {
            int n3 = 2;
            if (bl2) {
                n3 = 3;
            }
            mWMenuBar.insert((MWMenuComponent)this.fTextMenu, n3++);
            if (!EditorApplication.isStandalone()) {
                if (this.fIsInlineDebugger || this.fIsDebugger) {
                    mWMenuBar.insert((MWMenuComponent)this.fDebugMenu, n3++);
                }
                mWMenuBar.insert((MWMenuComponent)this.fBreakpointMenu, n3);
            }
        }
        this.fMenubar = mWMenuBar;
        return mWMenuBar;
    }
}

