/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.editor;

import com.mathworks.ide.desktop.DTExternalFrame;
import com.mathworks.ide.desktop.DTMenu;
import com.mathworks.ide.editor.EditorApplication;
import com.mathworks.ide.editor.EditorOptions;
import com.mathworks.mwt.MWMenu;
import com.mathworks.mwt.MWMenuBar;
import com.mathworks.mwt.MWMenuComponent;
import com.mathworks.mwt.MWMenuItem;
import com.mathworks.mwt.command.MWCommandAdapter;
import com.mathworks.mwt.command.MWCommandCenter;
import com.mathworks.mwt.command.MWCommandSource;
import com.mathworks.mwt.command.MWCommandTarget;
import com.mathworks.mwt.window.FullWindowRegistry;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import com.mathworks.util.PlatformInfo;
import java.awt.Window;
import java.util.Enumeration;
import java.util.Vector;

public class EditorMRUFiles
extends MWCommandAdapter {
    private static final int MAX_MRU = 9;
    private static int sNFilesSaved = 4;
    private static Vector sFileNames;
    private static EditorMRUFiles sMe;
    private static PrefListener sPrefListener;
    private static String sFileSep;

    EditorMRUFiles() {
        if (sMe != null) {
            return;
        }
        sFileNames = new Vector(10);
        MWCommandCenter mWCommandCenter = new MWCommandCenter((MWCommandTarget)this);
        this.setCommandCenter(mWCommandCenter);
        sNFilesSaved = EditorOptions.getMRUSize();
        sPrefListener = new MRUPrefListener();
        Prefs.addListener((PrefListener)sPrefListener, (String)"EditorMRUSize");
        int n = 0;
        while (n < 9) {
            Integer n2 = new Integer(n + 1);
            String string = Prefs.getStringPref((String)("EditorMRU" + n2.toString()), (String)"");
            if (string != null && !string.equals("")) {
                sFileNames.addElement(string);
            }
            ++n;
        }
    }

    static void setNum(int n) {
        if (n < 0 || n > 9) {
            n = 4;
        }
        sNFilesSaved = n;
        EditorOptions.setMRUSize(sNFilesSaved);
    }

    static int getNum() {
        return sNFilesSaved;
    }

    static void addItem(String string) {
        if (sNFilesSaved <= 0 || string == null || string.equals("")) {
            return;
        }
        int n = 0;
        while (n < sFileNames.size()) {
            String string2 = (String)sFileNames.elementAt(n);
            boolean bl = false;
            bl = PlatformInfo.getPlatform() != 2 ? string2.equalsIgnoreCase(string) : string2.equals(string);
            if (bl) {
                sFileNames.removeElementAt(n);
            }
            ++n;
        }
        sFileNames.insertElementAt(string, 0);
        if (sFileNames.size() > sNFilesSaved) {
            sFileNames.removeElementAt(sNFilesSaved);
        }
        EditorMRUFiles.serializeMRUList();
        EditorMRUFiles.updateAllFileMenus();
    }

    private static int filePart(String string) {
        int n = string.length();
        int n2 = string.lastIndexOf(sFileSep);
        if (n2 != -1) {
            n = string.substring(n2 + 1).length();
        }
        return n;
    }

    private static String createMenuString(String string, int n) {
        int n2 = 6;
        if (PlatformInfo.isWindows()) {
            n2 = 3;
        }
        int n3 = Math.max(25, EditorMRUFiles.filePart(string) + n2 + 3);
        String string2 = string.length() > n3 ? String.valueOf(string.substring(0, n2)) + "..." + string.substring(string.length() - n3 + n2 + 3) : string;
        String string3 = "&" + Integer.toString(n) + " " + string2;
        return string3;
    }

    private static void updateAllFileMenus() {
        Enumeration enumeration = FullWindowRegistry.windows();
        while (enumeration.hasMoreElements()) {
            MWMenu mWMenu;
            Window window = (Window)enumeration.nextElement();
            if (!(window instanceof DTExternalFrame)) continue;
            DTExternalFrame dTExternalFrame = (DTExternalFrame)((Object)window);
            boolean bl = false;
            MWMenuBar mWMenuBar = dTExternalFrame.getMWMenuBar();
            if (mWMenuBar == null || (mWMenu = mWMenuBar.getMenu(0)) == null) continue;
            int n = mWMenu.getItemCount();
            int n2 = 0;
            while (n2 < n) {
                if (mWMenu.getItem(n2).getLabel().startsWith("&1")) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) continue;
            int n3 = 1;
            MWMenuComponent mWMenuComponent = mWMenu.getItem(n2);
            while (mWMenuComponent.getLabel().startsWith("&" + Integer.toString(n3))) {
                mWMenu.remove(n2);
                if (n2 >= --n) break;
                ++n3;
                mWMenuComponent = mWMenu.getItem(n2);
            }
            n3 = sFileNames.size();
            int n4 = 600 + n3 - 1;
            int n5 = n3 - 1;
            while (n5 >= 0) {
                String string = EditorMRUFiles.createMenuString((String)sFileNames.elementAt(n5), n3);
                MWMenuItem mWMenuItem = new MWMenuItem(string);
                sMe.getCommandCenter().addCommandSource((MWCommandSource)mWMenuItem, n4);
                mWMenu.insert((MWMenuComponent)mWMenuItem, n2);
                --n4;
                --n3;
                --n5;
            }
        }
    }

    private static void serializeMRUList() {
        Integer n;
        int n2 = 0;
        while (n2 < sFileNames.size()) {
            n = new Integer(n2 + 1);
            Prefs.setStringPref((String)("EditorMRU" + n.toString()), (String)((String)sFileNames.elementAt(n2)));
            ++n2;
        }
        int n3 = n2;
        while (n3 < 9) {
            n = new Integer(n3 + 1);
            Prefs.setStringPref((String)("EditorMRU" + n.toString()), (String)"");
            ++n3;
        }
    }

    static String getItem(int n) {
        String string = null;
        if (n >= 1 && n <= sFileNames.size()) {
            string = (String)sFileNames.elementAt(n - 1);
        }
        return string;
    }

    private static void addMenuItems(DTMenu dTMenu) {
        int n = 600;
        int n2 = 1;
        while (n2 <= sFileNames.size()) {
            new Integer(n2);
            String string = EditorMRUFiles.createMenuString((String)sFileNames.elementAt(n2 - 1), n2);
            dTMenu.addMenuItem(sMe.getCommandCenter(), string, n, -1);
            ++n;
            ++n2;
        }
    }

    public static void addToMenu(DTMenu dTMenu) {
        if (sFileNames.size() > 0) {
            EditorMRUFiles.addMenuItems(dTMenu);
        }
    }

    public void doCommand(int n) {
        switch (n) {
            case 600: 
            case 601: 
            case 602: 
            case 603: 
            case 604: 
            case 605: 
            case 606: 
            case 607: 
            case 608: {
                int n2 = n - 600;
                String string = EditorMRUFiles.getItem(n2 + 1);
                if (string == null) break;
                if (EditorApplication.isStandalone()) {
                    EditorApplication.openDocument(string);
                    return;
                }
                if (EditorOptions.getBuiltinEditor()) {
                    EditorApplication.openDocument(string);
                    return;
                }
                String string2 = "edit " + string;
                EditorApplication.getMatlab().evalConsoleOutput(string2);
                return;
            }
            default: {
                super.doCommand(n);
            }
        }
    }

    public boolean isCommandEnabled(int n) {
        switch (n) {
            case 600: 
            case 601: 
            case 602: 
            case 603: 
            case 604: 
            case 605: 
            case 606: 
            case 607: 
            case 608: {
                return true;
            }
        }
        return super.isCommandEnabled(n);
    }

    static /* synthetic */ int access$0() {
        return sNFilesSaved;
    }

    static {
        sFileSep = System.getProperty("file.separator");
        sMe = new EditorMRUFiles();
    }

    private class MRUPrefListener
    implements PrefListener {
        public void prefChanged(PrefEvent prefEvent) {
            String string = prefEvent.getPrefKey();
            if (string.equals("EditorMRUSize")) {
                sNFilesSaved = EditorOptions.getMRUSize();
            }
        }

        MRUPrefListener() {
            EditorMRUFiles.this = EditorMRUFiles.this;
        }
    }
}

