/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.editor;

import com.mathworks.ide.editor.EditorApplication;
import com.mathworks.ide.editor.EditorDocument;
import com.mathworks.ide.editor.EditorMRUFiles;
import com.mathworks.ide.editor.EditorView;
import com.mathworks.ide.editor.EditorViewContainer;
import com.mathworks.ide.widgets.MFilePathUtil;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwt.MWComponent;
import com.mathworks.mwt.command.MWCommandAdapter;
import com.mathworks.mwt.command.MWCommandCenter;
import com.mathworks.mwt.command.MWCommandChain;
import com.mathworks.mwt.dialog.MWAlert;
import com.mathworks.mwt.dialog.MWFileDialog;
import com.mathworks.mwt.undo.UndoEvent;
import com.mathworks.mwt.undo.UndoManager;
import com.mathworks.mwt.undo.UndoManagerListener;
import com.mathworks.util.CharBuffer;
import com.mathworks.util.NativeJava;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.StringUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class EditorDocument
extends MWCommandAdapter {
    private static ResourceBundle sRes;
    private static final int BUFSIZE = 16384;
    private static int sUntitledNum;
    private static final String UNTITLED_STRING;
    private EditorView fEditorView;
    private File fFile;
    private String fFilename;
    private String fFullPathname;
    private EditorViewContainer fViewContainer;
    private UndoManager fUndoManager;
    private UndoEventHandler fUndoHandler;
    private Matlab fMatlab;
    private long fLastModified;

    public EditorDocument(EditorViewContainer editorViewContainer, Matlab matlab, MWCommandCenter mWCommandCenter) {
        this(editorViewContainer, matlab, mWCommandCenter, null);
    }

    public EditorDocument(EditorViewContainer editorViewContainer, Matlab matlab, MWCommandCenter mWCommandCenter, String string) {
        sRes = EditorApplication.getSRes();
        this.fViewContainer = editorViewContainer;
        if (string == null) {
            if (sUntitledNum == 1) {
                this.setFilename(UNTITLED_STRING);
            } else {
                this.setFilename(String.valueOf(UNTITLED_STRING) + sUntitledNum);
            }
            this.fFullPathname = this.fFilename;
            ++sUntitledNum;
        } else {
            this.fFile = new File(string);
            this.setFilename(this.fFile.getName());
            this.setPathname(string);
            this.setTimeLastModified();
        }
        this.setCommandCenter(mWCommandCenter);
        this.fUndoManager = new UndoManager();
        this.fUndoHandler = new UndoEventHandler();
        this.addUndoManagerListener(this.fUndoHandler);
        this.clearUndoHistory();
        this.fEditorView = new EditorView(this, matlab);
        this.fEditorView.setNextTarget((MWCommandChain)this);
        this.fEditorView.addUndoListener(this.fUndoManager);
        this.fMatlab = matlab;
        this.setInitialCommandStates();
    }

    public void dispose() {
        if (this.fEditorView != null) {
            this.fEditorView.dispose();
        }
    }

    CharBuffer readFileContents(CharBuffer charBuffer) {
        block12: {
            FileReader fileReader = null;
            if (this.fFile != null && this.fFile.exists()) {
                try {
                    try {
                        fileReader = new FileReader(this.fFullPathname);
                        int n = (int)this.fFile.length();
                        charBuffer.ensureCapacity(n);
                        char[] cArray = charBuffer.getRawBuf();
                        n = Math.max(0, fileReader.read(cArray, 0, cArray.length));
                        charBuffer.setSize(n, false);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    Object var5_8 = null;
                    if (fileReader == null) break block12;
                }
                catch (Throwable throwable) {
                    Object var5_9 = null;
                    if (fileReader != null) {
                        try {
                            try {
                                fileReader.close();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        catch (Throwable throwable2) {}
                        return charBuffer;
                    }
                    throw throwable;
                }
                try {
                    try {
                        fileReader.close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                catch (Throwable throwable) {}
                return charBuffer;
            }
        }
        return charBuffer;
    }

    void addReplaceListener() {
        this.fEditorView.addReplaceListener();
    }

    public String getFilename() {
        return this.fFilename;
    }

    String getPathname() {
        return this.fFullPathname;
    }

    static String getFullPathname(String string) {
        String string2 = MFilePathUtil.mapPFileToMFile(string);
        String string3 = StringUtils.toJavaPath((String)string2);
        String string4 = NativeJava.toAbsolutePath((String)string3);
        if (string4 == null || string4.length() == 0) {
            return string3;
        }
        return string4;
    }

    static boolean fileExists(String string) {
        boolean bl = false;
        String string2 = EditorDocument.getFullPathname(string);
        File file = new File(string2 = string2.trim());
        if (file.exists()) {
            bl = true;
        }
        return bl;
    }

    boolean saveFile(boolean bl) {
        if (this.fFile == null) {
            return this.saveFileAs();
        }
        if (this.isFileReadOnly()) {
            return this.saveReadOnly();
        }
        return this.writeFile(bl);
    }

    boolean saveFileAs() {
        int n;
        Object object;
        String string;
        boolean bl = false;
        boolean bl2 = false;
        String string2 = this.getPathOrUntitledName();
        MWFileDialog mWFileDialog = new MWFileDialog(MWComponent.getComponentFrame((Component)((Object)this.fEditorView)), sRes.getString("title.Savefileas"), 1, 1);
        string = this.fFile == null ? ((string = this.fEditorView.getFunctionName(0)) == null ? String.valueOf(this.fFilename) + ".m" : (string.length() == 0 ? String.valueOf(this.fFilename) + ".m" : String.valueOf(string) + ".m")) : this.fFilename;
        if (this.fFile != null && (object = this.fFullPathname.substring(0, n = this.fFullPathname.lastIndexOf(this.fFilename))) != null && ((String)object).length() > 0) {
            MWFileDialog.setCurrentDirectory((String)object);
        }
        mWFileDialog.setFile(string);
        mWFileDialog.show();
        if (mWFileDialog.getFile() != null && mWFileDialog.getFile().length() != 0) {
            Object[] objectArray;
            Object object2;
            n = 0;
            String string3 = mWFileDialog.getFile();
            object = new File(mWFileDialog.getDirectory(), string3);
            String string4 = EditorDocument.getFullPathname(((File)object).getPath());
            if (!string4.equals(string2)) {
                bl2 = true;
                if (!string3.endsWith(".m") && string3.indexOf(".") == -1) {
                    if (PlatformInfo.getPlatform() == 1) {
                        string3 = String.valueOf(string3) + ".m";
                        n = 1;
                    } else {
                        object2 = sRes.getString("question.Addmtothefilename");
                        int n2 = new MWAlert(this.fEditorView.getFrame(), sRes.getString("MATLABEditor"), (String)object2, 3).getReply();
                        if (n2 == 1) {
                            string3 = String.valueOf(string3) + ".m";
                            n = 1;
                        }
                    }
                }
            }
            File file = this.fFile;
            object2 = new File(mWFileDialog.getDirectory(), string3);
            int n3 = 1;
            if (n != 0 && ((File)object2).exists()) {
                objectArray = new Object[]{string3};
                String string5 = MessageFormat.format(sRes.getString("question.OverwriteFile"), objectArray);
                n3 = new MWAlert(this.fEditorView.getFrame(), sRes.getString("MATLABEditor"), string5, 3).getReply();
            }
            if (n3 == 1) {
                this.fFile = object2;
                bl = this.saveFile(bl2);
            }
            if (bl) {
                objectArray = EditorDocument.getFullPathname(this.fFile.getPath());
                EditorMRUFiles.addItem((String)objectArray);
                this.setFilename(this.fFile.getName());
                this.setPathname(this.fFile.getPath());
                this.fEditorView.setFilename(this.getPathname(), this.fFile);
                this.fViewContainer.fileNameChange(string2, this.getPathname());
                this.enableMDependentCommands(this.isMFileOrUntitled());
            } else {
                this.fFile = file;
            }
        } else {
            if (mWFileDialog.getFile() != null) {
                String string6 = sRes.getString("msg.InvalidFilename");
                new MWAlert(this.fEditorView.getFrame(), sRes.getString("MATLABEditor"), string6, 1);
            }
            bl = false;
        }
        return bl;
    }

    boolean saveReadOnly() {
        Object[] objectArray = new Object[]{this.fFile.getPath()};
        String string = MessageFormat.format(sRes.getString("msg.Thisisreadonly"), objectArray);
        int n = new MWAlert(this.fEditorView.getFrame(), sRes.getString("MATLABEditor"), string, 6).getReply();
        if (n == 3) {
            return this.saveFileAs();
        }
        if (n == 2) {
            NativeJava.changeFileAttribute((String)this.getPathname());
            if (this.fFile.canWrite()) {
                return this.saveFile(false);
            }
            new MWAlert(this.fEditorView.getFrame(), sRes.getString("MATLABEditor"), sRes.getString("msg.Nowriteaccess"), 1);
            return false;
        }
        return false;
    }

    private void doReload() {
        this.fEditorView.reloadFile(this);
        if (this.fMatlab != null) {
            this.fMatlab.forceFcnTableUpdate(this.fFile, true);
        }
    }

    void reloadFileIfChangedNoPrompt() {
        if (this.fFile == null || !this.fFile.exists()) {
            return;
        }
        this.setTimeLastModified();
        this.doReload();
    }

    void reloadFileIfChanged() {
        if (this.fFile == null || !this.fFile.exists()) {
            return;
        }
        if (this.fFile.lastModified() > this.fLastModified) {
            this.setTimeLastModified();
            Object[] objectArray = new Object[]{this.fFile.getPath()};
            String string = MessageFormat.format(sRes.getString("question.ReloadModifiedFile"), objectArray);
            Thread thread = new Thread(new Alertable(string, this.fEditorView.getFrame()));
            thread.start();
        }
    }

    private void setTimeLastModified() {
        this.fLastModified = this.fFile.lastModified();
    }

    /*
     * Unable to fully structure code
     */
    private boolean writeFile(boolean var1_1) {
        var2_2 = null;
        var3_3 = true;
        var4_4 = false;
        var5_5 = this.fEditorView.getSyntaxArea().getModel().getRawCharBuf();
        try {
            try {
                var4_4 = this.fFile.exists();
                var2_2 = new FileWriter(this.fFile);
                var8_6 = this.fEditorView.getSyntaxArea().getModel().length();
                var9_10 = 0;
                var10_12 = 16384;
                while (var8_6 > 0) {
                    if (var8_6 < var10_12) {
                        var10_12 = var8_6;
                    }
                    var2_2.write(var5_5, var9_10, var10_12);
                    var8_6 -= var10_12;
                    var9_10 += var10_12;
                }
                this.setCleanMarkerHere();
            }
            catch (Exception var8_7) {
                var3_3 = false;
                if (var8_7 instanceof FileNotFoundException) {
                    if (this.fEditorView != null) {
                        var9_11 = new Object[]{var8_7.getMessage()};
                        new MWAlert(this.fEditorView.getFrame(), EditorDocument.sRes.getString("MATLABEditor"), MessageFormat.format(EditorDocument.sRes.getString("error.writingfile"), var9_11), 1);
                    } else {
                        var8_7.printStackTrace();
                    }
                }
                var8_7.printStackTrace();
            }
            var7_13 = null;
            ** if (var2_2 == null) goto lbl-1000
        }
        catch (Throwable var6_15) {
            var7_14 = null;
            if (var2_2 != null) {
                try {
                    var2_2.close();
                }
                catch (Exception var8_9) {
                    var8_9.printStackTrace();
                }
            }
            throw var6_15;
        }
lbl-1000:
        // 1 sources

        {
            try {
                var2_2.close();
            }
            catch (Exception var8_8) {
                var8_8.printStackTrace();
            }
        }
lbl-1000:
        // 2 sources

        {
        }
        if (var3_3) {
            this.setTimeLastModified();
            if (this.fMatlab != null) {
                this.fMatlab.forceFcnTableUpdate(this.fFile, var4_4);
                if (!var1_1) {
                    this.fEditorView.fileSaved();
                }
                if (!var4_4 && PlatformInfo.getVendor() == 6) {
                    this.fMatlab.evalConsoleOutput("rehash('path')");
                }
            }
        }
        return var3_3;
    }

    public UndoManager getUndoManager() {
        return this.fUndoManager;
    }

    boolean closeFile() {
        boolean bl = false;
        if (this.isDirty()) {
            Object[] objectArray = new Object[]{this.fFilename};
            String string = MessageFormat.format(sRes.getString("question.Savechangestofile"), objectArray);
            int n = PlatformInfo.getAppearance() == 0 ? 5 : 4;
            int n2 = new MWAlert(this.fEditorView.getFrame(), sRes.getString("MATLABEditor"), string, n).getReply();
            if (n2 == 4) {
                bl = true;
            } else if (n2 == 1 && !this.saveFile(false)) {
                bl = true;
            }
        }
        return !bl;
    }

    boolean isDirty() {
        return this.fUndoManager.isDirty();
    }

    boolean isFileReadOnly() {
        if (this.fFile != null) {
            return this.fFile.exists() && !this.fFile.canWrite();
        }
        return false;
    }

    public void doCommand(int n) {
        switch (n) {
            case 350: {
                this.saveFile(false);
                return;
            }
            case 351: {
                this.saveFileAs();
                return;
            }
            case 800: {
                this.undo();
                return;
            }
            case 810: {
                this.redo();
                return;
            }
            case 400: {
                this.SourceControlCheckIn();
                return;
            }
            case 401: {
                this.SourceControlCheckOut();
                return;
            }
            case 403: {
                this.SourceControlConfigure();
                return;
            }
            case 402: {
                this.SourceControlUndoCheckout();
                return;
            }
        }
        super.doCommand(n);
    }

    public boolean isCommandEnabled(int n) {
        switch (n) {
            case 350: 
            case 351: {
                return true;
            }
            case 800: {
                return this.canUndo();
            }
            case 810: {
                return this.canRedo();
            }
        }
        return super.isCommandEnabled(n);
    }

    boolean isMFile() {
        if (this.fFile == null) {
            return false;
        }
        String string = PlatformInfo.isUnix() ? this.fFilename : this.fFilename.toLowerCase();
        return string.endsWith(".m") || string.endsWith(".cdr");
    }

    boolean isMFileOrUntitled() {
        if (this.fFile == null) {
            return true;
        }
        return this.isMFile();
    }

    protected Point getToolLocation(int n) {
        return this.fViewContainer.getToolLocation(n);
    }

    private void setFilename(String string) {
        int n = 0;
        if (string != null) {
            n = string.length();
            int n2 = string.lastIndexOf(46);
            if (n2 + 1 == n) {
                --n;
            }
            this.fFilename = string.substring(0, n);
        } else {
            this.fFilename = null;
        }
        if (this.fViewContainer != null) {
            this.fViewContainer.setFilename(string);
        }
    }

    private void setPathname(String string) {
        this.fFullPathname = EditorDocument.getFullPathname(string);
    }

    String getPathOrUntitledName() {
        if (this.fFile == null) {
            return this.fFilename;
        }
        return this.getPathname();
    }

    public EditorView getEditorView() {
        return this.fEditorView;
    }

    public File getFile() {
        return this.fFile;
    }

    void saveAndExecute() {
        boolean bl = true;
        if (this.isDirty()) {
            bl = this.saveFile(false);
        }
        if (bl && this.fMatlab != null && this.isMFile()) {
            if (this.isCommandEnabled(1600)) {
                this.fMatlab.evalConsoleOutput("dbquit");
            }
            String string = this.fFilename.substring(0, this.fFilename.length() - 2);
            String string2 = this.fFile.getParent();
            Object[] objectArray = new Object[]{string2};
            this.fMatlab.evalConsoleOutput("cd ('" + string2 + "')");
            if (string.indexOf(32) == -1) {
                this.fMatlab.evalConsoleOutput(string);
                return;
            }
            this.fMatlab.fevalConsoleOutput(string, null, 0, null);
        }
    }

    private void SourceControlCheckIn() {
        if (this.saveFile(false)) {
            Object[] objectArray = new Object[]{this.fFile.getAbsolutePath(), new Boolean(false)};
            this.fMatlab.feval("checkinwin", objectArray, (CompletionObserver)new Vtrl_CmpObsr());
        }
    }

    private void SourceControlCheckOut() {
        Object[] objectArray;
        int n;
        if (this.fFile == null) {
            new MWAlert(this.fEditorView.getFrame(), sRes.getString("SourceControl"), sRes.getString("error.Filedoesnotexist"), 1);
            return;
        }
        if (this.isDirty() && (n = (objectArray = new MWAlert(this.fEditorView.getFrame(), sRes.getString("SourceControl"), sRes.getString("question.FileChangedProceed"), 3)).getReply()) == 2) {
            return;
        }
        objectArray = new Object[]{this.fFile.getAbsolutePath(), new Boolean(false)};
        this.fMatlab.feval("checkoutwin", objectArray, (CompletionObserver)new Vtrl_CmpObsr());
    }

    private void SourceControlConfigure() {
        this.fMatlab.eval("cmoptsdialog", (CompletionObserver)new Vtrl_CmpObsr());
    }

    private void SourceControlUndoCheckout() {
        MWAlert mWAlert;
        int n;
        if (this.fFile == null) {
            new MWAlert(this.fEditorView.getFrame(), sRes.getString("SourceControl"), sRes.getString("error.Filedoesnotexist"), 1);
            return;
        }
        if (this.isDirty() && (n = (mWAlert = new MWAlert(this.fEditorView.getFrame(), sRes.getString("SourceControl"), sRes.getString("question.FileChangedProceed"), 3)).getReply()) == 2) {
            return;
        }
        mWAlert = new MWAlert[]{this.fFile.getAbsolutePath()};
        this.fMatlab.feval("undocheckout", (Object[])mWAlert, (CompletionObserver)new Vtrl_CmpObsr());
    }

    private void enableMDependentCommands(boolean bl) {
    }

    private void setInitialCommandStates() {
        this.getCommandCenter().setCommandEnabled(800, this.canUndo());
        this.getCommandCenter().setCommandEnabled(810, this.canRedo());
        if (EditorApplication.isStandalone()) {
            this.getCommandCenter().setCommandEnabled(400, false);
            this.getCommandCenter().setCommandEnabled(401, false);
            this.getCommandCenter().setCommandEnabled(403, false);
            this.getCommandCenter().setCommandEnabled(402, false);
        }
    }

    private void clearUndoHistory() {
        this.fUndoManager.clearUndoHistory();
    }

    private boolean canUndo() {
        return this.fUndoManager.canUndo();
    }

    private void undo() {
        if (this.fUndoManager.canUndo()) {
            this.fEditorView.beginDeferUpdates();
            try {
                this.fUndoManager.undo();
                return;
            }
            finally {
                Object var2_1 = null;
                this.fEditorView.endDeferUpdates();
            }
        }
        Toolkit.getDefaultToolkit().beep();
    }

    private boolean canRedo() {
        return this.fUndoManager.canRedo();
    }

    private void redo() {
        if (this.fUndoManager.canRedo()) {
            this.fEditorView.beginDeferUpdates();
            try {
                this.fUndoManager.redo();
                return;
            }
            finally {
                Object var2_1 = null;
                this.fEditorView.endDeferUpdates();
            }
        }
        Toolkit.getDefaultToolkit().beep();
    }

    private void addUndoManagerListener(UndoManagerListener undoManagerListener) {
        this.fUndoManager.addUndoManagerListener(undoManagerListener);
    }

    private void removeUndoManagerListener(UndoManagerListener undoManagerListener) {
        this.fUndoManager.removeUndoManagerListener(undoManagerListener);
    }

    private void setCleanMarkerHere() {
        this.fUndoManager.setCleanMarkerHere();
    }

    public static void main(String[] stringArray) {
    }

    static {
        sUntitledNum = 1;
        UNTITLED_STRING = PlatformInfo.getAppearance() == 1 ? "Untitled" : "untitled";
    }

    private class Alertable
    implements Runnable {
        private Frame fFrame;
        private String fString;

        Alertable(String string, Frame frame) {
            EditorDocument.this = EditorDocument.this;
            this.fFrame = frame;
            this.fString = string;
        }

        public void run() {
            int n = new MWAlert(this.fFrame, sRes.getString("MATLABEditor"), this.fString, 3).getReply();
            if (n == 1) {
                EditorDocument.this.doReload();
            }
        }
    }

    private class UndoEventHandler
    implements UndoManagerListener {
        public void dirtyStateChanged(UndoEvent undoEvent) {
            EditorDocument.this.fViewContainer.dirtyStatusChanged();
            EditorDocument.this.fEditorView.fileDirtied(EditorDocument.this.isDirty());
        }

        public void undoabilityChanged(UndoEvent undoEvent) {
            EditorDocument.this.getCommandCenter().setCommandEnabled(800, EditorDocument.this.canUndo());
        }

        public void redoabilityChanged(UndoEvent undoEvent) {
            EditorDocument.this.getCommandCenter().setCommandEnabled(810, EditorDocument.this.canRedo());
        }

        UndoEventHandler() {
            EditorDocument.this = EditorDocument.this;
        }
    }

    class CompletionCallback
    implements CompletionObserver {
        public void CompletionCallback() {
        }

        public void completed(int n, Object object) {
        }

        CompletionCallback() {
            EditorDocument.this = EditorDocument.this;
        }
    }

    class Vtrl_CmpObsr
    implements CompletionObserver {
        public void completed(int n, Object object) {
            if (Matlab.getExecutionStatus((int)n) != 0) {
                Frame frame = EditorDocument.this.fEditorView.getFrame();
                EditorDocument.this.fMatlab.feval("lasterr", null, (CompletionObserver)new 1(frame));
            }
        }

        Vtrl_CmpObsr() {
            EditorDocument.this = EditorDocument.this;
        }
    }
}

