/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.editor;

import com.mathworks.ide.browsers.PathBrowser;
import com.mathworks.ide.desktop.DTClient;
import com.mathworks.ide.desktop.DTDockPath;
import com.mathworks.ide.desktop.Desktop;
import com.mathworks.ide.desktop.MLDesktop;
import com.mathworks.ide.editor.EditorDocument;
import com.mathworks.ide.editor.EditorMRUFiles;
import com.mathworks.ide.editor.EditorOptions;
import com.mathworks.ide.editor.EditorViewContainer;
import com.mathworks.ide.editor.ExternalEditorInterface;
import com.mathworks.ide.editor.MWReplaceDialog;
import com.mathworks.ide.widgets.MFilePathUtil;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwt.MWFrameProxy;
import com.mathworks.mwt.MWUtils;
import com.mathworks.mwt.command.MWCommandAdapter;
import com.mathworks.mwt.command.MWCommandChain;
import com.mathworks.mwt.dialog.MWAlert;
import com.mathworks.mwt.dialog.MWFileDialog;
import com.mathworks.mwt.dialog.MWFileFilter;
import com.mathworks.mwt.message.MWLooper;
import com.mathworks.mwt.message.MWMessage;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.QueueEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;

public class EditorApplication
extends MWCommandAdapter
implements ActionListener {
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.ide.editor.resources.RES_Editor");
    private static final int DEBUG_INTEREST = 1;
    private static final int WORKSPACE_INTEREST = 2;
    private static final int STACK_MESSAGE = 3;
    protected static final String DEBUGSTATECHANGED = "DebugStateChanged";
    private static Vector sDocuments;
    private static boolean sIsStandalone;
    private static EditorApplication sMe;
    private static Matlab sMatlab;
    private static boolean sDBStopRegistered;
    private static boolean sWeDebugging;
    private static boolean sPrefInlineDebugging;
    private static boolean sPrefTabbedMode;
    private static boolean sPrefGraphicalDebugging;
    private static boolean sActivateDebugger;
    private static ActionListener sActionListener;
    private static InterestCallback sStackInterest;
    private static ExternalEditorInterface sExternalEditor;
    private static String sExternalEditorName;
    private static MWFileDialog sDlog;
    private static Rectangle sWindowRect;
    private static Dimension sScreenSize;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;

    public EditorApplication() {
        if (sMe != null) {
            return;
        }
        sScreenSize = Toolkit.getDefaultToolkit().getScreenSize();
        sActivateDebugger = sPrefGraphicalDebugging = EditorOptions.getGraphicalDebugging();
        Prefs.addListener((PrefListener)new GrDebuggingPrefListener(), (String)"EditorGraphicalDebugging");
        if (sMatlab != null) {
            ExtEditorPrefListener extEditorPrefListener = new ExtEditorPrefListener();
            Prefs.addListener((PrefListener)extEditorPrefListener, (String)"EditorBuiltinEditor");
            Prefs.addListener((PrefListener)extEditorPrefListener, (String)"EditorOtherEditor");
            EditorApplication.loadExternalEditor();
            sMatlab.registerInterest(1, 0x4000000, (CompletionObserver)new InterestCallback(1));
            sMatlab.registerInterest(1, 0x10000000, (CompletionObserver)new InterestCallback(1));
            sMatlab.registerInterest(3, Integer.MIN_VALUE, (CompletionObserver)new InterestCallback(2));
            sStackInterest = new InterestCallback(3);
        }
    }

    private static void setInDebugMode(boolean bl) {
        if (bl != sWeDebugging) {
            sWeDebugging = bl;
            if (sExternalEditor != null) {
                sExternalEditor.debugMode(bl);
                return;
            }
            EditorApplication.processActionEvent();
        }
    }

    static boolean getInDebugMode() {
        return sWeDebugging;
    }

    static void initializeInDebugMode() {
        if (sMatlab != null) {
            sMatlab.eval("dbstack", (CompletionObserver)sStackInterest, 512);
            return;
        }
        EditorApplication.setInDebugMode(false);
    }

    public static boolean hasExternalEditor() {
        return sExternalEditor != null;
    }

    public static void newDocument() {
        if (sExternalEditor != null) {
            sExternalEditor.newDocument(null);
            return;
        }
        EditorViewContainer editorViewContainer = new EditorViewContainer();
        EditorApplication.addDocumentToDesktop(editorViewContainer);
        editorViewContainer.setNextTarget((MWCommandChain)sMe);
    }

    public static void newDocumentWithString(String string) {
        if (sExternalEditor != null) {
            sExternalEditor.newDocument(string);
            return;
        }
        EditorViewContainer editorViewContainer = new EditorViewContainer();
        EditorApplication.addDocumentToDesktop(editorViewContainer);
        editorViewContainer.setNextTarget((MWCommandChain)sMe);
        editorViewContainer.setContents(string);
    }

    private static synchronized EditorViewContainer getOpenDocument(String string) {
        int n = sDocuments.size();
        int n2 = 0;
        while (n2 < n) {
            String string2 = ((EditorViewContainer)sDocuments.elementAt(n2)).getLongName();
            boolean bl = PlatformInfo.getPlatform() != 2 ? string.equalsIgnoreCase(string2) : string.equals(string2);
            if (bl) {
                return (EditorViewContainer)sDocuments.elementAt(n2);
            }
            ++n2;
        }
        return null;
    }

    private static void debugStopFromCCode(String string, int n, boolean bl) {
        sActivateDebugger = bl;
        if (!sDBStopRegistered && EditorOptions.getGraphicalDebugging()) {
            EditorApplication.openDocumentToLine(string, n);
        }
    }

    private static void showDebugger(String string, int n) {
        EditorApplication.openDocumentToLine(string, n);
        EditorApplication.setInDebugMode(true);
    }

    public static void closeDocument(String[] stringArray) {
        if (stringArray != null && stringArray.length >= 1) {
            int n = 0;
            while (n < stringArray.length) {
                EditorApplication.closeDocument(stringArray[n]);
                ++n;
            }
        }
    }

    public static void closeDocument(String string) {
        String string2;
        EditorViewContainer editorViewContainer;
        if (sExternalEditor == null && (editorViewContainer = EditorApplication.getOpenDocument(string2 = EditorDocument.getFullPathname(string))) != null) {
            editorViewContainer.closeWindow();
        }
    }

    public static void openDocument(String[] stringArray) {
        if (stringArray != null && stringArray.length >= 1) {
            int n = 0;
            while (n < stringArray.length) {
                EditorApplication.openDocument(stringArray[n]);
                ++n;
            }
        }
    }

    public static void openDocument(String string) {
        if (MWUtils.isAWTEventQueueThread()) {
            EditorApplication.myOpenDocument(string);
            return;
        }
        EditorOpenEvent editorOpenEvent = new EditorOpenEvent(string);
        QueueEvent.postQueueEvent((QueueEvent)editorOpenEvent);
    }

    private static void myOpenDocument(String string) {
        if (sExternalEditor != null) {
            sExternalEditor.openDocument(string);
            return;
        }
        String string2 = EditorDocument.getFullPathname(string);
        EditorViewContainer editorViewContainer = EditorApplication.getOpenDocument(string2);
        if (editorViewContainer != null) {
            editorViewContainer.toFront();
            return;
        }
        try {
            boolean bl = true;
            if (!EditorDocument.fileExists(string2)) {
                Frame frame = new Frame();
                ((Component)frame).setLocation(300, 200);
                Object[] objectArray = new Object[]{string2};
                String string3 = MessageFormat.format(EditorApplication.intlString("question.DoesnotexistCreate"), objectArray);
                int n = new MWAlert(frame, EditorApplication.intlString("MATLABEditor"), string3, 3).getReply();
                if (n == 2) {
                    bl = false;
                }
                frame.dispose();
            }
            if (bl) {
                EditorMRUFiles.addItem(string2);
                editorViewContainer = new EditorViewContainer(string2);
                EditorApplication.addDocumentToDesktop(editorViewContainer);
                editorViewContainer.setNextTarget((MWCommandChain)sMe);
                System.gc();
                return;
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.out.println(EditorApplication.intlString("msg.Notenoughmemorytoeditfile"));
            System.gc();
            return;
        }
    }

    static String intlString(String string) {
        return sRes.getString(string);
    }

    static ResourceBundle getSRes() {
        return sRes;
    }

    public static void openDocumentToLine(String string, int n, boolean bl) {
        EditorApplication.openDocumentToLine(string, n, bl, false);
    }

    public static void openDocumentToLine(String string, int n, boolean bl, boolean bl2) {
        if (sExternalEditor != null) {
            sExternalEditor.openDocumentToLine(string, n, bl, bl2);
            return;
        }
        String string2 = EditorDocument.getFullPathname(string);
        EditorViewContainer editorViewContainer = EditorApplication.getOpenDocument(string2);
        if (editorViewContainer != null) {
            if (bl) {
                editorViewContainer.toFront();
            }
        } else if (EditorDocument.fileExists(string2)) {
            EditorMRUFiles.addItem(string2);
            editorViewContainer = new EditorViewContainer(string2);
            EditorApplication.addDocumentToDesktop(editorViewContainer);
            editorViewContainer.setNextTarget((MWCommandChain)sMe);
        }
        if (editorViewContainer != null) {
            editorViewContainer.showLine(n, bl2);
        }
    }

    public static void openDocumentToLine(String string, int n) {
        EditorApplication.openDocumentToLine(string, n, true);
    }

    public static void openDocumentToFunction(String string, String string2, String string3) {
        if (sExternalEditor != null) {
            sExternalEditor.openDocumentToFunction(string, string2, string3);
            return;
        }
        String string4 = EditorDocument.getFullPathname(string);
        EditorViewContainer editorViewContainer = EditorApplication.getOpenDocument(string4);
        if (editorViewContainer != null) {
            editorViewContainer.toFront();
            editorViewContainer.showFunction(string2, string3);
            return;
        }
        EditorMRUFiles.addItem(string4);
        editorViewContainer = new EditorViewContainer(string4);
        EditorApplication.addDocumentToDesktop(editorViewContainer);
        editorViewContainer.setNextTarget((MWCommandChain)sMe);
        editorViewContainer.showFunction(string2, string3);
    }

    public static void openDocumentToFunction(String string, String string2) {
        EditorApplication.openDocumentToFunction(string, string2, null);
    }

    public static void openADocument() {
        String string;
        Frame frame = null;
        Vector vector = EditorApplication.getOpenDocuments();
        if (vector.size() >= 1) {
            EditorViewContainer editorViewContainer = (EditorViewContainer)vector.elementAt(0);
            frame = editorViewContainer.getFrame();
        }
        int n = 15;
        MWFileFilter mWFileFilter = new MWFileFilter(100, n);
        if (PlatformInfo.isWindows()) {
            sDlog = new MWFileDialog(frame, EditorApplication.intlString("title.OpenFile"), 0, mWFileFilter, (ActionListener)sMe);
            sDlog.show();
            return;
        }
        MWFileDialog mWFileDialog = new MWFileDialog(frame, EditorApplication.intlString("title.OpenFile"), 0, mWFileFilter);
        mWFileDialog.show();
        if (mWFileDialog.getFile() != null && (string = MFilePathUtil.mapPFileToMFile(mWFileDialog.getFile())) != null && string.length() != 0) {
            File file = new File(mWFileDialog.getDirectory(), string);
            String string2 = file.getAbsolutePath();
            EditorApplication.openDocument(PathBrowser.toJavaPath(string2));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == sDlog) {
            if (sDlog.getFile() != null) {
                String string = MFilePathUtil.mapPFileToMFile(sDlog.getFile());
                File file = new File(sDlog.getDirectory(), string);
                String string2 = file.getAbsolutePath();
                EditorApplication.openDocument(PathBrowser.toJavaPath(string2));
            }
            sDlog.dispose();
        }
    }

    public static boolean isDirty(String string) {
        String string2;
        EditorViewContainer editorViewContainer;
        boolean bl = false;
        if (sExternalEditor == null && (editorViewContainer = EditorApplication.getOpenDocument(string2 = EditorDocument.getFullPathname(string))) != null && EditorDocument.fileExists(string2) && editorViewContainer.isDirty()) {
            bl = true;
        }
        return bl;
    }

    public static int reloadFileNoPrompt(String string) {
        int n = 1;
        if (sExternalEditor != null) {
            return 0;
        }
        String string2 = EditorDocument.getFullPathname(string);
        EditorViewContainer editorViewContainer = EditorApplication.getOpenDocument(string2);
        if (editorViewContainer == null) {
            n = 0;
        } else if (EditorDocument.fileExists(string2)) {
            editorViewContainer.reloadFileNoPrompt();
        }
        return n;
    }

    public static int saveExistingFileNoPrompt(String string) {
        int n = 1;
        if (sExternalEditor == null) {
            String string2 = EditorDocument.getFullPathname(string);
            EditorViewContainer editorViewContainer = EditorApplication.getOpenDocument(string2);
            if (editorViewContainer == null) {
                n = 0;
            } else if (EditorDocument.fileExists(string2)) {
                editorViewContainer.save();
            }
        }
        return n;
    }

    static void addDocumentToDesktop(EditorViewContainer editorViewContainer) {
        Object object;
        String string;
        MLDesktop mLDesktop = MLDesktop.getMLDesktop();
        DTClient dTClient = null;
        DTDockPath dTDockPath = null;
        MWFrameProxy mWFrameProxy = (MWFrameProxy)((Component)((Object)editorViewContainer)).getParent();
        boolean bl = false;
        Vector vector = EditorApplication.getOpenDocuments();
        if (vector.size() <= 1) {
            string = EditorOptions.getDockPath();
            if (!EditorOptions.isExternal() && string != null && string.length() > 0) {
                object = EditorOptions.getEditorWindowBounds();
                mWFrameProxy.setSize(((Rectangle)object).width, ((Rectangle)object).height);
                dTDockPath = new DTDockPath(string);
            } else {
                dTDockPath = new DTDockPath(mWFrameProxy);
            }
        } else if (!EditorOptions.isTabMode()) {
            dTDockPath = new DTDockPath(mWFrameProxy);
        } else {
            string = null;
            object = (EditorViewContainer)vector.elementAt(0);
            if (object == editorViewContainer) {
                object = (EditorViewContainer)vector.elementAt(1);
            }
            string = (MWFrameProxy)((Component)object).getParent();
            dTDockPath = string.getDTClient().getDockPath();
            bl = true;
        }
        dTClient = mLDesktop == null ? Desktop.addClient((Component)((Object)editorViewContainer), dTDockPath, editorViewContainer.getLongName()) : mLDesktop.addClient((Component)((Object)editorViewContainer), dTDockPath, editorViewContainer.getLongName(), true);
        if (!editorViewContainer.isDockedInDesktop() && !bl) {
            if (vector.size() == 1) {
                sWindowRect = EditorOptions.getEditorWindowBounds();
            } else {
                if (sWindowRect == null) {
                    sWindowRect = EditorOptions.getEditorWindowBounds();
                }
                sWindowRect.setLocation(EditorApplication.sWindowRect.x + 15, EditorApplication.sWindowRect.y + 15);
                if (EditorApplication.sWindowRect.y + EditorApplication.sWindowRect.height >= EditorApplication.sScreenSize.height) {
                    EditorApplication.sWindowRect.y = 0;
                }
                if (EditorApplication.sWindowRect.x + EditorApplication.sWindowRect.width >= EditorApplication.sScreenSize.width) {
                    EditorApplication.sWindowRect.x = 0;
                }
            }
            int n = EditorOptions.getEditorWindowMinMaxState();
            object = editorViewContainer.getExternalFrame();
            if (object != null) {
                ((Component)object).setBounds(sWindowRect);
                if (n == 1) {
                    object.setMaximized(true);
                }
            }
        }
    }

    public static synchronized boolean orderedCloseAll() {
        EditorViewContainer editorViewContainer;
        boolean bl = true;
        int n = sDocuments.size() - 1;
        Vector<EditorViewContainer> vector = new Vector<EditorViewContainer>(sDocuments.size());
        while (n >= 0) {
            editorViewContainer = (EditorViewContainer)sDocuments.elementAt(n);
            boolean bl2 = editorViewContainer.isDirty();
            if (bl2) {
                bl = editorViewContainer.close();
            } else {
                vector.addElement(editorViewContainer);
            }
            if (!bl) break;
            --n;
        }
        if (!bl) {
            return bl;
        }
        n = vector.size() - 1;
        while (n >= 0) {
            editorViewContainer = (EditorViewContainer)vector.elementAt(n);
            bl = editorViewContainer.close();
            if (!bl) break;
            --n;
        }
        return bl;
    }

    public static synchronized boolean closeAll() {
        boolean bl = true;
        int n = sDocuments.size() - 1;
        while (n >= 0) {
            bl = ((EditorViewContainer)sDocuments.elementAt(n)).close();
            if (!bl) break;
            --n;
        }
        return bl;
    }

    public static synchronized void saveAll() {
        int n = sDocuments.size();
        int n2 = 0;
        while (n2 < n) {
            EditorViewContainer editorViewContainer = (EditorViewContainer)sDocuments.elementAt(n2);
            if (editorViewContainer.isDirty()) {
                editorViewContainer.save();
            }
            ++n2;
        }
    }

    public static boolean quit() {
        boolean bl = EditorApplication.closeAll();
        if (bl && sIsStandalone) {
            System.exit(0);
        }
        return bl;
    }

    public static boolean isStandalone() {
        return sIsStandalone;
    }

    static void setStandalone(boolean bl) {
        sIsStandalone = bl;
    }

    static synchronized void addDocument(EditorViewContainer editorViewContainer) {
        MWReplaceDialog mWReplaceDialog;
        sDocuments.addElement(editorViewContainer);
        editorViewContainer.setNextTarget((MWCommandChain)sMe);
        if (sDocuments.size() == 1 && (mWReplaceDialog = MWReplaceDialog.getReplaceDialog()) != null) {
            mWReplaceDialog.addSearchFilters(1);
            editorViewContainer.addReplaceListener();
        }
    }

    static synchronized void removeDocument(EditorViewContainer editorViewContainer) {
        MWReplaceDialog mWReplaceDialog;
        sDocuments.removeElement(editorViewContainer);
        if (sDocuments.size() == 0 && (mWReplaceDialog = MWReplaceDialog.getReplaceDialog()) != null) {
            mWReplaceDialog.removeSearchFilters(1);
        }
    }

    static Matlab getMatlab() {
        return sMatlab;
    }

    public static synchronized Vector getOpenDocuments() {
        return (Vector)sDocuments.clone();
    }

    public void doCommand(int n) {
        switch (n) {
            case 100: {
                EditorApplication.newDocument();
                return;
            }
            case 130: {
                EditorApplication.openADocument();
                return;
            }
            case 118: {
                EditorApplication.closeAll();
                return;
            }
            case 352: {
                EditorApplication.saveAll();
                return;
            }
            case -111: {
                EditorApplication.quit();
                return;
            }
        }
        super.doCommand(n);
    }

    public boolean isCommandEnabled(int n) {
        return true;
    }

    private void handleStackReply(String string) {
        if (string != null && string.length() > 5) {
            EditorApplication.setInDebugMode(true);
        }
    }

    private void handleDebugInterest(Object object) {
        MWMessage mWMessage = (MWMessage)object;
        Integer n = (Integer)mWMessage.findData("eventid", class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = EditorApplication.class$("java.lang.Integer")));
        int n2 = n;
        if (n2 == 0x4000000) {
            this.interestDebugStop(mWMessage);
            return;
        }
        if (n2 == 0x10000000) {
            EditorApplication.setInDebugMode(false);
            return;
        }
        if (n2 == -8 && (n = (Integer)mWMessage.findData("familyid", class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = EditorApplication.class$("java.lang.Integer")))) == 0) {
            sDBStopRegistered = true;
        }
    }

    private void handleWorkspaceInterest(Object object) {
        MWMessage mWMessage = (MWMessage)object;
        Integer n = (Integer)mWMessage.findData("level", class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = EditorApplication.class$("java.lang.Integer")));
        if (n == null) {
            return;
        }
        if (n != 0 && (n = (Integer)mWMessage.findData("status", class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = EditorApplication.class$("java.lang.Integer")))) != null && Matlab.getInputRequester((int)n) == 1) {
            this.interestDebugStop(mWMessage);
        }
    }

    private void interestDebugStop(MWMessage mWMessage) {
        if (mWMessage == null) {
            return;
        }
        if (!sPrefGraphicalDebugging || !sActivateDebugger) {
            sActivateDebugger = sPrefGraphicalDebugging;
            EditorApplication.setInDebugMode(true);
            return;
        }
        String string = (String)mWMessage.findData("string", class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = EditorApplication.class$("java.lang.String")));
        if (string != null && string.length() > 0) {
            String string2 = MFilePathUtil.mapPFileToMFile(string);
            Integer n = (Integer)mWMessage.findData("lineno", class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = EditorApplication.class$("java.lang.Integer")));
            if (!sPrefInlineDebugging) {
                EditorApplication.showDebugger(string2, n);
                return;
            }
            EditorApplication.openDocumentToLine(string2, n, false);
        }
    }

    static void addDebugStateListener(ActionListener actionListener) {
        sActionListener = AWTEventMulticaster.add(sActionListener, actionListener);
    }

    static void removeDebugStateListener(ActionListener actionListener) {
        sActionListener = AWTEventMulticaster.remove(sActionListener, actionListener);
    }

    private static void processActionEvent() {
        if (sActionListener != null) {
            sActionListener.actionPerformed(new ActionEvent(sMe, 1001, DEBUGSTATECHANGED));
        }
    }

    private static void loadExternalEditor() {
        if (EditorOptions.getBuiltinEditor()) {
            sExternalEditor = null;
        } else {
            String string = EditorOptions.getOtherEditor();
            if (string != null && string.startsWith("-eei")) {
                string = string.substring(4);
                if (!(string = string.trim()).equals(sExternalEditorName)) {
                    try {
                        Class<?> clazz = Class.forName(string);
                        if (clazz != null) {
                            sExternalEditor = (ExternalEditorInterface)clazz.newInstance();
                            sExternalEditorName = string;
                        }
                    }
                    catch (Exception exception) {
                        sExternalEditor = null;
                    }
                }
            } else {
                sExternalEditor = null;
            }
        }
        if (sExternalEditor == null) {
            sExternalEditorName = null;
        }
    }

    public static void main(String[] stringArray) {
        try {
            sIsStandalone = true;
            if (stringArray != null && stringArray.length != 0) {
                if (stringArray.length == 1) {
                    EditorApplication.openDocument(stringArray[0]);
                    return;
                }
                System.out.println(EditorApplication.intlString("error.Onlyoneargumentallowed"));
                System.exit(-1);
                return;
            }
            EditorApplication.newDocument();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ int access$0() {
        return 1;
    }

    static /* synthetic */ int access$2() {
        return 2;
    }

    static /* synthetic */ int access$4() {
        return 3;
    }

    static /* synthetic */ boolean access$8() {
        return sActivateDebugger;
    }

    static {
        sActionListener = null;
        sStackInterest = null;
        sExternalEditor = null;
        sExternalEditorName = null;
        sWindowRect = null;
        sDocuments = new Vector();
        sIsStandalone = false;
        if (Matlab.isMatlabAvailable()) {
            sMatlab = new Matlab(new MWLooper("EditorApplication"));
        }
        sMe = new EditorApplication();
    }

    private static class EditorOpenEvent
    extends QueueEvent {
        String fFilename;

        public EditorOpenEvent(String string) {
            this.fFilename = new String(string);
        }

        public void dispatch() {
            EditorApplication.myOpenDocument(this.fFilename);
        }
    }

    class InterestCallback
    implements CompletionObserver {
        int fReplyType;

        public InterestCallback(int n) {
            EditorApplication.this = EditorApplication.this;
            this.fReplyType = n;
        }

        public void completed(int n, Object object) {
            if (this.fReplyType == EditorApplication.access$0()) {
                EditorApplication.this.handleDebugInterest(object);
                return;
            }
            if (this.fReplyType == EditorApplication.access$2()) {
                EditorApplication.this.handleWorkspaceInterest(object);
                return;
            }
            if (this.fReplyType == EditorApplication.access$4()) {
                EditorApplication.this.handleStackReply((String)object);
            }
        }
    }

    private class GrDebuggingPrefListener
    implements PrefListener {
        public void prefChanged(PrefEvent prefEvent) {
            sPrefGraphicalDebugging = EditorOptions.getGraphicalDebugging();
            if (!EditorApplication.getInDebugMode()) {
                sActivateDebugger = sPrefGraphicalDebugging;
            }
        }

        GrDebuggingPrefListener() {
            EditorApplication.this = EditorApplication.this;
        }
    }

    private class ExtEditorPrefListener
    implements PrefListener {
        public void prefChanged(PrefEvent prefEvent) {
            EditorApplication.loadExternalEditor();
        }

        ExtEditorPrefListener() {
            EditorApplication.this = EditorApplication.this;
        }
    }
}

