/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.editor;

import com.mathworks.ide.editor.EditorView;
import com.mathworks.ide.widgets.MScanner;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwt.MWToolTip2;
import com.mathworks.mwt.text.MWTextModel;
import com.mathworks.mwt.text.MWTextView;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import com.mathworks.util.Range;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;

class DataTip
extends MWToolTip2 {
    private EditorView fEditorView;
    private MouseMotionListener fMouseMotionEventHandler = new MouseMotionEventHandler();
    private MouseListener fMouseEventHandler = new MouseEventHandler();
    private KeyListener fKeyEventHandler = new KeyEventHandler();
    private MWToolTip2.TextProvider fTextProvider = new DataTipTextProvider();
    private Matlab fMatlab;
    private CompletionObserver fCompletionObserver = new DataTipCompletionObserver();
    private String fVariable;
    private Range fCurrentRange = new Range();
    private Range fNewRange = new Range();
    private int fOutstandingRequests = 0;
    private boolean fDataTipEnabled = false;
    private boolean fMouseIn;

    public DataTip(EditorView editorView, Matlab matlab) {
        super((Component)editorView.getSyntaxArea().getView());
        this.fMatlab = matlab;
        EditorFontPrefListener editorFontPrefListener = new EditorFontPrefListener();
        Prefs.addListener((PrefListener)editorFontPrefListener, (String)"EditorFont");
        this.changeFont();
        this.setView(editorView);
        this.setDataTipEnabled(true);
    }

    public void collapse() {
        this.fMouseIn = false;
        super.collapse();
        this.getTextView().requestFocus();
    }

    protected void changeFont() {
        Font font = Prefs.getFontPref((String)"EditorFont", (Font)new Font("Monospaced", 0, 12));
        int n = Math.max(1, font.getSize() - 1);
        int n2 = 0;
        if (((Component)((Object)this)).getFont() != null) {
            n2 = ((Component)((Object)this)).getFont().getSize();
        }
        if (n2 != n) {
            this.setFont(new Font("Monospaced", 0, n));
        }
    }

    public void setView(EditorView editorView) {
        if (editorView != this.fEditorView) {
            boolean bl = this.isDataTipEnabled();
            this.setDataTipEnabled(false);
            this.fEditorView = editorView;
            this.setDataTipEnabled(bl);
        }
    }

    public void setDataTipEnabled(boolean bl) {
        if (this.fEditorView != null) {
            MWTextView mWTextView = this.getTextView();
            if (bl && !this.fDataTipEnabled) {
                this.fDataTipEnabled = bl;
                this.addTool((Component)mWTextView, this.fTextProvider);
                mWTextView.addMouseMotionListener(this.fMouseMotionEventHandler);
                mWTextView.addMouseListener(this.fMouseEventHandler);
                ((Component)((Object)this)).addKeyListener(this.fKeyEventHandler);
                return;
            }
            if (!bl && this.fDataTipEnabled) {
                this.fDataTipEnabled = bl;
                mWTextView.removeMouseMotionListener(this.fMouseMotionEventHandler);
                mWTextView.removeMouseListener(this.fMouseEventHandler);
                ((Component)((Object)this)).removeKeyListener(this.fKeyEventHandler);
                this.removeTool((Component)this.getTextView());
            }
        }
    }

    public boolean isDataTipEnabled() {
        return this.fDataTipEnabled;
    }

    protected void addToolImpl(Component component, String string, MWToolTip2.TextProvider textProvider, Rectangle rectangle) {
        this.setToolInfo(component, string, textProvider, rectangle);
    }

    private void variableUnderPoint(Point point, Range range) {
        this.wordUnderPoint(point, range);
        if (!range.isEmpty() && !this.isValidVariableName(range)) {
            range.setValues(-1, -1);
        }
    }

    private void wordUnderPoint(Point point, Range range) {
        int n;
        int n2;
        range.setValues(-1, -1);
        MWTextView mWTextView = this.getTextView();
        int n3 = mWTextView.posFromPixel(point);
        if (n3 != -1 && (n2 = mWTextView.wordStartFromPos(n3 + 1)) != (n = mWTextView.wordEndFromPos(n3)) + 1) {
            range.setValues(n2, n);
        }
    }

    private boolean isValidVariableName(Range range) {
        MWTextModel mWTextModel = this.getTextView().getModel();
        char[] cArray = mWTextModel.getRawCharBuf();
        boolean bl = MScanner.isReservedWord(cArray, range.getStart(), range.getEnd());
        boolean bl2 = Character.isLetter(mWTextModel.charAt(range.getStart()));
        return !bl && bl2;
    }

    private MWTextView getTextView() {
        return this.fEditorView.getSyntaxArea().getView();
    }

    private void generateMouseOut() {
        this.fMouseIn = false;
        this.setCurrentTool(null);
        this.nextState(1);
    }

    private void generateMouseIn() {
        this.fMouseIn = true;
        this.setCurrentTool((Component)this.getTextView());
        this.nextState(0);
    }

    private void generateReset() {
        this.fMouseIn = false;
        this.setCurrentTool(null);
        this.nextState(6);
    }

    private class DataTipTextProvider
    implements MWToolTip2.TextProvider {
        public void toolTipTextNeeded(MWToolTip2 mWToolTip2) {
            if (DataTip.this.fMatlab != null) {
                DataTip dataTip = DataTip.this;
                dataTip.fOutstandingRequests = dataTip.fOutstandingRequests + 1;
                String string = "eval( 'if exist(''" + DataTip.this.fVariable + "'',''var''), datatipinfo(" + DataTip.this.fVariable + "), end', '');";
                DataTip.this.fMatlab.eval(string, DataTip.this.fCompletionObserver);
            }
        }

        DataTipTextProvider() {
            DataTip.this = DataTip.this;
        }
    }

    private class DataTipCompletionObserver
    implements CompletionObserver {
        private String resetLineEndings(String string) {
            int n = string.length();
            if (string == null) {
                return null;
            }
            char[] cArray = string.toCharArray();
            int n2 = 0;
            while (n2 < n) {
                if (string.charAt(n2) == '\r') {
                    if (n2 < n - 1 && string.charAt(n2 + 1) == '\n') {
                        cArray[n2] = 32;
                        cArray[n2 + 1] = 13;
                    }
                } else if (string.charAt(n2) == '\n') {
                    cArray[n2] = 13;
                }
                ++n2;
            }
            String string2 = new String(cArray);
            return string2;
        }

        private String prettyText(String string) {
            String string2 = this.resetLineEndings(string);
            String string3 = String.valueOf(DataTip.this.fVariable) + " =" + '\r' + string2;
            int n = Math.min(12, DataTip.this.getTextView().numLinesHigh() - 3);
            if (n < 1) {
                n = 1;
            }
            int n2 = 0;
            int n3 = 0;
            while (n3 < string2.length()) {
                if ((n3 = string2.indexOf(13, n3)) != -1) {
                    ++n2;
                } else {
                    n3 = string2.length() - 1;
                }
                if (n2 > n) {
                    string3 = String.valueOf(DataTip.this.fVariable) + " =" + '\r' + string2.substring(0, n3) + '\r' + "...";
                    break;
                }
                ++n3;
            }
            return string3;
        }

        public void completed(int n, Object object) {
            DataTip dataTip = DataTip.this;
            dataTip.fOutstandingRequests = dataTip.fOutstandingRequests - 1;
            if (DataTip.this.fOutstandingRequests < 0) {
                DataTip.this.fOutstandingRequests = 0;
                throw new IllegalStateException("negative number of text requests outstanding");
            }
            String string = (String)object;
            if (DataTip.this.fMouseIn && DataTip.this.fOutstandingRequests == 0 && string.length() > 0) {
                String string2 = this.prettyText(string);
                DataTip.this.provideText(string2);
            }
        }

        DataTipCompletionObserver() {
            DataTip.this = DataTip.this;
        }
    }

    private class MouseMotionEventHandler
    extends MouseMotionAdapter {
        public void mouseMoved(MouseEvent mouseEvent) {
            if (DataTip.this.fEditorView != null && !DataTip.this.getTextView().hasFocus() && !DataTip.this.isToolTipVisible()) {
                return;
            }
            DataTip.this.variableUnderPoint(mouseEvent.getPoint(), DataTip.this.fNewRange);
            if (!DataTip.this.fNewRange.equals((Object)DataTip.this.fCurrentRange)) {
                if (!DataTip.this.fCurrentRange.isEmpty()) {
                    DataTip.this.generateMouseOut();
                }
                if (!DataTip.this.fNewRange.isEmpty()) {
                    DataTip.this.fVariable = DataTip.this.getTextView().getModel().getText(DataTip.this.fNewRange);
                    DataTip.this.generateMouseIn();
                    Point point = DataTip.this.getTextView().pixelFromPos(DataTip.this.fNewRange.getMin());
                    point.y += DataTip.this.getTextView().getModel().getFontBaseline() + 2;
                    point.x = mouseEvent.getX();
                    DataTip.this.setMousePoint(point);
                }
                DataTip.this.fCurrentRange.copyFrom(DataTip.this.fNewRange);
            }
        }

        MouseMotionEventHandler() {
            DataTip.this = DataTip.this;
        }
    }

    private class MouseEventHandler
    extends MouseAdapter {
        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            DataTip.this.generateReset();
        }

        MouseEventHandler() {
            DataTip.this = DataTip.this;
        }
    }

    private class KeyEventHandler
    extends KeyAdapter {
        public void keyPressed(KeyEvent keyEvent) {
            DataTip.this.generateReset();
            if (DataTip.this.fEditorView != null) {
                DataTip.this.getTextView().processKeyEvent(keyEvent);
            }
        }

        KeyEventHandler() {
            DataTip.this = DataTip.this;
        }
    }

    private class EditorFontPrefListener
    implements PrefListener {
        public void prefChanged(PrefEvent prefEvent) {
            DataTip.this.changeFont();
        }

        EditorFontPrefListener() {
            DataTip.this = DataTip.this;
        }
    }
}

