/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.editor;

import com.mathworks.ide.editor.EditorDocument;
import com.mathworks.ide.widgets.MFilePathUtil;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwt.MWCanvas;
import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.mwt.message.MWMessage;
import com.mathworks.mwt.text.MWTextAdapter;
import com.mathworks.mwt.text.MWTextComponent;
import com.mathworks.mwt.text.MWTextEvent;
import com.mathworks.mwt.text.MWTextListener;
import com.mathworks.mwt.text.MWTextModel;
import com.mathworks.mwt.text.MWTextViewAdapter;
import com.mathworks.mwt.text.MWTextViewEvent;
import com.mathworks.mwt.text.MWTextViewListener;
import com.mathworks.util.Offscreen;
import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.util.Vector;

class BreakpointDisplay
extends MWCanvas {
    private static final int BREAKPOINT_WIDTH = 8;
    private static final int BREAKPOINTS_REPLY = 1;
    private static final int ERROR_BKPTS_REPLY = 2;
    private static final int INTEREST_MESSAGE = 5;
    private static final int BREAKPOINTS_RESET = 7;
    private static Matlab sMatlab;
    private static Vector sInterests;
    private static Object[] sInterestCookies;
    private File fFile;
    private String fAbsoluteFilename;
    private MWTextComponent fText;
    private int fTopLine;
    private int fLineCount;
    private Offscreen fOffscreen;
    private Vector fBreakList;
    private BreakpointMouser fMouser;
    private int fClickLine;
    private Matlab fMatlab;
    private BreakpointCallback fInterestCallback;
    private boolean fListeningToMatlab = true;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Object;

    private void repaintAfterChange() {
        if (this.fText.getView().getTopLine() != this.fTopLine || this.fText.getModel().getNumLines() != this.fLineCount) {
            ((Component)((Object)this)).repaint(5L);
        }
    }

    private void adjustBreakpoints(MWTextEvent mWTextEvent) {
        if (this.fBreakList.size() > 0) {
            int n = mWTextEvent.getMinLine();
            int n2 = mWTextEvent.getMaxLine();
            int n3 = this.fBreakList.size();
            int n4 = n2 - n;
            int n5 = mWTextEvent.getType();
            if (n5 == 8) {
                n4 = -n4;
            }
            if (n5 == 7 || n5 == 8) {
                int n6 = n3 - 1;
                while (n6 >= 0) {
                    int n7 = (Integer)this.fBreakList.elementAt(n6);
                    if (n7 >= n) {
                        if (n5 == 8 && n7 >= n && n7 < n2) {
                            this.fBreakList.removeElementAt(n6);
                        } else {
                            this.fBreakList.setElementAt(new Integer(n7 + n4), n6);
                        }
                    }
                    --n6;
                }
            }
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(16, 100);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    private static void addBreakpointInterests(BreakpointDisplay breakpointDisplay, Matlab matlab, CompletionObserver completionObserver) {
        if (matlab != null && completionObserver != null) {
            if (sMatlab == null) {
                sMatlab = matlab;
                sInterests = new Vector();
                sInterestCookies = new Object[3];
                BreakpointDispatch breakpointDispatch = breakpointDisplay.new BreakpointDispatch();
                BreakpointDisplay.sInterestCookies[0] = sMatlab.registerInterest(1, Integer.MIN_VALUE, (CompletionObserver)breakpointDispatch);
                BreakpointDisplay.sInterestCookies[1] = sMatlab.registerInterest(1, 0x40000000, (CompletionObserver)breakpointDispatch);
                BreakpointDisplay.sInterestCookies[2] = sMatlab.registerInterest(1, 0x20000000, (CompletionObserver)breakpointDispatch);
            }
            sInterests.addElement(completionObserver);
        }
    }

    private static void removeBreakpointInterests(CompletionObserver completionObserver) {
        if (completionObserver != null && sInterests != null) {
            sInterests.removeElement(completionObserver);
            if (sInterests.size() == 0) {
                sMatlab.unregisterInterest(sInterestCookies[0]);
                sMatlab.unregisterInterest(sInterestCookies[1]);
                sMatlab.unregisterInterest(sInterestCookies[2]);
                sInterestCookies = null;
                sInterests = null;
                sMatlab = null;
            }
        }
    }

    public void addNotify() {
        this.setupMatlabAndInterests();
        super.addNotify();
    }

    private void setupMatlabAndInterests() {
        if (this.fMatlab != null && this.fInterestCallback == null) {
            this.fInterestCallback = new BreakpointCallback(5);
            BreakpointDisplay.addBreakpointInterests(this, this.fMatlab, this.fInterestCallback);
        }
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.fInterestCallback != null) {
            BreakpointDisplay.removeBreakpointInterests(this.fInterestCallback);
            this.fInterestCallback = null;
        }
    }

    protected int lineNoToY(int n) {
        return (n - this.fText.getView().getTopLine()) * this.fText.getModel().getFontHeight();
    }

    private int pointToLineNo(Point point) {
        Rectangle rectangle = ((Component)((Object)this)).getBounds();
        if (point.x < 0 || point.x >= rectangle.width) {
            return -1;
        }
        int n = point.y / this.fText.getModel().getFontHeight() + this.fText.getView().getTopLine();
        if (n >= this.fText.getModel().getNumLines()) {
            return -1;
        }
        return n;
    }

    private void eraseBlockAt(Graphics graphics, int n) {
        Rectangle rectangle = ((Component)((Object)this)).getBounds();
        rectangle.x = 1;
        rectangle.y = this.lineNoToY(n) + 1;
        rectangle.width -= 2;
        rectangle.height = this.fText.getModel().getFontHeight() - 2;
        graphics.clearRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    private void drawIntermediateBreakpointAt(int n) {
        Graphics graphics = ((Component)((Object)this)).getGraphics();
        Rectangle rectangle = ((Component)((Object)this)).getBounds();
        this.eraseBlockAt(graphics, n);
        int n2 = (rectangle.width - 8 - 2) / 2;
        int n3 = this.lineNoToY(n);
        graphics.setColor(Color.red);
        graphics.fillOval(n2, n3 += (this.fText.getModel().getFontHeight() - 4) / 2, 8, 4);
        graphics.setColor(Color.black);
        graphics.drawOval(n2, n3, 8, 4);
    }

    private void drawBreakpointAt(int n) {
        Graphics graphics = ((Component)((Object)this)).getGraphics();
        Rectangle rectangle = ((Component)((Object)this)).getBounds();
        this.eraseBlockAt(graphics, n);
        int n2 = (rectangle.width - 8) / 2;
        int n3 = this.lineNoToY(n);
        this.drawBreakpoint(graphics, n2, n3);
    }

    private void drawBreakpoint(Graphics graphics, int n, int n2) {
        graphics.setColor(Color.red);
        graphics.fillOval(--n, n2 += (this.fText.getModel().getFontHeight() - 8) / 2, 8, 8);
        graphics.setColor(Color.black);
        graphics.drawOval(n, n2, 8, 8);
    }

    private void drawExecutableMarkAt(int n) {
        Graphics graphics = ((Component)((Object)this)).getGraphics();
        Rectangle rectangle = ((Component)((Object)this)).getBounds();
        this.eraseBlockAt(graphics, n);
        int n2 = (rectangle.width - 8) / 2;
        int n3 = this.lineNoToY(n);
        this.drawExecutableMark(graphics, n2, n3);
    }

    private void drawExecutableMark(Graphics graphics, int n, int n2) {
        graphics.setColor(Color.black);
        graphics.drawLine(n, n2 += this.fText.getModel().getFontBaseline() / 2 + 1, n + 5, n2);
    }

    private boolean isFunctionLine(int n) {
        String string = "function";
        if (n < this.fText.getModel().getNumLines()) {
            String string2;
            int n2 = this.fText.getModel().getLineStart(n);
            int n3 = this.fText.getModel().getLineLengthNoEOL(n);
            if (n3 > string.length() && (string2 = this.fText.getModel().getText(n2, n2 + string.length())).equals(string)) {
                return true;
            }
        }
        return false;
    }

    public boolean breakpointAt(int n) {
        return this.fBreakList.indexOf(new Integer(n)) != -1;
    }

    protected boolean executableLineAt(int n) {
        if (this.fFile == null || this.isFunctionLine(n)) {
            return false;
        }
        MWTextModel mWTextModel = this.fText.getModel();
        int n2 = mWTextModel.getLineStart(n);
        int n3 = n2 + mWTextModel.getLineLengthNoEOL(n);
        boolean bl = false;
        while (n2 < n3 && Character.isWhitespace(mWTextModel.charAt(n2))) {
            ++n2;
        }
        if (n2 < n3 && mWTextModel.charAt(n2) != '%') {
            if (n == 0) {
                bl = true;
            }
            while (n > 0) {
                n2 = mWTextModel.getLineStart(--n);
                n3 = n2 + mWTextModel.getLineLengthNoEOL(n) - 1;
                while (n3 >= n2 && Character.isWhitespace(mWTextModel.charAt(n3))) {
                    --n3;
                }
                if (n3 > n2 + 1) {
                    if (mWTextModel.charAt(n3) != '.' || mWTextModel.charAt(n3 - 1) != '.' || mWTextModel.charAt(n3 - 2) != '.') {
                        bl = true;
                    }
                    n = 0;
                    continue;
                }
                if (n3 >= n2) {
                    bl = true;
                    n = 0;
                    continue;
                }
                if (n3 != -1) continue;
                bl = true;
                n = 0;
            }
        }
        return bl;
    }

    public synchronized void paint(Graphics graphics) {
        Graphics graphics2 = this.fOffscreen.startRender(graphics);
        if (graphics2 == null) {
            return;
        }
        Rectangle rectangle = ((Component)((Object)this)).getBounds();
        rectangle.y = 0;
        rectangle.x = 0;
        graphics2.setFont(((Component)((Object)this)).getFont());
        graphics2.setColor(Decorations.getColor((int)1));
        graphics2.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics2.setColor(Color.black);
        int n = this.fText.getModel().getFontHeight();
        int n2 = n - this.fText.getModel().getFontBaseline();
        this.fTopLine = this.fText.getView().getTopLine();
        this.fLineCount = this.fText.getModel().getNumLines();
        int n3 = this.fTopLine;
        int n4 = this.fLineCount;
        Dimension dimension = this.fText.getView().getSize();
        dimension.height = Math.min(dimension.height, rectangle.height);
        int n5 = (dimension.height + n * 3 / 10) / n;
        if (n4 > n3 + n5) {
            n4 = n3 + n5;
        }
        int n6 = this.fText.getView().pixelYFromLine(n3);
        n5 = n3;
        while (n5 < n4) {
            int n7 = (rectangle.width - 8) / 2;
            if (this.breakpointAt(n5)) {
                this.drawBreakpoint(graphics2, n7, n6);
            } else if (this.executableLineAt(n5)) {
                this.drawExecutableMark(graphics2, n7, n6);
            }
            n6 += n;
            ++n5;
        }
        graphics2.setColor(Color.white);
        graphics2.drawLine(0, 0, 0, rectangle.height - 1);
        graphics2.drawLine(1, 0, rectangle.width - 1, 0);
        graphics2.setColor(Color.darkGray);
        graphics2.drawLine(0, rectangle.height - 1, rectangle.width - 1, rectangle.height - 1);
        graphics2.drawLine(rectangle.width - 1, 0, rectangle.width - 1, rectangle.height - 2);
        this.fOffscreen.finishRender(graphics);
    }

    private String gimmeDebugFileName() {
        System.getProperty("file.separator");
        return this.fAbsoluteFilename;
    }

    public void goUntil(int n) {
        String string;
        if (this.fMatlab == null) {
            return;
        }
        String string2 = this.gimmeDebugFileName();
        boolean bl = this.breakpointAt(n - 1);
        if (!bl) {
            string = "dbstop  '" + string2 + "' " + n;
            this.fMatlab.evalConsoleOutput(string);
        }
        this.fMatlab.eval("dbcont", null, 1024);
        if (!bl) {
            string = "dbclear '" + string2 + "'  " + n;
            this.fMatlab.evalConsoleOutput(string);
        }
    }

    private void interestAddBreakpoints(MWMessage[] mWMessageArray) {
        if (mWMessageArray == null || this.fFile == null) {
            return;
        }
        int n = mWMessageArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = (String)mWMessageArray[n2].findData("string", class$java$lang$String != null ? class$java$lang$String : BreakpointDisplay.class$("java.lang.String"));
            Integer n3 = (Integer)mWMessageArray[n2].findData("lineno", class$java$lang$Integer != null ? class$java$lang$Integer : BreakpointDisplay.class$("java.lang.Integer"));
            if (string != null && n3 != null) {
                String string2 = MFilePathUtil.mFileToJavaPath(string);
                if (PlatformInfo.getPlatform() == 2 && string2.equals(this.fFile.getPath()) || PlatformInfo.getPlatform() != 2 && string2.equalsIgnoreCase(this.fFile.getPath())) {
                    this.fBreakList.addElement(new Integer(n3 - 1));
                }
            }
            ++n2;
        }
        ((Component)((Object)this)).repaint(5L);
    }

    private void interestDeleteBreakpoints(MWMessage[] mWMessageArray) {
        if (mWMessageArray == null || this.fFile == null) {
            return;
        }
        int n = mWMessageArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = (String)mWMessageArray[n2].findData("string", class$java$lang$String != null ? class$java$lang$String : BreakpointDisplay.class$("java.lang.String"));
            Integer n3 = (Integer)mWMessageArray[n2].findData("lineno", class$java$lang$Integer != null ? class$java$lang$Integer : BreakpointDisplay.class$("java.lang.Integer"));
            if (string != null && n3 != null) {
                String string2 = MFilePathUtil.mFileToJavaPath(string);
                if (PlatformInfo.getPlatform() == 2 && string2.equals(this.fFile.getPath()) || PlatformInfo.getPlatform() != 2 && string2.equalsIgnoreCase(this.fFile.getPath())) {
                    this.fBreakList.removeElement(new Integer(n3 - 1));
                }
            }
            ++n2;
        }
        ((Component)((Object)this)).repaint(5L);
    }

    private void interestClearAllBreakpoints() {
        this.fBreakList.removeAllElements();
        ((Component)((Object)this)).repaint(5L);
    }

    private void handleInterest(Object object) {
        if (this.fListeningToMatlab) {
            MWMessage mWMessage = (MWMessage)object;
            Integer n = (Integer)mWMessage.findData("eventid", class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = BreakpointDisplay.class$("java.lang.Integer")));
            int n2 = n;
            if (n2 == 0x40000000) {
                this.interestClearAllBreakpoints();
                return;
            }
            if (n2 == Integer.MIN_VALUE) {
                MWMessage[] mWMessageArray = (MWMessage[])mWMessage.findData("result", class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = BreakpointDisplay.class$("java.lang.Object")));
                this.interestAddBreakpoints(mWMessageArray);
                return;
            }
            if (n2 == 0x20000000) {
                MWMessage[] mWMessageArray = (MWMessage[])mWMessage.findData("result", class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = BreakpointDisplay.class$("java.lang.Object")));
                this.interestDeleteBreakpoints(mWMessageArray);
            }
        }
    }

    private void resetBreakpoints() {
        if (this.fBreakList.size() > 0) {
            Vector vector = (Vector)this.fBreakList.clone();
            BreakpointCallback breakpointCallback = new BreakpointCallback(7);
            this.setBreakpoint((Integer)vector.elementAt(0), breakpointCallback);
            int n = 1;
            while (n < vector.size()) {
                this.setBreakpoint((Integer)vector.elementAt(n), null);
                ++n;
            }
            return;
        }
        this.fListeningToMatlab = true;
    }

    void listenToMatlab(boolean bl) {
        if (!bl) {
            this.fListeningToMatlab = false;
        }
        if (bl) {
            if (this.gimmeDebugFileName() != null) {
                this.fMatlab.eval("dbclear all '" + this.gimmeDebugFileName() + "' ", null, 512);
            }
            this.resetBreakpoints();
        }
    }

    public void clearBreakpoint(int n) {
        if (this.fMatlab != null) {
            if (!this.fListeningToMatlab) {
                this.fBreakList.removeElement(new Integer(n));
                ((Component)((Object)this)).repaint(5L);
                return;
            }
            this.fMatlab.evalConsoleOutput("dbclear '" + this.gimmeDebugFileName() + "' " + (n + 1));
        }
    }

    private void setBreakpoint(int n, CompletionObserver completionObserver) {
        this.fMatlab.evalConsoleOutput("dbstop '" + this.gimmeDebugFileName() + "' " + (n + 1), completionObserver);
    }

    public void setBreakpoint(int n) {
        if (this.fMatlab != null) {
            if (!this.fListeningToMatlab) {
                if (this.executableLineAt(n)) {
                    this.fBreakList.addElement(new Integer(n));
                    ((Component)((Object)this)).repaint(5L);
                    return;
                }
            } else {
                this.setBreakpoint(n, null);
            }
        }
    }

    public void clearAllBreakpoints() {
        if (!this.fListeningToMatlab) {
            this.fBreakList.removeAllElements();
            ((Component)((Object)this)).repaint(5L);
            return;
        }
        if (this.fMatlab != null) {
            this.fMatlab.evalConsoleOutput("dbclear all ");
        }
    }

    private boolean isErrorReply(String string) {
        if (string != null) {
            return string.length() > 3 && string.indexOf("???") == 0;
        }
        return true;
    }

    private void initBreakIfs(String string) {
        String string2 = "Break if error.";
        String string3 = "Break if warning.";
        String string4 = "Break if naninf.";
        if (this.isErrorReply(string)) {
            return;
        }
        if (string.length() > 0) {
            boolean bl = string.indexOf(string2) != -1;
            bl = string.indexOf(string3) != -1;
            bl = string.indexOf(string4) != -1;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void initBreakpoints(String var1_1) {
        block5: {
            if (this.fBreakList != null) {
                this.fBreakList.removeAllElements();
                this.repaint();
            }
            if (this.isErrorReply(var1_1)) {
                return;
            }
            var5_2 = var1_1.length();
            if (var5_2 <= 0) break block5;
            this.fBreakList.removeAllElements();
            var3_3 = 0;
            var6_4 = new char[256];
            ** GOTO lbl22
            {
                ++var3_3;
                do {
                    if (var3_3 < var5_2 - 1 && !Character.isDigit(var1_1.charAt(var3_3))) continue block0;
                    if (var3_3 >= var5_2 - 1) break block0;
                    var2_5 = 0;
                    while (Character.isDigit(var1_1.charAt(var3_3))) {
                        var6_4[var2_5++] = var1_1.charAt(var3_3++);
                    }
                    var4_6 = new Integer(new String(var6_4, 0, var2_5));
                    this.fBreakList.addElement(new Integer(var4_6 - 1));
lbl22:
                    // 2 sources

                } while (var3_3 < var5_2);
            }
            this.repaint(5L);
        }
    }

    private void getBreakpointList() {
        if (this.fMatlab != null) {
            String string = "mdbstatus ('" + this.gimmeDebugFileName() + "')";
            this.fMatlab.eval(string, (CompletionObserver)new BreakpointCallback(1), 512);
        }
    }

    public void setFile(File file) {
        this.fFile = file;
        if (this.fFile != null) {
            this.fAbsoluteFilename = EditorDocument.getFullPathname(file.getPath());
            this.getBreakpointList();
        } else {
            this.fAbsoluteFilename = null;
            this.fBreakList.removeAllElements();
        }
        ((Component)((Object)this)).repaint(5L);
    }

    BreakpointDisplay(MWTextComponent mWTextComponent, Matlab matlab) {
        this.fText = mWTextComponent;
        this.fMatlab = matlab;
        this.fTopLine = -1;
        this.fLineCount = 0;
        this.fBreakList = new Vector();
        this.fOffscreen = new Offscreen((Component)((Object)this));
        this.fMouser = new BreakpointMouser();
        ((Component)((Object)this)).addMouseListener(this.fMouser);
        ((Component)((Object)this)).addMouseMotionListener(this.fMouser);
        this.fClickLine = -1;
        this.setupMatlabAndInterests();
        this.fText.getModel().addTextListener((MWTextListener)new TextEventHandler());
        this.fText.getView().addTextViewListener((MWTextViewListener)new TextViewEventHandler());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ int access$5() {
        return 5;
    }

    static /* synthetic */ int access$7() {
        return 1;
    }

    static /* synthetic */ int access$9() {
        return 7;
    }

    static /* synthetic */ boolean access$10(BreakpointDisplay breakpointDisplay) {
        return breakpointDisplay.fListeningToMatlab;
    }

    class BreakpointMouser
    implements MouseListener,
    MouseMotionListener {
        public void mousePressed(MouseEvent mouseEvent) {
            int n = mouseEvent.getModifiers() == 16 ? BreakpointDisplay.this.pointToLineNo(mouseEvent.getPoint()) : -1;
            if (n == -1) {
                return;
            }
            if (BreakpointDisplay.this.executableLineAt(n)) {
                if (mouseEvent.isControlDown()) {
                    BreakpointDisplay.this.goUntil(n + 1);
                    return;
                }
                BreakpointDisplay.this.drawIntermediateBreakpointAt(n);
                BreakpointDisplay.this.fClickLine = n;
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (BreakpointDisplay.this.fClickLine == -1) {
                return;
            }
            int n = BreakpointDisplay.this.pointToLineNo(mouseEvent.getPoint());
            if (n == -1) {
                return;
            }
            if (n == BreakpointDisplay.this.fClickLine) {
                if (BreakpointDisplay.this.breakpointAt(n)) {
                    BreakpointDisplay.this.clearBreakpoint(n);
                } else {
                    BreakpointDisplay.this.setBreakpoint(n);
                }
            }
            ((Component)((Object)BreakpointDisplay.this)).repaint(5L);
            BreakpointDisplay.this.fClickLine = -1;
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n = BreakpointDisplay.this.pointToLineNo(mouseEvent.getPoint());
            if (n == -1) {
                return;
            }
            if (n != BreakpointDisplay.this.fClickLine) {
                if (BreakpointDisplay.this.breakpointAt(BreakpointDisplay.this.fClickLine)) {
                    BreakpointDisplay.this.drawBreakpointAt(BreakpointDisplay.this.fClickLine);
                    return;
                }
                BreakpointDisplay.this.drawExecutableMarkAt(BreakpointDisplay.this.fClickLine);
                return;
            }
            Rectangle rectangle = ((Component)((Object)BreakpointDisplay.this)).getBounds();
            rectangle.x = 0;
            rectangle.y = BreakpointDisplay.this.lineNoToY(n);
            rectangle.height = BreakpointDisplay.this.fText.getModel().getFontHeight();
            if (rectangle.contains(mouseEvent.getPoint())) {
                BreakpointDisplay.this.drawIntermediateBreakpointAt(n);
                return;
            }
            if (BreakpointDisplay.this.breakpointAt(n)) {
                BreakpointDisplay.this.drawBreakpointAt(n);
                return;
            }
            BreakpointDisplay.this.drawExecutableMarkAt(n);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        BreakpointMouser() {
            BreakpointDisplay.this = BreakpointDisplay.this;
        }
    }

    private class TextEventHandler
    extends MWTextAdapter {
        public void lineChange(MWTextEvent mWTextEvent) {
            BreakpointDisplay.this.adjustBreakpoints(mWTextEvent);
        }

        private int findFirstChar(int n) {
            MWTextModel mWTextModel = BreakpointDisplay.this.fText.getModel();
            int n2 = mWTextModel.getLineStart(n);
            int n3 = n2 + mWTextModel.getLineLengthNoEOL(n);
            while (n2 < n3 && Character.isWhitespace(mWTextModel.charAt(n2))) {
                ++n2;
            }
            return n2;
        }

        public void textInserted(MWTextEvent mWTextEvent) {
            int n = mWTextEvent.getMinLine();
            if (n == mWTextEvent.getMaxLine()) {
                int n2 = this.findFirstChar(n);
                if (n2 == mWTextEvent.getMinPos()) {
                    if (BreakpointDisplay.this.breakpointAt(n) && !BreakpointDisplay.this.executableLineAt(n)) {
                        BreakpointDisplay.this.fBreakList.removeElement(new Integer(n));
                    }
                    ((Component)((Object)BreakpointDisplay.this)).repaint(5L);
                    return;
                }
            } else {
                BreakpointDisplay.this.repaintAfterChange();
            }
        }

        public void textDeleted(MWTextEvent mWTextEvent) {
            int n = mWTextEvent.getMinLine();
            if (n == mWTextEvent.getMaxLine()) {
                int n2 = this.findFirstChar(n);
                if (n2 >= mWTextEvent.getMinPos()) {
                    if (BreakpointDisplay.this.breakpointAt(n) && !BreakpointDisplay.this.executableLineAt(n)) {
                        BreakpointDisplay.this.fBreakList.removeElement(new Integer(n));
                    }
                    ((Component)((Object)BreakpointDisplay.this)).repaint(5L);
                    return;
                }
            } else {
                BreakpointDisplay.this.repaintAfterChange();
            }
        }

        TextEventHandler() {
            BreakpointDisplay.this = BreakpointDisplay.this;
        }
    }

    private class TextViewEventHandler
    extends MWTextViewAdapter {
        public void topLineChanged(MWTextViewEvent mWTextViewEvent) {
            BreakpointDisplay.this.repaintAfterChange();
        }

        TextViewEventHandler() {
            BreakpointDisplay.this = BreakpointDisplay.this;
        }
    }

    class BreakpointDispatch
    implements CompletionObserver {
        public void completed(int n, Object object) {
            int n2 = 0;
            while (n2 < sInterests.size()) {
                CompletionObserver completionObserver = (CompletionObserver)sInterests.elementAt(n2);
                completionObserver.completed(n, object);
                ++n2;
            }
        }

        BreakpointDispatch() {
            BreakpointDisplay.this = BreakpointDisplay.this;
        }
    }

    class BreakpointCallback
    implements CompletionObserver {
        int fReplyType;

        public BreakpointCallback(int n) {
            BreakpointDisplay.this = BreakpointDisplay.this;
            this.fReplyType = n;
        }

        public void completed(int n, Object object) {
            if (this.fReplyType == BreakpointDisplay.access$5()) {
                BreakpointDisplay.this.handleInterest(object);
                return;
            }
            if (this.fReplyType == BreakpointDisplay.access$7()) {
                BreakpointDisplay.this.initBreakpoints((String)object);
                return;
            }
            if (this.fReplyType == BreakpointDisplay.access$9() && Matlab.getExecutionStatus((int)n) == 0) {
                BreakpointDisplay.this.fBreakList.removeAllElements();
                BreakpointDisplay.this.fListeningToMatlab = true;
            }
        }
    }
}

