/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.desktop;

import com.mathworks.mwt.window.MWWindowOwner;
import com.mathworks.mwt.window.WindowRegistry;
import com.mathworks.util.IntHashtable;
import com.mathworks.util.NativeJava;
import java.util.ResourceBundle;

public class MLNativeWindow
implements MWWindowOwner {
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.ide.desktop.resources.RES_Desktop");
    private static final int MAX_FIGURES = 100;
    public int fHWND;
    private String fLongName;
    private static IntHashtable sMLNativeWindowTable = new IntHashtable(100);

    public MLNativeWindow(int n) {
        this.fHWND = n;
        MLNativeWindow.addToMLNativeWindowTable(this, n);
        this.fLongName = NativeJava.getWindowTitle((int)n);
        if (this.fLongName == null || this.fLongName.equals("")) {
            this.fLongName = sRes.getString("native.Untitled");
        }
        WindowRegistry.getRegistry().register((MWWindowOwner)this);
    }

    public synchronized void destroyWindow(int n) {
        MLNativeWindow.removeFromMLNativeWindowTable(n);
        WindowRegistry.getRegistry().unregister((MWWindowOwner)this);
    }

    public int closeWindow() {
        NativeJava.destroywindow((int)this.fHWND);
        return 0;
    }

    public void setActive(boolean bl) {
    }

    public String getShortName() {
        return this.fLongName;
    }

    public String getLongName() {
        return this.fLongName;
    }

    public void setLongName(String string) {
        this.fLongName = string;
        if (this.fLongName == null || this.fLongName.equals("")) {
            this.fLongName = sRes.getString("native.Untitled");
        }
        WindowRegistry.getRegistry().nameChange((MWWindowOwner)this);
    }

    private static void addToMLNativeWindowTable(MWWindowOwner mWWindowOwner, int n) {
        sMLNativeWindowTable.put(n, (Object)mWWindowOwner);
    }

    private static void removeFromMLNativeWindowTable(int n) {
        sMLNativeWindowTable.remove(n);
    }

    public static MWWindowOwner WindowOwnerFromHWND(int n) {
        return (MWWindowOwner)sMLNativeWindowTable.get(n);
    }
}

