/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.desktop;

import com.mathworks.ide.desktop.DTClient;
import com.mathworks.ide.desktop.DTExternalFrame;
import com.mathworks.ide.desktop.DTMainFrame;
import com.mathworks.ide.desktop.DTMenuBar;
import com.mathworks.ide.desktop.MLDesktop;
import com.mathworks.ide.desktop.MenuUtils;
import com.mathworks.ide.editor.EditorCommand;
import com.mathworks.ide.help.HelpBrowser;
import com.mathworks.ide.widgets.CwdDisplayPanel;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwt.MWButton;
import com.mathworks.mwt.MWFocusChain;
import com.mathworks.mwt.MWMenu;
import com.mathworks.mwt.MWMenuComponent;
import com.mathworks.mwt.MWToolbar;
import com.mathworks.mwt.command.MWCommandCenter;
import com.mathworks.mwt.message.MWLooper;
import com.mathworks.mwt.window.WindowRegistry;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;

public class MLMainFrame
extends DTMainFrame {
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.ide.desktop.resources.RES_Desktop");
    protected Matlab fMatlab = new Matlab(new MWLooper("MLMainFrame"));
    private String fStatusMsg = sRes.getString("status.WaitingForMATLAB");
    protected DesktopCwdDisplayPanel fCwdDisplayPanel;

    public MLMainFrame(MLDesktop mLDesktop, String string) {
        super(mLDesktop, string);
        super.setStatusText(this.fStatusMsg);
        Object[] objectArray = new Object[]{"simulink"};
        this.fMatlab.feval("exist", objectArray, (CompletionObserver)new SimulinkAvailableObserver());
    }

    void pingMatlab() {
        this.fMatlab.eval("", (CompletionObserver)new 1());
    }

    public void setStatusText(String string) {
        String string2 = sRes.getString("status.Ready");
        if (string.equals(string2)) {
            super.setStatusText(this.fStatusMsg);
            return;
        }
        super.setStatusText(string);
    }

    public void shutdownFrame() {
        this.fCwdDisplayPanel.getCwdDisplay().saveCwdHistory();
    }

    public int closeWindow() {
        int n = 0;
        MLDesktop mLDesktop = (MLDesktop)this.fDesktop;
        mLDesktop.saveDesktop(null, null);
        n = WindowRegistry.getRegistry().closeAllWindows();
        if (n == 0 && (n = this.fDesktop.getDockManager().terminateNotify()) == 0) {
            this.shutdownFrame();
            mLDesktop.setSaveDesktop(false);
            this.fMatlab.evalConsoleOutput("quit");
        }
        return 1;
    }

    public void activeClientChanged(DTClient dTClient) {
        super.activeClientChanged(dTClient);
        this.fCenter.setCommandEnabled(2010, dTClient != null);
        this.fCenter.setCommandEnabled(135, dTClient != null);
    }

    public void doCommand(int n) {
        if (this.fCenter.getCommandEnabled(n)) {
            switch (n) {
                case 2010: {
                    DTClient dTClient = this.fDTContainer.getActiveClient();
                    if (dTClient == null) break;
                    dTClient.moveOutOfDesktop();
                    return;
                }
                case 70: {
                    ((Window)((Object)this)).setCursor(Cursor.getPredefinedCursor(3));
                    this.fMatlab.evalConsoleOutput("simulink", (CompletionObserver)new SimulinkLaunchObserver());
                    return;
                }
                case 4050: {
                    HelpBrowser.getHelpBrowser().displayTopic(null, "matlab_env", "matlabenvironment_desktop", this.fDTContainer.getFrame());
                    return;
                }
                default: {
                    super.doCommand(n);
                    return;
                }
            }
        }
    }

    protected MWToolbar createToolbar() {
        MWToolbar mWToolbar = new MWToolbar();
        MWButton mWButton = mWToolbar.addImageButton("/com/mathworks/mwt/resources/new.gif", 100, sRes.getString("toolbar.NewMFile"), this.fCenter);
        mWButton.setName("New M-file");
        MWButton mWButton2 = mWToolbar.addImageButton("/com/mathworks/mwt/resources/open.gif", 130, sRes.getString("toolbar.OpenFile"), this.fCenter);
        mWButton2.setName("Open file");
        mWToolbar.addSpacer();
        this.fCutButton = mWToolbar.addImageButton("/com/mathworks/mwt/resources/cut.gif", 900, sRes.getString("toolbar.Cut"));
        this.fCutButton.setName("Cut");
        this.fCutButton.setEnabled(false);
        this.fCopyButton = mWToolbar.addImageButton("/com/mathworks/mwt/resources/copy.gif", 910, sRes.getString("toolbar.Copy"));
        this.fCopyButton.setName("Copy");
        this.fCopyButton.setEnabled(false);
        this.fPasteButton = mWToolbar.addImageButton("/com/mathworks/mwt/resources/paste.gif", 920, sRes.getString("toolbar.Paste"));
        this.fPasteButton.setName("Paste");
        this.fPasteButton.setEnabled(false);
        this.fUndoButton = mWToolbar.addImageButton("/com/mathworks/mwt/resources/undo.gif", 800, sRes.getString("toolbar.Undo"));
        this.fUndoButton.setName("Undo");
        this.fUndoButton.setEnabled(false);
        this.fRedoButton = mWToolbar.addImageButton("/com/mathworks/mwt/resources/redo.gif", 810, sRes.getString("toolbar.Redo"));
        this.fRedoButton.setName("Redo");
        this.fRedoButton.setEnabled(false);
        mWToolbar.addSpacer();
        MWButton mWButton3 = mWToolbar.addImageButton("/com/mathworks/ide/desktop/resources/SimulinkIcon1Color16.gif", 70, sRes.getString("toolbar.Simulink"), this.fCenter);
        mWButton3.setName("Simulink");
        mWToolbar.addSpacer();
        MWButton mWButton4 = mWToolbar.addImageButton("/com/mathworks/mwt/resources/help.gif", 4000, sRes.getString("toolbar.Help"), this.fCenter);
        mWButton4.setName("Help");
        mWToolbar.addSpacer();
        this.fCwdDisplayPanel = new DesktopCwdDisplayPanel(true);
        mWToolbar.addComponent((Component)((Object)this.fCwdDisplayPanel));
        return mWToolbar;
    }

    public static MWMenu AddNewMenu(MWCommandCenter mWCommandCenter, MWMenu mWMenu, boolean bl) {
        MWMenu mWMenu2 = new MWMenu(sRes.getString("menuitem.New"));
        if (bl) {
            MenuUtils.addMenuItem(mWCommandCenter, mWMenu2, sRes.getString("menuitem.Mfile"), 100, EditorCommand.getKbdAcc(1, 100));
        } else {
            MenuUtils.addMenuItem(mWCommandCenter, mWMenu2, sRes.getString("menuitem.Mfile"), 100, -1);
        }
        MenuUtils.addMenuItem(mWCommandCenter, mWMenu2, sRes.getString("menuitem.Figure"), 110, -1);
        MenuUtils.addMenuItem(mWCommandCenter, mWMenu2, sRes.getString("menuitem.Model"), 120, -1);
        if (mWMenu != null) {
            mWMenu.add((MWMenuComponent)mWMenu2);
        }
        return mWMenu2;
    }

    private final class 1
    implements CompletionObserver {
        public void completed(int n, Object object) {
            MLMainFrame.this.fStatusMsg = sRes.getString("status.Ready");
            MLMainFrame.this.setStatusText(MLMainFrame.this.fStatusMsg);
            if (MLMainFrame.this.fDesktopMenuBar != null) {
                DTMenuBar.setMatlabReady();
            }
        }

        /* synthetic */ 1() {
        }
    }

    private class DesktopCwdDisplayPanel
    extends CwdDisplayPanel
    implements MWFocusChain {
        public DesktopCwdDisplayPanel(boolean bl) {
            super(bl);
            MLMainFrame.this = MLMainFrame.this;
        }

        public void focusEvent(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary() && focusEvent.getID() == 1004) {
                DTExternalFrame dTExternalFrame;
                DTClient dTClient;
                Container container = ((Component)((Object)this)).getParent();
                while (container != null && !(container instanceof DTExternalFrame)) {
                    container = container.getParent();
                }
                if (container != null && (dTClient = (dTExternalFrame = (DTExternalFrame)((Object)container)).getDTContainer().getActiveClient()) != null) {
                    dTExternalFrame.getDTContainer().setActiveClient(null);
                    dTExternalFrame.restoreMenuBar(null);
                    this.mergeMenus(dTExternalFrame.fDesktopMenuBar.getMenubar());
                }
            }
        }

        public void focusSwitch(KeyEvent keyEvent) {
        }

        public void focusMousePressed(MouseEvent mouseEvent) {
        }
    }

    private class SimulinkLaunchObserver
    implements CompletionObserver {
        public void completed(int n, Object object) {
            ((Window)((Object)MLMainFrame.this)).setCursor(Cursor.getDefaultCursor());
        }

        SimulinkLaunchObserver() {
            MLMainFrame.this = MLMainFrame.this;
        }
    }

    private class SimulinkAvailableObserver
    implements CompletionObserver {
        public void completed(int n, Object object) {
            if (Matlab.getExecutionStatus((int)n) == 0 && object instanceof double[]) {
                double[] dArray = (double[])object;
                boolean bl = dArray.length == 1 && dArray[0] == 5.0;
                MLMainFrame.this.fCenter.setCommandEnabled(70, bl);
                MLMainFrame.this.fDesktopMenuBar.getCommandCenter().setCommandEnabled(120, bl);
            }
        }

        SimulinkAvailableObserver() {
            MLMainFrame.this = MLMainFrame.this;
        }
    }
}

