/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.desktop;

import com.mathworks.ide.editor.EditorApplication;
import com.mathworks.ide.prefs.GeneralPrefsColorPanel;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwt.MWImageResource;
import com.mathworks.mwt.MWMenu;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.MWTreeView;
import com.mathworks.mwt.command.MWCommandCenter;
import com.mathworks.mwt.command.MWCommandTarget;
import com.mathworks.mwt.message.MWLooper;
import com.mathworks.mwt.table.LabeledImageResource;
import com.mathworks.mwt.table.TreeData;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ResourceBundle;
import java.util.Vector;

public class MLExplorer
extends MWPanel
implements MWCommandTarget {
    private static final ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.ide.desktop.resources.RES_MLExplorer");
    private static final String sMLImagePath = "$toolbox/matlab/general/matlabicon.gif";
    private static final String sSLImagePath = "$toolbox/simulink/simulink/simulinkicon.gif";
    private static final String sStateflowImagePath = "$toolbox/stateflow/stateflow/stateflowicon.gif";
    private static final String sHelpImagePath = "$toolbox/matlab/general/helpicon.gif";
    private static final String sFigureImagePath = "$toolbox/matlab/general/figureicon.gif";
    private static final String sDemoImagePath = "$toolbox/matlab/general/demoicon.gif";
    private static final String sUnknownImagePath = "$toolbox/matlab/general/unknownicon.gif";
    private static final int EDIT = 1;
    private static final int REFRESH = 2;
    private static MLExplorer sm = null;
    private Matlab fMatlab;
    private MWTreeView fTree;
    private Vector fCallbackVector;
    private int fMatlabRootItem;
    private int fSimulinkRootItem;
    private int fStateflowRootItem;
    private int fUserRootItem;
    private String fMatlabRoot = Matlab.matlabRoot();
    private Vector fXmlFileVector;
    private Vector[] fSortedVectors = new Vector[3];
    private int fTempInfoItemID;
    private MWMenu fPopupMenu;
    private MWCommandCenter fCenter;

    public MLExplorer() {
        if (sm == null) {
            this.fMatlab = new Matlab(new MWLooper("MLExplorer- for Launch Pad"));
            sm = this;
        }
        this.fCenter = new MWCommandCenter((MWCommandTarget)this);
        ((Container)((Object)this)).setLayout(new BorderLayout());
        Prefs.addListener((PrefListener)new FontChangeListener(), (String)"GeneralFont");
        this.populate();
    }

    private void populate() {
        this.fTree = new MWTreeView();
        this.createPopupMenu();
        this.fTree.addKeyListener(new ExplorerKeyListener());
        this.fTree.addMouseListener(new ExplorerMouseAdapter());
        this.fTree.setContextTriggerAware(true);
        this.fCallbackVector = new Vector();
        this.fTree.setFont(GeneralPrefsColorPanel.getDesktopFont());
        ((Container)((Object)this)).add((Component)this.fTree, "Center");
        ((Container)((Object)this)).invalidate();
        ((Container)((Object)this)).validate();
        this.fMatlabRootItem = 0;
        this.fSimulinkRootItem = 0;
        this.fStateflowRootItem = 0;
        this.fUserRootItem = 0;
        this.fXmlFileVector = new Vector();
        this.fTree.setShowRootlines(false);
        this.fTempInfoItemID = this.fTree.addItem(-1, (Object)sRes.getString("msg.WaitingforMATLAB"), true);
        if (this.fMatlabRoot == null) {
            this.fMatlabRoot = "";
        }
        this.fMatlab.eval("which -all info.xml", (CompletionObserver)new WhichAllCallback());
    }

    public static void refresh() {
        if (sm == null) {
            sm = new MLExplorer();
            return;
        }
        ((Container)((Object)sm)).remove((Component)MLExplorer.sm.fTree);
        MLExplorer.sm.fTree = null;
        sm.populate();
    }

    public void requestFocus() {
        this.fTree.requestFocus();
    }

    public static Object getMLExplorer() {
        return sm;
    }

    public void buildIndex(File file) {
        BufferedReader bufferedReader = null;
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
            bufferedReader = new BufferedReader(fileReader);
        }
        catch (FileNotFoundException fileNotFoundException) {}
        if (bufferedReader != null) {
            try {
                this.sortInputFiles(bufferedReader, file.getAbsolutePath());
                bufferedReader.close();
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }
    }

    private void sortInputFiles(BufferedReader bufferedReader, String string) {
        String string2 = null;
        try {
            String string3 = "<Product Name>";
            String string4 = "matlab";
            while ((string2 = bufferedReader.readLine()) != null && !string2.startsWith("<list>")) {
                if ((string2 = string2.trim()).startsWith("<name>")) {
                    string3 = this.getItem(string2, "name");
                    continue;
                }
                if (!string2.startsWith("<area>")) continue;
                string4 = this.getItem(string2, "area");
            }
            if (string4.equals("matlab")) {
                this.addToSortedVector(0, "MATLAB", string3, string);
                return;
            }
            if (string4.equals("simulink")) {
                this.addToSortedVector(1, "Simulink", string3, string);
                return;
            }
            if (string4.equals("stateflow")) {
                this.addToSortedVector(2, "Stateflow", string3, string);
                return;
            }
        }
        catch (IOException iOException) {}
    }

    private void addToSortedVector(int n, String string, String string2, String string3) {
        IndexFileObject indexFileObject = new IndexFileObject(string2, string3);
        if (string2.equals(string)) {
            this.fSortedVectors[n].insertElementAt(indexFileObject, 0);
            return;
        }
        boolean bl = false;
        int n2 = 0;
        while (n2 < this.fSortedVectors[n].size()) {
            String string4 = ((IndexFileObject)this.fSortedVectors[n].elementAt(n2)).getName();
            if (string4.compareTo(string2) > 0 && !string4.equals(string)) {
                this.fSortedVectors[n].insertElementAt(indexFileObject, n2);
                bl = true;
                break;
            }
            ++n2;
        }
        if (!bl) {
            this.fSortedVectors[n].addElement(indexFileObject);
        }
    }

    public void buildProductTree(File file) {
        BufferedReader bufferedReader = null;
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
            bufferedReader = new BufferedReader(fileReader);
        }
        catch (FileNotFoundException fileNotFoundException) {}
        if (bufferedReader != null) {
            try {
                this.buildIndexFromFile(bufferedReader, file.getParent());
                bufferedReader.close();
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void buildIndexFromFile(BufferedReader bufferedReader, String string) {
        String string2 = null;
        try {
            block20: {
                Image image;
                int n;
                String string3;
                int n2;
                String string4;
                block19: {
                    String string5 = "<Product Name>";
                    String string6 = "matlab";
                    string4 = "<Icon>";
                    n2 = -1;
                    string3 = StringUtils.fromJavaPath((String)(String.valueOf(string) + "/info.xml"));
                    n = 0;
                    while ((string2 = bufferedReader.readLine()) != null && !string2.startsWith("<list>")) {
                        if ((string2 = string2.trim()).startsWith("<name>")) {
                            string5 = this.getItem(string2, "name");
                        } else if (string2.startsWith("<area>")) {
                            string6 = this.getItem(string2, "area");
                        } else if (string2.startsWith("<icon>")) {
                            string4 = this.getItem(string2, "icon");
                        }
                        ++n;
                    }
                    image = this.loadMyImage(string, string4);
                    if (image == null) {
                        image = this.loadMyImage(string, sMLImagePath);
                    }
                    n2 = this.fTree.addItem(-1, (Object)new LabeledImageResource(image, string5), true);
                    this.fCallbackVector.addElement(new ItemCallbackData(n2, null, string3, 0));
                    if (!string2.startsWith("<list>")) return;
                    if (!true) break block19;
                    string2 = bufferedReader.readLine();
                    if (string2 == null) return;
                    if (string2.startsWith("</list>")) break block20;
                }
                do {
                    if ((string2 = string2.trim()).startsWith("<listitem>")) {
                        String string7 = "<Label>";
                        String string8 = "<Callback>";
                        string4 = "<Icon>";
                        while ((string2 = bufferedReader.readLine()) != null && !string2.startsWith("</listitem>")) {
                            if (string2.startsWith("<label>")) {
                                string7 = this.getItem(string2, "label");
                            } else if (string2.startsWith("<callback>")) {
                                string8 = this.getItem(string2, "callback");
                            } else if (string2.startsWith("<icon>")) {
                                string4 = this.getItem(string2, "icon");
                            }
                            ++n;
                        }
                        image = this.loadMyImage(string, string4);
                        if (image == null) {
                            image = this.loadMyImage(string, sUnknownImagePath);
                        }
                        int n3 = this.fTree.addItem(n2, (Object)new LabeledImageResource(image, string7), true);
                        this.fCallbackVector.addElement(new ItemCallbackData(n3, string8, string3, n));
                        ++n;
                    }
                    ++n;
                    string2 = bufferedReader.readLine();
                    if (string2 == null) return;
                } while (!string2.startsWith("</list>"));
            }
            return;
        }
        catch (IOException iOException) {}
    }

    private Image loadMyImage(String string, String string2) {
        File file;
        if (string2.startsWith("$toolbox")) {
            string2 = String.valueOf(this.fMatlabRoot) + string2.replace('$', '/');
        } else {
            file = new File(string2);
            if (!file.exists()) {
                string2 = String.valueOf(string) + "/" + string2;
            }
        }
        file = new MWImageResource(string2);
        return file.getImage();
    }

    public void doCommand(int n) {
        boolean bl = true;
        if (this.fCenter.getCommandEnabled(n)) {
            switch (n) {
                case -102: {
                    this.executeCommand();
                    return;
                }
                case 1: {
                    this.doEdit();
                    return;
                }
                case 2: {
                    MLExplorer.refresh();
                    return;
                }
            }
            bl = false;
            return;
        }
    }

    private void executeCommand() {
        int n = this.fTree.getFirstSelectedRow();
        if (n < 0) {
            return;
        }
        int n2 = this.fTree.getItemId(n);
        int[] nArray = this.fTree.getChildren(n2);
        if (nArray.length > 0) {
            TreeData treeData = this.fTree.getTreeData();
            if (treeData.isExpanded(n2)) {
                treeData.collapseItem(n2);
                return;
            }
            treeData.expandItem(n2);
            return;
        }
        ItemCallbackData itemCallbackData = this.findItemData(n2);
        if (itemCallbackData != null) {
            ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(3));
            this.fMatlab.evalConsoleOutput(itemCallbackData.getCallback(), (CompletionObserver)new ExplorerCompletionObserver());
        }
    }

    private void doEdit() {
        int n = this.fTree.getFirstSelectedRow();
        if (n < 0) {
            return;
        }
        ItemCallbackData itemCallbackData = this.findItemData(this.fTree.getItemId(n));
        if (itemCallbackData != null) {
            int n2 = itemCallbackData.getLineNumber();
            EditorApplication.openDocumentToLine(itemCallbackData.getFilename(), n2, true, n2 != 0);
        }
    }

    private ItemCallbackData findItemData(int n) {
        int n2 = 0;
        while (n2 < this.fCallbackVector.size()) {
            ItemCallbackData itemCallbackData = (ItemCallbackData)this.fCallbackVector.elementAt(n2);
            if (itemCallbackData.getItemID() == n) {
                return itemCallbackData;
            }
            ++n2;
        }
        return null;
    }

    private void createPopupMenu() {
        this.fPopupMenu = new MWMenu("", this.fCenter);
        this.fPopupMenu.addMenuItem(sRes.getString("action.Open"), -102);
        this.fPopupMenu.addMenuItem(sRes.getString("action.EditSource"), 1);
        this.fPopupMenu.addSeparator();
        this.fPopupMenu.addMenuItem(sRes.getString("action.Refresh"), 2);
        this.fPopupMenu.attachTo((Component)this.fTree);
    }

    private String getItem(String string, String string2) {
        String string3 = "<" + string2 + ">";
        int n = string.indexOf(string3) + string3.length();
        int n2 = string.indexOf("</" + string2 + ">", n);
        return string.substring(n, n2);
    }

    private class FontChangeListener
    implements PrefListener {
        public void prefChanged(PrefEvent prefEvent) {
            if (prefEvent.getEventType() == 1) {
                MLExplorer.this.fTree.setFont(GeneralPrefsColorPanel.getDesktopFont());
                ((Component)((Object)MLExplorer.this)).repaint();
            }
        }

        FontChangeListener() {
            MLExplorer.this = MLExplorer.this;
        }
    }

    private class WhichAllCallback
    implements CompletionObserver {
        public WhichAllCallback() {
            MLExplorer.this = MLExplorer.this;
        }

        public void completed(int n, Object object) {
            Object object2;
            if (object == null) {
                return;
            }
            MLExplorer.this.fTree.removeItem(MLExplorer.this.fTempInfoItemID);
            MLExplorer.this.fTempInfoItemID = MLExplorer.this.fTree.addItem(-1, (Object)sRes.getString("msg.LoadingData"), true);
            String string = (String)object;
            int n2 = 0;
            int n3 = 0;
            while (n3 < string.length()) {
                if (string.charAt(n3) == '\n') {
                    object2 = string.substring(n2, n3);
                    char c = '%';
                    int n4 = n2 + 1;
                    while (n4 < n3) {
                        if (string.charAt(n4) == c) break;
                        ++n4;
                    }
                    object2 = string.substring(n2, n4);
                    object2 = StringUtils.getLocalizedFilename((String)object2);
                    MLExplorer.this.fXmlFileVector.addElement(((String)object2).trim());
                    n2 = n3 + 1;
                }
                ++n3;
            }
            object2 = new ReadInfoFilesThread();
            ((Thread)object2).start();
        }
    }

    private class ReadInfoFilesThread
    extends Thread {
        ReadInfoFilesThread() {
            MLExplorer.this = MLExplorer.this;
        }

        public void run() {
            ((MLExplorer)MLExplorer.this).fSortedVectors[0] = new Vector();
            ((MLExplorer)MLExplorer.this).fSortedVectors[1] = new Vector();
            ((MLExplorer)MLExplorer.this).fSortedVectors[2] = new Vector();
            int n = 0;
            while (n < MLExplorer.this.fXmlFileVector.size()) {
                String string = (String)MLExplorer.this.fXmlFileVector.elementAt(n);
                File file = new File(string);
                MLExplorer.this.buildIndex(file);
                ++n;
            }
            MLExplorer.this.fTree.removeItem(MLExplorer.this.fTempInfoItemID);
            MLExplorer.this.fTree.setShowRootlines(true);
            int n2 = 0;
            while (n2 < 3) {
                int n3 = 0;
                while (n3 < MLExplorer.this.fSortedVectors[n2].size()) {
                    IndexFileObject indexFileObject = (IndexFileObject)MLExplorer.this.fSortedVectors[n2].elementAt(n3);
                    String string = indexFileObject.getFilename();
                    File file = new File(string);
                    MLExplorer.this.buildProductTree(file);
                    ++n3;
                }
                ++n2;
            }
        }
    }

    private class IndexFileObject {
        private String fName;
        private String fFilename;

        IndexFileObject(String string, String string2) {
            MLExplorer.this = MLExplorer.this;
            this.fName = string;
            this.fFilename = string2;
        }

        public String getName() {
            return this.fName;
        }

        public String getFilename() {
            return this.fFilename;
        }
    }

    private class ItemCallbackData {
        private int fItemID;
        private String fCallback;
        private String fFilename;
        private int fLineNumber;

        ItemCallbackData(int n, String string, String string2, int n2) {
            MLExplorer.this = MLExplorer.this;
            this.fItemID = n;
            this.fCallback = string;
            this.fFilename = string2;
            this.fLineNumber = n2;
        }

        public String getCallback() {
            return this.fCallback;
        }

        public String getFilename() {
            return this.fFilename;
        }

        public int getItemID() {
            return this.fItemID;
        }

        public int getLineNumber() {
            return this.fLineNumber;
        }
    }

    class ExplorerKeyListener
    extends KeyAdapter {
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                MLExplorer.this.executeCommand();
            }
        }

        ExplorerKeyListener() {
            MLExplorer.this = MLExplorer.this;
        }
    }

    private class ExplorerMouseAdapter
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            if (PlatformInfo.getPlatform() == 2) {
                this.doStuff(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (PlatformInfo.getPlatform() != 2) {
                this.doStuff(mouseEvent);
            }
        }

        public void doStuff(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                int n = MLExplorer.this.fTree.getFirstSelectedRow();
                if (n < 0) {
                    return;
                }
                int n2 = MLExplorer.this.fTree.getItemId(n);
                int[] nArray = MLExplorer.this.fTree.getChildren(n2);
                if (nArray.length > 0 && MLExplorer.this.fTree.getTreeData().isExpanded(n2)) {
                    MLExplorer.this.fPopupMenu.getItem(0).setLabel(sRes.getString("action.Close"));
                } else {
                    MLExplorer.this.fPopupMenu.getItem(0).setLabel(sRes.getString("action.Open"));
                }
                MLExplorer.this.fPopupMenu.show((Component)MLExplorer.this.fTree, mouseEvent.getX(), mouseEvent.getY());
                return;
            }
            if (mouseEvent.getClickCount() == 2) {
                MLExplorer.this.executeCommand();
            }
        }

        ExplorerMouseAdapter() {
            MLExplorer.this = MLExplorer.this;
        }
    }

    private class ExplorerItem {
        String fLabel;
        String fCallback;
        int fID;
        int fImage;

        public ExplorerItem(String string, String string2, int n, int n2) {
            MLExplorer.this = MLExplorer.this;
            this.fLabel = string;
            this.fCallback = string2;
            this.fID = n2;
            this.fImage = n;
        }

        public String getLabel() {
            return this.fLabel;
        }

        public String getCallback() {
            return this.fCallback;
        }

        public int getID() {
            return this.fID;
        }

        public int getImage() {
            return this.fImage;
        }
    }

    private class ExplorerCompletionObserver
    implements CompletionObserver {
        public ExplorerCompletionObserver() {
            MLExplorer.this = MLExplorer.this;
        }

        public void completed(int n, Object object) {
            ((Component)((Object)MLExplorer.this)).setCursor(Cursor.getDefaultCursor());
        }
    }
}

