/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.desktop;

import com.mathworks.ide.CommandHistory;
import com.mathworks.ide.browsers.FileBrowser;
import com.mathworks.ide.desktop.DTClient;
import com.mathworks.ide.desktop.DTClientFrame;
import com.mathworks.ide.desktop.DTDockPath;
import com.mathworks.ide.desktop.DTMainFrame;
import com.mathworks.ide.desktop.Desktop;
import com.mathworks.ide.desktop.MLExplorer;
import com.mathworks.ide.desktop.MLMainFrame;
import com.mathworks.ide.help.HelpBrowser;
import com.mathworks.ide.widgets.MatlabCommandWidget;
import com.mathworks.ide.workspace.WorkspaceBrowser;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.services.Prefs;
import com.mathworks.util.NativeJava;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.QueueEvent;
import com.mathworks.util.RemoteLogClient;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.ResourceBundle;

public class MLDesktop
extends Desktop {
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.ide.desktop.resources.RES_Desktop");
    private static MLDesktop sMLDesktop = null;
    private static boolean bRestored;
    private static final int sVersion = 17;
    private MLMainFrame fMainFrame;
    private static MatlabCommandWidget fCommandWidget;
    private static CommandHistory fCommandHistory;
    private static HelpBrowser fHelpBrowser;
    private static FileBrowser fFileBrowser;
    private static WorkspaceBrowser fWorkspace;
    private static MLExplorer fExplorer;
    private static Dimension commandSize;
    private static Dimension historySize;
    private static Dimension helpSize;
    private static Dimension directorySize;
    private static Dimension workspaceSize;
    private static Dimension launchpadSize;
    private boolean bSaveDesktop = true;

    public MLDesktop(boolean bl) {
        this(sRes.getString("MATLAB"), bl);
    }

    public MLDesktop(String string, boolean bl) {
        super(string, bl);
        bRestored = true;
        if (this.fMainFrame != null) {
            this.fMainFrame.pingMatlab();
        }
        if (PlatformInfo.isBlackdownVM()) {
            QueueEvent.postQueueEvent((QueueEvent)new DesktopQueueEvent());
        } else {
            this.showClient(MLDesktop.getCommandWindowName());
        }
        RemoteLogClient.desktopStarted();
    }

    public void setDesktop() throws Exception {
        if (sMLDesktop != null) {
            throw new Exception(sRes.getString("error.OnlyOneMLDesktop"));
        }
        sMLDesktop = this;
    }

    private void determineDefaultComponentSizes() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        commandSize = new Dimension(dimension.width / 2, (int)((double)dimension.height * 0.4));
        historySize = new Dimension((int)((double)dimension.width * 0.31), (int)((double)dimension.height * 0.34));
        helpSize = new Dimension(200, 325);
        directorySize = new Dimension((int)((double)dimension.width * 0.31), (int)((double)dimension.height * 0.29));
        workspaceSize = new Dimension((int)((double)dimension.width * 0.31), (int)((double)dimension.height * 0.24));
        launchpadSize = new Dimension((int)((double)dimension.width * 0.15), (int)((double)dimension.height * 0.34));
    }

    public void setDefaultDesktop() {
        if (this.clearDesktop() == 0) {
            DTClient dTClient = null;
            DTClient dTClient2 = null;
            DTClient dTClient3 = null;
            DTClient dTClient4 = null;
            DTClient dTClient5 = null;
            this.setDefaultMainFrameSize();
            this.determineDefaultComponentSizes();
            dTClient = this.addCommandWindow();
            dTClient2 = this.addCommandHistory(new DTDockPath("WS"));
            dTClient4 = this.addFileBrowser(new DTDockPath("WS"));
            dTClient5 = this.addWorkspaceBrowser(new DTDockPath("WN"));
            dTClient3 = this.addProductExplorer(new DTDockPath("WN"));
            this.addHelpBrowser(new DTDockPath(null));
            dTClient.restore(false);
            dTClient2.restore(false);
            dTClient3.restore(false);
            dTClient4.restore(false);
            dTClient5.restore(false);
            this.fDTMainFrame.restoreMenuBar(dTClient);
            DTClientFrame dTClientFrame = null;
            dTClientFrame = dTClient3.getClientFrame();
            if (dTClientFrame != null) {
                dTClientFrame.showClient(dTClient3, false);
            }
            if ((dTClientFrame = dTClient2.getClientFrame()) != null) {
                dTClientFrame.showClient(dTClient2, false);
            }
            if ((dTClientFrame = dTClient.getClientFrame()) != null) {
                dTClientFrame.showClient(dTClient, false);
            }
            dTClient.activate();
            this.setStatusText(sRes.getString("status.Ready"));
        }
    }

    public void setMolerMode() {
        if (this.clearDesktop() == 0) {
            DTClient dTClient = null;
            this.determineDefaultComponentSizes();
            dTClient = this.addCommandWindow();
            this.addCommandHistory(new DTDockPath("WS"));
            this.addFileBrowser(new DTDockPath("WS"));
            this.addWorkspaceBrowser(new DTDockPath("WN"));
            this.addProductExplorer(new DTDockPath("WN"));
            this.addHelpBrowser(new DTDockPath(null));
            dTClient.restore(false);
            this.fDTMainFrame.restoreMenuBar(dTClient);
            dTClient.activate();
            this.setStatusText(sRes.getString("status.Ready"));
        }
    }

    public void setSimpleLayout() {
        if (this.clearDesktop() == 0) {
            DTClient dTClient = null;
            DTClient dTClient2 = null;
            this.determineDefaultComponentSizes();
            dTClient = this.addCommandWindow();
            dTClient2 = this.addCommandHistory(new DTDockPath("WS"));
            this.addFileBrowser(new DTDockPath("WS"));
            this.addWorkspaceBrowser(new DTDockPath("WN"));
            this.addProductExplorer(new DTDockPath("WN"));
            this.addHelpBrowser(new DTDockPath(null));
            dTClient.restore(false);
            dTClient2.restore(false);
            this.fDTMainFrame.restoreMenuBar(dTClient);
            dTClient.activate();
            this.setStatusText(sRes.getString("status.Ready"));
        }
    }

    private void determineShortComponentSizes() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        commandSize = new Dimension((int)((double)dimension.width * 0.49), (int)((double)dimension.height * 0.31));
        historySize = new Dimension((int)((double)dimension.width * 0.23), (int)((double)dimension.height * 0.31));
        helpSize = new Dimension(200, 325);
        directorySize = new Dimension((int)((double)dimension.width * 0.73), (int)((double)dimension.height * 0.26));
        workspaceSize = new Dimension((int)((double)dimension.width * 0.73), (int)((double)dimension.height * 0.26));
        launchpadSize = new Dimension((int)((double)dimension.width * 0.73), (int)((double)dimension.height * 0.26));
    }

    public void setShortLayout() {
        if (this.clearDesktop() == 0) {
            DTClient dTClient = null;
            DTClient dTClient2 = null;
            DTClient dTClient3 = null;
            DTClient dTClient4 = null;
            this.determineShortComponentSizes();
            dTClient = this.addCommandWindow();
            dTClient2 = this.addCommandHistory(new DTDockPath("E"));
            dTClient3 = this.addFileBrowser(new DTDockPath("N"));
            dTClient4 = this.addWorkspaceBrowser(new DTDockPath("N"));
            this.addProductExplorer(new DTDockPath("N"));
            this.addHelpBrowser(new DTDockPath(null));
            dTClient.restore(false);
            dTClient2.restore(false);
            dTClient3.restore(false);
            dTClient4.restore(false);
            this.fDTMainFrame.restoreMenuBar(dTClient);
            DTClientFrame dTClientFrame = dTClient3.getClientFrame();
            if (dTClientFrame != null) {
                dTClientFrame.showClient(dTClient3, false);
            }
            dTClient.activate();
            this.setStatusText(sRes.getString("status.Ready"));
        }
    }

    public void setTallLayout() {
        if (this.clearDesktop() == 0) {
            DTClient dTClient = null;
            DTClient dTClient2 = null;
            DTClient dTClient3 = null;
            DTClient dTClient4 = null;
            this.determineShortComponentSizes();
            dTClient = this.addCommandWindow();
            dTClient2 = this.addCommandHistory(new DTDockPath("W"));
            dTClient3 = this.addFileBrowser(new DTDockPath("EN"));
            dTClient4 = this.addWorkspaceBrowser(new DTDockPath("EN"));
            this.addProductExplorer(new DTDockPath("EN"));
            this.addHelpBrowser(new DTDockPath(null));
            dTClient.restore(false);
            dTClient2.restore(false);
            dTClient3.restore(false);
            dTClient4.restore(false);
            this.fDTMainFrame.restoreMenuBar(dTClient);
            DTClientFrame dTClientFrame = dTClient3.getClientFrame();
            if (dTClientFrame != null) {
                dTClientFrame.showClient(dTClient3, false);
            }
            dTClient.activate();
            this.setStatusText(sRes.getString("status.Ready"));
        }
    }

    private void determine5PanelComponentSizes() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        commandSize = new Dimension((int)((double)dimension.width * 0.28), (int)((double)dimension.height * 0.63));
        historySize = new Dimension((int)((double)dimension.width * 0.42), (int)((double)dimension.height * 0.31));
        helpSize = new Dimension(200, 325);
        directorySize = new Dimension((int)((double)dimension.width * 0.42), (int)((double)dimension.height * 0.31));
        workspaceSize = new Dimension((int)((double)dimension.width * 0.42), (int)((double)dimension.height * 0.31));
        launchpadSize = new Dimension((int)((double)dimension.width * 0.42), (int)((double)dimension.height * 0.31));
    }

    public void set5PanelLayout() {
        if (this.clearDesktop() == 0) {
            DTClient dTClient = null;
            DTClient dTClient2 = null;
            DTClient dTClient3 = null;
            DTClient dTClient4 = null;
            DTClient dTClient5 = null;
            this.determine5PanelComponentSizes();
            dTClient = this.addCommandWindow();
            dTClient2 = this.addCommandHistory(new DTDockPath("WSW"));
            dTClient3 = this.addFileBrowser(new DTDockPath("WS"));
            dTClient4 = this.addWorkspaceBrowser(new DTDockPath("WN"));
            dTClient5 = this.addProductExplorer(new DTDockPath("WNW"));
            this.addHelpBrowser(new DTDockPath(null));
            dTClient.restore(false);
            dTClient4.restore(false);
            dTClient3.restore(false);
            dTClient2.restore(false);
            dTClient5.restore(false);
            this.fDTMainFrame.restoreMenuBar(dTClient);
            dTClient.activate();
            this.setStatusText(sRes.getString("status.Ready"));
        }
    }

    public int getDesktopVersion() {
        return 17;
    }

    void setSaveDesktop(boolean bl) {
        this.bSaveDesktop = bl;
    }

    public void saveDesktop(String string, String string2) {
        if (this.bSaveDesktop) {
            if (string == null || string2 == null) {
                super.saveDesktop(this.fDTName, Prefs.getPropertyDirectory());
            } else {
                super.saveDesktop(string, string2);
            }
            RemoteLogClient.desktopExit();
            return;
        }
        this.bSaveDesktop = true;
    }

    protected DTMainFrame createMainFrame(String string) {
        this.fMainFrame = new MLMainFrame(this, string);
        return this.fMainFrame;
    }

    public boolean isRestored() {
        return bRestored;
    }

    public static MLDesktop getMLDesktop() {
        return sMLDesktop;
    }

    public Component createComponentFromClass(String string) {
        if (string.endsWith("MatlabCommandWidget")) {
            return this.createCommandWidget();
        }
        if (string.endsWith("CommandHistory")) {
            return this.createCommandHistory();
        }
        if (string.endsWith("HelpBrowser")) {
            return this.createHelpBrowser();
        }
        if (string.endsWith("MLExplorer")) {
            return this.createExplorer();
        }
        if (string.endsWith("FileBrowser")) {
            return this.createFileBrowser();
        }
        if (string.endsWith("Workspace")) {
            return this.createWorkspaceBrowser();
        }
        return super.createComponentFromClass(string);
    }

    private Component createCommandWidget() {
        if (fCommandWidget == null) {
            try {
                fCommandWidget = new MatlabCommandWidget(this.fDTMainFrame.getCommandCenter());
            }
            catch (Exception exception) {
                fCommandWidget = null;
            }
        }
        if (fCommandWidget != null) {
            ((Component)((Object)fCommandWidget)).setSize(MLDesktop.commandSize.width, MLDesktop.commandSize.height);
        }
        return fCommandWidget;
    }

    private DTClient addCommandWindow() {
        return this.addClient(this.createCommandWidget(), "S", MLDesktop.getCommandWindowName(), false);
    }

    public Component createCommandHistory() {
        if (fCommandHistory == null) {
            fCommandHistory = CommandHistory.getInstance() == null ? new CommandHistory() : CommandHistory.getInstance();
        }
        if (fCommandHistory != null) {
            ((Component)((Object)fCommandHistory)).setSize(MLDesktop.historySize.width, MLDesktop.historySize.height);
        }
        return fCommandHistory;
    }

    public DTClient addCommandHistory(DTDockPath dTDockPath) {
        DTClient dTClient = new DTClient(this, "com.mathworks.ide.CommandHistory", sRes.getString("CommandHistory"), dTDockPath, null, null, MLDesktop.historySize.width, MLDesktop.historySize.height, null);
        this.addClient(dTClient, false);
        return dTClient;
    }

    private Component createExplorer() {
        if (fExplorer == null) {
            try {
                fExplorer = new MLExplorer();
            }
            catch (Exception exception) {
                fExplorer = null;
            }
        }
        if (fExplorer != null) {
            ((Component)((Object)fExplorer)).setSize(MLDesktop.launchpadSize.width, MLDesktop.launchpadSize.height);
        }
        return fExplorer;
    }

    private DTClient addProductExplorer(DTDockPath dTDockPath) {
        DTClient dTClient = new DTClient(this, "com.mathworks.ide.desktop.MLExplorer", sRes.getString("LaunchPad"), dTDockPath, null, null, MLDesktop.launchpadSize.width, MLDesktop.launchpadSize.height, null);
        this.addClient(dTClient, false);
        return dTClient;
    }

    private Component createFileBrowser() {
        if (fFileBrowser == null) {
            try {
                fFileBrowser = new FileBrowser();
            }
            catch (Exception exception) {
                fFileBrowser = null;
            }
        }
        if (fFileBrowser != null) {
            ((Component)((Object)fFileBrowser)).setSize(MLDesktop.helpSize.width, MLDesktop.helpSize.height);
        }
        return fFileBrowser;
    }

    private DTClient addFileBrowser(DTDockPath dTDockPath) {
        DTClient dTClient = new DTClient(this, "com.mathworks.ide.browsers.FileBrowser", sRes.getString("CurrentDirectory"), dTDockPath, null, null, MLDesktop.helpSize.width, MLDesktop.helpSize.height, null);
        this.addClient(dTClient, false);
        return dTClient;
    }

    public Component createHelpBrowser() {
        if (fHelpBrowser == null) {
            fHelpBrowser = HelpBrowser.createHelpBrowser();
            ((Component)((Object)fHelpBrowser)).setSize(MLDesktop.helpSize.width, MLDesktop.helpSize.height);
        }
        return fHelpBrowser;
    }

    private DTClient addHelpBrowser(DTDockPath dTDockPath) {
        DTClient dTClient = new DTClient(this, "com.mathworks.ide.help.HelpBrowser", sRes.getString("Help"), dTDockPath, null, null, 0, 0, null);
        this.addClient(dTClient, false);
        return dTClient;
    }

    private Component createWorkspaceBrowser() {
        if (fWorkspace == null) {
            try {
                fWorkspace = new WorkspaceBrowser();
            }
            catch (Exception exception) {
                fWorkspace = null;
            }
        }
        if (fWorkspace != null) {
            fWorkspace.setSize(MLDesktop.workspaceSize.width, MLDesktop.workspaceSize.height);
        }
        return fWorkspace;
    }

    private DTClient addWorkspaceBrowser(DTDockPath dTDockPath) {
        DTClient dTClient = new DTClient(this, "com.mathworks.ide.workspace.WorkspaceBrowser", sRes.getString("Workspace"), dTDockPath, null, null, MLDesktop.workspaceSize.width, MLDesktop.workspaceSize.height, null);
        this.addClient(dTClient, false);
        return dTClient;
    }

    public void startSplash() {
    }

    public void stopSplash() {
        if (PlatformInfo.isWindows()) {
            NativeMatlab.nativeKillSplashScreen();
        }
    }

    static String getCommandWindowName() {
        if (Matlab.isStudentVersion()) {
            return sRes.getString("StudentVersionCommand");
        }
        return sRes.getString("CommandWindow");
    }

    public void showCommandWindow() {
        this.showClient(MLDesktop.getCommandWindowName());
    }

    public static int getCommandWindowHWND() {
        Component component;
        int n = 0;
        MLDesktop mLDesktop = MLDesktop.getMLDesktop();
        if (mLDesktop != null && (component = mLDesktop.getClient(MLDesktop.getCommandWindowName())) != null) {
            n = NativeJava.hWndFromComponent((Component)component);
        }
        return n;
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        if (stringArray != null && stringArray[0] != null && stringArray[0].equals("minimized")) {
            bl = true;
        }
        new MLDesktop("MATLAB", bl);
    }

    protected boolean isDesktopAllowed() {
        return Matlab.getRuntimeVariant() != 2;
    }

    static {
        fCommandWidget = null;
        fCommandHistory = null;
        fHelpBrowser = null;
        fFileBrowser = null;
        fWorkspace = null;
        fExplorer = null;
        commandSize = new Dimension(600, 400);
        historySize = new Dimension(405, 350);
        helpSize = new Dimension(200, 325);
        directorySize = new Dimension(400, 300);
        workspaceSize = new Dimension(400, 250);
        launchpadSize = new Dimension(205, 320);
    }

    private class DesktopQueueEvent
    extends QueueEvent {
        public void dispatch() {
            MLDesktop.this.showClient(MLDesktop.getCommandWindowName());
        }

        DesktopQueueEvent() {
            MLDesktop.this = MLDesktop.this;
        }
    }
}

